/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.common.EnumItem;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.comparator.ComparatorUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.collections.ComparatorUtils;
import org.ktde.util.StringUtil;

public class StopListPanel
extends JPanel {
    private static final long serialVersionUID = 5000545029780467580L;
    private static final int MAXLISTROWCOUNT = 5;
    private static final Comparator<StopModel> NAME_COMPARATOR = new Comparator<StopModel>(){

        @Override
        public int compare(StopModel o1, StopModel o2) {
            return StopModelUtil.getStopDisplay(o1, false).compareTo(StopModelUtil.getStopDisplay(o2, false));
        }
    };
    private static final Comparator<StopModel> ADDRESS_COMPARATOR = new Comparator<StopModel>(){

        @Override
        public int compare(StopModel o1, StopModel o2) {
            LocationWrapper locationWrapper1 = LocationWrapperFactory.INSTANCE.createLocationWrapper(o1.getLocation());
            LocationWrapper locationWrapper2 = LocationWrapperFactory.INSTANCE.createLocationWrapper(o2.getLocation());
            if (locationWrapper1 == null) {
                return -1;
            }
            if (locationWrapper2 == null) {
                return 1;
            }
            int d = ComparatorUtil.compareMultipleValueChain(new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getCountry() == null ? "" : locationWrapper1.getCountry().getIso3166_2()), StringUtil.nullToEmpty(locationWrapper2.getCountry() == null ? "" : locationWrapper2.getCountry().getIso3166_2())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getPostcode()), StringUtil.nullToEmpty(locationWrapper2.getPostcode())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getCity()), StringUtil.nullToEmpty(locationWrapper2.getCity())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getDistrict()), StringUtil.nullToEmpty(locationWrapper2.getDistrict())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getStreet()), StringUtil.nullToEmpty(locationWrapper2.getStreet())), new ComparatorUtil.CompareUnit<Integer>(ComparatorUtils.naturalComparator(), PrimitiveUtil.nullToZero(locationWrapper1.getHousenumber()), PrimitiveUtil.nullToZero(locationWrapper2.getHousenumber())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getHousenumberExtension()), StringUtil.nullToEmpty(locationWrapper2.getHousenumberExtension())));
            if (d == 0) {
                return NAME_COMPARATOR.compare(o1, o2);
            }
            return d;
        }
    };
    private TourManagerCalendarGui tourManagerCalendarGui;
    private JList stopList;
    private EnumComboBox<Sort> sortComboBox;
    private JSpinner startDate;
    private JSpinner endDate;
    private JTextField startPostcode;
    private JTextField endPostcode;

    public StopListPanel(TourManagerCalendarGui tourManagerCalendarGui) {
        super(new BorderLayout());
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.initialize();
    }

    private void initialize() {
        this.stopList = new JList(new DefaultListModel());
        this.stopList.setSelectionMode(1);
        this.stopList.setLayoutOrientation(1);
        this.stopList.setVisibleRowCount(5);
        this.stopList.setCellRenderer(new AbstractStringListCellRenderer(this.stopList.getCellRenderer()){

            @Override
            protected String getString(Object value) {
                return StopModelUtil.getDisplayString((StopModel)value) + "   ";
            }
        });
        JScrollPane stopListScrollPane = new JScrollPane(this.stopList);
        this.add((Component)stopListScrollPane, "Center");
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel orderPanel = new JPanel(new SpringLayout());
        orderPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.sort", new Serializable[0])));
        this.sortComboBox = new EnumComboBox<Sort>(Sort.class, false);
        this.sortComboBox.addActionListener(new SortActionListener());
        orderPanel.add(this.sortComboBox);
        SpringUtilities.makeCompactGrid(orderPanel, 1, 2, 2, 2, 2, 2);
        JPanel dateFilterPanel = new JPanel(new SpringLayout());
        dateFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("gui.date.date", "messages.default.from"), new String[0])));
        FilterChangedListener filterChangedListener = new FilterChangedListener();
        this.startDate = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        this.startDate.setEditor(new JSpinner.DateEditor(this.startDate, "yyyy-MM-dd"));
        this.startDate.addChangeListener(filterChangedListener);
        dateFilterPanel.add(this.startDate);
        dateFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0])));
        this.endDate = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        this.endDate.setEditor(new JSpinner.DateEditor(this.endDate, "yyyy-MM-dd"));
        this.endDate.addChangeListener(filterChangedListener);
        dateFilterPanel.add(this.endDate);
        SpringUtilities.makeCompactGrid(dateFilterPanel, 1, 4, 2, 2, 2, 2);
        JPanel plzFilterPanel = new JPanel(new SpringLayout());
        TextFilterChangedListener textFilterChangedListener = new TextFilterChangedListener();
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("address.postcode", "messages.default.from"), new String[0])));
        this.startPostcode = new JTextField(3);
        this.startPostcode.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.startPostcode);
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0])));
        this.endPostcode = new JTextField(3);
        this.endPostcode.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.endPostcode);
        SpringUtilities.makeCompactGrid(plzFilterPanel, 1, 4, 2, 2, 2, 2);
        JPanel filterPanel = new JPanel(new FlowLayout());
        filterPanel.add(dateFilterPanel);
        filterPanel.add(plzFilterPanel);
        filterPanel.add(orderPanel);
        topPanel.add((Component)filterPanel, "West");
        this.add((Component)topPanel, "North");
    }

    public void loadUnsortedStops() {
        ArrayList<StopModel> newUnsortedStops = new ArrayList<StopModel>(this.tourManagerCalendarGui.getNewUnsortedStops());
        Date lowest = null;
        Date highest = null;
        for (StopModel stopModel : newUnsortedStops) {
            for (TimeWindowModel timeWindowModel : stopModel.iterableTimeWindows()) {
                Date startTime = timeWindowModel.getStartTime();
                if (lowest == null || lowest.compareTo(startTime) >= 0) {
                    lowest = startTime;
                }
                Date endTime = timeWindowModel.getEndTime();
                if (highest != null && highest.compareTo(endTime) > 0) continue;
                highest = endTime;
            }
        }
        if (lowest != null) {
            this.startDate.setValue(lowest);
        }
        if (highest != null) {
            this.endDate.setValue(highest);
        }
        List<StopModel> list = this.sortAndFilterStops(newUnsortedStops);
        DefaultListModel dlm = (DefaultListModel)this.stopList.getModel();
        dlm.clear();
        for (StopModel stopModel : list) {
            dlm.addElement(stopModel);
        }
    }

    public JPanel getPanelWithTitel() {
        return ClientSwingUtil.createPanelForComponent(this, ModelEnviroment.getMessageResolver().resolveMessage("gui.location.unsortedLocation", new Serializable[0]));
    }

    public void addStopInList(StopModel stop) {
        stop.setEstimatedTimeOfArrival(null);
        stop.setStreetMileageMetersFromTourStart(0);
        this.tourManagerCalendarGui.getUnsortedStops().add(stop);
        if (this.isInFilter(stop)) {
            Comparator<StopModel> comparator = this.getSelectedComparator();
            DefaultListModel dlm = (DefaultListModel)this.stopList.getModel();
            boolean inserted = false;
            for (int i = 0; i < dlm.size(); ++i) {
                StopModel iStop = (StopModel)dlm.getElementAt(i);
                if (comparator.compare(stop, iStop) > 0) continue;
                dlm.insertElementAt(stop, i);
                inserted = true;
                break;
            }
            if (!inserted) {
                dlm.addElement(stop);
            }
        }
    }

    private boolean isInFilter(StopModel stop) {
        boolean b = stop.isTimeWindowsEmpty();
        if (!b) {
            Date lower = (Date)this.startDate.getValue();
            Date upper = (Date)this.endDate.getValue();
            for (TimeWindowModel timeWindowModel : stop.iterableTimeWindows()) {
                Date lowerT = timeWindowModel.getStartTime();
                Date upperT = timeWindowModel.getEndTime();
                if (lowerT.compareTo(lower) < 0 || upperT.compareTo(upper) > 0) continue;
                b = true;
            }
        }
        if (b) {
            String startPostcode = StringUtil.emptyToNull(this.startPostcode.getText());
            String endPostcode = StringUtil.emptyToNull(this.endPostcode.getText());
            if (startPostcode != null || endPostcode != null) {
                String postcode;
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation());
                String string = postcode = locationWrapper == null ? null : locationWrapper.getPostcode();
                if (postcode != null && (startPostcode != null && startPostcode.compareTo(postcode.substring(0, Math.min(postcode.length(), startPostcode.length()))) > 0 || endPostcode != null && endPostcode.compareTo(postcode.substring(0, Math.min(postcode.length(), endPostcode.length()))) < 0)) {
                    b = false;
                }
            }
        }
        return b;
    }

    public void updateStopList() {
        ((DefaultListModel)this.stopList.getModel()).setSize(this.tourManagerCalendarGui.getUnsortedStops().size());
        this.stopList.repaint();
    }

    public void removeStopInList() {
        this.tourManagerCalendarGui.getUnsortedStops().remove(this.stopList.getSelectedValue());
        DefaultListModel dlm = (DefaultListModel)this.stopList.getModel();
        dlm.removeElement(this.stopList.getSelectedValue());
        this.stopList.clearSelection();
        this.stopList.repaint();
    }

    public StopModel getSelStopFromList() {
        return (StopModel)this.stopList.getSelectedValue();
    }

    public boolean isInList(Point location) {
        Point pointTable = this.stopList.getLocationOnScreen();
        return location.x > pointTable.x && location.x < pointTable.x + FormUtil.SIZEOFLISTANDTREE.width && location.y > pointTable.y && location.y < pointTable.y + FormUtil.SIZEOFLISTANDTREE.height;
    }

    public JList getStopList() {
        return this.stopList;
    }

    public void setEditable(boolean editable) {
        this.stopList.setEnabled(editable);
    }

    private synchronized List<StopModel> sortAndFilterStops(Collection<StopModel> stopModels) {
        Comparator<StopModel> comparator = this.getSelectedComparator();
        ArrayList<StopModel> stops = new ArrayList<StopModel>(stopModels.size());
        for (StopModel stopModel : stopModels) {
            if (!this.isInFilter(stopModel)) continue;
            stops.add(stopModel);
        }
        Collections.sort(stops, comparator);
        return stops;
    }

    private Comparator<StopModel> getSelectedComparator() {
        EnumItem item = (EnumItem)this.sortComboBox.getSelectedItem();
        Sort sort = Sort.NAME;
        if (item != null) {
            sort = (Sort)((Object)item.getT());
        }
        Comparator<StopModel> comparator = null;
        switch (sort) {
            case NAME: {
                comparator = NAME_COMPARATOR;
                break;
            }
            case ADDRESS: {
                comparator = ADDRESS_COMPARATOR;
            }
        }
        return comparator;
    }

    private void sortAndFilterStopsAndSetInList() {
        Set<StopModel> stops = this.tourManagerCalendarGui.getUnsortedStops();
        List<StopModel> list = this.sortAndFilterStops(stops);
        DefaultListModel dlm = (DefaultListModel)this.stopList.getModel();
        dlm.clear();
        for (StopModel stopModel : list) {
            dlm.addElement(stopModel);
        }
    }

    private class TextFilterChangedListener
    implements DocumentListener {
        private TextFilterChangedListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StopListPanel.this.sortAndFilterStopsAndSetInList();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StopListPanel.this.sortAndFilterStopsAndSetInList();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StopListPanel.this.sortAndFilterStopsAndSetInList();
        }
    }

    private class FilterChangedListener
    implements ChangeListener {
        private FilterChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            StopListPanel.this.sortAndFilterStopsAndSetInList();
        }
    }

    private class SortActionListener
    implements ActionListener {
        private SortActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StopListPanel.this.sortAndFilterStopsAndSetInList();
        }
    }

    public static enum Sort {
        NAME,
        ADDRESS;

    }
}

