/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.client.gui.common.DurationPicker;
import de.datomino.peppergis.client.gui.common.TimeDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.listener.stop.StopInformationListener;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.util.datatypes.Tupel;

public class StopInformationPanel {
    private AddAndUpdateStopDialog addAndUpdateStopDialog;
    private JSpinner estimatedTimeSpinner;
    private DurationPicker estimatedDurationField;
    private JTextArea informationArea;
    private JTextArea parkingInformationArea;
    private JTextArea delivererInformationArea;

    public StopInformationPanel(AddAndUpdateStopDialog addAndUpdateStopDialog) {
        this.addAndUpdateStopDialog = addAndUpdateStopDialog;
    }

    public void loadInformation(StopModel stopModel, JTabbedPane tabbedPane) {
        JPanel serviceTicketPanel = this.createInformationPanel(stopModel);
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), serviceTicketPanel);
    }

    private JPanel createInformationPanel(final StopModel stopModel) {
        boolean editable = this.addAndUpdateStopDialog.isEditable();
        if (!ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DELIVERER_ACTIVE, UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)) {
            editable = false;
        }
        JPanel informationPanel = new JPanel(new SpringLayout());
        JPanel timePane = new JPanel(new GridLayout(4, 2));
        JLabel estimatedTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0]) + ": ");
        timePane.add(estimatedTimeLabel);
        JLabel actualTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.actualTime", new Serializable[0]) + ": ");
        timePane.add(actualTimeLabel);
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(new Date(), null, null, 5);
        this.estimatedTimeSpinner = new JSpinner(spinnerDateModel);
        JSpinner.DateEditor estimatedTimeEditor = new JSpinner.DateEditor(this.estimatedTimeSpinner, FormUtil.TIMEFORMAT);
        this.estimatedTimeSpinner.setFont(UIManager.getDefaults().getFont("TextField.font"));
        this.estimatedTimeSpinner.setEditor(estimatedTimeEditor);
        this.estimatedTimeSpinner.setFocusable(false);
        this.estimatedTimeSpinner.setEnabled(false);
        JFormattedTextField estimatedTimeField = ((JSpinner.DefaultEditor)this.estimatedTimeSpinner.getEditor()).getTextField();
        estimatedTimeField.setHorizontalAlignment(2);
        estimatedTimeField.setEditable(false);
        timePane.add(this.estimatedTimeSpinner);
        JTextField actualTimeField = new JTextField("");
        actualTimeField.setEditable(false);
        timePane.add(actualTimeField);
        JLabel estimatedDurationLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.durationOnLocation", new Serializable[0]) + " (hh:mm:ss):");
        timePane.add(estimatedDurationLabel);
        JLabel actualDurationLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.actualDuration", new Serializable[0]) + " (" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.inMinute", new Serializable[0]) + "): ");
        timePane.add(actualDurationLabel);
        this.estimatedDurationField = new DurationPicker();
        this.estimatedDurationField.setEnabled(editable);
        timePane.add(this.estimatedDurationField);
        DurationPicker actualDurationField = new DurationPicker();
        actualDurationField.setEnabled(false);
        timePane.add(actualDurationField);
        informationPanel.add(timePane);
        JLabel streetMileageLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.streetMileage", new Serializable[0]) + " (" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.inMeter", new Serializable[0]) + "): ");
        informationPanel.add(streetMileageLabel);
        JTextField streetMileageField = new JTextField("");
        streetMileageField.setEditable(false);
        informationPanel.add(streetMileageField);
        JLabel informationLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]) + ": ");
        informationPanel.add(informationLabel);
        this.informationArea = new JTextArea("");
        this.informationArea.setRows(5);
        this.informationArea.setEditable(editable);
        informationPanel.add(ClientSwingUtil.scrollTextArea(this.informationArea, null, editable));
        JLabel parkingInformationLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.infoForPark", new Serializable[0]) + ": ");
        informationPanel.add(parkingInformationLabel);
        this.parkingInformationArea = new JTextArea("");
        this.parkingInformationArea.setRows(5);
        this.parkingInformationArea.setEditable(editable);
        informationPanel.add(ClientSwingUtil.scrollTextArea(this.parkingInformationArea, null, editable));
        JLabel delivererInformationLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.infoForDeliverer", new Serializable[0]) + ": ");
        informationPanel.add(delivererInformationLabel);
        this.delivererInformationArea = new JTextArea("");
        this.delivererInformationArea.setRows(5);
        this.delivererInformationArea.setEditable(editable);
        informationPanel.add(ClientSwingUtil.scrollTextArea(this.delivererInformationArea, null, editable));
        SpringUtilities.makeCompactGrid(informationPanel, 9, 1, 5, 5, 5, 5);
        if (stopModel != null) {
            if (stopModel.getEstimatedTimeOfArrival() == null) {
                estimatedTimeField.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noA", new Serializable[0]));
            } else {
                this.estimatedTimeSpinner.setValue(stopModel.getEstimatedTimeOfArrival());
            }
            this.estimatedDurationField.setDurationInSeconds(PrimitiveUtil.nullToZero(stopModel.getEstimatedDurationSeconds()));
            streetMileageField.setText(ClientFormUtil.getDistanceDisplay(stopModel.getStreetMileageMetersFromTourStart(), ""));
            actualTimeField.setText(ClientFormUtil.dateToString(stopModel.getActualTimeOfArrival()));
            actualDurationField.setDurationInSeconds(PrimitiveUtil.nullToZero(stopModel.getActualDurationSeconds()));
            this.informationArea.setText(FormUtil.getStringDisplay(stopModel.getInformation()));
            this.informationArea.setCaretPosition(0);
            this.parkingInformationArea.setText(FormUtil.getStringDisplay(stopModel.getParkingInformation()));
            this.parkingInformationArea.setCaretPosition(0);
            this.delivererInformationArea.setText(FormUtil.getStringDisplay(stopModel.getDelivererInformation()));
            this.delivererInformationArea.setCaretPosition(0);
        }
        if (editable) {
            this.addTextAreaListeners(this.informationArea, stopModel, StopInformationListener.INFORMATIONTYPE.Information);
            this.addTextAreaListeners(this.parkingInformationArea, stopModel, StopInformationListener.INFORMATIONTYPE.ParkingInformation);
            this.addTextAreaListeners(this.delivererInformationArea, stopModel, StopInformationListener.INFORMATIONTYPE.DelivererInformation);
            this.estimatedDurationField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    stopModel.setEstimatedDurationSeconds(StopInformationPanel.this.estimatedDurationField.getDurationInSeconds());
                }
            });
            estimatedTimeField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Tupel<Date, Boolean> newTimeTupel;
                    if (e.getClickCount() == 2 && e.getButton() == 1 && (newTimeTupel = TimeDialog.createAndShow(stopModel.getEstimatedTimeOfArrival(), StopInformationPanel.this.addAndUpdateStopDialog)).getElement2().booleanValue()) {
                        stopModel.setEstimatedTimeOfArrival(newTimeTupel.getElement1());
                        StopInformationPanel.this.estimatedTimeSpinner.setValue(newTimeTupel.getElement1());
                        StopInformationPanel.this.estimatedTimeSpinner.repaint(10L);
                    }
                    super.mouseClicked(e);
                }
            });
        }
        ClientSwingUtil.setSpinnerEnable(this.estimatedTimeSpinner, editable);
        JPanel mainServiceTicketPanel = new JPanel(new BorderLayout());
        mainServiceTicketPanel.add((Component)informationPanel, "North");
        return mainServiceTicketPanel;
    }

    private void addTextFieldListeners(JTextField textField, StopModel stopModel, StopInformationListener.INFORMATIONTYPE type) {
        StopInformationListener stopInformationListener = new StopInformationListener(stopModel, textField, type);
        textField.addMouseListener(stopInformationListener);
        textField.addActionListener(stopInformationListener);
        textField.addFocusListener(stopInformationListener);
    }

    private void addTextAreaListeners(JTextArea textArea, StopModel stopModel, StopInformationListener.INFORMATIONTYPE type) {
        StopInformationListener stopInformationListener = new StopInformationListener(stopModel, textArea, type);
        textArea.addMouseListener(stopInformationListener);
        textArea.addFocusListener(stopInformationListener);
    }

    public JSpinner getEstimatedTimeSpinner() {
        return this.estimatedTimeSpinner;
    }

    public DurationPicker getEstimatedDurationField() {
        return this.estimatedDurationField;
    }

    public JTextArea getInfomationArea() {
        return this.informationArea;
    }

    public JTextArea getParkingInformationArea() {
        return this.parkingInformationArea;
    }

    public JTextArea getDelivererInformationArea() {
        return this.delivererInformationArea;
    }
}

