/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.map;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.tourmanager.gui.map.legend.StopAttributeNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.StopNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourAttributeNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourNode;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.ktde.util.StringUtil;

public class TourLegendTreeRenderer
implements TreeCellRenderer {
    DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.renderer.setIcon(null);
        if (value != null) {
            if (value instanceof TourNode) {
                TourNode tourNode = (TourNode)value;
                TourModel tourModel = tourNode.getTourModel();
                this.renderer.setText(TourModelUtil.getDisplayForLegend(tourModel));
                this.renderer.setForeground(tourNode.getColor());
                if (TourModelUtil.hasBadTimeWindow(tourModel)) {
                    this.renderer.setIcon(TourModelUtil.icon_bad_window);
                }
            } else if (value instanceof TourAttributeNode) {
                TourAttributeNode attributeNode = (TourAttributeNode)value;
                TourModel tour = attributeNode.getTourModel();
                switch (attributeNode.getAttribute()) {
                    case TIME: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(tour.getPlannedStartTime()));
                        break;
                    }
                    case DURATION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{TourModelUtil.getDurationOfTourString(tour)}));
                        break;
                    }
                    case DISTANCE: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{TourModelUtil.getStreetMileageMetersString(tour)}));
                        break;
                    }
                    case WEIGHT: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.weight", new Serializable[0]) + ": " + TourModelUtil.getSumAttributeString(tour, "WEIGHT"));
                        break;
                    }
                    case COST: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.sum", new Serializable[0]) + ": " + TourModelUtil.getSumCostString(tour));
                        break;
                    }
                    case WEIGHT_PEAK: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.weightPeak", new Serializable[0]) + ": " + TourModelUtil.getWeightPeak(tour));
                    }
                }
                this.renderer.setForeground(attributeNode.getColor());
            } else if (value instanceof StopNode) {
                StopNode stopNode = (StopNode)value;
                StopModel stopModel = stopNode.getStopModel();
                String text = stopNode.getOrder() + ": " + StopModelUtil.getStopDisplay(stopModel, false) + ", ";
                LocationModel location = stopModel.getLocation();
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                text = text + locationWrapper.getPostcode() + " " + locationWrapper.getCity();
                String district = locationWrapper.getDistrict();
                if (!StringUtil.isBlank(district)) {
                    text = text + " - " + district;
                }
                text = text + ", " + locationWrapper.getStreet() + " " + StringUtil.nullToEmpty(locationWrapper.getHousenumber()) + StringUtil.nullToEmpty(locationWrapper.getHousenumberExtension()).trim();
                this.renderer.setText(text);
                this.renderer.setForeground(stopNode.getColor());
                LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stopModel.getLocation());
                if (wrapper == null || GeoUtil.isNullPoint(wrapper.getGeoLocation())) {
                    this.renderer.setForeground(PeppergisConstants.NULL_GEOM_COLOR);
                }
                if (StopModelUtil.hasBadTimeWindow(stopModel)) {
                    this.renderer.setIcon(TourModelUtil.icon_bad_window);
                }
            } else if (value instanceof StopAttributeNode) {
                StopAttributeNode stopAttributeNode = (StopAttributeNode)value;
                switch (stopAttributeNode.getStopAttribute()) {
                    case ADDRESS: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("address.address", new Serializable[0]) + ": " + LocationModelUtil.getAddressString(stopAttributeNode.getStopModel().getLocation()));
                        break;
                    }
                    case TIME: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.arrivalTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(stopAttributeNode.getStopModel().getEstimatedTimeOfArrival()));
                        break;
                    }
                    case DURATION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.durationOnLocation", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(stopAttributeNode.getStopModel().getEstimatedDurationSeconds()));
                        break;
                    }
                    case MILEAGE: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(stopAttributeNode.getStopModel().getStreetMileageMetersFromTourStart(), " Meter"));
                        break;
                    }
                    case INFO: {
                        this.renderer.setText("Lagezusatz: " + StopModelUtil.getStopInfos(stopAttributeNode.getStopModel()));
                        break;
                    }
                    case COMPANY: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer", new Serializable[0]) + ": " + StopModelUtil.getCompanyNames(stopAttributeNode.getStopModel()));
                        break;
                    }
                    case WEIGHT: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.weight", new Serializable[0]) + ": " + StopModelUtil.getWeightString(stopAttributeNode.getStopModel()));
                    }
                }
                this.renderer.setForeground(stopAttributeNode.getColor());
            } else {
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                this.renderer.setText(object.toString());
                this.renderer.setForeground(Color.BLACK);
            }
        }
        return this.renderer;
    }
}

