/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.map;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.gui.renderer.DashLineRenderer;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.manager.util.ManagerMapUtil;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.type.RendererType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourLayerRenderer
extends AbstractNavigatorRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TourLayerRenderer.class);
    private AbstractManagerMapGui<TourModel> mapGui;
    private NavigatorPanel navigatorPanel;
    private Map<TourModel, Color> tourWithColorOnMap;
    private Map<StopModel, Rectangle2D.Double> stopsOnMap = new HashMap<StopModel, Rectangle2D.Double>();
    private Map<TourModel, List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>>> currentLineStrings;
    private Set<Coordinate> areaRectangles;
    private ModelEnviroment modelEnviroment;
    private boolean withStack;
    private boolean withArrow;
    private boolean withLine;
    private Map<StopModel, Color> stopColorCache = new HashMap<StopModel, Color>();
    private Tupel<Rectangle2D.Double, String> selectedRectangle;
    private Tupel<StopModel, Point2D.Double> hovered;

    public TourLayerRenderer(AbstractManagerMapGui<TourModel> mapGui, ModelEnviroment modelEnviroment) {
        super("TourLayerRenderer");
        this.mapGui = mapGui;
        this.modelEnviroment = modelEnviroment;
        this.withStack = true;
        this.withArrow = true;
        this.withLine = true;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        StopModel stop;
        if (this.tourWithColorOnMap == null) {
            return Collections.emptyList();
        }
        ImmutableEnvelope envelope = new ImmutableEnvelope(realBoundaryBottomLeft.getX(), realBoundaryTopRight.getX(), realBoundaryBottomLeft.getY(), realBoundaryTopRight.getY(), this.navigatorPanel.getCoordinateFactory());
        if (this.withLine) {
            this.drawTourLineOnMap(g2d, upp, envelope);
        }
        ManagerPointRenderer pointRenderer = new ManagerPointRenderer(g2d, this.navigatorPanel.getUpp(), this.navigatorPanel.getCoordinateFactory(), this.modelEnviroment){

            @Override
            protected boolean isSelected(Object o) {
                if (!(TourLayerRenderer.this.mapGui instanceof TourMapGui)) {
                    return false;
                }
                if (((TourMapGui)TourLayerRenderer.this.mapGui).getSelectedStopsForAdd().contains(o)) {
                    return true;
                }
                return ((TourMapGui)TourLayerRenderer.this.mapGui).getSelectedStopsForRemove().contains(o);
            }
        };
        this.drawPointsOnMap(g2d, upp, pointRenderer, envelope);
        double margin = 10.0 * Math.pow(upp, -0.2) * upp;
        if (this.selectedRectangle != null) {
            Rectangle2D.Double rectangle = this.selectedRectangle.getElement1();
            Coordinate coordinate = this.navigatorPanel.getCoordinateFactory().createCoordinate(rectangle.getMaxX(), rectangle.getMinY());
            RendererNode node = new RendererNode(this.selectedRectangle.getElement2(), coordinate, Color.BLACK, null, margin);
            node.setType(RendererType.DASH_LINE);
            pointRenderer.drawShape(rectangle, node, margin / 5.0);
            if (node.getText() != null) {
                pointRenderer.drawText(node);
            }
        }
        ArrayList<PoiModel> pois = new ArrayList<PoiModel>();
        for (TourModel tour : this.tourWithColorOnMap.keySet()) {
            for (StopModel stop2 : TourModelUtil.getAllStops(tour, false)) {
                PoiModel poi = stop2.getPoi();
                if (poi == null) continue;
                pois.add(poi);
            }
        }
        pointRenderer.drawPoisWithImage(pois, margin, null, Color.BLACK, ModelEnviroment.getMessageResolver().resolveMessage("messages.poi", new Serializable[0]));
        if (this.hovered != null && (stop = this.hovered.getElement1()) != null) {
            TourModel tour;
            String text = StopModelUtil.getDisplayString(this.hovered.getElement1());
            Coordinate c = this.navigatorPanel.getCoordinateFactory().createCoordinate(this.hovered.getElement2());
            Color color = Color.WHITE;
            TourPartModel tp = stop.getTourPart();
            if (tp != null && (tour = tp.getTour()) != null && (color = this.tourWithColorOnMap.get(tour)) == null) {
                color = Color.WHITE;
            }
            pointRenderer.drawInfoBox(CollectionUtil.buildArrayList(text), c, color, 11.0 * upp);
        }
        return Collections.emptyList();
    }

    private void drawPointsOnMap(Graphics2D g2d, double upp, ManagerPointRenderer pointRenderer, ImmutableEnvelope envelope) {
        HashMap<TourModel, List<ImmutablePoint>> pointsOnMap = new HashMap<TourModel, List<ImmutablePoint>>();
        for (TourModel tour : this.tourWithColorOnMap.keySet()) {
            ArrayList<ImmutablePoint> pointsOfTour = new ArrayList<ImmutablePoint>();
            Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
            while (tourPartIter.hasNext()) {
                Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
                while (stopIter.hasNext()) {
                    LocationModel location = stopIter.next().getLocation();
                    try {
                        ImmutablePoint geoLocation = LocationWrapperFactory.INSTANCE.createLocationWrapper(location).getGeoLocation();
                        pointsOfTour.add(geoLocation);
                    }
                    catch (Exception e) {
                        LOGGER.warn("location with null point - " + LocationModelUtil.getAddressShortString(location));
                    }
                }
            }
            pointsOnMap.put(tour, pointsOfTour);
        }
        this.transformPointsForPaint(pointsOnMap);
        this.drawPointsOnMap(pointsOnMap, g2d, upp, pointRenderer, envelope);
    }

    private void drawTourLineOnMap(Graphics2D g2d, double upp, ImmutableEnvelope envelope) {
        Set<TourModel> keys = this.getCurrentLineStrings().keySet();
        this.stopsOnMap = new HashMap<StopModel, Rectangle2D.Double>();
        DashLineRenderer dashLineRenderer = new DashLineRenderer(upp, this.withArrow, this.navigatorPanel.getCoordinateFactory());
        SolidLineRenderer solidLineRenderer = new SolidLineRenderer(upp, this.withArrow, this.navigatorPanel.getCoordinateFactory());
        for (TourModel key : keys) {
            Color colorOfLine = Color.BLUE;
            if (this.tourWithColorOnMap != null && !this.tourWithColorOnMap.isEmpty()) {
                colorOfLine = this.tourWithColorOnMap.get(key);
            }
            for (Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType> geoObjectTupel : this.getCurrentLineStrings().get(key)) {
                if (geoObjectTupel.getElement1() == null || geoObjectTupel.getElement1() instanceof ImmutablePoint || !(geoObjectTupel.getElement1() instanceof ImmutableLineString)) continue;
                try {
                    ImmutableLineString lineString = (ImmutableLineString)((ImmutableLineString)geoObjectTupel.getElement1()).getTransformed(this.navigatorPanel.getCoordinateFactory());
                    if (!envelope.covers(lineString) && !envelope.intersects(lineString)) continue;
                    if (geoObjectTupel.getElement2().equals((Object)AbstractLineRenderer.LineType.DASH)) {
                        dashLineRenderer.render(g2d, lineString, colorOfLine, 1.0f);
                        continue;
                    }
                    solidLineRenderer.render(g2d, lineString, colorOfLine, 1.0f);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private void transformPointsForPaint(Map<TourModel, List<ImmutablePoint>> pointsOnMap) {
        for (TourModel tour : pointsOnMap.keySet()) {
            ArrayList<ImmutableGeoObject> pointsOfTour = new ArrayList<ImmutableGeoObject>(pointsOnMap.get(tour).size());
            for (ImmutablePoint point : pointsOnMap.get(tour)) {
                if (point == null) continue;
                pointsOfTour.add(point.getTransformed(this.navigatorPanel.getCoordinateFactory()));
            }
            pointsOnMap.put(tour, pointsOfTour);
        }
    }

    private void drawPointsOnMap(Map<TourModel, List<ImmutablePoint>> pointsOnMap, Graphics2D g2d, double upp, ManagerPointRenderer pointRenderer, ImmutableEnvelope envelope) {
        double margin = 35.0 * Math.pow(upp, -0.2) * upp;
        ArrayList<Tripel<String, Color, StopModel>> drawedPoints = new ArrayList<Tripel<String, Color, StopModel>>();
        for (TourModel tour : pointsOnMap.keySet()) {
            int index = 0;
            boolean first = true;
            List<ImmutablePoint> points = pointsOnMap.get(tour);
            for (ImmutablePoint point : points) {
                Tripel<String, Color, StopModel> tripel;
                boolean notInEnvelope = !envelope.covers(point) || !envelope.intersects(point);
                if (drawedPoints.contains(tripel = new Tripel<String, Color, StopModel>(String.valueOf(++index), this.tourWithColorOnMap.get(tour), TourModelUtil.getStopWithIndex(tour, index))) || notInEnvelope) {
                    first = false;
                    if (!notInEnvelope) continue;
                    drawedPoints.add(tripel);
                    continue;
                }
                Tupel<Map<Tripel<String, Color, StopModel>, ImmutablePoint>, Boolean> tupel = this.getOverlappedPoint(index, margin, tour, point, pointsOnMap, drawedPoints);
                Map<Tripel<String, Color, StopModel>, ImmutablePoint> overlappedPoints = tupel.getElement1();
                drawedPoints.addAll(overlappedPoints.keySet());
                boolean last = tupel.getElement2();
                if (this.withStack) {
                    this.stopsOnMap.putAll(pointRenderer.drawStopsWithStack(overlappedPoints, margin, this.stopColorCache, first, last));
                } else {
                    this.stopsOnMap.putAll(pointRenderer.drawStopsWithOutStack(overlappedPoints, margin, this.stopColorCache, first, last));
                }
                first = false;
            }
        }
    }

    private Tupel<Map<Tripel<String, Color, StopModel>, ImmutablePoint>, Boolean> getOverlappedPoint(int index, double margin, TourModel tourOfPoint, ImmutablePoint point, Map<TourModel, List<ImmutablePoint>> pointsOnMap, List<Tripel<String, Color, StopModel>> drawedPoints) {
        HashMap<Tripel<String, Color, StopModel>, ImmutablePoint> overlappedPoints = new HashMap<Tripel<String, Color, StopModel>, ImmutablePoint>();
        Color colorOfLine = this.tourWithColorOnMap.get(tourOfPoint);
        overlappedPoints.put(new Tripel<String, Color, StopModel>(String.valueOf(index), colorOfLine, TourModelUtil.getStopWithIndex(tourOfPoint, index)), point);
        boolean last = false;
        for (TourModel tour : pointsOnMap.keySet()) {
            List<ImmutablePoint> pointsOfTour = pointsOnMap.get(tour);
            colorOfLine = this.tourWithColorOnMap.get(tour);
            for (int i = 0; i < pointsOfTour.size(); ++i) {
                if (drawedPoints.contains(new Tripel<String, Color, StopModel>(String.valueOf(i + 1), colorOfLine, TourModelUtil.getStopWithIndex(tour, i + 1))) || !ManagerPointRenderer.isOverlapped(margin, point, pointsOfTour.get(i))) continue;
                overlappedPoints.put(new Tripel<String, Color, StopModel>(String.valueOf(i + 1), colorOfLine, TourModelUtil.getStopWithIndex(tour, i + 1)), pointsOfTour.get(i));
                if (i != pointsOfTour.size() - 1) continue;
                last = true;
            }
        }
        return new Tupel<Map<Tripel<String, Color, StopModel>, ImmutablePoint>, Boolean>(overlappedPoints, last);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    private void initLineStrings() {
        if (this.tourWithColorOnMap == null) {
            this.currentLineStrings = Collections.emptyMap();
        } else {
            this.currentLineStrings = new HashMap<TourModel, List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>>>();
            for (TourModel tourModel : this.tourWithColorOnMap.keySet()) {
                List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>> lineStringOfTour = ManagerMapUtil.getLineStringOfTour(tourModel, true, this.modelEnviroment);
                if (lineStringOfTour != null && lineStringOfTour.isEmpty()) continue;
                for (Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType> tupel : lineStringOfTour) {
                    if (tupel.getElement1() == null || tupel.getElement1().getCoordinates() == null) continue;
                    this.areaRectangles.addAll(GeoUtils.getAreaRectangle(tupel.getElement1().getCoordinates()));
                }
                this.currentLineStrings.put(tourModel, lineStringOfTour);
            }
        }
    }

    public void setTourWithColorOnMap(Map<TourModel, Color> tourWithColorOnMap) {
        this.tourWithColorOnMap = tourWithColorOnMap;
        this.areaRectangles = new HashSet<Coordinate>();
        this.initLineStrings();
        this.mapGui.setAreaRectangles(this.areaRectangles);
        this.stopColorCache.clear();
    }

    private Map<TourModel, List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>>> getCurrentLineStrings() {
        if (this.currentLineStrings == null) {
            this.initLineStrings();
        }
        return this.currentLineStrings;
    }

    public void changeWithStock() {
        this.withStack = !this.withStack;
    }

    public void setWithStack(boolean isWithStack) {
        this.withStack = isWithStack;
    }

    public boolean isWithStack() {
        return this.withStack;
    }

    public Set<Coordinate> getAreaRectangles() {
        return this.areaRectangles;
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public void setWithArrow(boolean isWithArrow) {
        this.withArrow = isWithArrow;
    }

    public Map<StopModel, Rectangle2D.Double> getPointsOnMap() {
        return this.stopsOnMap;
    }

    public void setSelectedRectangle(Tupel<Rectangle2D.Double, String> selectedRectangle) {
        this.selectedRectangle = selectedRectangle;
    }

    public void setWithLine(boolean withLine) {
        this.withLine = withLine;
    }

    public void doMouseMoved(Point2D.Double real) {
        if (this.isActive()) {
            this.hovered = null;
            Set<StopModel> stops = this.stopsOnMap.keySet();
            for (StopModel stop : stops) {
                Rectangle2D.Double rectangle = this.stopsOnMap.get(stop);
                if (!rectangle.contains(real)) continue;
                this.hovered = new Tupel<StopModel, Point2D.Double>(stop, new Point2D.Double(rectangle.getCenterX(), rectangle.getCenterY()));
                break;
            }
        }
    }

    public void removeToursFromMap(Collection<TourModel> tours) {
        for (TourModel tour : tours) {
            this.tourWithColorOnMap.remove(tour);
            this.currentLineStrings.remove(tour);
        }
    }
}

