/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.map;

import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.parcel.ParcelLayerRenderer;
import de.datomino.peppergis.client.gui.renderer.CoordinateEditorLayerRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.tourmanager.listener.map.LocationEditorMapMouseManipulator;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.datatypes.Tupel;

public class LocationEditorMapPanel
extends AbstractManagerMapGui<LocationModel> {
    private static final long serialVersionUID = 5884351116084075722L;
    private JSpinner xSpinner;
    private JSpinner ySpinner;
    private JComboBox coordinateFormat;
    private CoordinateEditorLayerRenderer coodinateEditorLayerRenderer;

    public LocationEditorMapPanel(Coordinate coordinate, ModelEnviroment modelEnviroment) throws IOException {
        super((LayoutManager)new BorderLayout(), modelEnviroment);
        this.modelEnviroment = modelEnviroment;
        this.setCoordinate(coordinate);
        this.initialized();
    }

    private void initialized() throws IOException {
        if (this.coordinate == null) {
            this.coordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        this.initializedMapPanel();
        this.add((Component)this.navigatorPanel, "Center");
        this.add((Component)this.creatControlPanel(), "North");
    }

    private void initializedMapPanel() throws IOException {
        this.navigatorPanel = new NavigatorPanel(this.coordinate, OpenStreetmapViewFactory.INSTANCE, (Container)this);
        this.navigatorPanel.setPanning(true);
        this.navigatorPanel.getPanningAction().setSelected(true);
        this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        osmNavigatorRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(osmNavigatorRenderer);
        ParcelLayerRenderer parcelLayerRenderer = new ParcelLayerRenderer(this, this.modelEnviroment, false);
        parcelLayerRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(parcelLayerRenderer);
        this.coodinateEditorLayerRenderer = new CoordinateEditorLayerRenderer(true);
        this.coodinateEditorLayerRenderer.setNavigatorPanel(this.navigatorPanel);
        this.coodinateEditorLayerRenderer.setCoordinate(this.coordinate);
        this.navigatorPanel.addRenderer(this.coodinateEditorLayerRenderer);
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        renderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(this.navigatorPanel);
        zoomingRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(zoomingRenderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
        LocationEditorMapMouseManipulator coordinateMapMouseManipulator = new LocationEditorMapMouseManipulator(this);
        this.navigatorPanel.setMouseManipulator(coordinateMapMouseManipulator);
    }

    private JPanel creatControlPanel() {
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel leftPanel = new JPanel(new FlowLayout());
        JLabel locationXLabel = new JLabel("X ");
        leftPanel.add(locationXLabel);
        double x = this.coordinate.getX();
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            x = 0.0;
        }
        this.xSpinner = new JSpinner(new SpinnerNumberModel(x, -2.147483648E9, 2.147483647E9, 0.001));
        JSpinner.NumberEditor editorX = new JSpinner.NumberEditor(this.xSpinner, "###,###,##0.######");
        this.xSpinner.setEditor(editorX);
        this.xSpinner.setValue(x);
        this.xSpinner.setPreferredSize(new Dimension(100, 25));
        leftPanel.add(this.xSpinner);
        JLabel locationYLabel = new JLabel("Y ");
        leftPanel.add(locationYLabel);
        double y = this.coordinate.getY();
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            y = 0.0;
        }
        this.ySpinner = new JSpinner(new SpinnerNumberModel(y, -2.147483648E9, 2.147483647E9, 0.001));
        JSpinner.NumberEditor editorY = new JSpinner.NumberEditor(this.ySpinner, "###,###,##0.######");
        this.ySpinner.setEditor(editorY);
        this.ySpinner.setPreferredSize(new Dimension(100, 25));
        leftPanel.add(this.ySpinner);
        String wgs84 = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate_factory.Wgs84.name", new Serializable[0]);
        String mercator = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate_factory.Mercator.name", new Serializable[0]);
        this.coordinateFormat = new JComboBox<String>(new String[]{wgs84, mercator});
        this.coordinateFormat.setSelectedItem(wgs84);
        leftPanel.add(this.coordinateFormat);
        JButton updateButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.update", new Serializable[0])){
            private static final long serialVersionUID = 5063782018133441114L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationEditorMapPanel.this.updatePinOnMap();
            }
        });
        leftPanel.add(updateButton);
        controlPanel.add((Component)leftPanel, "Center");
        JPanel rightPanel = new JPanel(new FlowLayout());
        SearchLocationAction searchLocationAction = new SearchLocationAction(this, this.navigatorPanel, this.modelEnviroment, false, true){
            private static final long serialVersionUID = -2513116948153037575L;

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                if (super.getCoordinate() != null) {
                    LocationEditorMapPanel.this.navigatorPanel.gotoCoordinate(super.getCoordinate());
                }
            }
        };
        rightPanel.add(new JButton(searchLocationAction));
        rightPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        controlPanel.add((Component)rightPanel, "East");
        return controlPanel;
    }

    private void updatePinOnMap() {
        Double newX = Double.valueOf(this.xSpinner.getValue().toString());
        Double newY = Double.valueOf(this.ySpinner.getValue().toString());
        String coordinateFactoryName = (String)this.coordinateFormat.getSelectedItem();
        CoordinateFactory factory = CoordinateFactory.getInstance(coordinateFactoryName);
        Coordinate newCoordinate = factory.createCoordinate(newX, newY);
        Coordinate wgs84Coordinate = Wgs84Factory.INSTANCE.createCoordinate(newCoordinate);
        if (wgs84Coordinate.getX() <= -360.0 || wgs84Coordinate.getX() >= 360.0 || wgs84Coordinate.getY() <= -360.0 || wgs84Coordinate.getY() >= 360.0) {
            JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("errors.import.coordsNotValid", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
        } else {
            super.setCoordinate(newCoordinate);
            Tupel<ImmutablePoint, ImmutablePoint> boundary = this.getDefaultBoundary();
            this.navigatorPanel.center(Arrays.asList(boundary.getElement1().getCoordinate(), boundary.getElement2().getCoordinate()), 0);
            this.repaintGui(false);
        }
    }

    public CoordinateEditorLayerRenderer getCoodinateEditorLayerRenderer() {
        return this.coodinateEditorLayerRenderer;
    }

    @Override
    public Component getPane() {
        return null;
    }

    @Override
    public LocationModel getSelectedModel() {
        return null;
    }

    @Override
    public void repaintGui(boolean tourUpdate) {
        String coordinateFactoryName = (String)this.coordinateFormat.getSelectedItem();
        CoordinateFactory factory = CoordinateFactory.getInstance(coordinateFactoryName);
        Coordinate reformedCoordinate = factory.createCoordinate(this.coordinate);
        this.xSpinner.setValue(reformedCoordinate.getX());
        this.ySpinner.setValue(reformedCoordinate.getY());
        this.coodinateEditorLayerRenderer.setCoordinate(this.coordinate);
        this.navigatorPanel.repaint(10L);
    }

    @Override
    public void setAreaRectangles(Set<Coordinate> areaRectangles) {
    }
}

