/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.main;

import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.handler.TourManagerJobManager;
import de.datomino.peppergis.tourmanager.handler.TourMapActions;
import de.datomino.peppergis.type.UserRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class TourManagerControlGui
extends JPanel {
    private static final long serialVersionUID = 6619022229822651115L;
    private TourManagerCalendarGui tourManager;
    private JMenu filterSubMenu;
    private TourMapActions tourMapActions;
    private JCheckBoxMenuItem trackingDisplayItem;

    public TourManagerControlGui(TourManagerCalendarGui tourManager) {
        super(new BorderLayout());
        this.tourManager = tourManager;
        this.tourMapActions = tourManager.getTourMapGui().getTourMapActions();
        this.initialize();
    }

    public void initialize() {
        JMenu exportMenu;
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createDisplayMenu());
        menuBar.add(this.createSearchMenu());
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)) {
            JMenu filterMenu = this.createFilterMenu();
            menuBar.add(filterMenu);
        }
        menuBar.add(this.createSumMenu());
        menuBar.add(this.createPrintMenu());
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.DELIVERER_ACTIVE, UserRole.DISPONENT_LOCAL_PASSIVE) && (exportMenu = this.createExportMenu()) != null) {
            menuBar.add(exportMenu);
        }
        menuBar.add(this.createRefreshMenu());
        menuBar.add(this.createGeoTrackingMenu());
        this.add((Component)menuBar, "Center");
    }

    private JMenu createGeoTrackingMenu() {
        JMenu geoTrackingMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.geotracking", new Serializable[0]));
        geoTrackingMenu.add(this.tourMapActions.getShowGeoTrackingAction());
        this.trackingDisplayItem = new JCheckBoxMenuItem(new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.geotracking.show", new Serializable[0])){
            private static final long serialVersionUID = -3599589936368761648L;

            @Override
            public void turnOn() {
                TourManagerControlGui.this.tourManager.getTourMapGui().setGeoTrackingRenderer(true);
            }

            @Override
            public void turnOff() {
                TourManagerControlGui.this.tourManager.getTourMapGui().setGeoTrackingRenderer(false);
            }
        });
        geoTrackingMenu.add(this.trackingDisplayItem);
        JCheckBoxMenuItem turnOnLastTrackingItem = new JCheckBoxMenuItem(new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.geotracking.lastpoint", new Serializable[0])){
            private static final long serialVersionUID = 5504363621553875799L;

            @Override
            public void turnOn() {
                TourManagerControlGui.this.tourManager.getTourMapGui().getGeoTrackingRenderer().setShowLastTracking(true);
            }

            @Override
            public void turnOff() {
                TourManagerControlGui.this.tourManager.getTourMapGui().getGeoTrackingRenderer().setShowLastTracking(false);
            }
        });
        geoTrackingMenu.add(turnOnLastTrackingItem);
        geoTrackingMenu.addSeparator();
        geoTrackingMenu.add(new JCheckBoxMenuItem(new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tracking.selectTours", new Serializable[0])){
            private static final long serialVersionUID = 3920717808685100965L;

            @Override
            public void turnOn() {
                TourManagerControlGui.this.tourManager.getTourMapGui().getTourTrackingRenderer().setActive(true);
                TourManagerControlGui.this.tourManager.getTourMapGui().getTourTrackingRenderer().setTours(false);
            }

            @Override
            public void turnOff() {
                TourManagerControlGui.this.tourManager.getTourMapGui().getTourTrackingRenderer().setActive(false);
            }
        }));
        geoTrackingMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return geoTrackingMenu;
    }

    private JMenu createRefreshMenu() {
        JMenu refreshMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.update", new Serializable[0]));
        JRadioButtonMenuItem turnOnItem = new JRadioButtonMenuItem(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.turnon", new Serializable[0])){
            private static final long serialVersionUID = 5504363621553875799L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TourManagerJobManager.resumeJob("refresh tours");
            }
        });
        refreshMenu.add(turnOnItem);
        JRadioButtonMenuItem turnOffItem = new JRadioButtonMenuItem(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.turnoff", new Serializable[0])){
            private static final long serialVersionUID = -3891894090043430127L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TourManagerJobManager.pause("refresh tours");
            }
        });
        refreshMenu.add(turnOffItem);
        ButtonGroup group = new ButtonGroup();
        group.add(turnOffItem);
        group.add(turnOnItem);
        turnOffItem.setSelected(true);
        String refreshActive = ModelEnviroment.getProperties().getProperty("refresh.tours.active");
        if (!StringUtil.isTrue(refreshActive)) {
            turnOnItem.setEnabled(false);
            turnOffItem.setEnabled(false);
        }
        return refreshMenu;
    }

    private JMenu createSumMenu() {
        JMenu sumMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.summation", new Serializable[0]));
        JMenuItem serviceItem = new JMenuItem(this.tourManager.getActions().getSumServicesAction());
        sumMenu.add(serviceItem);
        sumMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return sumMenu;
    }

    private JMenu createSearchMenu() {
        JMenu searchAddressMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0]));
        Tupel<SearchLocationAction, Action> tupel = SearchLocationAction.createButtonTupel(this.tourManager, this.tourManager.getCurrentNavigatorPanel(), this.tourManager.getModelEnviroment(), false, false);
        JMenuItem locationSearchItem = new JMenuItem(tupel.getElement1());
        searchAddressMenu.add(locationSearchItem);
        JMenuItem searchStopItem = new JMenuItem(this.tourManager.getActions().getSearchStopsAction(tupel.getElement1()));
        searchAddressMenu.add(searchStopItem);
        searchAddressMenu.addSeparator();
        searchAddressMenu.add(tupel.getElement2());
        searchAddressMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return searchAddressMenu;
    }

    private JMenu createExportMenu() {
        Action[] exportTourActions;
        JMenu menu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.export", new Serializable[0]));
        boolean isExportToServerActive = this.tourManager.getModelEnviroment().getAllCaller().getExportCaller().isServerTourExportEnabled();
        for (Action a : exportTourActions = this.tourManager.getActions().getExportTourActions()) {
            menu.add(a);
        }
        if (isExportToServerActive) {
            menu.add(new JMenuItem(this.tourManager.getActions().getExportTourToServerAction()));
            menu.add(new JMenuItem(this.tourManager.getActions().getExportSelectedToursInMapToServerAction()));
        }
        menu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return menu;
    }

    private JMenu createPrintMenu() {
        JMenu printTourMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.print", new Serializable[0]));
        JMenuItem screenshotItem = new JMenuItem(this.tourMapActions.getPrintScreenShotAction());
        printTourMenu.add(screenshotItem);
        JMenuItem printToursWithPoi = new JMenuItem(this.tourMapActions.getPrintToursWithPoiAction());
        printTourMenu.add(printToursWithPoi);
        JMenuItem printToursWithoutPoi = new JMenuItem(this.tourMapActions.getPrintToursWithoutPoiAction());
        printTourMenu.add(printToursWithoutPoi);
        printTourMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return printTourMenu;
    }

    private JMenu createFilterMenu() {
        JMenu filterMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.filter", new Serializable[0]));
        JMenuItem newStopFilter = new JMenuItem(this.tourMapActions.getFilterAction(null, LegendType.STOP));
        filterMenu.add(newStopFilter);
        JMenuItem removeFilter = new JMenuItem(this.tourMapActions.getRemoveFilterOnMapAction());
        filterMenu.add(removeFilter);
        filterMenu.addSeparator();
        this.filterSubMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.existingFilter", new Serializable[0]));
        this.loadFilterSubMenu();
        filterMenu.add(this.filterSubMenu);
        filterMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return filterMenu;
    }

    public void loadFilterSubMenu() {
        this.filterSubMenu.removeAll();
        for (FilterEntity filterEntity : this.tourManager.getFilters()) {
            JMenuItem filterItem = new JMenuItem(this.tourMapActions.getFilterAction(filterEntity, filterEntity.getType()));
            this.filterSubMenu.add(filterItem);
        }
        this.filterSubMenu.revalidate();
        this.filterSubMenu.repaint();
    }

    private JMenu createDisplayMenu() {
        JMenu displayMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.display", new Serializable[0]));
        JMenuItem showAllTours = new JMenuItem(this.tourMapActions.getShowAllToursAction());
        displayMenu.add(showAllTours);
        JMenuItem showSelectedTours = new JMenuItem(this.tourMapActions.getShowSelectedToursAction());
        displayMenu.add(showSelectedTours);
        JMenuItem clearSelectedTours = new JMenuItem(this.tourMapActions.getClearSelectedToursAction());
        displayMenu.add(clearSelectedTours);
        JMenuItem showToursOfSelectedDay = new JMenuItem(this.tourMapActions.getShowToursOfSelectedDayAction());
        displayMenu.add(showToursOfSelectedDay);
        displayMenu.addSeparator();
        displayMenu.add(new JCheckBoxMenuItem(this.tourMapActions.getChangeStopSymbolAction()));
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.ADMIN, UserRole.DISPONENT_SUPER)) {
            JCheckBoxMenuItem showUnsortedStops = new JCheckBoxMenuItem(this.tourMapActions.getShowUnsortedStopsAction());
            displayMenu.add(showUnsortedStops);
        }
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER)) {
            displayMenu.add(new JCheckBoxMenuItem(this.tourMapActions.getShowPostcodeAction()));
        }
        displayMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return displayMenu;
    }

    private JMenu createEditMenu() {
        JMenu edit = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0]));
        JMenuItem saveChanges = new JMenuItem(this.tourManager.getActions().getSaveAction());
        edit.add(saveChanges);
        JMenuItem undo = new JMenuItem(this.tourManager.getActions().getUndoAction());
        edit.add(undo);
        JMenuItem redo = new JMenuItem(this.tourManager.getActions().getRedoAction());
        edit.add(redo);
        JMenuItem revertChanges = new JMenuItem(this.tourManager.getActions().getRevertAction());
        edit.add(revertChanges);
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER)) {
            edit.addSeparator();
            JMenuItem addTour = new JMenuItem(this.tourManager.getActions().getNewTourAction());
            edit.add(addTour);
            JMenuItem deleteTour = new JMenuItem(this.tourManager.getActions().getDeleteToursInTabAction());
            edit.add(deleteTour);
            JMenuItem addDeliverer = new JMenuItem(this.tourManager.getActions().getNewDelivererAction());
            edit.add(addDeliverer);
            JMenuItem difficultyLevel = new JMenuItem(this.tourManager.getActions().getEditDifficultyLevelAction());
            edit.add(difficultyLevel);
        }
        edit.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return edit;
    }

    public JCheckBoxMenuItem getTrackingDisplayItem() {
        return this.trackingDisplayItem;
    }
}

