/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.main;

import de.datomino.peppergis.client.gui.blocking.BusyDialogShowingBusyHandler;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.CalendarGui;
import de.datomino.peppergis.client.manager.DelivererTreeGui;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerControlGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.timeline.TourTimeLineGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourListGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourPlanTableGui;
import de.datomino.peppergis.tourmanager.gui.tracking.GeoTrackingLegendPane;
import de.datomino.peppergis.tourmanager.handler.TourManagerActions;
import de.datomino.peppergis.tourmanager.handler.TourManagerJobManager;
import de.datomino.peppergis.tourmanager.handler.job.GeoTrackingJob;
import de.datomino.peppergis.tourmanager.handler.job.RefreshTourPlanTableJob;
import de.datomino.peppergis.tourmanager.listener.TourPlanTableListener;
import de.datomino.peppergis.tourmanager.listener.deliverer.DelivererTreeListener;
import de.datomino.peppergis.tourmanager.listener.tour.TourListListener;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.apache.commons.io.IOUtils;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class TourManagerCalendarGui
extends JPanel {
    private static final boolean HEADLESS = StringUtil.isTrue(System.getProperty("java.awt.headless"));
    private static final long serialVersionUID = -6342326590436987688L;
    public static final String REFRESH_TOURS = "refresh tours";
    public static final int REFRESH_TOURS_INDAYS = 4;
    private static final String REFRESH_TOURS_CRON = "0 0/2 7-22 ? * *";
    public static final String GEO_TRACKING = "geo tracking";
    public static final String GEO_TRACKING_CRON = "0 0/%% 7-22 ? * *";
    public static final String REFRESH_TIME_LINE = "time line";
    public static final String REFRESH_TIME_LINE_CRON = "0 0/%% * 1/1 * ? *";
    private Properties properties;
    private TourManagerActions actions;
    private CalendarGui calendarGui;
    private TourPlanTableGui planTableGui;
    private TourListGui tourListGui;
    private TourMapGui tourMapGui;
    private JTabbedPane tabbedPane;
    private DelivererTreeGui delivererGui;
    private TourManagerControlGui controlGui;
    private Set<StopModel> unsortedStops;
    private List<FilterEntity> filters;
    private ModelEnviroment modelEnviroment;
    private BusyHandler busyHandler = new BusyDialogShowingBusyHandler(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]));
    private final TourListListener tourListListener;
    private TourTimeLineGui timeLineGui;

    public TourManagerCalendarGui(ModelEnviroment modelEnviroment) throws IOException {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.properties = ModelEnviroment.getProperties();
        this.actions = new TourManagerActions(this, modelEnviroment);
        List<DelivererModel> deliverers = modelEnviroment.getAllCaller().getTourCaller().fetchAllDeliverers();
        List<BranchModel> allBranches = modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs();
        HashSet<BranchModel> branches = new HashSet<BranchModel>();
        for (BranchModel branch : allBranches) {
            if (branch == null || branch.getBranchType() != BranchType.REGULAR_TOUR_DELIVERER) continue;
            branches.add(branch);
        }
        this.unsortedStops = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.ADMIN, UserRole.DISPONENT_SUPER) ? new HashSet<StopModel>(modelEnviroment.getAllCaller().getTourCaller().fetchAllUnsortedStops()) : new HashSet<StopModel>();
        JPanel rightPanel = this.createVerticalBoxPanel();
        this.tourListGui = new TourListGui();
        rightPanel.add(ClientSwingUtil.createPanelForComponent(this.tourListGui.createTourGui(this), ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.list", new Serializable[0])));
        rightPanel.add(this.createLogoPanel(this.properties.getProperty("companylogo")));
        JPanel leftPanel = new JPanel();
        this.calendarGui = new CalendarGui(){

            @Override
            public void update() {
                String dateString;
                super.update();
                if (TourManagerCalendarGui.this.delivererGui == null || TourManagerCalendarGui.this.planTableGui == null) {
                    return;
                }
                TourManagerCalendarGui.this.delivererGui.getDelivererJTree().repaint();
                int dayOfWeek = this.calendar.get(7);
                if (dayOfWeek == 1) {
                    dayOfWeek = 8;
                }
                if (this.isSameWeek((dateString = TourManagerCalendarGui.this.getPlanTableGui().getColumnHeader()[dayOfWeek - 1].split("\n")[2]).split(" - "))) {
                    return;
                }
                this.calendar.add(5, 1 - dayOfWeek);
                int sumOfColumn = TourManagerCalendarGui.this.getPlanTableGui().getColumnHeader().length;
                for (int i = 1; i < sumOfColumn; ++i) {
                    String oldHeader = TourManagerCalendarGui.this.getPlanTableGui().getColumnHeader()[i];
                    this.calendar.add(5, 1);
                    TourManagerCalendarGui.this.getPlanTableGui().getColumnHeader()[i] = this.changDayInHeader(oldHeader, this.calendar);
                }
                TourManagerCalendarGui.this.getPlanTableGui().createPlanTable();
            }
        };
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)ClientSwingUtil.createPanelForComponent(this.calendarGui.createCalendarGui(), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monthlyCalendar", new Serializable[0])), "First");
        this.delivererGui = new DelivererTreeGui();
        rightPanel.add(ClientSwingUtil.createPanelForComponent(this.delivererGui.createDelivererGui(new LinkedList<DelivererModel>(deliverers), branches, this.calendarGui), ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.logisticI.list", new Serializable[0])));
        JPanel middlePanel = this.createVerticalBoxPanel();
        this.planTableGui = new TourPlanTableGui();
        middlePanel.add(ClientSwingUtil.createPanelForComponent(this.planTableGui.createPlanGui(this, this.delivererGui.getDelivererCount()), ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plan", new Serializable[0])));
        JPanel addNullRowPane = new JPanel(new FlowLayout());
        addNullRowPane.add(new JButton(new AbstractAction("+"){
            private static final long serialVersionUID = 1715299921325637285L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourManagerCalendarGui.this.planTableGui.addNullRow();
            }
        }));
        middlePanel.add(addNullRowPane);
        JPanel planPanel = new JPanel();
        planPanel.setLayout(new BorderLayout());
        planPanel.add((Component)middlePanel, "Center");
        planPanel.add((Component)rightPanel, "East");
        JSplitPane managementSplitPane = new JSplitPane(1, leftPanel, planPanel);
        managementSplitPane.setOneTouchExpandable(true);
        Coordinate startCoordinate = this.getStartCoordinate();
        this.tourMapGui = new TourMapGui(this);
        this.tourMapGui.initialized(startCoordinate);
        this.timeLineGui = new TourTimeLineGui(this);
        this.tabbedPane = new JTabbedPane(3, 0);
        this.tabbedPane.addTab("Verwaltung", managementSplitPane);
        this.tabbedPane.addTab("Tourkarte", this.tourMapGui);
        this.tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.timeLine", new Serializable[0]), new JScrollPane(this.timeLineGui));
        this.controlGui = new TourManagerControlGui(this);
        this.add((Component)this.controlGui, "North");
        this.add((Component)this.tabbedPane, "Center");
        this.tourMapGui.getNavigatorPanel().addKeyListenerToContainer(this);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tourListListener = new TourListListener(this);
        this.addListeners();
        if (!HEADLESS) {
            String refreshActive = this.properties.getProperty("refresh.tours.active");
            if (refreshActive != null && refreshActive.equalsIgnoreCase("true")) {
                String tourCron = this.properties.getProperty("refresh.tours.cron") == null ? REFRESH_TOURS_CRON : this.properties.getProperty("refresh.tours.cron");
                TourManagerJobManager.addJob(REFRESH_TOURS, RefreshTourPlanTableJob.class.getName(), tourCron, this);
            }
            String trackingCron = this.properties.getProperty("geo.tracking.cron") == null ? GEO_TRACKING_CRON : this.properties.getProperty("geo.tracking.cron");
            TourManagerJobManager.addJob(GEO_TRACKING, GeoTrackingJob.class.getName(), trackingCron, this);
            TourManagerJobManager.start();
            TourManagerJobManager.pauseAll();
        }
    }

    protected Coordinate getStartCoordinate() {
        String startString = this.properties.getProperty("navigator.startCoordinate");
        Coordinate startCoordinate = null;
        if (startString != null) {
            try {
                Tupel<String, String[]> tupel = StringUtil.parseTokens(startString);
                CoordinateFactory factory = CoordinateFactory.getInstance(tupel.getElement1());
                startCoordinate = factory.createCoordinate(Double.valueOf(tupel.getElement2()[0]), Double.valueOf(tupel.getElement2()[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        return startCoordinate;
    }

    private void addListeners() {
        TourPlanTableListener planTableListener = new TourPlanTableListener(this);
        DelivererTreeListener delivererTreeListener = new DelivererTreeListener(this);
        this.planTableGui.getPlanTable().addMouseListener(planTableListener);
        this.tourListGui.getTourJList().addMouseListener(this.tourListListener);
        this.delivererGui.getDelivererJTree().addMouseListener(delivererTreeListener);
        if (!HEADLESS && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN, UserRole.DELIVERER_ACTIVE)) {
            boolean moreThanDelivererActive = ModelEnviroment.getUserInformation().hasOtherRolesThan(UserRole.DELIVERER_ACTIVE);
            new DropTarget(this.planTableGui.getPlanTable(), 3, planTableListener);
            if (moreThanDelivererActive) {
                new DropTarget(this.tourListGui.getTourJList(), 3, this.tourListListener);
            }
            new DropTarget(this.delivererGui.getDelivererJTree(), 3, delivererTreeListener);
            DragSource dragSource = new DragSource();
            dragSource.createDefaultDragGestureRecognizer(this.planTableGui.getPlanTable(), 3, planTableListener);
            dragSource.createDefaultDragGestureRecognizer(this.tourListGui.getTourJList(), 3, this.tourListListener);
            dragSource.createDefaultDragGestureRecognizer(this.delivererGui.getDelivererJTree(), 3, delivererTreeListener);
        }
        final NavigatorPanel navigatorPanel = this.tourMapGui.getNavigatorPanel();
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (TourManagerCalendarGui.this.tabbedPane.getSelectedComponent() == TourManagerCalendarGui.this.tourMapGui) {
                    navigatorPanel.keyPressed(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (TourManagerCalendarGui.this.tabbedPane.getSelectedComponent() == TourManagerCalendarGui.this.tourMapGui) {
                    navigatorPanel.keyReleased(e);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (TourManagerCalendarGui.this.tabbedPane.getSelectedComponent() == TourManagerCalendarGui.this.tourMapGui) {
                    navigatorPanel.keyTyped(e);
                }
            }
        };
        this.addKeyListener(keyListener);
        this.addKeyListenerRek(keyListener, this.tourMapGui);
        this.addKeyListenerRek(keyListener, this.controlGui);
        this.actions.initializeListeners();
    }

    private void addKeyListenerRek(KeyListener keyListener, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            component.addKeyListener(keyListener);
            if (!(component instanceof Container)) continue;
            this.addKeyListenerRek(keyListener, (Container)component);
        }
    }

    private JPanel createLogoPanel(String companyLogo) {
        ImageIcon logoImageIconSource;
        if (companyLogo == null) {
            companyLogo = "/images/LOGO_BS.jpg";
        }
        try {
            logoImageIconSource = new ImageIcon(IOUtils.toByteArray(this.getClass().getResourceAsStream(companyLogo)));
        }
        catch (IOException e) {
            return new JPanel();
        }
        Image logoImage = logoImageIconSource.getImage().getScaledInstance(FormUtil.SIZEOFLISTANDTREE.width, FormUtil.SIZEOFLISTANDTREE.height, 1);
        JLabel logoLabel = new JLabel(new ImageIcon(logoImage));
        logoLabel.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        JPanel logoPanel = new JPanel();
        logoPanel.add(logoLabel);
        return logoPanel;
    }

    private JPanel createVerticalBoxPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return p;
    }

    public GregorianCalendar getDateFromCol(int col) {
        String stringInColHeader = this.getPlanTableGui().getColumnHeader()[col];
        String[] date = stringInColHeader.split("\n")[2].split(" - ");
        GregorianCalendar dropDate = new GregorianCalendar(Locale.GERMAN);
        dropDate.set(Integer.parseInt(date[2]), Integer.parseInt(date[1]) - 1, Integer.parseInt(date[0]));
        return dropDate;
    }

    public CalendarGui getCalendarGui() {
        return this.calendarGui;
    }

    public TourPlanTableGui getPlanTableGui() {
        return this.planTableGui;
    }

    public DelivererTreeGui getDelivererGui() {
        return this.delivererGui;
    }

    public TourListGui getTourListGui() {
        return this.tourListGui;
    }

    public Set<StopModel> getUnsortedStops() {
        return this.unsortedStops;
    }

    public Set<StopModel> getNewUnsortedStops() {
        this.mergeUnsortedStops(this.actions.getTourCaller().fetchAllUnsortedStops());
        return this.unsortedStops;
    }

    public void mergeUnsortedStops(List<StopModel> stops) {
        for (StopModel stopModel : stops) {
            if (this.stopIsExists(stopModel)) continue;
            this.unsortedStops.add(stopModel);
        }
        ArrayList<StopModel> sortedStops = new ArrayList<StopModel>();
        for (StopModel stopModel : this.unsortedStops) {
            if (stopModel.getTourPart() == null) continue;
            sortedStops.add(stopModel);
        }
        for (StopModel stopModel : sortedStops) {
            this.unsortedStops.remove(stopModel);
        }
    }

    private boolean stopIsExists(StopModel stopModel) {
        for (StopModel oldStopModel : this.unsortedStops) {
            if (!oldStopModel.getTempUUID().equals(stopModel.getTempUUID())) continue;
            return true;
        }
        return false;
    }

    public TourManagerActions getActions() {
        return this.actions;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = ModelEnviroment.getProperties();
        }
        return this.properties;
    }

    public TourMapGui getTourMapGui() {
        return this.tourMapGui;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public List<FilterEntity> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterEntity>();
        }
        return this.filters;
    }

    public TourManagerControlGui getControlGui() {
        return this.controlGui;
    }

    public NavigatorPanel getCurrentNavigatorPanel() {
        return this.tourMapGui.getNavigatorPanel();
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public BusyHandler getBusyHandler() {
        return this.busyHandler;
    }

    public TourListListener getTourListListener() {
        return this.tourListListener;
    }

    public void actionBeforeClose() {
        TourManagerJobManager.shutdown();
    }

    public Set<TourModel> loadGeoTracks() {
        GeoTrackingLegendPane geoTrackingLegendPane = this.getTourMapGui().getGeoTrackingLegendPane();
        geoTrackingLegendPane.loadGeoTracks();
        this.getTourMapGui().getGeoTrackingRenderer().setValues(geoTrackingLegendPane.getTrackingMap());
        this.getTimeLineGui().loadGeoTracks(geoTrackingLegendPane.getTrackingMap());
        this.getTourMapGui().getTourTrackingRenderer().loadGeoTracks(geoTrackingLegendPane.getTrackingMap());
        return geoTrackingLegendPane.getTrackingMap().keySet();
    }

    public TourTimeLineGui getTimeLineGui() {
        return this.timeLineGui;
    }
}

