/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.filter;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.tourmanager.gui.filter.FilterServiceRenderer;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.handler.action.filter.StopFilterSettingActions;
import de.datomino.peppergis.tourmanager.listener.filter.FilterDelivererListener;
import de.datomino.peppergis.tourmanager.listener.filter.FilterServiceComboBoxListener;
import de.datomino.peppergis.tourmanager.listener.filter.StopFilterSettingListener;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.swing.HeightUnifier;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import org.ktde.util.datatypes.Holder;

public class StopFilterSettingDialog
extends JDialog {
    private static final long serialVersionUID = 745151804383258979L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private TourCaller tourCaller;
    private StopFilterEntity filterEntity;
    private StopFilterSettingActions filterSettingActions;
    private JTextField nameField;

    public StopFilterSettingDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public StopFilterSettingDialog(TourManagerCalendarGui tourManagerCalendarGui, StopFilterEntity filterEntity) {
        this((JFrame)null, ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.filter", new Serializable[0]) + "-" + ModelEnviroment.getMessageResolver().resolveMessage("gui.common.setting", new Serializable[0]), true);
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.tourCaller = tourManagerCalendarGui.getActions().getTourCaller();
        if (filterEntity == null) {
            String name = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]) + "-" + ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.filter", new Serializable[0]) + "-";
            filterEntity = new StopFilterEntity(name, LegendType.STOP);
        }
        this.filterEntity = filterEntity;
        this.filterSettingActions = new StopFilterSettingActions(this, this.filterEntity);
        this.initialize();
    }

    private void initialize() {
        try {
            this.setIconImage(ImageIO.read(StopFilterSettingDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.createInputPanel();
        this.createButtonPanel();
        Point locationOfParent = this.tourManagerCalendarGui.getLocationOnScreen();
        this.setLocation(locationOfParent.x + 30, locationOfParent.y + 20);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(600, 330));
    }

    private void createInputPanel() {
        Holder<StopFilterEntity> holder = new Holder<StopFilterEntity>(this.filterEntity);
        JPanel inputPanel = new JPanel(new SpringLayout());
        HeightUnifier heightUnifier = new HeightUnifier();
        JLabel nameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]));
        inputPanel.add(nameLabel);
        this.nameField = ClientSwingUtil.createParameterTextField(50, this.filterEntity.getKey(), true, "Key", holder, this);
        inputPanel.add(this.nameField);
        heightUnifier.add(this.nameField);
        JLabel typeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0]));
        inputPanel.add(typeLabel);
        final EnumComboBox typeComboBox = new EnumComboBox(LegendType.class, false, (Enum[])new LegendType[]{LegendType.STOP, LegendType.UNSORTEDSTOP});
        typeComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        inputPanel.add(typeComboBox);
        heightUnifier.add(typeComboBox);
        JLabel timeWindowLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.timewindow", new Serializable[0]));
        inputPanel.add(timeWindowLabel);
        String dateFormat = FormUtil.TIMEFORMAT;
        JPanel timePanel = new JPanel(new SpringLayout());
        WidthUnifier widthUnifier = new WidthUnifier();
        JTextField startTime = ClientSwingUtil.createParameterTextField(50, ClientFormUtil.dateToString(this.filterEntity.getStartTime(), dateFormat), true, "StartTime", holder, this, dateFormat);
        timePanel.add(startTime);
        widthUnifier.add(startTime);
        JLabel timeToLabel = ClientSwingUtil.createLabelWithTextFieldFont(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " ", 0);
        timePanel.add(timeToLabel);
        JTextField endTime = ClientSwingUtil.createParameterTextField(50, ClientFormUtil.dateToString(this.filterEntity.getEndTime(), dateFormat), true, "EndTime", holder, this, dateFormat);
        timePanel.add(endTime);
        widthUnifier.add(endTime);
        widthUnifier.unifyWidth();
        heightUnifier.add(timePanel);
        SpringUtilities.makeCompactGrid(timePanel, 1, 3, 0, 0, 5, 5);
        inputPanel.add(timePanel);
        JLabel postcodeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]));
        inputPanel.add(postcodeLabel);
        JPanel postcodePanel = new JPanel(new SpringLayout());
        WidthUnifier postCodeWidthUnifier = new WidthUnifier();
        final JTextField startPostcode = ClientSwingUtil.createParameterTextField(50, this.filterEntity.getStartPostcode(), true, "StartPostcode", holder, this);
        postcodePanel.add(startPostcode);
        postCodeWidthUnifier.add(startPostcode);
        JLabel postcodeToLabel = ClientSwingUtil.createLabelWithTextFieldFont(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " ", 0);
        postcodePanel.add(postcodeToLabel);
        final JTextField endPostcode = ClientSwingUtil.createParameterTextField(50, this.filterEntity.getEndPostcode(), true, "EndPostcode", holder, this);
        postcodePanel.add(endPostcode);
        postCodeWidthUnifier.add(endPostcode);
        postCodeWidthUnifier.unifyWidth();
        heightUnifier.add(postcodePanel);
        SpringUtilities.makeCompactGrid(postcodePanel, 1, 3, 0, 0, 5, 5);
        inputPanel.add(postcodePanel);
        JLabel serviceLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.service", new Serializable[0]));
        inputPanel.add(serviceLabel);
        DefaultComboBoxModel<ServiceModel> serviceComboBoxModel = this.createServiceComboBoxModel();
        JComboBox<ServiceModel> serviceComboBox = new JComboBox<ServiceModel>(serviceComboBoxModel);
        serviceComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        serviceComboBox.setRenderer(new FilterServiceRenderer());
        inputPanel.add(serviceComboBox);
        heightUnifier.add(serviceComboBox);
        JLabel delivererLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.deliverer", new Serializable[0]));
        inputPanel.add(delivererLabel);
        final JTextField delivererField = new JTextField("");
        inputPanel.add(delivererField);
        heightUnifier.add(delivererField);
        heightUnifier.unifyHeight();
        SpringUtilities.makeCompactGrid(inputPanel, 6, 2, 5, 5, 5, 5);
        this.getContentPane().add((Component)inputPanel, "North");
        this.fireLegendTypeChange(startPostcode, endPostcode, delivererField, this.filterEntity.getType());
        serviceComboBox.setSelectedIndex(-1);
        if (this.filterEntity.getServices().size() > 0) {
            serviceComboBox.setSelectedItem(this.filterEntity.getServices().iterator().next());
        }
        if (this.filterEntity.getDeliverers().size() > 0) {
            delivererField.setText(DelivererModelUtil.getDisplayString(this.filterEntity.getDeliverers().iterator().next()));
        }
        typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LegendType selected = (LegendType)((Object)typeComboBox.getSelectedValue());
                    StopFilterSettingDialog.this.filterEntity.setType(selected);
                    StopFilterSettingDialog.this.fireLegendTypeChange(startPostcode, endPostcode, delivererField, selected);
                }
            }
        });
        this.addListeners(serviceComboBox, delivererField);
    }

    private void addListeners(JComboBox<ServiceModel> serviceComboBox, JTextField delivererField) {
        FilterServiceComboBoxListener filterServiceComboBoxListener = new FilterServiceComboBoxListener(this.filterEntity, false);
        serviceComboBox.addItemListener(filterServiceComboBoxListener);
        FilterDelivererListener filterDelivererListener = new FilterDelivererListener(this.filterEntity, delivererField, this.tourCaller.fetchAllDeliverers(), false);
        delivererField.getDocument().addDocumentListener(filterDelivererListener);
    }

    private void createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton applyFilterButton = new JButton(this.filterSettingActions.getApplyFilterActions());
        buttonPanel.add(applyFilterButton);
        JButton storeFilterButton = new JButton(this.filterSettingActions.getStoreFilterAction());
        buttonPanel.add(storeFilterButton);
        JButton deleteFilterButton = new JButton(this.filterSettingActions.getDeleteFilterAction());
        buttonPanel.add(deleteFilterButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private DefaultComboBoxModel<ServiceModel> createServiceComboBoxModel() {
        List<ServiceModel> serviceList = this.tourCaller.fetchAllServices();
        serviceList.add(0, null);
        ServiceModel[] allServices = new ServiceModel[serviceList.size()];
        return new DefaultComboBoxModel<ServiceModel>(serviceList.toArray(allServices));
    }

    public static void createAndShowDialog(TourManagerCalendarGui tourManagerCalendarGui, StopFilterEntity filterEntity) {
        StopFilterSettingDialog filterSettingDialog = new StopFilterSettingDialog(tourManagerCalendarGui, filterEntity);
        StopFilterSettingListener filterSettingListener = new StopFilterSettingListener(filterSettingDialog);
        filterSettingDialog.addWindowListener(filterSettingListener);
        filterSettingDialog.pack();
        filterSettingDialog.setVisible(true);
    }

    public TourManagerCalendarGui getTourManagerCalendarGui() {
        return this.tourManagerCalendarGui;
    }

    public StopFilterSettingActions getFilterSettingActions() {
        return this.filterSettingActions;
    }

    public JTextField getNameField() {
        return this.nameField;
    }

    private void fireLegendTypeChange(JTextField startPostcode, JTextField endPostcode, JTextField deliverer, LegendType legendType) {
        switch (legendType) {
            case STOP: {
                this.filterEntity.setStartPostcode(null);
                this.filterEntity.setEndPostcode(null);
                startPostcode.setEnabled(false);
                endPostcode.setEnabled(false);
                deliverer.setEnabled(true);
                break;
            }
            case UNSORTEDSTOP: {
                this.filterEntity.setDeliverers(null);
                startPostcode.setEnabled(true);
                endPostcode.setEnabled(true);
                deliverer.setText(null);
                deliverer.setEnabled(false);
                break;
            }
            default: {
                throw new RuntimeException("invalid filter type - " + (Object)((Object)legendType));
            }
        }
        startPostcode.repaint(10L);
        endPostcode.repaint(10L);
        deliverer.repaint(10L);
    }
}

