/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui;

import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.tour.CalculateSettingDialog;
import de.datomino.peppergis.tourmanager.gui.tour.OptimiseSettingDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.ktde.util.StringUtil;

public abstract class ToursRoutingDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = -9065716323792979260L;
    private static final String VEHICLE_PROPERTY_KEY = "tour.optimize.vehicle";
    private static final String CALC_TYPE_PROPERTY_KEY = "tour.optimize.calculationType";
    private TourManagerCalendarGui gui;
    private JRadioButton calculate;
    private JRadioButton optimise;
    private JRadioButton reset;
    private JRadioButton motorcar;
    private JRadioButton foot;
    private JRadioButton bike;

    public ToursRoutingDialog(TourManagerCalendarGui gui) {
        super(gui.getModelEnviroment(), gui, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.gui = gui;
    }

    @Override
    protected Component getMainComponent() {
        JPanel pane = new JPanel();
        BoxLayout boxLayout = new BoxLayout(pane, 1);
        pane.setLayout(boxLayout);
        JPanel typePane = new JPanel(new FlowLayout());
        typePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.calculate = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculate", new Serializable[]{""}));
        typePane.add(this.calculate);
        this.optimise = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.optimise", new Serializable[]{""}));
        typePane.add(this.optimise);
        this.reset = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.reset", new Serializable[0]));
        typePane.add(this.reset);
        ButtonGroup group = new ButtonGroup();
        group.add(this.calculate);
        group.add(this.optimise);
        group.add(this.reset);
        String prop = ModelEnviroment.getProperties().getProperty(CALC_TYPE_PROPERTY_KEY);
        boolean wasSet = false;
        if (prop != null) {
            switch (prop) {
                case "CALCULATE": {
                    wasSet = true;
                    this.calculate.setSelected(true);
                    break;
                }
                case "OPTIMIZE": {
                    wasSet = true;
                    this.optimise.setSelected(true);
                    break;
                }
                case "RESET": {
                    wasSet = true;
                    this.reset.setSelected(true);
                }
            }
        }
        if (!wasSet) {
            this.optimise.setSelected(true);
        }
        pane.add(typePane);
        JPanel vehiclePane = new JPanel(new FlowLayout());
        vehiclePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.motorcar = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.MOTORCAR));
        vehiclePane.add(this.motorcar);
        this.foot = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.FOOT));
        vehiclePane.add(this.foot);
        this.bike = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.BIKE));
        vehiclePane.add(this.bike);
        ButtonGroup vehicleGroup = new ButtonGroup();
        vehicleGroup.add(this.motorcar);
        vehicleGroup.add(this.foot);
        vehicleGroup.add(this.bike);
        prop = ModelEnviroment.getProperties().getProperty(VEHICLE_PROPERTY_KEY);
        wasSet = false;
        if (prop != null) {
            switch (prop) {
                case "FOOT": {
                    wasSet = true;
                    this.foot.setSelected(true);
                    break;
                }
                case "BIKE": {
                    wasSet = true;
                    this.bike.setSelected(true);
                    break;
                }
                case "MOTORCAR": {
                    wasSet = true;
                    this.motorcar.setSelected(true);
                }
            }
        }
        if (!wasSet) {
            this.foot.setSelected(true);
        }
        pane.add(vehiclePane);
        return pane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(this.getOkActionName()){
            private static final long serialVersionUID = 4753099193275092139L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ToursRoutingDialog.this.dispose();
                ToursRoutingDialog.this.routTour();
            }
        };
    }

    protected abstract Collection<TourModel> getTours();

    protected abstract void repaintGui();

    private void routTour() {
        boolean optimised = this.optimise.isSelected();
        boolean importOrder = this.reset.isSelected();
        RouteVehicleType routeVehicleType = null;
        if (this.motorcar.isSelected()) {
            routeVehicleType = RouteVehicleType.MOTORCAR;
        } else if (this.foot.isSelected()) {
            routeVehicleType = RouteVehicleType.FOOT;
        } else if (this.bike.isSelected()) {
            routeVehicleType = RouteVehicleType.BIKE;
        }
        RouteType routeType = routeVehicleType.getRouteType();
        this.routTour(optimised, importOrder, routeVehicleType, routeType);
    }

    private void routTour(boolean optimised, boolean importOrder, RouteVehicleType routeVehicleType, RouteType routeType) {
        ModelEnviroment modelEnviroment = this.gui.getModelEnviroment();
        TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        Collection<TourModel> tours = this.getTours();
        if (tours == null || tours.isEmpty()) {
            return;
        }
        UndoManager undoManager = modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        boolean poiSelectionActive = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("tour.routing.poiSelection.active"));
        boolean update = false;
        if (optimised) {
            update = OptimiseSettingDialog.createAndShow(tours, tourCaller, this.gui, routeVehicleType, routeType, poiSelectionActive, this.gui);
            undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.optimise", Integer.valueOf(tours.size())));
        } else {
            update = CalculateSettingDialog.createAndShow(tours, tourCaller, this.gui, importOrder, routeVehicleType, routeType, poiSelectionActive, modelEnviroment);
            if (importOrder) {
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.reset", Integer.valueOf(tours.size())));
            } else {
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.calculate", Integer.valueOf(tours.size())));
            }
        }
        undoManager.startTransaction();
        if (update) {
            this.repaintGui();
        }
    }
}

