/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tour;

import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.RouteBackType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.RoutingType;
import de.datomino.peppergis.tour.ParcelParameter;
import de.datomino.peppergis.tour.SubscriptionParameter;
import de.datomino.peppergis.type.ParcelBlockType;
import de.datomino.peppergis.type.Product;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.peppergis.util.NightSurchargeTimeWindow;
import de.datomino.peppergis.util.RewardEntity;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.ktde.util.StringUtil;

public class AreaTourParameter
implements Serializable {
    private static final long serialVersionUID = -4720420345481716353L;
    private AreaTourType areaTourType;
    private RouteVehicleType routeVehicleTypeInArea;
    private RouteVehicleType routeVehicleTypeFromPoi;
    private RouteVehicleType routeVehicleTypeFromPickPoint;
    private RouteType routeTypeInArea;
    private RouteType routeTypeFromPoi;
    private RouteType routeTypeFromPickPoint;
    private RoutingType routingType;
    private int sizeOfStartBlock;
    private int sizeOfEndBlock;
    private boolean poi;
    private boolean calculateWithoutPoi = true;
    private boolean startPickPoint;
    private boolean endPickPoint;
    private boolean save = true;
    private RouteBackType back = RouteBackType.NONE;
    private boolean distanceMatrixClear = false;
    private Boolean difficultyLevelDescriptor;
    private Boolean parcelLocationDescriptor;
    private Double difficultyLevel;
    private Double parcelLocation;
    private OptimizationAlgorithmType algorithmType = OptimizationAlgorithmType.DEFAULT_SEGMENT_MIDDLE;
    private Collection<BlockDescriptor> parcelBlock;
    private boolean renew = false;
    private boolean origSortOrder;
    private Long areaObjectId;
    private boolean preferExclusion;
    private boolean allowOnlyAlreadyCalculatedTours;
    private Collection<Product> deliveryProducts;
    private Long deliveryRoundId;
    private Date date;
    private RewardEntity rewardEntity;
    private NightSurchargeTimeWindow night;

    public AreaTourParameter(AreaTourType areaTourType, RoutingType routingType, Date date) {
        this(areaTourType, RouteVehicleType.FOOT, RouteType.SHORTEST, routingType, false, false, false, true, RouteBackType.NONE, date);
    }

    public AreaTourParameter(AreaTourType areaTourType, RouteVehicleType routeVehicleType, RouteType routeType, RoutingType routingType, boolean poi, boolean startPickPoint, boolean endPickPoint, boolean save, RouteBackType back, Date date) {
        this(areaTourType, routeVehicleType, routeType, routingType, poi, startPickPoint, endPickPoint, save, back, null, null, date);
    }

    public AreaTourParameter(AreaTourType areaTourType, RouteVehicleType routeVehicleType, RouteType routeType, RoutingType routingType, boolean poi, boolean startPickPoint, boolean endPickPoint, boolean save, RouteBackType back, Boolean difficultyLevelDescriptor, Boolean parcelLocationDescriptor, Date date) {
        this(areaTourType, routeVehicleType, routeType, routingType, poi, startPickPoint, endPickPoint, save, back, difficultyLevelDescriptor, parcelLocationDescriptor, date, Collections.EMPTY_LIST, true);
    }

    public AreaTourParameter(AreaTourType areaTourType, RouteVehicleType routeVehicleType, RouteType routeType, RoutingType routingType, boolean poi, boolean startPickPoint, boolean endPickPoint, boolean save, RouteBackType back, Boolean difficultyLevelDescriptor, Boolean parcelLocationDescriptor, Date date, Collection<BlockDescriptor> parcelBlock, boolean preferExclusion) {
        this.date = date;
        this.areaTourType = areaTourType;
        this.routeVehicleTypeInArea = routeVehicleType;
        this.routeTypeInArea = routeType;
        this.routingType = routingType;
        this.poi = poi;
        this.startPickPoint = startPickPoint;
        this.endPickPoint = endPickPoint;
        this.save = save;
        this.back = back;
        this.difficultyLevelDescriptor = difficultyLevelDescriptor;
        this.parcelLocationDescriptor = parcelLocationDescriptor;
        this.parcelBlock = parcelBlock;
        this.preferExclusion = preferExclusion;
    }

    public AreaTourParameter() {
    }

    public AreaTourType getAreaTourType() {
        return this.areaTourType;
    }

    public void setAreaTourType(AreaTourType areaTourType) {
        this.areaTourType = areaTourType;
    }

    public RouteVehicleType getRouteVehicleTypeInArea() {
        return this.routeVehicleTypeInArea;
    }

    public void setRouteVehicleTypeInArea(RouteVehicleType routeVehicleTypeInArea) {
        this.routeVehicleTypeInArea = routeVehicleTypeInArea;
    }

    public RouteVehicleType getRouteVehicleTypeFromPoi() {
        if (this.routeVehicleTypeFromPoi == null) {
            this.routeVehicleTypeFromPoi = this.routeVehicleTypeInArea;
        }
        return this.routeVehicleTypeFromPoi;
    }

    public void setRouteVehicleTypeFromPoi(RouteVehicleType routeVehicleTypeFromPoi) {
        this.routeVehicleTypeFromPoi = routeVehicleTypeFromPoi;
    }

    public RouteVehicleType getRouteVehicleTypeFromPickPoint() {
        if (this.routeVehicleTypeFromPickPoint == null) {
            this.routeVehicleTypeFromPickPoint = this.routeVehicleTypeInArea;
        }
        return this.routeVehicleTypeFromPickPoint;
    }

    public void setRouteVehicleTypeFromPickPoint(RouteVehicleType routeVehicleTypeFromPickPoint) {
        this.routeVehicleTypeFromPickPoint = routeVehicleTypeFromPickPoint;
    }

    public RouteType getRouteTypeInArea() {
        return this.routeTypeInArea;
    }

    public void setRouteTypeInArea(RouteType routeTypeInArea) {
        this.routeTypeInArea = routeTypeInArea;
    }

    public RouteType getRouteTypeFromPoi() {
        if (this.routeTypeFromPoi == null) {
            this.routeTypeFromPoi = this.routeTypeInArea;
        }
        return this.routeTypeFromPoi;
    }

    public void setRouteTypeFromPoi(RouteType routeTypeFromPoi) {
        this.routeTypeFromPoi = routeTypeFromPoi;
    }

    public RouteType getRouteTypeFromPickPoint() {
        if (this.routeTypeFromPickPoint == null) {
            this.routeTypeFromPickPoint = this.routeTypeInArea;
        }
        return this.routeTypeFromPickPoint;
    }

    public void setRouteTypeFromPickPoint(RouteType routeTypeFromPickPoint) {
        this.routeTypeFromPickPoint = routeTypeFromPickPoint;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public boolean isPoi() {
        return this.poi;
    }

    public void setPoi(boolean poi) {
        this.poi = poi;
    }

    public boolean isCalculateWithoutPoi() {
        return this.calculateWithoutPoi;
    }

    public void setCalculateWithoutPoi(boolean calculateWithoutPoi) {
        this.calculateWithoutPoi = calculateWithoutPoi;
    }

    public boolean isStartPickPoint() {
        return this.startPickPoint;
    }

    public void setStartPickPoint(boolean startPickPoint) {
        this.startPickPoint = startPickPoint;
    }

    public boolean isEndPickPoint() {
        return this.endPickPoint;
    }

    public void setEndPickPoint(boolean endPickPoint) {
        this.endPickPoint = endPickPoint;
    }

    public boolean isSave() {
        return this.save;
    }

    public void setSave(boolean save) {
        this.save = save;
    }

    public RouteBackType getBack() {
        return this.back;
    }

    public void setBack(RouteBackType back) {
        this.back = back;
    }

    public boolean isDistanceMatrixClear() {
        return this.distanceMatrixClear;
    }

    public void setDistanceMatrixClear(boolean distanceMatrixClear) {
        this.distanceMatrixClear = distanceMatrixClear;
    }

    public Boolean getDifficultyLevelDescriptor() {
        return this.difficultyLevelDescriptor;
    }

    public void setDifficultyLevelDescriptor(Boolean difficultyLevelDescriptor) {
        this.difficultyLevelDescriptor = difficultyLevelDescriptor;
    }

    public Boolean getParcelLocationDescriptor() {
        return this.parcelLocationDescriptor;
    }

    public void setParcelLocationDescriptor(Boolean parcelLocationDescriptor) {
        this.parcelLocationDescriptor = parcelLocationDescriptor;
    }

    public OptimizationAlgorithmType getAlgorithmType() {
        if (this.areaTourType == null) {
            return this.algorithmType;
        }
        switch (this.areaTourType.getAreaCalculationType()) {
            case CALCULATION: {
                return null;
            }
        }
        return this.algorithmType;
    }

    public void setAlgorithmType(OptimizationAlgorithmType algorithmType) {
        this.algorithmType = algorithmType;
    }

    public String getInfo() {
        String subVehicleType = this.routeVehicleTypeFromPoi == null ? "" : this.routeVehicleTypeFromPoi.name();
        subVehicleType = subVehicleType + (" - " + (Object)((Object)this.routeVehicleTypeFromPickPoint) == null ? "" : this.routeVehicleTypeFromPickPoint.name());
        return this.routingType + ", " + (Object)((Object)this.routeVehicleTypeInArea) + (StringUtil.isBlank(subVehicleType) ? "" : "(" + subVehicleType + ")") + ", " + (Object)((Object)this.routeTypeInArea) + ", " + this.areaTourType;
    }

    public Collection<BlockDescriptor> getParcelBlock() {
        if (this.parcelBlock == null) {
            this.parcelBlock = Collections.EMPTY_SET;
        }
        return this.parcelBlock;
    }

    public void setParcelBlock(Collection<BlockDescriptor> parcelBlock) {
        this.parcelBlock = parcelBlock;
    }

    public int getSizeOfStartBlock() {
        return this.sizeOfStartBlock;
    }

    public void setSizeOfStartBlock(int sizeOfStartBlock) {
        this.sizeOfStartBlock = sizeOfStartBlock;
    }

    public int getSizeOfEndBlock() {
        return this.sizeOfEndBlock;
    }

    public void setSizeOfEndBlock(int sizeOfEndBlock) {
        this.sizeOfEndBlock = sizeOfEndBlock;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    public boolean isOrigSortOrder() {
        return this.origSortOrder;
    }

    public void setOrigSortOrder(boolean origSortOrder) {
        this.origSortOrder = origSortOrder;
    }

    public Long getAreaObjectId() {
        return this.areaObjectId;
    }

    public void setAreaObjectId(Long areaObjectId) {
        this.areaObjectId = areaObjectId;
    }

    public Collection<Product> getDeliveryProducts() {
        return this.deliveryProducts;
    }

    public void setDeliveryProducts(Collection<Product> deliveryProducts) {
        this.deliveryProducts = deliveryProducts;
    }

    public Long getDeliveryRoundId() {
        return this.deliveryRoundId;
    }

    public void setDeliveryRoundId(Long deliveryRoundId) {
        this.deliveryRoundId = deliveryRoundId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setValue(AreaTourParameter clone) {
        for (Field field : AreaTourParameter.class.getDeclaredFields()) {
            try {
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.set(clone, field.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        clone.parcelBlock = this.parcelBlock == null ? null : new HashSet<BlockDescriptor>(this.parcelBlock);
        clone.deliveryProducts = this.deliveryProducts == null ? null : new HashSet<Product>(this.deliveryProducts);
    }

    public AreaTourParameter getClone() {
        AreaTourParameter clone = new AreaTourParameter();
        if (this instanceof ParcelParameter) {
            clone = new ParcelParameter();
            ((ParcelParameter)this).setValue(clone);
        } else if (this instanceof SubscriptionParameter) {
            clone = new SubscriptionParameter();
            ((SubscriptionParameter)this).setValue(clone);
        } else {
            this.setValue(clone);
        }
        return clone;
    }

    public Double getDifficultyLevel() {
        return this.difficultyLevel;
    }

    public void setDifficultyLevel(Double difficultyLevel) {
        this.difficultyLevel = difficultyLevel;
    }

    public Double getParcelLocation() {
        return this.parcelLocation;
    }

    public void setParcelLocation(Double parcelLocation) {
        this.parcelLocation = parcelLocation;
    }

    public boolean isPreferExclusion() {
        return this.preferExclusion;
    }

    public void setPreferExclusion(boolean preferExclusion) {
        this.preferExclusion = preferExclusion;
    }

    public void setAllowOnlyAlreadyCalculatedTours(boolean allowOnlyAlreadyCalculatedTours) {
        this.allowOnlyAlreadyCalculatedTours = allowOnlyAlreadyCalculatedTours;
    }

    public boolean isAllowOnlyAlreadyCalculatedTours() {
        return this.allowOnlyAlreadyCalculatedTours;
    }

    public boolean isGroup() {
        return this.areaTourType.getAreaCalculationType() == AreaCalculationType.GROUP;
    }

    public RewardEntity getRewardEntity() {
        return this.rewardEntity;
    }

    public void setRewardEntity(RewardEntity rewardEntity) {
        this.rewardEntity = rewardEntity;
    }

    public NightSurchargeTimeWindow getNight() {
        return this.night;
    }

    public void setNight(NightSurchargeTimeWindow night) {
        this.night = night;
    }

    public boolean isParcelSortOrder() {
        AreaCalculationType areaCalculationType = this.areaTourType.getAreaCalculationType();
        return areaCalculationType == AreaCalculationType.PARCEL_SORT_ORDER;
    }

    public static class BlockDescriptor
    implements Serializable {
        private static final long serialVersionUID = -5503837390061135846L;
        private String key;
        private Boolean value;
        private ParcelBlockType parcelBlockType;

        public BlockDescriptor(String key, Boolean value, ParcelBlockType parcelBlockType) {
            this.key = key;
            this.value = value;
            this.parcelBlockType = parcelBlockType;
        }

        public String getKey() {
            return this.key;
        }

        public Boolean getValue() {
            return this.value;
        }

        public ParcelBlockType getParcelBlockType() {
            return this.parcelBlockType;
        }
    }
}

