/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.special;

import de.datomino.peppergis.client.gui.area.MultiAreaObjectSelectionPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.special.AreaSelectionDialog;
import de.datomino.util.callback.CallBack;
import de.datomino.util.geo.swing.ObjectSelectionChangedEvent;
import de.datomino.util.geo.swing.ObjectSelectionListener;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class GraphicalMultiAreaSelectionPane
extends MultiAreaObjectSelectionPane {
    private static final long serialVersionUID = -599055338855574450L;
    private AreaLayerModel selectingLayer;
    private AreaSelectionDialog areaSelectionDialog;

    public GraphicalMultiAreaSelectionPane(ModelEnviroment modelEnviroment) {
        super(modelEnviroment);
    }

    @Override
    protected Action getSpecialChooserAction() {
        return new ChooseByGuiAction();
    }

    @Override
    protected Set<AreaObjectModel> getAreaObjectModelsToCalculate() {
        Set<AreaObjectModel> set = super.getAreaObjectModelsToCalculate();
        if (this.selectingLayer != null) {
            HashSet<AreaObjectModel> toRemove = new HashSet<AreaObjectModel>();
            for (AreaObjectModel areaObjectModel : set) {
                if (!areaObjectModel.getAreaLayer().equals(this.selectingLayer)) continue;
                toRemove.add(areaObjectModel);
            }
            set.removeAll(toRemove);
            set.addAll(this.areaSelectionDialog.getAreaSelectionPane().getSelectedObjects());
        }
        return set;
    }

    private class CalculatingObjectSelectionListener
    implements ObjectSelectionListener<AreaObjectModel> {
        private CalculatingObjectSelectionListener() {
        }

        @Override
        public void selectionChanged(ObjectSelectionChangedEvent<AreaObjectModel> objectSelectionChangedEvent) {
            GraphicalMultiAreaSelectionPane.this.recalcSums();
        }
    }

    private class SelectionCallback
    implements CallBack<Object, AreaObjectModel> {
        private Set<AreaObjectModel> preSelected;

        public SelectionCallback(Set<AreaObjectModel> preSelected) {
            this.preSelected = preSelected;
        }

        public Object execute(AreaObjectModel ... s) {
            HashSet<AreaObjectModel> set = new HashSet<AreaObjectModel>();
            for (AreaObjectModel areaObjectModel : s) {
                set.add(areaObjectModel);
            }
            GraphicalMultiAreaSelectionPane.this.removeSelection(this.preSelected);
            GraphicalMultiAreaSelectionPane.this.addSelection(set);
            return null;
        }
    }

    private class ChooseByGuiAction
    extends AbstractAction {
        private static final long serialVersionUID = -5652487065350942029L;

        public ChooseByGuiAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.chooseAreaOnMap", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaLayerModel layer = GraphicalMultiAreaSelectionPane.this.getSelectedAreaLayer();
            if (layer != null) {
                GraphicalMultiAreaSelectionPane.this.selectingLayer = layer;
                Collection<AreaObjectModel> selectedAreaObjects = GraphicalMultiAreaSelectionPane.this.getSelectedAreaObjects();
                HashSet<AreaObjectModel> layerObjects = new HashSet<AreaObjectModel>();
                for (AreaObjectModel areaObjectModel : selectedAreaObjects) {
                    if (!areaObjectModel.getAreaLayer().equals(layer)) continue;
                    layerObjects.add(areaObjectModel);
                }
                GraphicalMultiAreaSelectionPane.this.areaSelectionDialog = new AreaSelectionDialog(GraphicalMultiAreaSelectionPane.this.getModelEnviroment(), SwingUtils.findWindowParent(GraphicalMultiAreaSelectionPane.this), layer.getId(), new SelectionCallback(layerObjects), layerObjects){
                    private static final long serialVersionUID = -7833569555697895402L;

                    @Override
                    protected void processWindowEvent(WindowEvent e) {
                        if (e.getID() == 202) {
                            GraphicalMultiAreaSelectionPane.this.selectingLayer = null;
                        }
                        super.processWindowEvent(e);
                    }
                };
                GraphicalMultiAreaSelectionPane.this.areaSelectionDialog.getAreaSelectionPane().addObjectSelectionListener(new CalculatingObjectSelectionListener());
                GraphicalMultiAreaSelectionPane.this.areaSelectionDialog.setVisible(true);
            }
        }
    }
}

