/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.special;

import de.datomino.peppergis.client.action.search.CommonSearchAction;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.action.ShowAreaLayerAction;
import de.datomino.peppergis.simplebasearea.special.AreaSelectionPane;
import de.datomino.util.callback.CallBack;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.ktde.util.datatypes.Tripel;

public class AreaSelectionDialog
extends CommonDialog {
    private static final long serialVersionUID = 8794292262688287922L;
    private Long editBaseLayerId;
    private AreaSelectionPane areaSelectionPane;
    private ModelEnviroment modelEnviroment;
    private CallBack<?, AreaObjectModel> callBack;
    private Collection<AreaObjectModel> preselected;

    public AreaSelectionDialog(ModelEnviroment modelEnviroment, Window parent, Long editBaseLayerId, CallBack<?, AreaObjectModel> callBack, Collection<AreaObjectModel> preselected) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.chooseAreaOnMap", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.editBaseLayerId = editBaseLayerId;
        this.modelEnviroment = modelEnviroment;
        this.callBack = callBack;
        this.preselected = preselected;
        this.buildLayout();
        this.createMenu();
        this.setSize(600, 500);
        SwingUtils.center(this);
    }

    protected void createMenu() {
        Collection<Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>> showLayerActions = this.areaSelectionPane.getShowLayerActions().values();
        JMenuBar menuBar = new JMenuBar();
        if (!showLayerActions.isEmpty()) {
            JMenu viewMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.view", new Serializable[0]));
            viewMenu.addSeparator();
            for (Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>> toggleAction : showLayerActions) {
                viewMenu.add(new JCheckBoxMenuItem(toggleAction.getElement1()));
            }
            menuBar.add(viewMenu);
        }
        JMenu search = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0]));
        final CommonSearchAction searchAction = this.getAreaSelectionPane().getSearchActionMenu();
        search.add(searchAction);
        Action searchAreaAction = this.getAreaSelectionPane().getSearchAreaAction();
        search.add(searchAreaAction);
        search.addSeparator();
        Action centerAreaOnMapAction = this.getAreaSelectionPane().getCenterSelectedAreaObjectsAction();
        search.add(centerAreaOnMapAction);
        search.add(new AbstractAction("Markierungen l\u00f6schen"){
            private static final long serialVersionUID = 146427223919594767L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (searchAction instanceof CommonSearchAction) {
                    ((CommonSearchAction)searchAction).clearCoordinate();
                }
            }
        });
        menuBar.add(search);
        this.setJMenuBar(menuBar);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            if (this.preselected != null && !this.preselected.isEmpty()) {
                this.areaSelectionPane.select(this.preselected);
                this.areaSelectionPane.getCenterSelectedAreaObjectsAction().actionPerformed(new ActionEvent(this, 0, ""));
            }
            this.preselected = null;
        }
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -3044191992881775350L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<AreaObjectModel> selectedObjects = AreaSelectionDialog.this.areaSelectionPane.getSelectedObjects();
                AreaObjectModel[] areaObjectModels = new AreaObjectModel[selectedObjects.size()];
                int i = 0;
                for (AreaObjectModel areaObjectModel : selectedObjects) {
                    areaObjectModels[i++] = areaObjectModel;
                }
                AreaSelectionDialog.this.callBack.execute(areaObjectModels);
                AreaSelectionDialog.this.dispose();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4525606443151127614L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaSelectionDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        this.areaSelectionPane = new AreaSelectionPane(this.modelEnviroment, this.editBaseLayerId);
        return this.areaSelectionPane;
    }

    public AreaSelectionPane getAreaSelectionPane() {
        return this.areaSelectionPane;
    }
}

