/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.print;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.pdf.printer.PrintRenderer;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.pdf.printer.SvgHandler;
import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.gui.area.AreaNameRenderingType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.AbstractOsmSvgExportFetcherException;
import de.datomino.peppergis.client.gui.osm.NotThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.osm.OsmSvgExportFetcher;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRendererPrintTypeDecider;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.print.PlaceNameRenderer;
import de.datomino.peppergis.client.print.ScreenShotType;
import de.datomino.peppergis.client.print.StreetNameRenderer;
import de.datomino.peppergis.client.print.WhiteRectangleScreenShotRenderer;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.attribute.AttributeHelper;
import de.datomino.peppergis.client.util.wrapper.area.attribute.AreaAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.area.attribute.AreaAttributeValueModelAttributeWrapper;
import de.datomino.peppergis.print.AreaNamePrintType;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.ShowAreaLayerAction;
import de.datomino.peppergis.simplebasearea.action.print.AreaPrinterInformation;
import de.datomino.peppergis.simplebasearea.print.AreaPrintAreaLayerPrintTypeDecider;
import de.datomino.peppergis.simplebasearea.print.AreaPrinter;
import de.datomino.peppergis.simplebasearea.print.AreaPrintingInformation;
import de.datomino.peppergis.simplebasearea.print.AreaScreenShotAreaLayerPrintTypeDecider;
import de.datomino.peppergis.simplebasearea.print.legend.AreaPrinterImplLegendUtil;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.comparator.ComparatorBuilder;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.StaticGeoObjectBucketsModel;
import de.datomino.util.swing.ImagePosition;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpException;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.MapNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AreaPrinterImpl
implements AreaPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaPrinter.class);
    private static final String TEMPLATENAME = "fo/area_printing.vm";
    private static final String SCREENSHOT_TEMPLATE = "fo/area_printing_screenshot.vm";
    private static final SAXParserFactory SAX_FACTORY;
    private static final SimpleDateFormat sm;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public AreaPrinterImpl(BaseLayerEditorPanel baseLayerEditorPanel) {
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public InputStream printImage(NavigatorPanel navigatorPanel, PrinterInformation printInformation) throws Exception {
        ScreenShotType screenShotType = ScreenShotType.APPEND_TO_FORMAT;
        try {
            screenShotType = ScreenShotType.valueOf(ModelEnviroment.getProperties().getProperty("print.screenshot.type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Format format = printInformation.getFormat();
        Tupel<Double, Double> dim = format.getSizes(printInformation.getDpi(), 60.0, 60.0);
        double width = dim.getElement1();
        double lineHeight = (double)printInformation.getDpi().intValue() / (printInformation.isUseVector() ? 4.0 : 8.0);
        double height = dim.getElement2() - lineHeight;
        double widthMM = width / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        double heightMM = height / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        int iWidth = (int)Math.round(width);
        int iHeight = (int)Math.round(height);
        HashMap<String, Collection<Image>> inputImageCollection = new HashMap<String, Collection<Image>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ImageModel logo = this.baseLayerEditorPanel.getCurrentAreaLayer().getLogo();
        this.setParameter(dataMap, logo == null ? null : logo.getData());
        if (printInformation.isUseVector()) {
            NavigatorPanel printNavigatorPanel = this.createPrintNavigatorPanel(navigatorPanel, null, false, iWidth, iHeight, printInformation, 1.2);
            Coordinate bottomLeft = printNavigatorPanel.getCoordinateFactory().createCoordinate(navigatorPanel.getRealBoundaryBottomLeft());
            Coordinate topRight = printNavigatorPanel.getCoordinateFactory().createCoordinate(navigatorPanel.getRealBoundaryTopRight());
            OsmSvgExportFetcher osmSvgExportFetcher = new OsmSvgExportFetcher();
            Coordinate topLeft = printNavigatorPanel.getCoordinateFactory().createCoordinate(bottomLeft.getX(), topRight.getY());
            Coordinate bottomRight = printNavigatorPanel.getCoordinateFactory().createCoordinate(topRight.getX(), bottomLeft.getY());
            Tripel<String, Coordinate, Coordinate> tripel = osmSvgExportFetcher.fetchSvg(topLeft, bottomRight, widthMM, heightMM, printInformation.getMarginX(), printInformation.getMarginY(), true);
            String string = tripel.getElement1();
            topLeft = tripel.getElement2();
            bottomRight = tripel.getElement3();
            Tupel<Integer, Integer> tupel = this.extractWidthAndHeightFromSvg(string);
            int rWidth = tupel.getElement1();
            int rHeight = tupel.getElement2();
            StringBuilder sb = new StringBuilder();
            for (NavigatorRenderer navigatorRenderer : printNavigatorPanel.getRenderers()) {
                PrintRenderer printRenderer;
                Tupel<SVGGraphics2D, Double> svg;
                SVGGraphics2D element1;
                String removeSvgAndEnrich;
                if (navigatorRenderer instanceof MapNavigatorRenderer || !navigatorRenderer.isActive()) continue;
                AreaLayerRenderer areaLayerRenderer = null;
                AreaLayerRendererPrintTypeDecider areaLayerRendererPrintTypeDecider = null;
                if (navigatorRenderer instanceof AreaLayerRenderer) {
                    areaLayerRenderer = (AreaLayerRenderer)navigatorRenderer;
                    areaLayerRendererPrintTypeDecider = areaLayerRenderer.getAreaLayerRendererPrintTypeDecider();
                    AreaScreenShotAreaLayerPrintTypeDecider printAreaLayerRendererPrintTypeDecider = new AreaScreenShotAreaLayerPrintTypeDecider(areaLayerRendererPrintTypeDecider);
                    areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(printAreaLayerRendererPrintTypeDecider);
                }
                if ((removeSvgAndEnrich = this.removeSvgAndEnrich(element1 = (svg = (printRenderer = new PrintRenderer(navigatorPanel, navigatorRenderer, topLeft, bottomRight, navigatorPanel.getUpp())).render(rWidth, rHeight)).getElement1(), svg.getElement2())) != null) {
                    sb.append(removeSvgAndEnrich);
                }
                if (areaLayerRenderer == null) continue;
                areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(areaLayerRendererPrintTypeDecider);
            }
            String toImport = sb.toString();
            FileUtils.writeStringToFile(new File("/tmp/s.svg"), toImport);
            sb = null;
            String string2 = this.includeIntoSvg(string, toImport);
            dataMap.put("svg", true);
            dataMap.put("image", string2);
            String heightString = heightMM + "mm";
            dataMap.put("imageHeight", heightString);
            String widthString = widthMM + "mm";
            dataMap.put("imageWidth", widthString);
        } else {
            double f = 1.0 / ((double)printInformation.getDpi().intValue() / 150.0);
            iWidth = (int)((double)iWidth * f);
            iHeight = (int)((double)iHeight * f);
            NavigatorPanel printNavigatorPanel = this.createPrintNavigatorPanel(navigatorPanel, null, false, iWidth, iHeight, printInformation, 1.2);
            printNavigatorPanel.zoom(f);
            Coordinate bottomLeft = printNavigatorPanel.getCoordinateFactory().createCoordinate(navigatorPanel.getRealBoundaryBottomLeft());
            Coordinate topRight = printNavigatorPanel.getCoordinateFactory().createCoordinate(navigatorPanel.getRealBoundaryTopRight());
            printNavigatorPanel.center(CollectionUtil.buildArrayList(bottomLeft, topRight), 1.0, false);
            IdentityHashMap<AreaLayerRenderer, AreaLayerRendererPrintTypeDecider> deciderMap = new IdentityHashMap<AreaLayerRenderer, AreaLayerRendererPrintTypeDecider>();
            for (NavigatorRenderer navigatorRenderer : printNavigatorPanel.getRenderers()) {
                if (!(navigatorRenderer instanceof AreaLayerRenderer)) continue;
                AreaLayerRenderer areaLayerRenderer = (AreaLayerRenderer)navigatorRenderer;
                AreaLayerRendererPrintTypeDecider areaLayerRendererPrintTypeDecider = areaLayerRenderer.getAreaLayerRendererPrintTypeDecider();
                deciderMap.put(areaLayerRenderer, areaLayerRendererPrintTypeDecider);
                areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(new AreaScreenShotAreaLayerPrintTypeDecider(areaLayerRendererPrintTypeDecider));
            }
            if (screenShotType == ScreenShotType.EQUAL_DIMENSION) {
                WhiteRectangleScreenShotRenderer whiteRectangleScreenShotRenderer = new WhiteRectangleScreenShotRenderer(navigatorPanel.getCoordinateFactory().createCoordinate(navigatorPanel.getRealBoundaryTopRight()), navigatorPanel.getCoordinateFactory().createCoordinate(navigatorPanel.getRealBoundaryBottomLeft()));
                whiteRectangleScreenShotRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(whiteRectangleScreenShotRenderer);
            }
            Image image = this.getImageFromNavigatorPanel(printNavigatorPanel, false, false);
            for (Map.Entry entry : deciderMap.entrySet()) {
                ((AreaLayerRenderer)entry.getKey()).setAreaLayerRendererPrintTypeDecider((AreaLayerRendererPrintTypeDecider)entry.getValue());
            }
            deciderMap = null;
            Image image2 = this.addLogoIfSet(dataMap, image);
            inputImageCollection.put("imagePaths", CollectionUtil.buildArrayList(image2));
            dataMap.put("imageScale", Math.round(100.0));
            dataMap.put("svg", false);
        }
        dataMap.put("font", printInformation.getFont());
        dataMap.put("underline", printInformation.isUnderline());
        dataMap.put("format", format);
        Map<PrintPropertyKey, Serializable> commonProperties = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties().getCommonProperties();
        boolean showDate = ((PrintContentValue)commonProperties.get(PrintContentKey.PRINTING_DATE)).isPrint();
        if (showDate) {
            dataMap.put("showDate", showDate);
        } else {
            dataMap.put("showDate", null);
        }
        dataMap.put("currentDate", sm.format(new Date()));
        this.setFoot(dataMap, printInformation);
        InputStream pdfInputStream = this.printIntoInputStream(SCREENSHOT_TEMPLATE, inputImageCollection, dataMap, PdfCreatorImpl.DPI);
        this.rebuildRenderers(navigatorPanel);
        return pdfInputStream;
    }

    private Image addLogoIfSet(Map<String, Object> dataMap, Image image) {
        Image imageWithLogo = image;
        String logoWithString = (String)dataMap.get("logoWidth");
        String logoHeightString = (String)dataMap.get("logoHeight");
        Image logoImage = (Image)dataMap.get("logoImage");
        int logoWidth = 0;
        int logoHeight = 0;
        if (logoImage != null) {
            try {
                logoWidth = Math.round(Float.parseFloat(logoWithString));
            }
            catch (Exception ex) {
                logoWidth = logoImage.getWidth(null);
            }
            try {
                logoHeight = Math.round(Float.parseFloat(logoHeightString));
            }
            catch (Exception ex) {
                logoHeight = logoImage.getHeight(null);
            }
            ImagePosition position = (ImagePosition)((Object)dataMap.get("imageLogoPosition"));
            if (position == null) {
                position = ImagePosition.TOP_LEFT;
            }
            imageWithLogo = ClientSwingUtil.addLogoOnImage(image, logoImage, logoWidth, logoHeight, position);
        }
        return imageWithLogo;
    }

    @Override
    public InputStream printSelectedAreaObjects(NavigatorPanel navigatorPanel, Collection<AreaObjectModel> areaObjectModels, AreaPrinterInformation printInformation, AreaLayerRenderer mainAreaLayerRenderer) throws Exception {
        Map<PrintPropertyKey, Serializable> commonProperties;
        boolean bl;
        List<Tupel<Image, String>> filters;
        if (!areaObjectModels.iterator().hasNext()) {
            return null;
        }
        AreaNameRenderingType areaNameRenderingType = AreaNameRenderingType.getValue(printInformation.getNameRenderingType());
        Format format = printInformation.getFormat();
        AreaNamePrintType areaNamePrintType = (AreaNamePrintType)printInformation.getNamePrintType();
        boolean printAttributes = printInformation.isPrintAttributes();
        if (areaNameRenderingType == null) {
            areaNameRenderingType = AreaNameRenderingType.SHORTCUT;
        }
        List<String> lines = this.extractLines(printInformation.getSpecialMessage());
        Tupel<Double, Double> dim = format.getSizes(printInformation.getDpi(), 10.0, 10.0);
        double width = dim.getElement1();
        double lineHeight = (double)printInformation.getFooterFont().getSize() / 31.0 * (double)printInformation.getDpi().intValue();
        double height = dim.getElement2() - lineHeight - (areaNamePrintType.isHead() ? lineHeight : 0.0);
        double widthMM = width / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        double heightMM = dim.getElement2() / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        Tupel<Image, String> tupel = this.printAreaObjectsInOnePage(navigatorPanel, areaObjectModels, width, height, printInformation);
        HashMap<String, Collection<Image>> inputImageCollection = new HashMap<String, Collection<Image>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ImageModel logo = this.baseLayerEditorPanel.getCurrentAreaLayer().getLogo();
        this.setParameter(dataMap, logo == null ? null : logo.getData());
        dataMap.put("font", printInformation.getFont());
        dataMap.put("footerFont", printInformation.getFooterFont());
        dataMap.put("underline", printInformation.isUnderline());
        dataMap.put("imageText", lines);
        dataMap.put("format", format);
        ArrayList<AreaObjectModel> areaObjectModelList = new ArrayList<AreaObjectModel>(areaObjectModels);
        Image imageWithLogo = this.addLogoIfSet(dataMap, tupel.getElement1());
        AreaPrintingInformation areaPrintInformation = new AreaPrintingInformation((List<AreaObjectModel>)areaObjectModelList, printInformation.isUseVector() ? tupel.getElement2() : PdfCreatorImpl.saveImageToTempFile(imageWithLogo), format);
        if (printAttributes) {
            printAttributes = this.setPrintableAttributes(areaPrintInformation, areaObjectModelList);
        }
        areaPrintInformation.setWithAttributes(printAttributes);
        dataMap.put("printAttributes", printAttributes);
        if (areaNamePrintType.isHead()) {
            ArrayList<String> headers = new ArrayList<String>(areaObjectModels.size());
            for (AreaObjectModel areaObjectModel : areaObjectModels) {
                Tupel<String, String> tupel2 = this.getHeadAndTailLine(areaObjectModel);
                headers.add(tupel2.getElement1());
            }
            areaPrintInformation.setHeadLine(StringUtil.implode(headers, ", "));
        }
        dataMap.put("areas", Collections.singletonList(areaPrintInformation));
        dataMap.put("imageScaleHeight", Math.round(100.0 / printInformation.getScale()));
        dataMap.put("imageScaleWidth", Math.round(100.0 / printInformation.getScale()));
        dataMap.put("svg", printInformation.isUseVector());
        if (printInformation.isUseVector()) {
            String heightString = heightMM + "mm";
            dataMap.put("imageHeight", heightString);
            String widthString = widthMM + "mm";
            dataMap.put("imageWidth", widthString);
        }
        if ((filters = printInformation.getFilters()) != null) {
            ArrayList<Tupel<String, String>> list = new ArrayList<Tupel<String, String>>();
            for (Tupel<Image, String> tupel3 : filters) {
                list.add(new Tupel<String, String>(PdfCreatorImpl.saveImageToTempFile(tupel3.getElement1()), tupel3.getElement2()));
            }
            dataMap.put("filterLegend", list);
        }
        if (bl = ((PrintContentValue)(commonProperties = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties().getCommonProperties()).get(PrintContentKey.PRINTING_DATE)).isPrint()) {
            dataMap.put("showDate", bl);
        } else {
            dataMap.put("showDate", null);
        }
        dataMap.put("currentDate", sm.format(new Date()));
        this.setFoot(dataMap, printInformation);
        if (printInformation.isPrintAreaLegend()) {
            AreaPrinterImplLegendUtil.setLegend(dataMap, areaObjectModels, mainAreaLayerRenderer);
        }
        InputStream inputStream = this.printIntoInputStream(TEMPLATENAME, inputImageCollection, dataMap, printInformation.getDpi());
        this.rebuildRenderers(navigatorPanel);
        return inputStream;
    }

    private void setParameter(Map<String, Object> inputDatas, byte[] layerLogoImage) throws IOException {
        Serializable s;
        String address;
        BaseCaller baseCaller = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getBaseCaller();
        inputDatas.put("copyright", "Copyright\u00a9 datomino GmbH, powered by OpenStreetMap");
        PrintProperties printProperties = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties();
        Map<PrintPropertyKey, Serializable> commonProperties = printProperties.getCommonProperties();
        byte[] imageByte = layerLogoImage;
        if (imageByte == null) {
            String logoName = (String)((Object)commonProperties.get(PrintParameterKey.LOGO_IMAGE));
            if (logoName != null) {
                ImageModel logo = baseCaller.getImageByName(logoName);
                if (logo == null) {
                    LOGGER.error("Das Logo wurde nicht gefunden.");
                    imageByte = baseCaller.getDefaultImage();
                } else {
                    imageByte = logo.getData();
                }
            } else {
                imageByte = baseCaller.getDefaultImage();
            }
        }
        if (imageByte != null) {
            ImageIcon logoImage = new ImageIcon(imageByte);
            inputDatas.put("logoImage", logoImage.getImage());
            try {
                inputDatas.put("logo", PdfCreatorImpl.saveImageToTempFile(logoImage.getImage()));
            }
            catch (Exception e) {
                inputDatas.put("logo", null);
            }
            String logoWidth = String.valueOf(commonProperties.get(PrintParameterKey.LOGO_WIDTH));
            if (logoWidth == null) {
                logoWidth = Integer.toString(logoImage.getImage().getWidth(null));
            }
            inputDatas.put("logoWidth", logoWidth);
            String logoHeight = String.valueOf(commonProperties.get(PrintParameterKey.LOGO_HEIGHT));
            if (logoHeight == null) {
                logoHeight = Integer.toString(logoImage.getImage().getHeight(null));
            }
            inputDatas.put("logoHeight", logoHeight);
        }
        String string = address = (s = commonProperties.get(PrintParameterKey.COMPANY_ADDRESS)) == null ? "" : String.valueOf(s);
        if (StringUtil.isBlank(address)) {
            address = ModelEnviroment.getProperties().getProperty("datomino.address");
        }
        inputDatas.put("address", StringUtil.isBlank(address) ? "" : address.replaceAll("\"", ""));
    }

    @Override
    public InputStream printSelectedAreaObjectsInPages(NavigatorPanel navigatorPanel, Collection<AreaObjectModel> areaObjectModels, AreaPrinterInformation printInformation) throws Exception {
        Map<PrintPropertyKey, Serializable> commonProperties;
        boolean showDate;
        List<Tupel<Image, String>> filters;
        if (!areaObjectModels.iterator().hasNext()) {
            return null;
        }
        AreaNameRenderingType areaNameRenderingType = AreaNameRenderingType.getValue(printInformation.getNameRenderingType());
        Format format = printInformation.getFormat();
        AreaNamePrintType areaNamePrintType = (AreaNamePrintType)printInformation.getNamePrintType();
        boolean printAttributes = printInformation.isPrintAttributes();
        if (areaNameRenderingType == null) {
            areaNameRenderingType = AreaNameRenderingType.SHORTCUT;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ImageModel logo = this.baseLayerEditorPanel.getCurrentAreaLayer().getLogo();
        this.setParameter(dataMap, logo == null ? null : logo.getData());
        List<String> lines = this.extractLines(printInformation.getSpecialMessage());
        HashMap<String, Collection<Image>> inputImageCollection = new HashMap<String, Collection<Image>>();
        ArrayList<AreaPrintingInformation> areaPrintingInformations = new ArrayList<AreaPrintingInformation>(areaObjectModels.size());
        Tupel<Double, Double> dim = format.getSizes(printInformation.getDpi(), 10.0, 10.0);
        double lineHeight = (double)printInformation.getFooterFont().getSize() / 31.0 * (double)printInformation.getDpi().intValue();
        double width = dim.getElement1();
        double height = dim.getElement2() - lineHeight - (areaNamePrintType.isHead() ? lineHeight : 0.0);
        double widthMM = width / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        double heightMM = height / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0;
        height = dim.getElement2();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            Tupel<String, String> headTailTupel = this.getHeadAndTailLine(areaObjectModel);
            String string = headTailTupel.getElement1();
            String tailLine = headTailTupel.getElement2();
            double currentHeight = height - lineHeight * (double)(3 + StringUtil.countChar(string, '\n') + StringUtil.countChar(tailLine, '\n'));
            List<AreaObjectModel> areaObjectModelList = Collections.singletonList(areaObjectModel);
            Tupel<Image, String> tupel = this.printAreaObjectsInOnePage(navigatorPanel, areaObjectModelList, width, currentHeight, printInformation);
            Image imageWithLogo = this.addLogoIfSet(dataMap, tupel.getElement1());
            AreaPrintingInformation areaPrintingInformation = new AreaPrintingInformation(areaObjectModelList, printInformation.isUseVector() ? tupel.getElement2() : PdfCreatorImpl.saveImageToTempFile(imageWithLogo), format);
            if (printAttributes) {
                printAttributes = this.setPrintableAttributes(areaPrintingInformation, Collections.singleton(areaObjectModel));
            }
            areaPrintingInformation.setHeadLine(areaNamePrintType.isHead() ? string : null);
            areaPrintingInformation.setTailLine(tailLine);
            areaPrintingInformation.setWithAttributes(printAttributes);
            areaPrintingInformations.add(areaPrintingInformation);
        }
        dataMap.put("font", printInformation.getFont());
        dataMap.put("footerFont", printInformation.getFooterFont());
        dataMap.put("underline", printInformation.isUnderline());
        dataMap.put("imageText", lines);
        dataMap.put("format", format);
        dataMap.put("printAttributes", printAttributes);
        dataMap.put("areas", areaPrintingInformations);
        dataMap.put("imageScaleHeight", Math.round(100.0 / printInformation.getScale()));
        dataMap.put("imageScaleWidth", Math.round(100.0 / printInformation.getScale()));
        dataMap.put("svg", printInformation.isUseVector());
        if (printInformation.isUseVector()) {
            String heightString = heightMM + "mm";
            dataMap.put("imageHeight", heightString);
            String widthString = widthMM + "mm";
            dataMap.put("imageWidth", widthString);
        }
        if ((filters = printInformation.getFilters()) != null) {
            ArrayList list = new ArrayList();
            for (Tupel tupel : filters) {
                list.add(new Tupel(PdfCreatorImpl.saveImageToTempFile((Image)tupel.getElement1()), tupel.getElement2()));
            }
            dataMap.put("filterLegend", list);
        }
        if (showDate = ((PrintContentValue)(commonProperties = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties().getCommonProperties()).get(PrintContentKey.PRINTING_DATE)).isPrint()) {
            dataMap.put("showDate", showDate);
        } else {
            dataMap.put("showDate", null);
        }
        dataMap.put("currentDate", sm.format(new Date()));
        this.setFoot(dataMap, printInformation);
        InputStream inputStream = this.printIntoInputStream(TEMPLATENAME, inputImageCollection, dataMap, printInformation.getDpi());
        this.rebuildRenderers(navigatorPanel);
        return inputStream;
    }

    private Tupel<String, String> getHeadAndTailLine(AreaObjectModel areaObjectModel) {
        AreaLayerModel layer;
        Tupel<String, String> areaText;
        Map<PrintPropertyKey, Serializable> ap = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties().getAreaProperties();
        String headLine = (String)((Object)ap.get(PrintParameterKey.PAGE_HEAD_PATTERN));
        if (!StringUtil.isBlank(headLine)) {
            headLine = headLine.replaceAll("%%%shortcut%%%", areaObjectModel.getShortcut());
            headLine = headLine.replaceAll("%%%displayname%%%", areaObjectModel.getDisplayname());
        }
        if ((areaText = AreaObjectModelUtil.getContractTextAttribute(areaObjectModel)).getElement1() != null) {
            headLine = areaText.getElement1() + "\n" + (headLine == null ? "" : headLine);
        }
        String layerInfo = (layer = areaObjectModel.getAreaLayer()) == null || layer.getPrintInfo() == null ? "" : layer.getPrintInfo();
        String tailLine = "";
        if (!StringUtil.isBlank(layerInfo) && !StringUtil.isBlank(tailLine)) {
            tailLine = ((String)((Object)ap.get(PrintParameterKey.PAGE_FOOT_PATTERN))).replaceAll("%%%layerInfo%%%", layerInfo).trim();
        }
        return new Tupel<String, String>(headLine, tailLine);
    }

    private List<String> extractLines(String specialMessageText) {
        List<String> lines;
        List<String> list = lines = StringUtil.isBlank(specialMessageText) ? null : StringUtil.explode(specialMessageText, '\n');
        if (lines != null) {
            ArrayList<String> transformed = new ArrayList<String>(lines.size());
            for (String line : lines) {
                if (line.isEmpty()) {
                    transformed.add("\n");
                    continue;
                }
                transformed.add(line);
            }
            return transformed;
        }
        return lines;
    }

    @Override
    public InputStream printAllAreaObjectsInPages(NavigatorPanel navigatorPanel, AreaPrinterInformation printInformation) throws Exception {
        AreaLayerModel layer = this.baseLayerEditorPanel.getCurrentAreaLayer();
        ArrayList<AreaObjectModel> areaObjectModels = new ArrayList<AreaObjectModel>(layer.countAreaObjects());
        for (AreaObjectModel areaObjectModel : layer.iterableAreaObjects()) {
            areaObjectModels.add(areaObjectModel);
        }
        return this.printSelectedAreaObjectsInPages(navigatorPanel, areaObjectModels, printInformation);
    }

    private Tupel<Image, String> printAreaObjectsInOnePage(NavigatorPanel navigatorPanel, Collection<AreaObjectModel> areaObjectModels, double width, double height, AreaPrinterInformation printInformation) throws InterruptedException, AbstractOsmSvgExportFetcherException {
        if (printInformation.isUseVector()) {
            return new Tupel<Object, String>(null, this.printAreaObjectsInOnePageSvg(navigatorPanel, areaObjectModels, width / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0, height / ((double)printInformation.getDpi().intValue() / PdfCreatorImpl.INCH_PER_CM) * 10.0, printInformation));
        }
        return new Tupel<Image, Object>(this.printAreaObjectsInOnePageRegular(navigatorPanel, areaObjectModels, (int)Math.round(width), (int)Math.round(height), printInformation), null);
    }

    private String printAreaObjectsInOnePageSvg(NavigatorPanel navigatorPanel, Collection<AreaObjectModel> areaObjectModels, double width, double height, AreaPrinterInformation printInformation) throws AbstractOsmSvgExportFetcherException {
        double left = Double.MAX_VALUE;
        double top = Double.MIN_VALUE;
        double right = Double.MIN_VALUE;
        double bottom = Double.MAX_VALUE;
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            ImmutablePolygonKind geom = (ImmutablePolygonKind)areaObjectModel.getGeom().getTransformed(Wgs84Factory.INSTANCE);
            left = Math.min(geom.getMinX(), left);
            top = Math.max(geom.getMaxY(), top);
            right = Math.max(geom.getMaxX(), right);
            bottom = Math.min(geom.getMinY(), bottom);
        }
        Coordinate topLeft = Wgs84Factory.INSTANCE.createCoordinate(left, top);
        Coordinate bottomRight = Wgs84Factory.INSTANCE.createCoordinate(right, bottom);
        OsmSvgExportFetcher osmSvgExportFetcher = new OsmSvgExportFetcher();
        try {
            Tripel<String, Coordinate, Coordinate> tripel = osmSvgExportFetcher.fetchSvg(topLeft, bottomRight, width, height, printInformation.getMarginX(), printInformation.getMarginY(), printInformation.isFillupSpace());
            String fetchSvg = tripel.getElement1();
            topLeft = tripel.getElement2();
            bottomRight = tripel.getElement3();
            Tupel<Integer, Integer> tupel = this.extractWidthAndHeightFromSvg(fetchSvg);
            Tupel<SVGGraphics2D, Double> subGraphics = this.renderAreaSvg(navigatorPanel, areaObjectModels, tupel.getElement1(), tupel.getElement2(), topLeft, bottomRight, printInformation);
            String removeSvgAndEnrich = this.removeSvgAndEnrich(subGraphics.getElement1(), subGraphics.getElement2());
            if (removeSvgAndEnrich != null) {
                fetchSvg = this.includeIntoSvg(fetchSvg, removeSvgAndEnrich);
            }
            return fetchSvg;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
    }

    private Tupel<Integer, Integer> extractWidthAndHeightFromSvg(String svg) {
        Matcher matcher = Pattern.compile("height=\"(\\d*)pt\"").matcher(svg);
        matcher.find();
        int rHeight = Integer.parseInt(matcher.group(1));
        matcher = Pattern.compile("width=\"(\\d*)pt\"").matcher(svg);
        matcher.find();
        int rWidth = Integer.parseInt(matcher.group(1));
        return new Tupel<Integer, Integer>(rWidth, rHeight);
    }

    private String includeIntoSvg(String fetchSvg, String toImport) throws SVGGraphics2DIOException, ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = SAX_FACTORY.newSAXParser();
        SvgHandler handler = new SvgHandler(toImport.toString());
        fetchSvg = this.replaceDocType(fetchSvg);
        saxParser.parse((InputStream)new ByteArrayInputStream(fetchSvg.getBytes()), (DefaultHandler)handler);
        fetchSvg = handler.getResult();
        return fetchSvg;
    }

    private String removeSvgAndEnrich(SVGGraphics2D subGraphics, double scale) throws SVGGraphics2DIOException, ParserConfigurationException, SAXException, IOException {
        StringWriter sw = new StringWriter();
        subGraphics.stream(sw);
        sw.flush();
        SAXParser saxParser = SAX_FACTORY.newSAXParser();
        int fontSize = (int)Math.round(Math.pow(scale * 100.0, 1.0));
        SvgHandler handler = new SvgHandler(true, Math.max(1, fontSize));
        String in = sw.toString();
        sw = null;
        in = this.replaceDocType(in);
        saxParser.parse((InputStream)new ByteArrayInputStream(in.getBytes()), (DefaultHandler)handler);
        String svg = handler.isEmpty() ? null : handler.getResult();
        return svg;
    }

    private String replaceDocType(String xml) {
        int index = xml.indexOf("<!DOCTYPE");
        if (index >= 0) {
            int lIndex = xml.indexOf(62, index);
            return xml.substring(0, index) + xml.substring(lIndex + 1);
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tupel<SVGGraphics2D, Double> renderAreaSvg(NavigatorPanel navigatorPanel, Collection<AreaObjectModel> areaObjectModels, int width, int height, Coordinate topLeft, Coordinate bottomRight, AreaPrinterInformation printInformation) {
        Tupel<SVGGraphics2D, Double> svg;
        AreaLayerRenderer areaLayerRenderer = this.baseLayerEditorPanel.getEditBaseLayerRenderer();
        Font setFont = areaLayerRenderer.getAreaFont();
        String rendererPrefix = printInformation.getPrintPrefix();
        if (rendererPrefix != null) {
            areaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("Print", areaLayerRenderer.getBucketsModel(), BaseLayerEditorPanel.createAreaGeomExtractor(), rendererPrefix, this.baseLayerEditorPanel.getModelEnviroment(), false, this.baseLayerEditorPanel.getNavigatorPanel());
        }
        AreaLayerRendererPrintTypeDecider areaLayerRendererPrintTypeDecider = areaLayerRenderer.getAreaLayerRendererPrintTypeDecider();
        AreaNamePrintType areaNamePrintType = (AreaNamePrintType)printInformation.getNamePrintType();
        areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(new AreaPrintAreaLayerPrintTypeDecider(areaNamePrintType.isImage()));
        GeoObjectBucketsModel regularBucktesModel = areaLayerRenderer.getBucketsModel();
        try {
            StaticGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new StaticGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(BaseLayerEditorPanel.createAreaGeomExtractor(), navigatorPanel.getCoordinateFactory());
            bucketsModel.addAll(areaObjectModels);
            areaLayerRenderer.setBucketsModel(bucketsModel);
            areaLayerRenderer.setEmphasizeSelected(false);
            areaLayerRenderer.setIslandMode(printInformation.isIslandMode());
            Font pFont = printInformation.getFont();
            if (pFont != null) {
                areaLayerRenderer.setAreaFont(pFont);
            }
            PrintRenderer printRenderer = new PrintRenderer(navigatorPanel, areaLayerRenderer, topLeft, bottomRight);
            svg = printRenderer.render(width, height);
        }
        finally {
            areaLayerRenderer.setBucketsModel(regularBucktesModel);
            areaLayerRenderer.setEmphasizeSelected(true);
            areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(areaLayerRendererPrintTypeDecider);
            areaLayerRenderer.setAreaFont(setFont);
            areaLayerRenderer.setIslandMode(false);
        }
        return svg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image printAreaObjectsInOnePageRegular(NavigatorPanel navigatorPanel, Collection<AreaObjectModel> areaObjectModels, int width, int height, AreaPrinterInformation printInformation) throws InterruptedException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            coordinates.addAll(AreaObjectModelUtil.getAreaRectangle(areaObjectModel));
        }
        AreaLayerRenderer areaLayerRenderer = this.baseLayerEditorPanel.getEditBaseLayerRenderer();
        Font setFont = areaLayerRenderer.getAreaFont();
        String rendererPrefix = printInformation.getPrintPrefix();
        if (rendererPrefix != null) {
            areaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("Print", areaLayerRenderer.getBucketsModel(), BaseLayerEditorPanel.createAreaGeomExtractor(), rendererPrefix, this.baseLayerEditorPanel.getModelEnviroment(), false, this.baseLayerEditorPanel.getNavigatorPanel());
        }
        AreaNamePrintType areaNamePrintType = (AreaNamePrintType)printInformation.getNamePrintType();
        AreaLayerRendererPrintTypeDecider areaLayerRendererPrintTypeDecider = areaLayerRenderer.getAreaLayerRendererPrintTypeDecider();
        AreaPrintAreaLayerPrintTypeDecider tAreaLayerRendererPrintTypeDecider = new AreaPrintAreaLayerPrintTypeDecider(areaNamePrintType.isImage());
        areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(tAreaLayerRendererPrintTypeDecider);
        GeoObjectBucketsModel regularBucktesModel = areaLayerRenderer.getBucketsModel();
        Map<AreaLayerModel, Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>> showLayerActions = this.baseLayerEditorPanel.getShowLayerActions();
        ArrayList<Tupel<AreaLayerRenderer, AreaLayerRendererPrintTypeDecider>> sDeciderMap = new ArrayList<Tupel<AreaLayerRenderer, AreaLayerRendererPrintTypeDecider>>(showLayerActions.size());
        for (Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>> tripel : showLayerActions.values()) {
            AreaLayerRenderer sRenderer = tripel.getElement2();
            sDeciderMap.add(new Tupel<AreaLayerRenderer, AreaLayerRendererPrintTypeDecider>(sRenderer, sRenderer.getAreaLayerRendererPrintTypeDecider()));
            sRenderer.setAreaLayerRendererPrintTypeDecider(tAreaLayerRendererPrintTypeDecider);
        }
        try {
            StaticGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new StaticGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(BaseLayerEditorPanel.createAreaGeomExtractor(), navigatorPanel.getCoordinateFactory());
            bucketsModel.addAll(areaObjectModels);
            areaLayerRenderer.setBucketsModel(bucketsModel);
            areaLayerRenderer.setEmphasizeSelected(false);
            areaLayerRenderer.setIslandMode(printInformation.isIslandMode());
            Map<PrintPropertyKey, Serializable> ap = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties().getAreaProperties();
            areaLayerRenderer.setAreaNameRenderingPattern((String)((Object)ap.get(PrintParameterKey.INFO_PATTERN)));
            Font pFont = printInformation.getFont();
            if (pFont != null) {
                areaLayerRenderer.setAreaFont(pFont);
            }
            NavigatorPanel printNavigatorPanel = this.createPrintNavigatorPanel(navigatorPanel, areaLayerRenderer, true, width, height, printInformation, null);
            boolean optimalZoom = printInformation.isOptimalZoom();
            printNavigatorPanel.center(coordinates, 1.0, optimalZoom);
            printNavigatorPanel.paintImage();
            Image image = this.getImageFromNavigatorPanel(printNavigatorPanel, true, optimalZoom);
            printNavigatorPanel.close();
            Image image2 = image;
            return image2;
        }
        finally {
            areaLayerRenderer.setBucketsModel(regularBucktesModel);
            areaLayerRenderer.setEmphasizeSelected(true);
            areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(areaLayerRendererPrintTypeDecider);
            areaLayerRenderer.setAreaFont(setFont);
            for (Tupel tupel : sDeciderMap) {
                ((AreaLayerRenderer)tupel.getElement1()).setAreaLayerRendererPrintTypeDecider((AreaLayerRendererPrintTypeDecider)tupel.getElement2());
            }
            areaLayerRenderer.setIslandMode(false);
        }
    }

    private NavigatorPanel createPrintNavigatorPanel(NavigatorPanel navigatorPanel, AreaLayerRenderer areaLayerRenderer, boolean isSelected, int width, int height, PrinterInformation printerInformation, Double owScale) {
        CoordinateFactory navigatorFactory = navigatorPanel.getCoordinateFactory();
        NavigatorPanel printNavigatorPanel = this.baseLayerEditorPanel.createNavigatorPanel(null, navigatorFactory);
        double scale = owScale == null ? printerInformation.getScale() : owScale;
        printNavigatorPanel.setSize((int)((double)width * scale), (int)(((double)height - 0.8 * ((double)PdfCreatorImpl.DPI.intValue() / PdfCreatorImpl.INCH_PER_CM)) * scale));
        printNavigatorPanel.forceCalcTransform();
        LinkedList<AbstractNavigatorRenderer> lasts = new LinkedList<AbstractNavigatorRenderer>();
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (navigatorRenderer instanceof AreaLayerRenderer) {
                if (this.baseLayerEditorPanel.getEditBaseLayerRenderer() == navigatorRenderer && areaLayerRenderer != null) {
                    areaLayerRenderer.setNavigatorPanel(printNavigatorPanel);
                    printNavigatorPanel.addRenderer(areaLayerRenderer);
                    continue;
                }
                navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(navigatorRenderer);
                continue;
            }
            if (navigatorRenderer instanceof ThreadingOsmNavigatorRenderer) {
                NotThreadingOsmNavigatorRenderer osmrenderer = new NotThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
                osmrenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(osmrenderer);
                ModelEnviroment modelEnviroment = this.baseLayerEditorPanel.getModelEnviroment();
                try {
                    if (printerInformation.getPrintPlacesFont() != null) {
                        PlaceNameRenderer placeNameRenderer = new PlaceNameRenderer(modelEnviroment, printerInformation.getPrintPlacesFont());
                        placeNameRenderer.setNavigatorPanel(printNavigatorPanel);
                        lasts.add(placeNameRenderer);
                    }
                }
                catch (Exception placeNameRenderer) {
                    // empty catch block
                }
                try {
                    if (printerInformation.getPrintStreetsFont() == null) continue;
                    StreetNameRenderer streetNameRenderer = new StreetNameRenderer(modelEnviroment, printerInformation.getPrintStreetsFont());
                    streetNameRenderer.setNavigatorPanel(printNavigatorPanel);
                    lasts.add(streetNameRenderer);
                }
                catch (Exception exception) {}
                continue;
            }
            if (navigatorRenderer instanceof MapScaleRenderer) continue;
            navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
            printNavigatorPanel.addRenderer(navigatorRenderer);
        }
        for (NavigatorRenderer navigatorRenderer : lasts) {
            printNavigatorPanel.addRenderer(navigatorRenderer);
        }
        return printNavigatorPanel;
    }

    private Image getImageFromNavigatorPanel(NavigatorPanel printNavigatorPanel, boolean isSelected, boolean optimalZoom) throws InterruptedException {
        Point2D.Double realBottomLeft = printNavigatorPanel.getRealBoundaryBottomLeft();
        Point2D.Double realTopRight = printNavigatorPanel.getRealBoundaryTopRight();
        if (isSelected) {
            printNavigatorPanel.center(CollectionUtil.buildArrayList(printNavigatorPanel.getCoordinateFactory().createCoordinate(realBottomLeft), printNavigatorPanel.getCoordinateFactory().createCoordinate(realTopRight)), 10.0, optimalZoom);
        }
        return printNavigatorPanel.paintImage();
    }

    private InputStream printIntoInputStream(String template, Map<String, Collection<Image>> inputImageCollection, Map<String, Object> data, int dpi) throws Exception {
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf(template, data, null, inputImageCollection, ModelEnviroment.getMessageResolver(), dpi);
    }

    private void rebuildRenderers(NavigatorPanel navigatorPanel) {
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (navigatorRenderer instanceof ThreadingOsmNavigatorRenderer) continue;
            navigatorRenderer.setNavigatorPanel(navigatorPanel);
        }
    }

    private boolean setPrintableAttributes(AreaPrintingInformation areaPrintInformation, Collection<AreaObjectModel> areaObjectModels) {
        Collection<AreaAttributeValueDescriptorModel> descriptors = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        ArrayList<AreaAttributeValueDescriptorModelAttributeWrapper> wrappers = new ArrayList<AreaAttributeValueDescriptorModelAttributeWrapper>(descriptors.size());
        for (AreaAttributeValueDescriptorModel descriptor : descriptors) {
            Object key;
            Boolean canPrint = descriptor.getCanPrint();
            if (canPrint == null || !canPrint.booleanValue() || ((String)(key = descriptor.getKey())).equals("AREA-PRINTING-TITEL") || ((String)key).equals("AREA-PRINTING-TEXT") || ((String)key).equals("AREA-PRINTING-CREATION-DATE")) continue;
            wrappers.add(new AreaAttributeValueDescriptorModelAttributeWrapper(descriptor));
        }
        if (wrappers.isEmpty()) {
            return false;
        }
        Collections.sort(wrappers, new Comparator<AreaAttributeValueDescriptorModelAttributeWrapper>(){

            @Override
            public int compare(AreaAttributeValueDescriptorModelAttributeWrapper o1, AreaAttributeValueDescriptorModelAttributeWrapper o2) {
                return new ComparatorBuilder().append(o1.getPrintSortOrder(), o2.getPrintSortOrder()).compare();
            }
        });
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            HashMap<Long, AreaAttributeValueModelAttributeWrapper> map = new HashMap<Long, AreaAttributeValueModelAttributeWrapper>();
            for (AreaAttributeValueModel areaAttributeValueModel : areaObjectModel.iterableAreaAttributeValues()) {
                map.put(areaAttributeValueModel.getAreaAttributeValueDescriptor().getId(), new AreaAttributeValueModelAttributeWrapper(areaAttributeValueModel));
            }
            List<Tupel<String, String>> tupels = AttributeHelper.getTupelsForPrintFromMap(map, wrappers);
            areaPrintInformation.setAttributes(areaObjectModel, tupels);
        }
        return true;
    }

    protected void setFoot(Map<String, Object> inputDatas, PrinterInformation printerInformation) {
        Map<PrintPropertyKey, Serializable> areaProperties = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties().getAreaProperties();
        String footInfoPattern = String.valueOf(areaProperties.get(PrintParameterKey.PAGE_FOOT_PATTERN));
        Double footHeight = null;
        Font font = printerInformation.getFooterFont();
        double lineHeight = ((double)font.getSize() + 1.0) * 0.0352778;
        String footExtent = "0.2";
        String bodyMarginBottom = "0.2";
        String layerInfo = this.baseLayerEditorPanel.getCurrentAreaLayer().getPrintInfo();
        String address = "";
        address = !StringUtil.isBlank(layerInfo) && !StringUtil.isBlank(footInfoPattern) ? footInfoPattern.replaceAll("%%%layerInfo%%%", layerInfo).trim() : (inputDatas.get("address") == null ? "" : inputDatas.get("address").toString());
        int lineCount = StringUtil.countChar(address, '\n') + 1;
        lineCount = Math.max(3, Math.max(StringUtil.countChar("Copyright\u00a9 datomino GmbH, powered by OpenStreetMap", '\n') + 1, lineCount));
        footHeight = lineHeight * (double)lineCount;
        String baseRegionFootD = Long.toString(Math.round(Math.ceil((footHeight + 0.5) * 10.0)));
        footExtent = baseRegionFootD.substring(0, baseRegionFootD.length() - 1) + "." + baseRegionFootD.charAt(baseRegionFootD.length() - 1);
        String baseMarginBottomD = Long.toString(Math.round(Math.ceil((footHeight + 0.5) * 10.0)));
        bodyMarginBottom = baseMarginBottomD.substring(0, baseMarginBottomD.length() - 1) + "." + baseMarginBottomD.charAt(baseMarginBottomD.length() - 1);
        inputDatas.put("address", address);
        inputDatas.put("footExtent", footExtent);
        inputDatas.put("bodyMarginBottom", bodyMarginBottom);
        String footMarginTop = "0";
        if (lineCount == 3) {
            footMarginTop = "-0.2";
        } else if (lineCount > 3) {
            footMarginTop = "-0.3";
        }
        inputDatas.put("footMarginTop", footMarginTop);
    }

    static {
        sm = new SimpleDateFormat("dd.MM.yyyy");
        SAX_FACTORY = SAXParserFactory.newInstance();
        SAX_FACTORY.setValidating(false);
    }
}

