/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.makrocell;

import de.datomino.peppergis.area.MakroParameter;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.makrocell.MakrocellHandler;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class MakrocellHandlerImpl
implements MakrocellHandler {
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public MakrocellHandlerImpl(BaseLayerEditorPanel baseLayerEditorPanel) {
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void createMakrocellLayer(final String makroName, final MakroParameter makroParameter) {
        ModelEnviroment modelEnviroment = this.baseLayerEditorPanel.getModelEnviroment();
        AreaCaller areaCaller = modelEnviroment.getAllCaller().getAreaCaller();
        final AreaLayerModel currentAreaLayer = this.baseLayerEditorPanel.getCurrentAreaLayer();
        final ErrorMessages errorMessages = new ErrorMessages();
        if (currentAreaLayer.getDiscriminator() != AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) {
            errorMessages.addErrorMessage(new ErrorMessage("Der Typ des Bearbeitungslayers ist falsch."));
        } else {
            AbstractAsynchronousDialog<Boolean> asynchronousDialog = new AbstractAsynchronousDialog<Boolean>(this.baseLayerEditorPanel.getParentWindow(), ModelEnviroment.getMessageResolver().resolveMessage("messages.marcocell.create", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, modelEnviroment){
                private static final long serialVersionUID = -534886535033657922L;

                @Override
                protected AsynchronousDto<Boolean> getAsynchronousDto(String token) {
                    return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getCreateMakrocellLayerResult(token);
                }

                @Override
                protected String startAsynchronous() {
                    return this.modelEnviroment.getAllCaller().getAsynchronousCaller().createMakrocellLayer(makroName, currentAreaLayer.getId(), makroParameter, errorMessages);
                }
            };
            try {
                asynchronousDialog.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (errorMessages.hasErrors()) {
            BufferedImage image;
            try {
                image = ImageIO.read(MakrocellHandlerImpl.class.getResourceAsStream("/images/pepper.png"));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), ModelEnviroment.getMessageResolver(), errorMessages, image);
            errorMessageDialog.setVisible(true);
        } else {
            Collection<AreaLayerModel> makrocell = areaCaller.getAreaLayer(makroName);
            List<AreaObjectModel> areaObjects = areaCaller.fetchAreaObjectsByAreaLayer(makrocell.iterator().next(), false);
            JOptionPane.showMessageDialog(this.baseLayerEditorPanel, areaObjects.size() + " Macrozelle im Gebiets-Layer " + makroName);
        }
    }
}

