/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.search;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.util.international.country.Country;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SubscriptionSearchTableModel
implements TableModel {
    private static final String[] COL_HEADERS = new String[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptionNumber", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.customerNumber", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.firstName", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.lastName", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])};
    private List<SubscriptionModel> subscriptions = new ArrayList<SubscriptionModel>();
    private List<TableModelListener> tableModelListeners = new LinkedList<TableModelListener>();

    @Override
    public int getRowCount() {
        return this.subscriptions.size();
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COL_HEADERS[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SubscriptionModel subscriptionModel = this.subscriptions.get(rowIndex);
        CustomerModel customer = subscriptionModel.getCustomer();
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(subscriptionModel.getLocation());
        switch (columnIndex) {
            case 0: {
                return subscriptionModel.getSubscriptionNumber();
            }
            case 1: {
                return customer.getCustomerNumber();
            }
            case 2: {
                return customer.getFirstName();
            }
            case 3: {
                return customer.getLastName();
            }
            case 4: {
                Country country = locationWrapper.getCountry();
                return country == null ? "" : country.getVehicleSign();
            }
            case 5: {
                return locationWrapper.getPostcode();
            }
            case 6: {
                return locationWrapper.getCity();
            }
            case 7: {
                return locationWrapper.getDistrict();
            }
            case 8: {
                return locationWrapper.getStreet();
            }
            case 9: {
                Integer housenumber = locationWrapper.getHousenumber();
                return housenumber == null ? "" : housenumber.toString();
            }
            case 10: {
                return locationWrapper.getHousenumberExtension();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    protected void fireTableModelEvent(TableModelEvent e) {
        for (TableModelListener l : this.tableModelListeners) {
            l.tableChanged(e);
        }
    }

    public void setSubscriptions(List<SubscriptionModel> subscriptions) {
        this.subscriptions = subscriptions;
        this.fireTableModelEvent(new TableModelEvent(this));
    }

    public SubscriptionModel getSubscriptionAt(int s) {
        return this.subscriptions.get(s);
    }
}

