/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.menu;

import de.datomino.peppergis.area.MakroParameter;
import de.datomino.peppergis.client.action.ChooseAreaObjectOnMapAction;
import de.datomino.peppergis.client.action.ChoosePoiOnMapAction;
import de.datomino.peppergis.client.action.search.CommonSearchAction;
import de.datomino.peppergis.client.action.search.CommonSetSearchCoordinateAction;
import de.datomino.peppergis.client.communication.AllCaller;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.gui.subscription.SubscriptionLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.ExportAreaLegendAction;
import de.datomino.peppergis.simplebasearea.action.ExportSelectedAreaAction;
import de.datomino.peppergis.simplebasearea.action.ShowAreaLayerAction;
import de.datomino.peppergis.simplebasearea.action.clipboard.CopyAreaAction;
import de.datomino.peppergis.simplebasearea.action.clipboard.InsertAreaAction;
import de.datomino.peppergis.simplebasearea.action.cover.ClearCoverAction;
import de.datomino.peppergis.simplebasearea.action.cover.CreateCoverAction;
import de.datomino.peppergis.simplebasearea.action.cover.CreateNewAreaFromCoverAction;
import de.datomino.peppergis.simplebasearea.action.cover.MarkCoveredParcelsAction;
import de.datomino.peppergis.simplebasearea.action.cover.MarkCoveredSubscriptionsAction;
import de.datomino.peppergis.simplebasearea.action.letter.ClearLetterSelectionAction;
import de.datomino.peppergis.simplebasearea.action.mark.RemoveHolesAction;
import de.datomino.peppergis.simplebasearea.action.parcel.AddGeoParcelToAreaAction;
import de.datomino.peppergis.simplebasearea.action.parcel.AddParcelsToAreaAction;
import de.datomino.peppergis.simplebasearea.action.parcel.ClearParcelSelectionAction;
import de.datomino.peppergis.simplebasearea.action.parcel.RemoveParcelsToAreaAction;
import de.datomino.peppergis.simplebasearea.action.pmd.DownloadPmdAction;
import de.datomino.peppergis.simplebasearea.action.pmd.UploadPmdAction;
import de.datomino.peppergis.simplebasearea.action.smooth.RemoveSmoothAction;
import de.datomino.peppergis.simplebasearea.action.smooth.SmoothAreaAction;
import de.datomino.peppergis.simplebasearea.action.subscription.ClearSubscriptionSelectionAction;
import de.datomino.peppergis.simplebasearea.gui.menu.AreaFilterPatternMenu;
import de.datomino.peppergis.simplebasearea.gui.menu.LetterFilterPatternMenu;
import de.datomino.peppergis.simplebasearea.gui.menu.ParcelFilterPatternMenu;
import de.datomino.peppergis.simplebasearea.gui.menu.PoiFilterPatternMenu;
import de.datomino.peppergis.simplebasearea.gui.menu.SubAreaFilterPatternMenu;
import de.datomino.peppergis.simplebasearea.gui.menu.SubscriptionFilterPatternMenu;
import de.datomino.peppergis.simplebasearea.makrocell.MakrocellHandler;
import de.datomino.peppergis.simplebasearea.microcell.MicrocellHandler;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.MenuScroller;
import de.datomino.util.swing.blocking.AbstractBusyHandlingAction;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.PanelGroupPlacer;
import org.ktde.swing.ToggleAction;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class BaseLayerEditorPanelMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1159077318864389908L;
    private Map<AreaLayerModel, AreaFilterPatternMenu> areaFilterPatternMenus;
    private SubscriptionFilterPatternMenu subscriptionFilterPatternMenu;
    private PoiFilterPatternMenu poiFilterPatternMenu;
    private ParcelFilterPatternMenu parcelFilterPatternMenu;
    private LetterFilterPatternMenu letterFilterPatternMenu;

    public BaseLayerEditorPanelMenuBar(BaseLayerEditorPanel baseLayerEditorPanel) {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(121, 0), "none");
        boolean canWrite = ModelEnviroment.getUserInformation().hasUserRole(UserRole.ADMIN) || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER) || ModelEnviroment.getUserInformation().getAttachedIdsForUserRole(UserRole.AREA_EDITOR).contains(baseLayerEditorPanel.getEditBaseLayer().getId());
        this.initializeEditMenu(baseLayerEditorPanel, canWrite);
        this.initializeViewMenu(baseLayerEditorPanel);
        this.initializeSearchMenu(baseLayerEditorPanel);
        AreaFilterPatternMenu areaFilterPatternMenu = new AreaFilterPatternMenu(baseLayerEditorPanel);
        this.areaFilterPatternMenus = new HashMap<AreaLayerModel, AreaFilterPatternMenu>();
        this.areaFilterPatternMenus.put(baseLayerEditorPanel.getEditBaseLayer(), areaFilterPatternMenu);
        this.add(areaFilterPatternMenu);
        this.subscriptionFilterPatternMenu = new SubscriptionFilterPatternMenu(baseLayerEditorPanel);
        AreaObjectGenInfoDiscriminator discriminator = baseLayerEditorPanel.getEditBaseLayer().getDiscriminator();
        switch (discriminator) {
            case AREA_OBJECT_GEN_AREA_OBJECT: {
                break;
            }
            case AREA_OBJECT_GEN_FREEHAND: 
            case AREA_OBJECT_GEN_UNMODIFYABLE: 
            case AREA_OBJECT_MICRO_CELL: 
            case AREA_OBJECT_MACRO_CELL: {
                this.add(this.subscriptionFilterPatternMenu);
            }
        }
        this.poiFilterPatternMenu = new PoiFilterPatternMenu(baseLayerEditorPanel);
        this.add(this.poiFilterPatternMenu);
        this.parcelFilterPatternMenu = new ParcelFilterPatternMenu(baseLayerEditorPanel);
        this.add(this.parcelFilterPatternMenu);
        this.letterFilterPatternMenu = new LetterFilterPatternMenu(baseLayerEditorPanel);
        this.add(this.letterFilterPatternMenu);
        this.initializeMarkAreaMenu(baseLayerEditorPanel, canWrite);
        this.initializeMarkPointsMenu(baseLayerEditorPanel, canWrite);
        this.initializeCoverMenu(baseLayerEditorPanel, canWrite);
        this.initializePrintMenu(baseLayerEditorPanel);
        this.initializeExportMenu(baseLayerEditorPanel);
        this.initializePmdMenu(baseLayerEditorPanel);
    }

    private void initializeCoverMenu(BaseLayerEditorPanel baseLayerEditorPanel, boolean canWrite) {
        if (canWrite && baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() != AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE) {
            JMenu cover = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.cover.menu", new Serializable[0]));
            cover.add(new CreateCoverAction(baseLayerEditorPanel));
            cover.add(new ClearCoverAction(baseLayerEditorPanel));
            cover.add(new CreateNewAreaFromCoverAction(baseLayerEditorPanel));
            cover.add(new MarkCoveredParcelsAction(baseLayerEditorPanel));
            cover.add(new MarkCoveredSubscriptionsAction(baseLayerEditorPanel));
            this.add(cover);
        }
    }

    private void initializePmdMenu(BaseLayerEditorPanel baseLayerEditorPanel) {
        String importEnabled;
        JMenu pmd = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.pmd.menu", new Serializable[0]));
        boolean add = false;
        String exportEnabled = ModelEnviroment.getProperties().getProperty("pmd.export.enabled");
        if (StringUtil.isTrue(exportEnabled) && baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT) {
            pmd.add(new UploadPmdAction(baseLayerEditorPanel));
            add = true;
        }
        if (StringUtil.isTrue(importEnabled = ModelEnviroment.getProperties().getProperty("pmd.import.enabled")) && baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE) {
            pmd.add(new DownloadPmdAction(baseLayerEditorPanel));
            add = true;
        }
        if (add) {
            this.add(pmd);
        }
    }

    private void initializeMarkPointsMenu(BaseLayerEditorPanel baseLayerEditorPanel, boolean canWrite) {
        ToggleAction toggleAction;
        ToggleAction toggleAction2;
        canWrite &= baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() != AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE;
        JMenu mark = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.points", new Serializable[0]));
        for (ToggleAction toggleAction3 : baseLayerEditorPanel.getPointMarkerActions()) {
            mark.add(new JRadioButtonMenuItem(toggleAction3));
        }
        mark.add(new ClearParcelSelectionAction(baseLayerEditorPanel));
        AreaObjectGenInfoDiscriminator discriminator = baseLayerEditorPanel.getEditBaseLayer().getDiscriminator();
        switch (discriminator) {
            case AREA_OBJECT_GEN_AREA_OBJECT: {
                break;
            }
            case AREA_OBJECT_GEN_FREEHAND: 
            case AREA_OBJECT_GEN_UNMODIFYABLE: 
            case AREA_OBJECT_MICRO_CELL: 
            case AREA_OBJECT_MACRO_CELL: {
                mark.add(new ClearSubscriptionSelectionAction(baseLayerEditorPanel));
                mark.add(new ClearLetterSelectionAction(baseLayerEditorPanel));
            }
        }
        mark.addSeparator();
        ToggleAction toggleAction4 = baseLayerEditorPanel.getSetPointMarkModeRectangleWithinAction();
        if (toggleAction4 != null) {
            mark.add(toggleAction4);
        }
        if ((toggleAction2 = baseLayerEditorPanel.getSetPointMarkModeCircleWithinAction()) != null) {
            mark.add(toggleAction2);
        }
        if ((toggleAction = baseLayerEditorPanel.getSetPointMarkModeFreehandWithinAction()) != null) {
            mark.add(toggleAction);
        }
        if (canWrite) {
            mark.addSeparator();
            mark.add(new AddParcelsToAreaAction(baseLayerEditorPanel));
            mark.add(new RemoveParcelsToAreaAction(baseLayerEditorPanel));
            mark.addSeparator();
            switch (baseLayerEditorPanel.getEditBaseLayer().getDiscriminator()) {
                case AREA_OBJECT_GEN_FREEHAND: 
                case AREA_OBJECT_MICRO_CELL: 
                case AREA_OBJECT_MACRO_CELL: {
                    mark.add(new AddGeoParcelToAreaAction(baseLayerEditorPanel));
                    break;
                }
            }
        }
        this.add(mark);
    }

    private void initializeMarkAreaMenu(BaseLayerEditorPanel baseLayerEditorPanel, boolean canWrite) {
        ToggleAction markAction;
        JMenu mark = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.surface", new Serializable[0]));
        int count = 0;
        AreaObjectGenInfoDiscriminator discriminator = baseLayerEditorPanel.getEditBaseLayer().getDiscriminator();
        if (canWrite && !baseLayerEditorPanel.isUnmodifyable()) {
            String style = StringUtil.nullToEmpty(ModelEnviroment.getProperties().getProperty("baseLayerEditor.layerMenuStyle"));
            List<? extends ToggleAction> chooseSourceBaseLayerActions = baseLayerEditorPanel.getChooseSourceBaseLayerActions();
            if (discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT && style.equalsIgnoreCase("initialletter")) {
                LinkedHashMap menuMap = new LinkedHashMap();
                for (ToggleAction toggleAction : chooseSourceBaseLayerActions) {
                    String name = (String)toggleAction.getValue("Name");
                    String capital = name.trim();
                    capital = StringUtil.isBlank(capital) ? "?" : capital.substring(0, 1);
                    JMenu menu = (JMenu)menuMap.get(capital);
                    if (menu == null) {
                        menu = new JMenu(capital);
                        menuMap.put(capital, menu);
                    }
                    menu.add(toggleAction);
                }
                for (JMenu jMenu : menuMap.values()) {
                    mark.add(jMenu);
                }
                count = menuMap.size();
            } else {
                for (ToggleAction toggleAction : chooseSourceBaseLayerActions) {
                    mark.add(new JRadioButtonMenuItem(toggleAction));
                }
                count = chooseSourceBaseLayerActions.size();
            }
        }
        ChooseAreaObjectOnMapAction chooseAreaOnMap = baseLayerEditorPanel.getChooseAreaOnMapAction();
        mark.add(new JRadioButtonMenuItem(chooseAreaOnMap));
        ToggleAction panning = baseLayerEditorPanel.getPanningAction();
        mark.add(new JRadioButtonMenuItem(panning));
        mark.addSeparator();
        if (!baseLayerEditorPanel.isUnmodifyable()) {
            if (canWrite) {
                Action addMarkSetAction = baseLayerEditorPanel.getAddMarkSetAction();
                mark.add(addMarkSetAction);
                Action action = baseLayerEditorPanel.getRemoveMarkSetAction();
                mark.add(action);
                Action action2 = baseLayerEditorPanel.getReplaceWithMarkSetAction();
                mark.add(action2);
                Action dropMark = baseLayerEditorPanel.getDropMarkAction();
                mark.add(dropMark);
                if (discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT) {
                    SmoothAreaAction smoothAreaAction = new SmoothAreaAction(baseLayerEditorPanel);
                    mark.add(smoothAreaAction);
                    RemoveSmoothAction removeSmoothAction = new RemoveSmoothAction(baseLayerEditorPanel);
                    mark.add(removeSmoothAction);
                }
                if (discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND) {
                    RemoveHolesAction removeHolesAction = new RemoveHolesAction(baseLayerEditorPanel);
                    mark.add(removeHolesAction);
                }
                mark.addSeparator();
            } else if (ModelEnviroment.getUserInformation().getAttachedIdsForUserRole(UserRole.AREA_VIEWER).contains(baseLayerEditorPanel.getEditBaseLayer().getId())) {
                Action dropMark = baseLayerEditorPanel.getDropMarkAction();
                mark.add(dropMark);
                mark.addSeparator();
            }
        }
        if ((markAction = baseLayerEditorPanel.getSetMarkModeRectangleCrossesAction()) != null) {
            mark.add(new JRadioButtonMenuItem(markAction));
        }
        if ((markAction = baseLayerEditorPanel.getSetMarkModeRectangleWithinAction()) != null) {
            mark.add(new JRadioButtonMenuItem(markAction));
        }
        if ((markAction = baseLayerEditorPanel.getSetMarkModeCircleCrossesAction()) != null) {
            mark.add(new JRadioButtonMenuItem(markAction));
        }
        if ((markAction = baseLayerEditorPanel.getSetMarkModeCircleWithinAction()) != null) {
            mark.add(new JRadioButtonMenuItem(markAction));
        }
        if ((markAction = baseLayerEditorPanel.getSetMarkModeFreehandWithinAction()) != null) {
            mark.add(new JRadioButtonMenuItem(markAction));
        }
        if ((markAction = baseLayerEditorPanel.getSetMarkModeFreehandHalfAction()) != null) {
            mark.add(new JRadioButtonMenuItem(markAction));
        }
        if (discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT) {
            MenuScroller.setScrollerFor(mark, 20, 1, 0, mark.getItemCount() - count);
        }
        this.add(mark);
    }

    private void initializePrintMenu(BaseLayerEditorPanel baseLayerEditorPanel) {
        JMenu print = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.print", new Serializable[0]));
        Action printScreen = baseLayerEditorPanel.getPrintCurrentWindowAction();
        print.add(printScreen);
        Action printAreas = baseLayerEditorPanel.getPrintAreaObjectsAction();
        print.add(printAreas);
        this.add(print);
    }

    private void initializeSearchMenu(BaseLayerEditorPanel baseLayerEditorPanel) {
        JMenu search = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0]));
        final CommonSearchAction searchAction = baseLayerEditorPanel.getSearchActionMenu();
        search.add(searchAction);
        Action searchAreaAction = baseLayerEditorPanel.getSearchAreaAction();
        search.add(searchAreaAction);
        Action subscriptionSearchAction = baseLayerEditorPanel.getSubscriptionSearchAction();
        AreaObjectGenInfoDiscriminator discriminator = baseLayerEditorPanel.getEditBaseLayer().getDiscriminator();
        switch (discriminator) {
            case AREA_OBJECT_GEN_AREA_OBJECT: {
                break;
            }
            case AREA_OBJECT_GEN_FREEHAND: 
            case AREA_OBJECT_GEN_UNMODIFYABLE: 
            case AREA_OBJECT_MICRO_CELL: 
            case AREA_OBJECT_MACRO_CELL: {
                search.add(subscriptionSearchAction);
            }
        }
        Action poiSearchAction = baseLayerEditorPanel.getPoiSearchAction();
        search.add(poiSearchAction);
        Action circleSearchingAction = baseLayerEditorPanel.getCircleSearchingAction();
        JMenu circleSearchMenu = new JMenu(circleSearchingAction.getValue("Name").toString());
        circleSearchMenu.add(circleSearchingAction);
        if (searchAction instanceof CommonSearchAction) {
            CommonSearchAction commonSearchAction = searchAction;
            CommonSetSearchCoordinateAction commonSetSearchCoordinateAction = new CommonSetSearchCoordinateAction(commonSearchAction);
            circleSearchMenu.add(commonSetSearchCoordinateAction);
        }
        search.add(circleSearchMenu);
        search.addSeparator();
        Action centerAreaOnMapAction = baseLayerEditorPanel.getCenterSelectedAreaObjectsAction();
        search.add(centerAreaOnMapAction);
        search.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.searchAddress.removeCoordinate", new Serializable[0])){
            private static final long serialVersionUID = 146427223919594767L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (searchAction instanceof CommonSearchAction) {
                    ((CommonSearchAction)searchAction).clearCoordinate();
                }
            }
        });
        this.add(search);
    }

    private void initializeExportMenu(BaseLayerEditorPanel baseLayerEditorPanel) {
        JMenu export = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.export", new Serializable[0]));
        export.add(new ExportSelectedAreaAction(baseLayerEditorPanel));
        export.add(new ExportAreaLegendAction(baseLayerEditorPanel));
        this.add(export);
    }

    private void initializeViewMenu(final BaseLayerEditorPanel baseLayerEditorPanel) {
        JMenu viewMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.view", new Serializable[0]));
        ChoosePoiOnMapAction showPoi = baseLayerEditorPanel.getShowPoiAction();
        JMenu poiMenu1 = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.delivererLocation", new Serializable[0]));
        poiMenu1.add(new JCheckBoxMenuItem(showPoi.getMainDelivererLocationAction()));
        poiMenu1.add(new JCheckBoxMenuItem(showPoi.getBranchDelivererLocationAction()));
        poiMenu1.add(new JCheckBoxMenuItem(showPoi.getDelivererDelivererLocationAction()));
        viewMenu.add(poiMenu1);
        poiMenu1 = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0]));
        poiMenu1.add(new JCheckBoxMenuItem(showPoi.getRegularAreaObjectLocationAction()));
        poiMenu1.add(new JCheckBoxMenuItem(showPoi.getInactiveAreaObjectLocationAction()));
        poiMenu1.add(new JCheckBoxMenuItem(showPoi.getStartPickPointAreaObjectLocationAction()));
        poiMenu1.add(new JCheckBoxMenuItem(showPoi.getEndPickPointAreaObjectLocationAction()));
        viewMenu.add(poiMenu1);
        ToggleAction showParcel = baseLayerEditorPanel.getShowParcelAction();
        showParcel.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                if (event.getNewValue() == Boolean.TRUE) {
                    for (ToggleAction toggleAction : baseLayerEditorPanel.getChooseSourceBaseLayerActions()) {
                        if (!(toggleAction instanceof ParcelFilterableMarkerRenderer)) continue;
                        toggleAction.setSelected(true);
                    }
                }
            }
        });
        viewMenu.add(new JCheckBoxMenuItem(showParcel));
        JMenu subscriptionSubMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
        ToggleAction showSubscription = baseLayerEditorPanel.getShowSubscriptionAction();
        showSubscription.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                if (event.getNewValue() == Boolean.TRUE) {
                    for (ToggleAction toggleAction : baseLayerEditorPanel.getChooseSourceBaseLayerActions()) {
                        if (!(toggleAction instanceof SubscriptionLayerRenderer)) continue;
                        toggleAction.setSelected(true);
                    }
                }
            }
        });
        subscriptionSubMenu.add(new JCheckBoxMenuItem(showSubscription));
        ToggleAction showActiveSubscription = baseLayerEditorPanel.getShowActiveSubscriptionAction();
        showActiveSubscription.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                if (event.getNewValue() == Boolean.TRUE) {
                    for (ToggleAction toggleAction : baseLayerEditorPanel.getChooseSourceBaseLayerActions()) {
                        if (!(toggleAction instanceof SubscriptionLayerRenderer)) continue;
                        toggleAction.setSelected(true);
                    }
                }
            }
        });
        subscriptionSubMenu.add(new JCheckBoxMenuItem(showActiveSubscription));
        ToggleAction showInactiveSubscription = baseLayerEditorPanel.getShowInactiveSubscriptionAction();
        showInactiveSubscription.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                if (event.getNewValue() == Boolean.TRUE) {
                    for (ToggleAction toggleAction : baseLayerEditorPanel.getChooseSourceBaseLayerActions()) {
                        if (!(toggleAction instanceof SubscriptionLayerRenderer)) continue;
                        toggleAction.setSelected(true);
                    }
                }
            }
        });
        subscriptionSubMenu.add(new JCheckBoxMenuItem(showInactiveSubscription));
        AreaObjectGenInfoDiscriminator discriminator = baseLayerEditorPanel.getEditBaseLayer().getDiscriminator();
        switch (discriminator) {
            case AREA_OBJECT_GEN_AREA_OBJECT: {
                break;
            }
            case AREA_OBJECT_GEN_FREEHAND: 
            case AREA_OBJECT_GEN_UNMODIFYABLE: 
            case AREA_OBJECT_MICRO_CELL: 
            case AREA_OBJECT_MACRO_CELL: {
                viewMenu.add(subscriptionSubMenu);
            }
        }
        viewMenu.add(baseLayerEditorPanel.getShowLetterAction());
        viewMenu.add(new JCheckBoxMenuItem(showPoi.getCustomerAction()));
        viewMenu.add(new JCheckBoxMenuItem(showPoi.getPickPointAction()));
        int regularCount = viewMenu.getItemCount();
        Map<AreaLayerModel, Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>> showLayerActions = baseLayerEditorPanel.getShowLayerActions();
        if (!showLayerActions.isEmpty()) {
            viewMenu.addSeparator();
            String style = StringUtil.nullToEmpty(ModelEnviroment.getProperties().getProperty("baseLayerEditor.layerMenuStyle"));
            if (style.equalsIgnoreCase("initialletter")) {
                LinkedHashMap<String, JMenu> menuMap = new LinkedHashMap<String, JMenu>();
                for (Map.Entry<AreaLayerModel, Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>> entry : showLayerActions.entrySet()) {
                    AreaLayerModel areaLayer = entry.getKey();
                    String capital = areaLayer.getDisplayname().trim();
                    capital = StringUtil.isBlank(capital) ? "?" : capital.substring(0, 1);
                    JMenu menu = (JMenu)menuMap.get(capital);
                    if (menu == null) {
                        menu = new JMenu(capital);
                        menuMap.put(capital, menu);
                    }
                    SubAreaFilterPatternMenu subAreaFilterPatternMenu = new SubAreaFilterPatternMenu(baseLayerEditorPanel, areaLayer, entry.getValue().getElement1());
                    menu.add(subAreaFilterPatternMenu);
                }
                for (JMenu menu : menuMap.values()) {
                    viewMenu.add(menu);
                }
            } else {
                for (Map.Entry<AreaLayerModel, Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>> entry : showLayerActions.entrySet()) {
                    SubAreaFilterPatternMenu subAreaFilterPatternMenu = new SubAreaFilterPatternMenu(baseLayerEditorPanel, entry.getKey(), entry.getValue().getElement1());
                    viewMenu.add(subAreaFilterPatternMenu);
                }
            }
        }
        if (viewMenu.getItemCount() > 25) {
            MenuScroller.setScrollerFor(viewMenu, 20, 1, regularCount, 0);
        }
        this.add(viewMenu);
    }

    private void initializeEditMenu(final BaseLayerEditorPanel baseLayerEditorPanel, boolean canWrite) {
        Action addClipboardSelectionAction;
        JMenu editMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0]));
        if (canWrite) {
            Action saveAction = baseLayerEditorPanel.getSaveAction();
            editMenu.add(saveAction);
            Action undoAction = baseLayerEditorPanel.getUndoAction();
            editMenu.add(undoAction);
            Action redoAction = baseLayerEditorPanel.getRedoAction();
            editMenu.add(redoAction);
            Action revertAction = baseLayerEditorPanel.getRevertAction();
            editMenu.add(revertAction);
            editMenu.addSeparator();
            editMenu.add(new CopyAreaAction(baseLayerEditorPanel));
            editMenu.add(new InsertAreaAction(baseLayerEditorPanel));
            editMenu.addSeparator();
            Action newAreaAction = baseLayerEditorPanel.getCreateNewAreaAction();
            if (newAreaAction != null) {
                editMenu.add(newAreaAction);
            }
            AreaObjectGenInfoDiscriminator discriminator = baseLayerEditorPanel.getEditBaseLayer().getDiscriminator();
            switch (discriminator) {
                case AREA_OBJECT_GEN_AREA_OBJECT: 
                case AREA_OBJECT_MACRO_CELL: {
                    Action addClipboardSelectionAction2 = baseLayerEditorPanel.getAddClipboardSelectionAction();
                    if (addClipboardSelectionAction2 == null) break;
                    editMenu.add(addClipboardSelectionAction2);
                    break;
                }
                case AREA_OBJECT_MICRO_CELL: {
                    AbstractBusyHandlingAction calculateMicroCellAction = new AbstractBusyHandlingAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.mircocell.calculate", new Serializable[0]), baseLayerEditorPanel.getBusyHandler()){
                        private static final long serialVersionUID = 3430377524583958351L;

                        @Override
                        public void actionPerformedInternal(ActionEvent e) {
                            Point2D.Double boundaryBottomLeft = baseLayerEditorPanel.getNavigatorPanel().getRealBoundaryBottomLeft();
                            Point2D.Double boundaryTopRight = baseLayerEditorPanel.getNavigatorPanel().getRealBoundaryTopRight();
                            CoordinateFactory coordinateFactory = baseLayerEditorPanel.getNavigatorPanel().getCoordinateFactory();
                            Coordinate bottomLeft = Wgs84Factory.INSTANCE.createCoordinate(coordinateFactory.createCoordinate(boundaryBottomLeft));
                            Coordinate topRight = Wgs84Factory.INSTANCE.createCoordinate(coordinateFactory.createCoordinate(boundaryTopRight));
                            Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
                            Enum[] values = new CoordinateFactory.Projections[projections.size()];
                            values = projections.toArray(values);
                            EnumComboBox coordinateFormat = new EnumComboBox(CoordinateFactory.Projections.class, false, values);
                            coordinateFormat.setSelectedValue(CoordinateFactory.Projections.Wgs84);
                            final JTextField minX = new JTextField(String.valueOf(bottomLeft.getX()));
                            final JTextField maxX = new JTextField(String.valueOf(topRight.getX()));
                            final JTextField minY = new JTextField(String.valueOf(bottomLeft.getY()));
                            final JTextField maxY = new JTextField(String.valueOf(topRight.getY()));
                            JCheckBox clear = new JCheckBox();
                            JTextArea postcodes = new JTextArea(10, 20);
                            postcodes.addFocusListener(new FocusListener(){

                                @Override
                                public void focusLost(FocusEvent e) {
                                    this.setEnable(true);
                                }

                                @Override
                                public void focusGained(FocusEvent e) {
                                    this.setEnable(false);
                                }

                                private void setEnable(boolean enable) {
                                    minX.setEnabled(enable);
                                    maxX.setEnabled(enable);
                                    minY.setEnabled(enable);
                                    maxY.setEnabled(enable);
                                }
                            });
                            postcodes.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                            JComponent[] components = new JComponent[]{minX, maxX, minY, maxY, coordinateFormat, clear};
                            String[] labels = new String[]{"Min-X", "Max-X", "Min-Y", "Max-Y", "Format", "Leeren"};
                            boolean withPostcode = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("microcell.handler.postcode"));
                            if (withPostcode) {
                                components = new JComponent[]{minX, maxX, minY, maxY, coordinateFormat, ClientSwingUtil.scrollTextArea(postcodes, null, true), clear};
                                labels = new String[]{"Min-X", "Max-X", "Min-Y", "Max-Y", "Format", "PLZ", "Leeren"};
                            }
                            JPanel envelopePanel = new JPanel();
                            PanelGroupPlacer.createGroup((Container)envelopePanel, components, labels);
                            boolean tryagain = true;
                            while (tryagain && JOptionPane.showConfirmDialog(baseLayerEditorPanel, envelopePanel, "Bereich", 2) == 0) {
                                tryagain = false;
                                Coordinate bottomRight = null;
                                Coordinate topLeft = null;
                                CoordinateFactory factory = CoordinateFactory.getInstance((CoordinateFactory.Projections)((Object)coordinateFormat.getSelectedValue()));
                                try {
                                    bottomRight = factory.createCoordinate(ClientFormUtil.getNumber(maxX.getText()).doubleValue(), ClientFormUtil.getNumber(minY.getText()).doubleValue());
                                    topLeft = factory.createCoordinate(ClientFormUtil.getNumber(minX.getText()).doubleValue(), ClientFormUtil.getNumber(maxY.getText()).doubleValue());
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(baseLayerEditorPanel, "Die Koordinaten sind nicht akzeptiert.");
                                    tryagain = true;
                                    continue;
                                }
                                ModelEnviroment modelEnviroment = baseLayerEditorPanel.getModelEnviroment();
                                AllCaller allCaller = modelEnviroment.getAllCaller();
                                HashSet<ParcelModel> parcels = new HashSet();
                                String text = postcodes.getText().replaceAll(",", "\n");
                                if (withPostcode && !StringUtil.isBlank(text)) {
                                    for (String postcode : text.split("\n")) {
                                        parcels.addAll(allCaller.getStreetSearchCaller().findParcelExact(null, postcode.trim(), null, null, null, null, null));
                                    }
                                } else {
                                    parcels = allCaller.getStreetNetCaller().fetchParcels(topLeft, bottomRight, false);
                                }
                                MicrocellHandler microcellHandler = baseLayerEditorPanel.getMicrocellHandler();
                                microcellHandler.createMicrocellByLayer(parcels, clear.isSelected());
                            }
                        }
                    };
                    editMenu.add(calculateMicroCellAction);
                    AbstractBusyHandlingAction createMakroCellAction = new AbstractBusyHandlingAction("Makrozellen erzeugen", baseLayerEditorPanel.getBusyHandler()){
                        private static final long serialVersionUID = 3805853058835568069L;

                        @Override
                        protected void actionPerformedInternal(ActionEvent e) {
                            JPanel panel = new JPanel();
                            JTextField makro = new JTextField(20);
                            JTextField distance = new JTextField(20);
                            JTextField duration = new JTextField(20);
                            JTextField parcels = new JTextField(20);
                            JTextField weight = new JTextField(20);
                            JComponent[] components = new JComponent[]{makro, distance, duration, parcels, weight};
                            String makroName = ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]);
                            String distanceName = ModelEnviroment.getMessageResolver().resolveMessage("microcell.attribute.descriptor.distance", new Serializable[0]) + "(Meter)";
                            String durationName = ModelEnviroment.getMessageResolver().resolveMessage("microcell.attribute.descriptor.duration", new Serializable[0]) + "(Sekunden)";
                            String parcelsName = ModelEnviroment.getMessageResolver().resolveMessage("microcell.attribute.descriptor.parcels", new Serializable[0]);
                            String weightName = ModelEnviroment.getMessageResolver().resolveMessage("microcell.attribute.descriptor.weight", new Serializable[0]);
                            String[] labels = new String[]{makroName, distanceName, durationName, parcelsName, weightName};
                            PanelGroupPlacer.createGroup((Container)panel, components, labels);
                            boolean tryagain = true;
                            while (tryagain && JOptionPane.showConfirmDialog(baseLayerEditorPanel, panel, "Kriterien", 2) == 0) {
                                tryagain = false;
                                if (StringUtil.isBlank(makro.getText())) {
                                    JOptionPane.showMessageDialog(baseLayerEditorPanel, "Der Name des Bearbeitungslayers ist leer.");
                                    tryagain = true;
                                    continue;
                                }
                                String distanceKey = ModelEnviroment.getProperties().getProperty("microcell.attribute.descriptor.distance");
                                String durationKey = ModelEnviroment.getProperties().getProperty("microcell.attribute.descriptor.duration");
                                String parcelsKey = ModelEnviroment.getProperties().getProperty("microcell.attribute.descriptor.parcels");
                                String weightKey = ModelEnviroment.getProperties().getProperty("microcell.attribute.descriptor.weight");
                                MakroParameter makroParameter = new MakroParameter(distanceKey, durationKey, parcelsKey, weightKey);
                                try {
                                    makroParameter.setDistanceLimit(StringUtil.isBlank(distance.getText()) ? null : Integer.valueOf(Integer.parseInt(distance.getText())));
                                    makroParameter.setDurationLimit(StringUtil.isBlank(duration.getText()) ? null : Integer.valueOf(Integer.parseInt(duration.getText())));
                                    makroParameter.setParcelsLimit(StringUtil.isBlank(parcels.getText()) ? null : Integer.valueOf(Integer.parseInt(parcels.getText())));
                                    makroParameter.setWeightLimit(StringUtil.isBlank(weight.getText()) ? null : Integer.valueOf(Integer.parseInt(weight.getText())));
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(baseLayerEditorPanel, "Die Kriterien sind nicht akzeptiert.");
                                    tryagain = true;
                                    continue;
                                }
                                MakrocellHandler makrocellHandler = baseLayerEditorPanel.getMakrocellHandler();
                                makrocellHandler.createMakrocellLayer(makro.getText(), makroParameter);
                            }
                        }
                    };
                    editMenu.add(createMakroCellAction);
                    break;
                }
                case AREA_OBJECT_GEN_FREEHAND: {
                    break;
                }
            }
            Action deleteCurrentAreaAction = baseLayerEditorPanel.getDeleteCurrentAreaAction();
            if (deleteCurrentAreaAction != null) {
                editMenu.add(deleteCurrentAreaAction);
            }
            editMenu.addSeparator();
        } else if (ModelEnviroment.getUserInformation().getAttachedIdsForUserRole(UserRole.AREA_VIEWER).contains(baseLayerEditorPanel.getEditBaseLayer().getId()) && baseLayerEditorPanel.getEditBaseLayer().getDiscriminator().equals((Object)AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT) && (addClipboardSelectionAction = baseLayerEditorPanel.getAddClipboardSelectionAction()) != null) {
            editMenu.add(addClipboardSelectionAction);
            editMenu.addSeparator();
        }
        ToggleAction chooseEditLayer = baseLayerEditorPanel.getChooseEditLayerAction();
        editMenu.add(new JCheckBoxMenuItem(chooseEditLayer));
        editMenu.add(new JRadioButtonMenuItem(baseLayerEditorPanel.getRulerRenderer()));
        this.add(editMenu);
    }

    public void refreshAreaFilterPatternMenu() {
        for (AreaFilterPatternMenu areaFilterPatternMenu : this.areaFilterPatternMenus.values()) {
            areaFilterPatternMenu.refreshAreaFilterPatternMenu();
        }
    }

    public void refreshSubscriptionFilterPatternMenu() {
        this.subscriptionFilterPatternMenu.refreshSubscriptionFilterPatternMenu();
    }

    public void refreshPoiFilterPatternMenu() {
        this.poiFilterPatternMenu.refreshPoiFilterPatternMenu();
    }

    public void areaFilterLegendDialogClosing(AreaLayerModel areaLayerModel) {
        AreaFilterPatternMenu areaFilterPatternMenu = this.areaFilterPatternMenus.get(areaLayerModel);
        if (areaFilterPatternMenu != null) {
            areaFilterPatternMenu.areaFilterLegendDialogClosing();
        }
    }

    public void subscriptionFilterLegendDialogClosing() {
        this.subscriptionFilterPatternMenu.subscriptionFilterLegendDialogClosing();
    }

    public void poiFilterLegendDialogClosing() {
        this.poiFilterPatternMenu.poiFilterLegendDialogClosing();
    }

    protected JMenu getFilterAreaPatternMenu(AreaLayerModel areaLayerModel) {
        return this.areaFilterPatternMenus.get(areaLayerModel);
    }

    protected JMenu getFilterSubscriptionPatternMenu() {
        return this.subscriptionFilterPatternMenu;
    }

    protected JMenu getFilterPoiPatternMenu() {
        return this.poiFilterPatternMenu;
    }

    public AbstractToggleAction getShowAreaLegend(AreaLayerModel areaLayerModel) {
        AreaFilterPatternMenu areaFilterPatternMenu = this.areaFilterPatternMenus.get(areaLayerModel);
        return areaFilterPatternMenu == null ? null : areaFilterPatternMenu.getShowAreaLegend();
    }

    public AbstractToggleAction getShowPoiLegend() {
        return this.poiFilterPatternMenu.getShowPoiLegend();
    }

    public AbstractToggleAction getShowSubscriptionLegend() {
        return this.subscriptionFilterPatternMenu.getShowSubscriptionLegend();
    }

    public void refreshParcelFilterPatternMenu() {
        this.parcelFilterPatternMenu.refreshParcelFilterPatternMenu();
    }

    public void parcelFilterLegendDialogClosing() {
        this.parcelFilterPatternMenu.parcelFilterLegendDialogClosing();
    }
}

