/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.menu;

import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractLegendPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.FilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterAreaRelationModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.type.filter.FilterPatternParameter;
import de.datomino.peppergis.type.filter.FilterPatternRelation;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.callback.CallBack;
import de.datomino.util.swing.MenuScroller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.ktde.swing.AbstractToggleAction;

public abstract class AbstractFilterPatternMenu
extends JMenu {
    private static final long serialVersionUID = -2500958975818488191L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public AbstractFilterPatternMenu(String title, BaseLayerEditorPanel baseLayerEditorPanel) {
        super(title);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        MenuScroller.setScrollerFor(this, 20, 1, 1, 1);
    }

    protected <T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model> AbstractToggleAction createShowLegendAction(String titleMessageKey, final AbstractLegendPane.SymbolType symbolType, final CallBack<FilterPatternLegendDialog<T, S, U, V, W, X>, Object> dialogCreator, final CallBack<FilterPatternLegendDialog<T, S, U, V, W, X>, Object> dialogFetcher, final CallBack<Collection<ModelFilterPatternSetup<S, T, U, V, X>>, Object> setupFetcher) {
        return new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage(titleMessageKey, new Serializable[0])){
            private static final long serialVersionUID = -8966934151354211927L;

            @Override
            public void turnOn() {
                int start;
                FilterPatternLegendDialog filterPatternLegendDialog = (FilterPatternLegendDialog)dialogCreator.execute(new Object[0]);
                ArrayList list = new ArrayList((Collection)setupFetcher.execute(new Object[0]));
                ModelFilterPatternSetup selected = null;
                for (int i = start = 1 + ((menuItems = AbstractFilterPatternMenu.this.getStartingAdditionalMenuItems()).isEmpty() ? 0 : 1 + menuItems.size()); i < AbstractFilterPatternMenu.this.getItemCount() - 2; ++i) {
                    ModelFilterPatternSetup modelFilterPatternSetup = (ModelFilterPatternSetup)list.get(i - start);
                    if (!AbstractFilterPatternMenu.this.getItem(i).isSelected()) continue;
                    selected = modelFilterPatternSetup;
                    break;
                }
                filterPatternLegendDialog.setFilterPatternSetup(selected, symbolType, AbstractFilterPatternMenu.this.baseLayerEditorPanel.getModelEnviroment());
                filterPatternLegendDialog.setVisible(true);
            }

            @Override
            public void turnOff() {
                FilterPatternLegendDialog filterPatternLegendDialog = (FilterPatternLegendDialog)dialogFetcher.execute(new Object[0]);
                if (filterPatternLegendDialog != null) {
                    filterPatternLegendDialog.dispose();
                }
            }
        };
    }

    protected <T extends Model, S extends Model, U extends Model, V extends Model, X extends Model> void fillFilterMenu(List<ModelFilterPatternSetup<T, S, U, V, X>> modelFilterPatternSetups, CallBack<Action, Object> setFilterActionCreator, Action showLegendAction) {
        List<JMenuItem> menuItems = this.getStartingAdditionalMenuItems();
        if (!menuItems.isEmpty()) {
            for (JMenuItem menuItem : menuItems) {
                this.add(menuItem);
            }
            this.addSeparator();
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem emptyMenuItem = new JRadioButtonMenuItem(setFilterActionCreator.execute((Object[])new Object[]{this.baseLayerEditorPanel, null}));
        buttonGroup.add(emptyMenuItem);
        this.add(emptyMenuItem);
        for (ModelFilterPatternSetup<T, S, U, V, X> modelFilterPatternSetup : modelFilterPatternSetups) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(setFilterActionCreator.execute((Object[])new Object[]{this.baseLayerEditorPanel, modelFilterPatternSetup}));
            buttonGroup.add(menuItem);
            this.add(menuItem);
        }
        this.addSeparator();
        this.add(showLegendAction);
        emptyMenuItem.setSelected(true);
    }

    protected List<JMenuItem> getStartingAdditionalMenuItems() {
        return Collections.emptyList();
    }

    protected BaseLayerEditorPanel getBaseLayerEditorPanel() {
        return this.baseLayerEditorPanel;
    }

    protected <T extends Model, S extends Model, U extends Model, V extends Model, X extends Model> Long clearMenu(List<ModelFilterPatternSetup<T, S, U, V, X>> modelFilterPatternSetups) {
        int start;
        Long filterPatternSetupModelId = null;
        for (int i = start = 1 + ((menuItems = this.getStartingAdditionalMenuItems()).isEmpty() ? 0 : 1 + menuItems.size()); i < this.getItemCount() - 2; ++i) {
            ModelFilterPatternSetup<T, S, U, V, X> modelFilterPatternSetup = modelFilterPatternSetups.get(i - start);
            if (this.getItem(i).isSelected()) {
                filterPatternSetupModelId = ((Model)modelFilterPatternSetup.getAttachedObject()).getId();
            }
            this.evictCascading(modelFilterPatternSetup);
        }
        this.removeAll();
        return filterPatternSetupModelId;
    }

    private <T extends Model, S extends Model, U extends Model, V extends Model, X extends Model> void evictCascading(ModelFilterPatternSetup<T, S, U, V, X> modelFilterPatternSetup) {
        ModelCache modelCache = this.baseLayerEditorPanel.getModelEnviroment().getModelCache();
        for (FilterPatternRelation filterPatternRelation : modelFilterPatternSetup.getRelations()) {
            for (FilterPatternParameter filterPatternParameterModel : filterPatternRelation.getFilterPatternParameter()) {
                ObjectFilter objectFilter = filterPatternParameterModel.getObjectFilter();
                if (objectFilter != null) {
                    AttributeValueFilterModel attributeValueFilter = (AttributeValueFilterModel)objectFilter.getAttributeValueFilter();
                    if (attributeValueFilter != null) {
                        this.evictRek(attributeValueFilter);
                    }
                    this.evictSpecial(objectFilter, modelCache);
                    modelCache.evictModel((Model)objectFilter.getAttachedObject());
                }
                modelCache.evictModel((Model)filterPatternParameterModel.getAttachedObject());
            }
            modelCache.evictModel((Model)filterPatternRelation.getAttachedObject());
        }
        modelCache.evictModel((Model)modelFilterPatternSetup.getAttachedObject());
    }

    private void evictSpecial(ObjectFilter<?, ?> objectFilter, ModelCache modelCache) {
        Object filter = objectFilter.getAttachedObject();
        if (filter instanceof SubscriptionFilterModel) {
            SubscriptionFilterModel subscriptionFilter = (SubscriptionFilterModel)filter;
            for (SubscriptionFilterAreaRelationModel subscriptionFilterAreaRelationModel : subscriptionFilter.iterableSubscriptionFilterAreaRelation()) {
                modelCache.evictModel(subscriptionFilterAreaRelationModel);
            }
        }
    }

    private void evictRek(AttributeValueFilterModel attributeValueFilter) {
        for (AttributeValueFilterModel attributeValueFilterChild : attributeValueFilter.iterableChildAttributeValueFilters()) {
            this.evictRek(attributeValueFilterChild);
        }
        this.baseLayerEditorPanel.getModelEnviroment().getModelCache().evictModel(attributeValueFilter);
    }

    protected <T extends Model, S extends Model, U extends Model, V extends Model, X extends Model> void refreshFilterPatternMenu(List<ModelFilterPatternSetup<T, S, U, V, X>> modelFilterPatternSetups, CallBack<Action, Object> setFilterActionCreator, Action showLegendAction, Long filterPatternSetupModelId) {
        this.fillFilterMenu(modelFilterPatternSetups, setFilterActionCreator, showLegendAction);
        int toSelect = 0;
        if (filterPatternSetupModelId != null) {
            int start;
            for (int i = start = 1 + ((menuItems = this.getStartingAdditionalMenuItems()).isEmpty() ? 0 : 1 + menuItems.size()); i < this.getItemCount() - 2; ++i) {
                ModelFilterPatternSetup<T, S, U, V, X> modelFilterPatternSetup = modelFilterPatternSetups.get(i - start);
                if (!((Model)modelFilterPatternSetup.getAttachedObject()).getId().equals(filterPatternSetupModelId)) continue;
                toSelect = i;
                break;
            }
        }
        JMenuItem toSelectItem = this.getItem(toSelect);
        toSelectItem.setSelected(true);
        if (this.isDialogVisible()) {
            toSelectItem.doClick();
        }
    }

    protected abstract <T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model> boolean isDialogVisible();
}

