/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.attribute;

import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.gui.attribute.AbstractAttributeValuePane;
import de.datomino.peppergis.client.gui.parcel.ParcelAttributeValuePane;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.parcel.ParcelListCellRenderer;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.util.wrapper.parcel.attribute.ParcelAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.parcel.RemoveParcelSelectionAction;
import de.datomino.peppergis.simplebasearea.gui.attribute.AbstractAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.attribute.AbstractListBasedAttributeValueSumPane;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SwingUtils;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import org.ktde.util.datatypes.Tupel;

public class ParcelAttributeValueSumPane
extends AbstractListBasedAttributeValueSumPane<ParcelModel, ParcelAttributeValueModel, ParcelAttributeValueDescriptorModel, ParcelStaticChoiceAttributeValueModel> {
    private static final long serialVersionUID = -5561149715491406476L;
    private static final AbstractAttributeValueSumPane.SumCalculator<ParcelModel, ParcelAttributeValueDescriptorModel, ParcelStaticChoiceAttributeValueModel> VALUE_SUM_CALCULATOR = new AbstractAttributeValueSumPane.ValueSumCalculator<ParcelModel, ParcelAttributeValueDescriptorModel, ParcelStaticChoiceAttributeValueModel>(){

        @Override
        protected Integer getIntValue(ParcelModel t, ParcelAttributeValueDescriptorModel u) {
            Integer values = 0;
            Iterator<ParcelAttributeValueModel> valueIter = t.iterateParcelAttributeValues();
            while (valueIter.hasNext()) {
                Integer integerValue;
                ParcelAttributeValueModel value = valueIter.next();
                if (!value.getParcelAttributeValueDescriptor().equals(u) || (integerValue = value.getIntegerValue()) == null) continue;
                values = values + integerValue;
            }
            return values;
        }

        @Override
        protected Double getDoubleValue(ParcelModel t, ParcelAttributeValueDescriptorModel u) {
            Double values = 0.0;
            Iterator<ParcelAttributeValueModel> valueIter = t.iterateParcelAttributeValues();
            while (valueIter.hasNext()) {
                Double doubleValue;
                ParcelAttributeValueModel value = valueIter.next();
                if (!value.getParcelAttributeValueDescriptor().equals(u) || (doubleValue = value.getFloatValue()) == null) continue;
                values = values + doubleValue;
            }
            return values;
        }
    };

    public ParcelAttributeValueSumPane(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(baseLayerEditorPanel, "messages.parcel.sum.selectedParcels", "parcel.attributes.aggregate.sum");
    }

    @Override
    protected AbstractAttributeValuePane<ParcelModel, ParcelAttributeValueModel, ParcelAttributeValueDescriptorModel, ParcelStaticChoiceAttributeValueModel> getValuePane(String aggregate) {
        Set<Object> atrributesForSum = aggregate == null ? new HashSet() : CollectionUtil.buildHashSet(aggregate.split(","));
        Collection<ParcelAttributeValueDescriptorModel> descriptorModels = super.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        ArrayList<ParcelAttributeValueDescriptorModelAttributeWrapper> descriptors = new ArrayList<ParcelAttributeValueDescriptorModelAttributeWrapper>();
        for (ParcelAttributeValueDescriptorModel descriptor : descriptorModels) {
            AttributeValueType attributeValueType = descriptor.getAttributeValueType();
            if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT || !atrributesForSum.contains(descriptor.getKey())) continue;
            descriptors.add(new ParcelAttributeValueDescriptorModelAttributeWrapper(descriptor));
        }
        return new ParcelAttributeValuePane(descriptors, this.getBaseLayerEditorPanel().getModelEnviroment(), false){
            private static final long serialVersionUID = -5741664133497720016L;

            @Override
            public void clearValues(AbstractAttributeValuePane.ComponentType componentType) {
                ParcelAttributeValueSumPane.this.clear();
                super.clearValues(componentType);
            }
        };
    }

    @Override
    protected AbstractAttributeValueSumPane.SumCalculator<ParcelModel, ParcelAttributeValueDescriptorModel, ParcelStaticChoiceAttributeValueModel> getValueSumCalculator() {
        return VALUE_SUM_CALCULATOR;
    }

    @Override
    public void loadValues(Collection<ParcelModel> ts) {
        if (ts == null) {
            return;
        }
        DefaultListModel parcelListModel = this.getListModel();
        parcelListModel.clear();
        StreetNetCaller streetNetCaller = super.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getStreetNetCaller();
        for (ParcelModel parcel : ts) {
            parcelListModel.addElement(parcel);
        }
        super.loadValues(ts);
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        ParcelListCellRenderer renderer = new ParcelListCellRenderer();
        renderer.setWithIndex(true);
        return renderer;
    }

    @Override
    protected Action[] getPopupActions(Collection<Object> selected) {
        if (!selected.isEmpty()) {
            ArrayList<ParcelModel> parcels = new ArrayList<ParcelModel>(selected.size());
            for (Object object : selected) {
                if (!(object instanceof ParcelModel)) continue;
                ParcelModel parcelModel = (ParcelModel)object;
                parcels.add(parcelModel);
            }
            if (!parcels.isEmpty()) {
                return new Action[]{new RemoveParcelSelectionAction(this.getBaseLayerEditorPanel(), parcels)};
            }
        }
        return new Action[0];
    }

    @Override
    protected void showDialogForModel(Object selected) {
        Tupel tupel;
        Object element1;
        if (selected instanceof Tupel && (element1 = (tupel = (Tupel)selected).getElement1()) instanceof ParcelModel) {
            ParcelModel parcelModel = (ParcelModel)element1;
            BaseLayerEditorPanel baseLayerEditorPanel = this.getBaseLayerEditorPanel();
            ParcelDialog parcelDialog = new ParcelDialog(SwingUtils.findWindowParent(baseLayerEditorPanel), parcelModel, Dialog.ModalityType.APPLICATION_MODAL, baseLayerEditorPanel.getModelEnviroment(), false, false);
            parcelDialog.setVisible(true);
        }
    }
}

