/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.attribute;

import de.datomino.peppergis.client.gui.attribute.AbstractAttributeValuePane;
import de.datomino.peppergis.client.gui.letter.LetterAttributeValuePane;
import de.datomino.peppergis.client.gui.letter.LetterDialog;
import de.datomino.peppergis.client.gui.letter.LetterListCellRenderer;
import de.datomino.peppergis.client.model.base.LetterAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterStaticChoiceAttributeValueModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.letter.RemoveLetterSelectionAction;
import de.datomino.peppergis.simplebasearea.gui.attribute.AbstractAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.attribute.AbstractListBasedAttributeValueSumPane;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SwingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;

public class LetterAttributeValueSumPane
extends AbstractListBasedAttributeValueSumPane<LetterModel, LetterAttributeValueModel, LetterAttributeValueDescriptorModel, LetterStaticChoiceAttributeValueModel> {
    private static final long serialVersionUID = 6173892805396227602L;
    private static final AbstractAttributeValueSumPane.SumCalculator<LetterModel, LetterAttributeValueDescriptorModel, LetterStaticChoiceAttributeValueModel> VALUE_SUM_CALCULATOR = new AbstractAttributeValueSumPane.ValueSumCalculator<LetterModel, LetterAttributeValueDescriptorModel, LetterStaticChoiceAttributeValueModel>(){

        @Override
        protected Integer getIntValue(LetterModel t, LetterAttributeValueDescriptorModel u) {
            Integer values = 0;
            Iterator<LetterAttributeValueModel> valueIter = t.iterateLetterAttributeValues();
            while (valueIter.hasNext()) {
                Integer integerValue;
                LetterAttributeValueModel value = valueIter.next();
                if (!value.getLetterAttributeValueDescriptor().equals(u) || (integerValue = value.getIntegerValue()) == null) continue;
                values = values + integerValue;
            }
            return values;
        }

        @Override
        protected Double getDoubleValue(LetterModel t, LetterAttributeValueDescriptorModel u) {
            Double values = 0.0;
            Iterator<LetterAttributeValueModel> valueIter = t.iterateLetterAttributeValues();
            while (valueIter.hasNext()) {
                Double doubleValue;
                LetterAttributeValueModel value = valueIter.next();
                if (!value.getLetterAttributeValueDescriptor().equals(u) || (doubleValue = value.getFloatValue()) == null) continue;
                values = values + doubleValue;
            }
            return values;
        }
    };

    public LetterAttributeValueSumPane(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(baseLayerEditorPanel, "messages.letters.sum.selectedLetters", "letter.attributes.aggregate.sum");
    }

    @Override
    protected AbstractAttributeValuePane<LetterModel, LetterAttributeValueModel, LetterAttributeValueDescriptorModel, LetterStaticChoiceAttributeValueModel> getValuePane(String aggregate) {
        HashSet atrributesForSum = aggregate == null ? new HashSet() : CollectionUtil.buildHashSet(aggregate.replaceAll(" ", "").split(","));
        Collection<LetterAttributeValueDescriptorModel> descriptorModels = this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getLetterCaller().getAllLetterAttributeValueDescriptors();
        ArrayList<LetterAttributeValueDescriptorModel> descriptors = new ArrayList<LetterAttributeValueDescriptorModel>();
        for (LetterAttributeValueDescriptorModel descriptor : descriptorModels) {
            AttributeValueType attributeValueType = descriptor.getAttributeValueType();
            if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT || !atrributesForSum.contains(descriptor.getKey())) continue;
            descriptors.add(descriptor);
        }
        return new LetterAttributeValuePane(descriptors, this.getBaseLayerEditorPanel().getModelEnviroment(), false){
            private static final long serialVersionUID = -5741664133497720016L;

            @Override
            public void clearValues(AbstractAttributeValuePane.ComponentType componentType) {
                LetterAttributeValueSumPane.this.clear();
                super.clearValues(componentType);
            }
        };
    }

    @Override
    protected AbstractAttributeValueSumPane.SumCalculator<LetterModel, LetterAttributeValueDescriptorModel, LetterStaticChoiceAttributeValueModel> getValueSumCalculator() {
        return VALUE_SUM_CALCULATOR;
    }

    @Override
    public void loadValues(Collection<LetterModel> ts) {
        if (ts == null) {
            return;
        }
        DefaultListModel listModel = this.getListModel();
        listModel.clear();
        for (LetterModel letter : ts) {
            listModel.addElement(letter);
        }
        super.loadValues(ts);
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        LetterListCellRenderer renderer = new LetterListCellRenderer();
        renderer.setWithIndex(true);
        return renderer;
    }

    @Override
    protected Action[] getPopupActions(Collection<Object> selected) {
        if (!selected.isEmpty()) {
            ArrayList<LetterModel> letters = new ArrayList<LetterModel>(selected.size());
            for (Object object : selected) {
                if (!(object instanceof LetterModel)) continue;
                LetterModel letterModel = (LetterModel)object;
                letters.add(letterModel);
            }
            if (!letters.isEmpty()) {
                return new Action[]{new RemoveLetterSelectionAction(this.getBaseLayerEditorPanel(), letters)};
            }
        }
        return new Action[0];
    }

    @Override
    protected void showDialogForModel(Object selected) {
        if (selected instanceof LetterModel) {
            LetterModel letterModel = (LetterModel)selected;
            BaseLayerEditorPanel baseLayerEditorPanel = this.getBaseLayerEditorPanel();
            LetterDialog letterDialog = new LetterDialog(SwingUtils.findWindowParent(baseLayerEditorPanel), Collections.singletonList(letterModel), baseLayerEditorPanel.getModelEnviroment());
            letterDialog.setInternalFrame(this.getBaseLayerEditorPanel().getInternalFrame());
            letterDialog.setVisible(true);
        }
    }
}

