/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.attribute;

import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.gui.attribute.AbstractAttributeValueSumPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;

public abstract class AbstractListBasedAttributeValueSumPane<T extends Model, S extends Model, U extends Model, V extends Model>
extends AbstractAttributeValueSumPane<T, S, U, V> {
    private JList list;

    public AbstractListBasedAttributeValueSumPane(BaseLayerEditorPanel baseLayerEditorPanel, String title, String properties) {
        super(baseLayerEditorPanel, title, properties, new JList());
        JList list;
        this.list = list = (JList)this.getCenterComponent();
        DefaultListModel listModel = new DefaultListModel();
        list.setModel(listModel);
        ListCellRenderer renderer = this.createListRenderer();
        list.setCellRenderer(renderer);
        list.addMouseListener(new AttributeValueSumMouseListener());
    }

    protected DefaultListModel getListModel() {
        return (DefaultListModel)this.list.getModel();
    }

    protected abstract ListCellRenderer createListRenderer();

    protected abstract Action[] getPopupActions(Collection<Object> var1);

    protected abstract void showDialogForModel(Object var1);

    private class AttributeValueSumMouseListener
    extends MouseAdapter {
        private AttributeValueSumMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            switch (e.getButton()) {
                case 1: {
                    Object object;
                    if (e.getClickCount() <= 1 || (object = this.getClickedObject(e)) == null) break;
                    AbstractListBasedAttributeValueSumPane.this.showDialogForModel(object);
                    break;
                }
                case 3: {
                    List<Object> objects;
                    Action[] actions2;
                    Object object;
                    Object[] selectedObjects = AbstractListBasedAttributeValueSumPane.this.list.getSelectedValues();
                    if ((selectedObjects == null || selectedObjects.length == 0) && (object = this.getClickedObject(e)) != null) {
                        selectedObjects = new Object[]{object};
                    }
                    if ((actions2 = AbstractListBasedAttributeValueSumPane.this.getPopupActions(objects = selectedObjects == null ? Collections.emptyList() : Arrays.asList(selectedObjects))) == null || actions2.length <= 0) break;
                    JPopupMenu popupMenu = new JPopupMenu();
                    for (Action action : actions2) {
                        popupMenu.add(action);
                    }
                    popupMenu.show(AbstractListBasedAttributeValueSumPane.this.list, e.getX(), e.getY());
                }
            }
        }

        private Object getClickedObject(MouseEvent e) {
            int index = AbstractListBasedAttributeValueSumPane.this.list.locationToIndex(e.getPoint());
            if (index >= 0) {
                DefaultListModel model = AbstractListBasedAttributeValueSumPane.this.getListModel();
                Object object = model.get(index);
                return object;
            }
            return null;
        }
    }
}

