/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.attribute;

import de.datomino.peppergis.client.gui.attribute.AbstractAttributeValuePane;
import de.datomino.peppergis.client.gui.attribute.AttributeNumberSpinnerPanel;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractAttributeValueSumPane<T extends Model, S extends Model, U extends Model, V extends Model>
extends JPanel {
    private static final long serialVersionUID = -5559557045938136187L;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private AbstractAttributeValuePane<T, S, U, V> valuePane;
    private JLabel selectedObjectsLabel;
    private Component centerComponent;
    private String titleKey;

    public AbstractAttributeValueSumPane(BaseLayerEditorPanel baseLayerEditorPanel, String titel, String properties, Component centerComponent) {
        super(new BorderLayout());
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.centerComponent = centerComponent;
        this.initialize(titel, properties, centerComponent);
    }

    public AbstractAttributeValueSumPane(BaseLayerEditorPanel baseLayerEditorPanel, String titel, String properties) {
        this(baseLayerEditorPanel, titel, properties, null);
    }

    protected abstract AbstractAttributeValuePane<T, S, U, V> getValuePane(String var1);

    private void initialize(String titel, String property, Component centerComponent) {
        String aggregate = ModelEnviroment.getProperties().getProperty(property);
        if (aggregate == null) {
            this.setPreferredSize(new Dimension(0, 0));
        }
        JPanel northPanel = new JPanel(new BorderLayout());
        this.titleKey = titel;
        this.selectedObjectsLabel = new JLabel("");
        this.valuePane = this.getValuePane(aggregate);
        northPanel.add(this.valuePane, "Center");
        northPanel.add((Component)this.selectedObjectsLabel, "North");
        this.add((Component)northPanel, "North");
        if (centerComponent != null) {
            this.add((Component)new JScrollPane(centerComponent), "Center");
        }
        this.loadValues(null);
    }

    public void loadValues(Collection<T> ts) {
        AbstractAttributeValuePane.ComponentType componentType = AbstractAttributeValuePane.ComponentType.VALUE;
        this.loadValues(ts, componentType, this.getValueSumCalculator());
        super.repaint();
    }

    protected void loadValues(Collection<T> ts, AbstractAttributeValuePane.ComponentType componentType, SumCalculator<T, U, V> sumCalculator) {
        if (ts == null || ts.isEmpty()) {
            this.selectedObjectsLabel.setText(ModelEnviroment.getMessageResolver().resolveMessage(this.titleKey, Integer.valueOf(0)));
            this.valuePane.clearValues(componentType);
            this.clear();
        } else {
            this.selectedObjectsLabel.setText(ModelEnviroment.getMessageResolver().resolveMessage(this.titleKey, Integer.valueOf(ts.size())));
            Collection<AttributeValueDescriptorModel<U, V>> descriptors = this.valuePane.getDescriptorMap().values();
            for (AttributeValueDescriptorModel<U, V> descriptor : descriptors) {
                String tKey = descriptor.getKey();
                Tupel<String, AbstractAttributeValuePane.ComponentType> key = new Tupel<String, AbstractAttributeValuePane.ComponentType>(tKey, componentType);
                JComponent component = this.getValueComponentMap().get(key);
                if (component == null) continue;
                switch (descriptor.getAttributeValueType()) {
                    case INTEGER: {
                        AttributeNumberSpinnerPanel intField = (AttributeNumberSpinnerPanel)component;
                        Integer intValue = sumCalculator.getIntegerSum(ts, descriptor);
                        int width = (int)(Math.log10(intValue.intValue()) < 3.0 ? 3.0 : Math.log10(intValue.intValue())) + 1;
                        intField.setValue(intValue);
                        break;
                    }
                    case FLOAT: {
                        AttributeNumberSpinnerPanel doubleField = (AttributeNumberSpinnerPanel)component;
                        Double doubleValue = sumCalculator.getDoubleSum(ts, descriptor);
                        String string = doubleValue.toString();
                        int width = Math.max(3, string.length());
                        doubleField.setValue(doubleValue);
                    }
                }
            }
        }
    }

    protected abstract SumCalculator<T, U, V> getValueSumCalculator();

    protected void clear() {
        Collection<AttributeValueDescriptorModel<U, V>> descriptors = this.valuePane.getDescriptorMap().values();
        for (AttributeValueDescriptorModel<U, V> descriptor : descriptors) {
            String tKey = descriptor.getKey();
            Tupel<String, AbstractAttributeValuePane.ComponentType> key = new Tupel<String, AbstractAttributeValuePane.ComponentType>(tKey, AbstractAttributeValuePane.ComponentType.VALUE);
            JComponent component = this.getValueComponentMap().get(key);
            switch (descriptor.getAttributeValueType()) {
                case INTEGER: 
                case FLOAT: {
                    AttributeNumberSpinnerPanel attributeNumberSpinnerPanel = (AttributeNumberSpinnerPanel)component;
                }
            }
        }
    }

    protected BaseLayerEditorPanel getBaseLayerEditorPanel() {
        return this.baseLayerEditorPanel;
    }

    protected Component getCenterComponent() {
        return this.centerComponent;
    }

    public Map<Tupel<String, AbstractAttributeValuePane.ComponentType>, JComponent> getValueComponentMap() {
        return this.valuePane.getValueComponentMap();
    }

    public static abstract class ValueSumCalculator<T extends Model, U extends Model, V extends Model>
    implements SumCalculator<T, U, V> {
        @Override
        public Integer getIntegerSum(Collection<T> ts, AttributeValueDescriptorModel<U, V> descriptor) {
            Integer sum = 0;
            for (Model t : ts) {
                Integer intValue = this.getIntValue(t, (Model)descriptor.getAttachedObject());
                sum = sum + (intValue == null ? 0 : intValue);
            }
            return sum;
        }

        @Override
        public Double getDoubleSum(Collection<T> ts, AttributeValueDescriptorModel<U, V> descriptor) {
            Double sum = 0.0;
            for (Model t : ts) {
                Double doubleValue = this.getDoubleValue(t, (Model)descriptor.getAttachedObject());
                sum = sum + (doubleValue == null ? 0.0 : doubleValue);
            }
            return sum;
        }

        protected abstract Integer getIntValue(T var1, U var2);

        protected abstract Double getDoubleValue(T var1, U var2);
    }

    protected static interface SumCalculator<T extends Model, U extends Model, V extends Model> {
        public Integer getIntegerSum(Collection<T> var1, AttributeValueDescriptorModel<U, V> var2);

        public Double getDoubleSum(Collection<T> var1, AttributeValueDescriptorModel<U, V> var2);
    }
}

