/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui;

import de.datomino.peppergis.client.action.CopyAction;
import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.area.AreaObjectDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.CenterAreaObjectAction;
import de.datomino.peppergis.simplebasearea.action.mark.ClearMarkAction;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.geo.swing.ObjectSelectionChangedEvent;
import de.datomino.util.geo.swing.ObjectSelectionListener;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class SelectedAreaList
extends JList
implements ObjectSelectionListener<AreaObjectModel> {
    private static final long serialVersionUID = 4474465869742558663L;
    private static final Comparator<AreaObjectModel> COMPARATOR = ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

        @Override
        public Object transform(Object input) {
            AreaObjectModel areaObjectModel = (AreaObjectModel)input;
            return StringUtil.nullToEmpty(areaObjectModel.getShortcut());
        }
    });
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private Collection<AreaAttributeValueDescriptorModel> descriptors;

    public SelectedAreaList(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(new DefaultListModel());
        this.setCellRenderer(new AbstractListCellRenderer(){
            private static final long serialVersionUID = -6053298867297721029L;

            protected String getStringFromValue(Object object) {
                if (object instanceof AreaObjectModel) {
                    AreaObjectModel areaObjectModel = (AreaObjectModel)object;
                    String name = AreaObjectModelUtil.getShortcutAndDisplayname(areaObjectModel);
                    return (name + " " + SelectedAreaList.this.getValueChain(areaObjectModel)).trim();
                }
                return object.toString();
            }
        });
        this.setSelectionMode(2);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.setData(baseLayerEditorPanel.getAreaObjectsForLegend());
        this.baseLayerEditorPanel.addObjectSelectionListener(this);
        this.addMouseListener(new SelectedAreaListMouseListener());
    }

    private String getValueChain(AreaObjectModel areaObjectModel) {
        if (this.descriptors == null) {
            return "";
        }
        ArrayList<String> values = new ArrayList<String>(this.descriptors.size());
        for (AreaAttributeValueDescriptorModel descriptor : this.descriptors) {
            String value = "";
            for (AreaAttributeValueModel areaAttributeValueModel : areaObjectModel.iterableAreaAttributeValues()) {
                if (!descriptor.equals(areaAttributeValueModel.getAreaAttributeValueDescriptor())) continue;
                switch (descriptor.getAttributeValueType()) {
                    case BOOLEAN: {
                        value = ModelEnviroment.getMessageResolver().resolveMessage("messages.default." + PrimitiveUtil.nullToFalse(areaAttributeValueModel.getBooleanValue()), new Serializable[0]);
                        break;
                    }
                    case DATE: {
                        Long longValue = areaAttributeValueModel.getLongValue();
                        if (longValue == null) {
                            value = "";
                            break;
                        }
                        value = new SimpleDateFormat().format(new Date(longValue));
                        break;
                    }
                    case FLOAT: {
                        value = Double.toString(PrimitiveUtil.nullToZero(areaAttributeValueModel.getFloatValue()));
                        break;
                    }
                    case INTEGER: {
                        value = Integer.toString(PrimitiveUtil.nullToZero(areaAttributeValueModel.getIntegerValue()));
                        break;
                    }
                    case STATIC_CHOICE: {
                        AreaStaticChoiceAttributeValueModel staticChoiceValue = areaAttributeValueModel.getStaticChoiceValue();
                        if (staticChoiceValue == null) {
                            value = "";
                            break;
                        }
                        value = staticChoiceValue.getName();
                        break;
                    }
                    case STRING: {
                        value = StringUtil.nullToEmpty(areaAttributeValueModel.getStringValue());
                        break;
                    }
                    case TEXT: {
                        value = StringUtil.nullToEmpty(areaAttributeValueModel.getTextValue());
                    }
                }
                break;
            }
            values.add(value);
        }
        return StringUtil.implode(values, "/");
    }

    @Override
    public void selectionChanged(ObjectSelectionChangedEvent<AreaObjectModel> objectSelectionChangedEvent) {
        this.setData(objectSelectionChangedEvent.getNewSelection());
    }

    private void setData(Tupel<Set<AreaObjectModel>, Set<AreaObjectModel>> tupel) {
        DefaultListModel dlm = (DefaultListModel)this.getModel();
        dlm.clear();
        for (AreaObjectModel model : tupel.getElement1()) {
            dlm.addElement(model);
        }
        for (AreaObjectModel model : tupel.getElement2()) {
            dlm.addElement(model);
        }
    }

    public void setDescriptors(Collection<AreaAttributeValueDescriptorModel> descriptors) {
        this.descriptors = descriptors;
    }

    private class SelectedAreaListMouseListener
    extends MouseAdapter {
        private SelectedAreaListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            switch (e.getButton()) {
                case 1: {
                    int index;
                    if (e.getClickCount() != 2 || (index = SelectedAreaList.this.locationToIndex(e.getPoint())) < 0) break;
                    DefaultListModel dlm = (DefaultListModel)SelectedAreaList.this.getModel();
                    AreaObjectModel areaObjectModel = (AreaObjectModel)dlm.getElementAt(index);
                    AreaObjectDialog areaObjectDialog = new AreaObjectDialog(SwingUtils.findWindowParent(SelectedAreaList.this.baseLayerEditorPanel), areaObjectModel, SelectedAreaList.this.baseLayerEditorPanel.getModelEnviroment());
                    areaObjectDialog.setVisible(true);
                    break;
                }
                case 3: {
                    int index;
                    if (e.getClickCount() != 1) break;
                    ArrayList<Object> selectedValues = CollectionUtil.buildArrayList(SelectedAreaList.this.getSelectedValues());
                    if (selectedValues.isEmpty() && (index = SelectedAreaList.this.locationToIndex(e.getPoint())) >= 0) {
                        SelectedAreaList.this.setSelectedIndex(index);
                        selectedValues = CollectionUtil.buildArrayList(SelectedAreaList.this.getSelectedValues());
                    }
                    if (selectedValues.isEmpty()) break;
                    ArrayList os = Collections.list(((DefaultListModel)SelectedAreaList.this.getModel()).elements());
                    JPopupMenu popupMenu = new JPopupMenu();
                    ArrayList<AreaObjectModel> selectedAreaObjects = new ArrayList<AreaObjectModel>(selectedValues.size());
                    CollectionUtil.transform(selectedValues, selectedAreaObjects, new de.datomino.util.collection.Transformer<Object, AreaObjectModel>(){

                        @Override
                        public AreaObjectModel transform(Object input) {
                            return (AreaObjectModel)input;
                        }
                    });
                    popupMenu.add(new CenterAreaObjectAction(SelectedAreaList.this.baseLayerEditorPanel, selectedAreaObjects));
                    popupMenu.add(new ClearMarkAction(SelectedAreaList.this.baseLayerEditorPanel, selectedAreaObjects));
                    popupMenu.add(new CopyAction<AreaObjectModel>(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.copyToClipboard", new Serializable[0]), selectedAreaObjects));
                    popupMenu.add(new CopyAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.copyAllToClipboard", new Serializable[0]), os));
                    popupMenu.show(SelectedAreaList.this, e.getX(), e.getY());
                }
            }
        }
    }
}

