/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.frey;

import de.datomino.logistic.dto.LocationType;
import de.datomino.peppergis.client.util.filter.RendererFactory;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.swing.AbstractGeometryNavigatorStaticRenderer;
import de.datomino.util.geo.swing.renderer.IconPointRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.MouseManipulator;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class FreySimplePointRenderer
extends AbstractGeometryNavigatorStaticRenderer<Tupel<ImmutablePoint, LocationType>, ImmutablePoint>
implements MouseManipulator {
    private Tupel<ImmutablePoint, LocationType> point;
    private IconPointRenderer<Tupel<ImmutablePoint, LocationType>> streetNumberRenderer;
    private IconPointRenderer<Tupel<ImmutablePoint, LocationType>> nonExactRenderer;
    private boolean dragging = false;

    public FreySimplePointRenderer(String streetNumberImageUrl, String nonExactImageUrl) {
        super("FreySimplePointRenderer", 0.0, Double.MAX_VALUE, null, null, null, new PointGeomExtractor());
        this.streetNumberRenderer = FreySimplePointRenderer.createIconPointRenderer(streetNumberImageUrl);
        this.nonExactRenderer = FreySimplePointRenderer.createIconPointRenderer(nonExactImageUrl);
    }

    protected static IconPointRenderer<Tupel<ImmutablePoint, LocationType>> createIconPointRenderer(String imageUrl) {
        try {
            if (!StringUtil.isBlank(imageUrl)) {
                return RendererFactory.getInstance().createIconPointRenderer(new URL(imageUrl));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return RendererFactory.getInstance().createIconPointRenderer(null);
    }

    @Override
    protected Collection<Tupel<ImmutablePoint, LocationType>> getGeometries(Coordinate bottomLeft, Coordinate topRight, double upp) {
        if (this.point == null) {
            return Collections.emptySet();
        }
        double lx = bottomLeft.getX();
        double by = bottomLeft.getY();
        double rx = topRight.getX();
        double ty = topRight.getY();
        LinkedList<Tupel<ImmutablePoint, LocationType>> pointsInRect = new LinkedList<Tupel<ImmutablePoint, LocationType>>();
        ImmutablePoint point = this.point.getElement1();
        ImmutablePoint transformed = (ImmutablePoint)point.getTransformed(bottomLeft.getFactory());
        double x = transformed.getX();
        double y = transformed.getY();
        if (x >= lx && x <= rx && y >= by && y <= ty) {
            pointsInRect.add(this.point);
        }
        return pointsInRect;
    }

    public void setPoint(Tupel<ImmutablePoint, LocationType> point) {
        this.point = point;
        this.getPanel().repaint(10L);
    }

    @Override
    protected <W extends RendererProperties> void drawPoint(Graphics2D g2d, Tupel<ImmutablePoint, LocationType> model, ImmutablePoint geom, PointRenderer<W, Tupel<ImmutablePoint, LocationType>> pointRenderer, W rendererProperties, int cycle) {
        IconPointRenderer<Tupel<ImmutablePoint, LocationType>> aPointRenderer = model.getElement2() == LocationType.street_address ? this.streetNumberRenderer : this.nonExactRenderer;
        super.drawPoint(g2d, model, geom, aPointRenderer, rendererProperties, cycle);
    }

    public Tupel<ImmutablePoint, LocationType> getPoint() {
        return this.point;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragging) {
            System.out.println("Drag 1");
            Point2D.Double real = this.getPanel().getReal(e.getX(), e.getY());
            ImmutablePoint nP = ImmutableGeoObjectFactory.createImmutablePoint(this.getPanel().getCoordinateFactory().createCoordinate(real));
            if (this.point == null) {
                this.point = new Tupel<ImmutablePoint, LocationType>(nP, LocationType.street_address);
            } else {
                this.point.setElement1(nP);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.out.println("Click");
        if (this.point == null) {
            Point2D.Double real = this.getPanel().getReal(e.getX(), e.getY());
            ImmutablePoint nP = ImmutableGeoObjectFactory.createImmutablePoint(this.getPanel().getCoordinateFactory().createCoordinate(real));
            this.point = new Tupel<ImmutablePoint, LocationType>(nP, LocationType.street_address);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        System.out.println("Press");
        if (this.point != null) {
            System.out.println("Press 2");
            Point2D.Double pixel = this.getPanel().getPixel(this.point.getElement1().getCoordinate());
            System.out.println(e.getX() + " - " + e.getY() + " - " + pixel.getX() + " - " + pixel.getY());
            double tx = (double)e.getX() - pixel.getX();
            double ty = (double)e.getY() - pixel.getY();
            double length = Math.sqrt(tx * tx + ty * ty);
            if (length <= 10.0) {
                System.out.println("Press 3");
                this.dragging = true;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            Point2D.Double real = this.getPanel().getReal(e.getX(), e.getY());
            ImmutablePoint nP = ImmutableGeoObjectFactory.createImmutablePoint(this.getPanel().getCoordinateFactory().createCoordinate(real));
            if (this.point == null) {
                this.point = new Tupel<ImmutablePoint, LocationType>(nP, LocationType.street_address);
            } else {
                this.point.setElement1(nP);
            }
            this.dragging = false;
            this.getPanel().repaint(10L);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getPanel());
    }

    private static class PointGeomExtractor
    implements GeomExtractor<Tupel<ImmutablePoint, LocationType>, ImmutablePoint> {
        private PointGeomExtractor() {
        }

        @Override
        public ImmutablePoint getGeom(Tupel<ImmutablePoint, LocationType> object) {
            return object.getElement1();
        }
    }
}

