/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.frey;

import de.datomino.logistic.dto.GoogleLogisticQualifiedLocationDto;
import de.datomino.logistic.dto.LocationType;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.frey.CoordinateAndAreasDto;
import de.datomino.peppergis.client.frey.FreyHandler;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.frey.FreySimplePointRenderer;
import de.datomino.peppergis.simplebasearea.gui.menu.BaseLayerEditorPanelMenuBar;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.application.DynamicAttributedProperties;
import org.ktde.util.datatypes.Tupel;

public class FreySelectBaseLayerEditorPanel
extends JPanel {
    private static final long serialVersionUID = 95254946333517398L;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private FreySimplePointRenderer freySimplePointRenderer;

    public FreySelectBaseLayerEditorPanel(Long editBaseLayerId) {
        super(new BorderLayout());
        this.baseLayerEditorPanel = new BaseLayerEditorPanel(editBaseLayerId){
            private static final long serialVersionUID = 7195447217501029791L;

            @Override
            protected AbstractAction createSaveAction() {
                return new AbstractAction("Speichern"){
                    private static final long serialVersionUID = -5071401107541775541L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Set<AreaObjectModel> selectedObjects = this.getSelectedObjects();
                        String[] keys = new String[selectedObjects.size()];
                        int count = 0;
                        for (AreaObjectModel areaObjectModel : selectedObjects) {
                            keys[count++] = areaObjectModel.getShortcut();
                        }
                        Long id = FreySelectBaseLayerEditorPanel.this.baseLayerEditorPanel.getEditBaseLayer().getId();
                        Long wId = null;
                        try {
                            wId = Long.valueOf(ModelEnviroment.getProperties().getProperty("frey.delivery.wednesday.id"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Long sId = null;
                        try {
                            sId = Long.valueOf(ModelEnviroment.getProperties().getProperty("frey.delivery.saturday.id"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Tupel<ImmutablePoint, LocationType> point = FreySelectBaseLayerEditorPanel.this.freySimplePointRenderer.getPoint();
                        ImmutablePoint last = point == null ? null : point.getElement1();
                        Double x = 0.0;
                        Double y = 0.0;
                        if (last != null) {
                            Coordinate coord = Wgs84Factory.INSTANCE.createCoordinate(last.getCoordinate());
                            x = coord.getX();
                            y = coord.getY();
                        }
                        CoordinateAndAreasDto coordinateAndAreasDto = new CoordinateAndAreasDto(x, y, keys);
                        if (id.equals(wId)) {
                            this.getFreyHandler().sendWednesdaySelectAreas(coordinateAndAreasDto);
                        }
                        if (id.equals(sId)) {
                            this.getFreyHandler().sendSaturdaySelectAreas(coordinateAndAreasDto);
                        }
                    }

                    @Override
                    public void setEnabled(boolean newValue) {
                    }
                };
            }

            @Override
            protected Component createSumPanel() {
                Component sumComponent = super.createSumPanel();
                JPanel panel = new JPanel(new BorderLayout());
                panel.add(sumComponent, "Center");
                panel.add((Component)new JButton(this.getSaveAction()), "South");
                return panel;
            }

            @Override
            protected Double getAreaLayerBucketSize(AreaLayerModel areaLayer, boolean currentLayer) {
                if (currentLayer) {
                    String bucketSizeString = ModelEnviroment.getProperties().getProperty("areas.frey.localisation.bucketSize");
                    Double bucketSize = 1000.0;
                    try {
                        bucketSize = Double.valueOf(bucketSizeString);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bucketSize;
                }
                return super.getAreaLayerBucketSize(areaLayer, currentLayer);
            }
        };
        this.add((Component)this.baseLayerEditorPanel, "Center");
        DynamicAttributedProperties properties = ModelEnviroment.getProperties();
        this.freySimplePointRenderer = new FreySimplePointRenderer(properties.getProperty("frey.location.point.image.exact"), properties.getProperty("frey.location.point.image.nonexact"));
        this.getBaseLayerEditorPanel().getNavigatorPanel().addRenderer(this.freySimplePointRenderer);
        this.getBaseLayerEditorPanel().getNavigatorPanel().setMouseManipulator(this.freySimplePointRenderer);
        BaseLayerEditorPanelMenuBar menuBar = this.getBaseLayerEditorPanel().getMenuBar();
        JMenu menu = menuBar.getMenu(0);
        menu.add(new AbstractAction("Adresse verschieben"){
            private static final long serialVersionUID = 4141284170707758908L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FreySelectBaseLayerEditorPanel.this.getBaseLayerEditorPanel().getNavigatorPanel().setMouseManipulator(FreySelectBaseLayerEditorPanel.this.freySimplePointRenderer);
            }
        });
    }

    public Collection<String> selectAndCenterArea(Collection<String> areaKeys) {
        Collection<AreaObjectModel> areaObjectModels = this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjects(this.getBaseLayerEditorPanel().getEditBaseLayer(), areaKeys);
        HashSet<String> keysFound = new HashSet<String>();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            keysFound.add(areaObjectModel.getShortcut());
        }
        this.getBaseLayerEditorPanel().select(areaObjectModels);
        this.getBaseLayerEditorPanel().getCenterSelectedAreaObjectsAction().actionPerformed(null);
        return keysFound;
    }

    protected LogisticQualifiedLocationDto locateAdressAndAskIfMultiple(LogisticLocationDto<Long> logisticLocationDto, boolean fuzzy) {
        List<LogisticQualifiedLocationDto> points = this.locateAddress(logisticLocationDto, fuzzy);
        LogisticQualifiedLocationDto logisticQualifiedLocationDto = null;
        if (points != null) {
            int pSize = points.size();
            if (pSize == 0) {
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this), "Es konnte keine Adresse gefunden werden", "Warnung", 2);
            } else if (pSize == 1) {
                logisticQualifiedLocationDto = points.get(0);
            } else if (pSize > 1) {
                AddressChoosingPane addressChoosingPane = new AddressChoosingPane(points);
                int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this), addressChoosingPane, "Adress-Auswahl", 0);
                if (d == 0) {
                    logisticQualifiedLocationDto = addressChoosingPane.getSelectedLogisticQualifiedLocationDto();
                }
            }
        }
        return logisticQualifiedLocationDto;
    }

    protected List<LogisticQualifiedLocationDto> locateAddress(LogisticLocationDto<Long> logisticLocationDto, boolean fuzzy) {
        if (fuzzy) {
            return this.baseLayerEditorPanel.getModelEnviroment().getGeoServerStub().getBaseBi().geocodeFuzzy(logisticLocationDto, null);
        }
        return this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getBaseCaller().geocode(logisticLocationDto, null);
    }

    protected Collection<String> findAreaByPoint(ImmutablePoint point, Long layerId, int radius) {
        if (point == null) {
            return Collections.emptyList();
        }
        Collection<AreaObjectModel> areas = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().findAreasWithCoordInRange(point.getCoordinate(), radius, layerId);
        ArrayList<String> keys = new ArrayList<String>(areas.size());
        for (AreaObjectModel areaObjectModel : areas) {
            keys.add(areaObjectModel.getShortcut());
        }
        return keys;
    }

    public BaseLayerEditorPanel getBaseLayerEditorPanel() {
        return this.baseLayerEditorPanel;
    }

    public boolean findAreaByAddress(LogisticLocationDto<Long> logisticLocationDto, boolean fuzzy, int radius) {
        Set<AreaObjectModel> empty = Collections.emptySet();
        this.getBaseLayerEditorPanel().select((Collection<AreaObjectModel>)empty);
        this.freySimplePointRenderer.setPoint(null);
        LogisticQualifiedLocationDto logisticQualifiedLocationDto = this.locateAdressAndAskIfMultiple(logisticLocationDto, fuzzy);
        if (logisticQualifiedLocationDto != null) {
            ImmutablePoint point = null;
            LocationType locationType = LocationType.street_address;
            if (logisticQualifiedLocationDto != null) {
                ImmutablePointDto geom = logisticQualifiedLocationDto.getGeom();
                if (geom != null) {
                    point = (ImmutablePoint)geom.getGeoObject();
                }
                if (logisticQualifiedLocationDto instanceof GoogleLogisticQualifiedLocationDto && (locationType = ((GoogleLogisticQualifiedLocationDto)logisticQualifiedLocationDto).getGoogleLocationType()) == null) {
                    locationType = LocationType.street_address;
                }
            }
            if (point != null) {
                this.freySimplePointRenderer.setPoint(new Tupel<ImmutablePoint, LocationType>(point, locationType));
                Collection<String> keys = this.findAreaByPoint(point, this.getBaseLayerEditorPanel().getEditBaseLayer().getId(), radius);
                if (keys.isEmpty()) {
                    this.getBaseLayerEditorPanel().getNavigatorPanel().center(point.getCoordinate());
                } else {
                    this.selectAndCenterArea(keys);
                }
                return true;
            }
        }
        return false;
    }

    public Collection<String> getAreaKeys() {
        return this.baseLayerEditorPanel.getAreaKeys();
    }

    public void close() {
        this.baseLayerEditorPanel.close();
    }

    public void setFreyHandler(FreyHandler freyHandler) {
        this.baseLayerEditorPanel.setFreyHandler(freyHandler);
    }

    private static class AddressChoosingPane
    extends JPanel {
        private static final long serialVersionUID = 3258984540703835987L;
        private JList list;

        public AddressChoosingPane(List<LogisticQualifiedLocationDto> logisticQualifiedLocationDtos) {
            super(new BorderLayout());
            DefaultListModel<LogisticQualifiedLocationDto> dlm = new DefaultListModel<LogisticQualifiedLocationDto>();
            this.list = new JList(dlm);
            for (LogisticQualifiedLocationDto logisticQualifiedLocationDto : logisticQualifiedLocationDtos) {
                dlm.addElement(logisticQualifiedLocationDto);
            }
            this.list.setSelectionMode(0);
            final ListCellRenderer cellRenderer = this.list.getCellRenderer();
            this.list.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object nValue = value;
                    if (nValue instanceof LogisticQualifiedLocationDto) {
                        LogisticQualifiedLocationDto logisticQualifiedLocationDto = (LogisticQualifiedLocationDto)nValue;
                        StringBuilder sb = new StringBuilder();
                        sb.append(StringUtil.nullToEmpty(logisticQualifiedLocationDto.getStreet())).append(" ").append(StringUtil.nullToEmpty(logisticQualifiedLocationDto.getHousenumber())).append(StringUtil.nullToEmpty(logisticQualifiedLocationDto.getExtension())).append(", ").append(StringUtil.nullToEmpty(logisticQualifiedLocationDto.getPostcode())).append(" ").append(StringUtil.nullToEmpty(logisticQualifiedLocationDto.getCity())).append(" - ").append(StringUtil.nullToEmpty(logisticQualifiedLocationDto.getDistrict()));
                        Country country = logisticQualifiedLocationDto.getCountry();
                        if (country != null && country != Country.GERMANY) {
                            sb.append("(").append(country.getVehicleSign()).append(")");
                        }
                        nValue = sb.toString();
                    }
                    return cellRenderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
                }
            });
            this.add((Component)new JScrollPane(this.list), "Center");
        }

        public LogisticQualifiedLocationDto getSelectedLogisticQualifiedLocationDto() {
            return (LogisticQualifiedLocationDto)this.list.getSelectedValue();
        }
    }
}

