/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.cover;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.cover.CoverHandler;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.model.StaticGeoObjectBucketsModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.OpenStreetmapViewFactory;

public class CoverHandlerImpl
implements CoverHandler {
    private AreaLayerRenderer areaLayerRenderer;
    private Collection<AreaObjectModel> coverage;
    private final BaseLayerEditorPanel baseLayerEditorPanel;

    public CoverHandlerImpl(BaseLayerEditorPanel baseLayerEditorPanel, int sortOrder) {
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        GeomExtractor<AreaObjectModel, ImmutablePolygonKind> geomExtractor = new GeomExtractor<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public ImmutablePolygonKind getGeom(AreaObjectModel object) {
                return object.getGeom();
            }
        };
        StaticGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new StaticGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(geomExtractor, OpenStreetmapViewFactory.INSTANCE);
        this.areaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("Cover", bucketsModel, geomExtractor, null, baseLayerEditorPanel.getModelEnviroment(), false, baseLayerEditorPanel.getNavigatorPanel());
        this.areaLayerRenderer.setActive(true);
        this.baseLayerEditorPanel.getNavigatorPanel().addRenderer(this.areaLayerRenderer);
    }

    @Override
    public void clearCover() {
        this.coverage = null;
        StaticGeoObjectBucketsModel staticGeoObjectBucketsModel = (StaticGeoObjectBucketsModel)this.areaLayerRenderer.getBucketsModel();
        staticGeoObjectBucketsModel.clear();
    }

    @Override
    public Collection<AreaObjectModel> getCurrentCoverage() {
        if (this.coverage == null) {
            return Collections.emptySet();
        }
        return new HashSet<AreaObjectModel>(this.coverage);
    }

    @Override
    public void calculateCover(Collection<AreaObjectModel> areaObjects, AreaLayerModel targetLayer, Double percentage) {
        Collection<AreaObjectModel> cover = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().calculateCover(areaObjects, null, targetLayer, percentage);
        this.coverage = cover;
        StaticGeoObjectBucketsModel staticGeoObjectBucketsModel = (StaticGeoObjectBucketsModel)this.areaLayerRenderer.getBucketsModel();
        staticGeoObjectBucketsModel.clear();
        staticGeoObjectBucketsModel.addAll(cover);
        Map<AreaLayerModel, Set<AreaObjectModel>> objectMarkSetsHash = this.baseLayerEditorPanel.getObjectMarkSetsHash();
        for (AreaObjectModel areaObjectModel : cover) {
            Set<AreaObjectModel> set = objectMarkSetsHash.get(areaObjectModel.getAreaLayer());
            if (set == null) continue;
            set.add(areaObjectModel);
        }
        this.baseLayerEditorPanel.updateSelectAreaObjectsInfo();
        this.areaLayerRenderer.getPanel().repaint(10L);
    }

    @Override
    public void createNewAreaFromCoverage(String shortcut, String displayName, AreaLayerModel targetLayer) {
        this.baseLayerEditorPanel.getUndoManager().startTransaction();
        AreaObjectModelImpl areaObject = new AreaObjectModelImpl();
        areaObject.setAreaLayer(targetLayer);
        areaObject.setShortcut(shortcut);
        areaObject.setDisplayname(displayName);
        Collection<AreaObjectModel> currentCoverage = this.getCurrentCoverage();
        ArrayList<ImmutablePolygonKind> freeHands = new ArrayList<ImmutablePolygonKind>(currentCoverage.size());
        for (AreaObjectModel areaObjectModel : currentCoverage) {
            freeHands.add(areaObjectModel.getGeom());
        }
        this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().createAreaGeometryAdd(areaObject, currentCoverage, freeHands, this.baseLayerEditorPanel.getModelEnviroment());
        this.baseLayerEditorPanel.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.new.order", new Serializable[0]));
    }
}

