/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.smooth;

import de.datomino.peppergis.client.areagenerator.DefaultUnionAreaGenerator;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.smooth.AbstractAreaSmoothAction;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class SmoothAreaAction
extends AbstractAreaSmoothAction {
    private static final long serialVersionUID = 5640069143694390194L;
    private double currentInitialValue = 10.0;

    public SmoothAreaAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.areas.addAreaActionSmooth", new Serializable[0]), baseLayerEditorPanel);
    }

    @Override
    protected void doAction(Collection<AreaObjectModel> areaObjects, Set<AreaObjectModel> bigSet, BaseLayerEditorPanel baseLayerEditorPanel) {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.distanceInMeter", new Serializable[0])));
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel((Number)this.currentInitialValue, Double.valueOf(1.0), null, (Number)1.0));
        Dimension dim = jSpinner.getPreferredSize();
        jSpinner.setPreferredSize(new Dimension((int)Math.round(dim.getWidth() * 1.8), (int)Math.round(dim.getHeight())));
        panel.add(jSpinner);
        SpringUtilities.makeCompactGrid(panel, 1, 2, 5, 5, 5, 5);
        int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(baseLayerEditorPanel), panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.distance", new Serializable[0]), 0);
        if (d == 0) {
            double value;
            this.currentInitialValue = value = ((Double)jSpinner.getValue()).doubleValue();
            for (AreaObjectModel areaObject : areaObjects) {
                DefaultUnionAreaGenerator.INSTANCE.smoothAreaGeometry(areaObject, baseLayerEditorPanel.getModelEnviroment(), value);
            }
        }
    }

    @Override
    protected String getUndoMessage(Collection<AreaObjectModel> areaObject) {
        ArrayList<String> shortCuts = new ArrayList<String>(areaObject.size());
        for (AreaObjectModel areaObjectModel : areaObject) {
            shortCuts.add(areaObjectModel.getShortcut());
        }
        Collections.sort(shortCuts);
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.areas.addAreaActionSmooth.finished", new Serializable[]{StringUtil.implode(shortCuts, ", ")});
    }
}

