/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.smooth;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;

public abstract class AbstractAreaSmoothAction
extends AbstractAction {
    private static final long serialVersionUID = -3751543830271484968L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public AbstractAreaSmoothAction(String name, BaseLayerEditorPanel baseLayerEditorPanel) {
        super(name);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set<AreaObjectModel> selectedObjects = this.baseLayerEditorPanel.getSelectedObjects();
        if (selectedObjects != null && !selectedObjects.isEmpty()) {
            Map<AreaLayerModel, Set<AreaObjectModel>> objectMarkSetsHash = this.baseLayerEditorPanel.getObjectMarkSetsHash();
            HashSet<AreaObjectModel> bigSet = new HashSet<AreaObjectModel>();
            for (Set<AreaObjectModel> set : objectMarkSetsHash.values()) {
                bigSet.addAll(set);
            }
            ModelEnviroment modelEnviroment = this.baseLayerEditorPanel.getModelEnviroment();
            modelEnviroment.getUndoManager().startTransaction();
            try {
                this.doAction(selectedObjects, bigSet, this.baseLayerEditorPanel);
                modelEnviroment.getUndoManager().finishTransaction(this.getUndoMessage(selectedObjects));
            }
            catch (RuntimeException ex) {
                modelEnviroment.getUndoManager().rollbackTransaction();
                throw ex;
            }
        }
    }

    protected abstract void doAction(Collection<AreaObjectModel> var1, Set<AreaObjectModel> var2, BaseLayerEditorPanel var3);

    protected abstract String getUndoMessage(Collection<AreaObjectModel> var1);
}

