/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.print;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.gui.filter.area.AreaFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractLegendPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.print.FilterLegendPrintPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.OsmSvgExportFetcherMapTooLargeException;
import de.datomino.peppergis.client.gui.osm.OsmSvgExportFetcherServerTooBusyException;
import de.datomino.peppergis.client.model.area.AreaFilterPatternParameterModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternRelationAreaLayerRelationModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternRelationModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternSetupModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.print.AreaPrintOptionPane;
import de.datomino.peppergis.simplebasearea.action.print.AreaPrinterInformation;
import de.datomino.peppergis.simplebasearea.print.AreaPrinterImpl;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.swing.SwingUtils;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class PrintAreaObjectAction
extends AbstractAction {
    private static final long serialVersionUID = -506934411556687259L;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private AreaPrintOptionPane printOptionPane;

    public PrintAreaObjectAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage(baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.printAreas.order" : "messages.area.printAreas", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 512));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AreaPrinterInformation printInformation = this.getPrintInformation();
        if (printInformation != null) {
            PrinterInformation.PrintType printType = printInformation.getPrintType();
            AreaPrinterImpl areaPrinter = new AreaPrinterImpl(this.baseLayerEditorPanel);
            try {
                InputStream pdfInputStream = null;
                if (printType != null) {
                    switch (printType) {
                        case ONE_PAGE: {
                            pdfInputStream = areaPrinter.printSelectedAreaObjects(this.baseLayerEditorPanel.getNavigatorPanel(), this.baseLayerEditorPanel.getSelectedObjects(), printInformation, this.baseLayerEditorPanel.getEditBaseLayerRenderer());
                            break;
                        }
                        case MULTIPLE_PAGES: {
                            pdfInputStream = areaPrinter.printSelectedAreaObjectsInPages(this.baseLayerEditorPanel.getNavigatorPanel(), this.baseLayerEditorPanel.getSelectedObjects(), printInformation);
                            break;
                        }
                    }
                }
                if (pdfInputStream == null) {
                    JDialog.setDefaultLookAndFeelDecorated(true);
                    String key = this.baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.noAreasSelected.order" : "messages.area.noAreasSelected";
                    JOptionPane.showMessageDialog(this.baseLayerEditorPanel, ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                } else {
                    BaseLayerEditorPanel baseLEdPanel = this.baseLayerEditorPanel;
                    String selectedAreaObjects = StringUtil.implodeAndTruncate(baseLEdPanel.getSelectedObjects(), "_", 65, new NameGenerator<AreaObjectModel>(){

                        @Override
                        public String getName(AreaObjectModel t) {
                            return t.getShortcut();
                        }
                    });
                    PdfUtil.showPdf("Peppergis - Areas", pdfInputStream, ModelEnviroment.getProperties(), selectedAreaObjects + "_" + baseLEdPanel.getCurrentAreaLayer().getDisplayname(), true, true);
                }
            }
            catch (OsmSvgExportFetcherServerTooBusyException ex) {
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), ModelEnviroment.getMessageResolver().resolveMessage("messages.error.svgServerTooBusy", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
            }
            catch (OsmSvgExportFetcherMapTooLargeException ex) {
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), ModelEnviroment.getMessageResolver().resolveMessage("messages.error.svgMapTooLarge", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private AreaPrinterInformation getPrintInformation() {
        Map<PrintPropertyKey, Serializable> areaProperties = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties().getAreaProperties();
        boolean isPrintSpecialMessage = (Boolean)areaProperties.get(PrintParameterKey.SPECIAL_MESSAGE);
        boolean printStyleChoosable = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("area.printstyle.choosable"));
        if (this.printOptionPane == null) {
            this.printOptionPane = new AreaPrintOptionPane(this.baseLayerEditorPanel.getModelEnviroment(), isPrintSpecialMessage, printStyleChoosable, true, this.baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, "area");
        }
        AreaFilterPatternSetupRendererSelektor areaFilterPatternSetupRendererSelektor = this.baseLayerEditorPanel.getEditBaseLayerRenderer().getAreaFilterPatternSetupRendererSelektor();
        ModelFilterPatternSetup<AreaFilterPatternSetupModel, AreaFilterPatternRelationModel, AreaFilterPatternParameterModel, AreaFilterModel, AreaFilterPatternRelationAreaLayerRelationModel> modelFilterPatternSetup = null;
        if (areaFilterPatternSetupRendererSelektor != null) {
            modelFilterPatternSetup = areaFilterPatternSetupRendererSelektor.getModelFilterPatternSetup();
        }
        this.printOptionPane.setModelFilterPatternSetup(modelFilterPatternSetup);
        String title = ModelEnviroment.getMessageResolver().resolveMessage("gui.print.print", new Serializable[0]);
        Object[] items = new String[]{ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.onepage", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.multipage", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])};
        String defaultItem = ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.morepage", new Serializable[0]);
        Window window = SwingUtils.findWindowParent(this.baseLayerEditorPanel);
        int select = JOptionPane.showOptionDialog(window, this.printOptionPane, title, -1, 3, null, items, defaultItem);
        String specialMessageText = this.printOptionPane.getSpecialMessage();
        PrinterInformation.PrintType printType = null;
        switch (select) {
            case 0: {
                printType = PrinterInformation.PrintType.ONE_PAGE;
                break;
            }
            case 1: {
                printType = PrinterInformation.PrintType.MULTIPLE_PAGES;
                break;
            }
            default: {
                return null;
            }
        }
        List<Tupel<Image, String>> filters = null;
        if (this.printOptionPane.isPrintFilterLegend()) {
            FilterLegendPrintPane filterLegendPrintPane = new FilterLegendPrintPane(modelFilterPatternSetup, AbstractLegendPane.SymbolType.AREA, this.baseLayerEditorPanel.getModelEnviroment());
            int d = JOptionPane.showConfirmDialog(window, filterLegendPrintPane, ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.area.legend.print", new Serializable[0]), 1, 3);
            switch (d) {
                case 2: {
                    return this.getPrintInformation();
                }
                case 0: {
                    filters = filterLegendPrintPane.getSelectedFilters();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        Format format = this.printOptionPane.getFormat();
        PrintProperties printProperties = this.baseLayerEditorPanel.getModelEnviroment().getPrintProperties();
        Map<PrintPropertyKey, Serializable> properties = printProperties.getAreaProperties();
        String areaNameRenderingType = (String)((Object)properties.get(PrintParameterKey.INFO_PATTERN));
        if (printType == null) {
            return null;
        }
        return new AreaPrinterInformation(printType, format, true, specialMessageText, this.printOptionPane.getAreaNamePrintType(), areaNameRenderingType, printStyleChoosable ? this.printOptionPane.getSelectedStylePrefix() : null, this.printOptionPane.isOptimalZoom(), this.printOptionPane.getDpi(), this.printOptionPane.getScale(), this.printOptionPane.isVector(), this.printOptionPane.getXMargin().intValue(), this.printOptionPane.getYMargin().intValue(), this.printOptionPane.isFillUpSpace(), this.printOptionPane.getPrintFont(), this.printOptionPane.getPrintPlacesFont(), this.printOptionPane.getPrintStreetsFont(), this.printOptionPane.isUnderline(), this.printOptionPane.isWhiteBackgroundForScale(), filters, this.printOptionPane.getFooterFont(), this.printOptionPane.isIslandMode(), this.printOptionPane.isPrintAreaLegend());
    }
}

