/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.poi;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.search.PoiSearchDialog;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;

public class PoiSearchAction
extends AbstractAction {
    private static final long serialVersionUID = 9163280967670422169L;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private ModelEnviroment modelEnviroment;

    public PoiSearchAction(BaseLayerEditorPanel baseLayerEditorPanel, ModelEnviroment modelEnvironment) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.modelEnviroment = modelEnvironment;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PoiSearchDialog poiSearchDialog = new PoiSearchDialog(this.baseLayerEditorPanel.getParentWindow(), ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.search", new Serializable[0]), this.modelEnviroment, PoiSearchType.values(), true){
            private static final long serialVersionUID = -2159646626089136733L;

            @Override
            protected void doAfterOk() {
                ImmutablePoint geoLocation;
                LocationWrapper locationWrapper;
                super.doAfterOk();
                PoiModel poi = this.getSelectedPoiModel();
                if (poi != null && (locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(poi.getLocation())) != null && (geoLocation = locationWrapper.getGeoLocation()) != null) {
                    PoiSearchAction.this.baseLayerEditorPanel.getNavigatorPanel().center(geoLocation.getCoordinate());
                }
            }
        };
        poiSearchDialog.setVisible(true);
    }
}

