/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.pmd;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.pmd.UploadPmdReportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.exception.UploadPmdException;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class UploadPmdAction
extends AbstractAction {
    private static final long serialVersionUID = 2960315792231747503L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public UploadPmdAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.uploadAction", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AreaLayerModel targetLayer;
        if (this.checkSave(e) && (targetLayer = this.getTargetLayer()) != null) {
            Set<AreaObjectModel> selectedObjects = this.baseLayerEditorPanel.getSelectedObjects();
            try {
                UploadPmdReportDto uploadForPmd = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getExportCaller().uploadForPmd(selectedObjects, targetLayer);
                JComponent reportMessage = this.createReportMessage(uploadForPmd);
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), reportMessage, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.report", new Serializable[0]), 1);
                this.removeAreaObjects(selectedObjects);
            }
            catch (UploadPmdException ex) {
                String message = "";
                switch (ex.getType()) {
                    case INVALID_TARGET_LAYER: {
                        message = ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.invalidTargetLayer", new Serializable[]{StringUtil.nullToEmpty(ex.getTargetLayer())});
                        break;
                    }
                    case SHORTCUTS_IN_USE: {
                        message = ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.shortCutsInUse", new Serializable[]{StringUtil.implode(ex.getUsedShortcuts(), ", ")});
                        break;
                    }
                    case UNDEFINED: {
                        message = ex.getMessage();
                    }
                }
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), message, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            }
            catch (ClientExportException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private JComponent createReportMessage(UploadPmdReportDto uploadForPmd) {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table = new JTable(new ReportTableModel(uploadForPmd));
        table.getTableHeader().setReorderingAllowed(false);
        panel.add((Component)new JScrollPane(table), "Center");
        panel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.areasUploaded", Integer.valueOf(uploadForPmd.getResult().size()))), "North");
        return panel;
    }

    private void removeAreaObjects(Set<AreaObjectModel> selectedObjects) {
        ArrayList<Long> ids = new ArrayList<Long>(selectedObjects.size());
        for (AreaObjectModel areaObjectModel : selectedObjects) {
            ids.add(areaObjectModel.getId());
        }
        this.baseLayerEditorPanel.clearSelection();
        this.baseLayerEditorPanel.getEditBaseLayerRenderer().getBucketsModel().clear();
        this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjectsById(ids);
    }

    private AreaLayerModel getTargetLayer() {
        AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getExportCaller().getPmdUploadableAreaLayers(), false);
        int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), areaLayerComboBox, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.whichTargetlayer", new Serializable[0]), 0, 3);
        return d == 0 ? (AreaLayerModel)areaLayerComboBox.getSelectedItem() : null;
    }

    private boolean checkSave(ActionEvent e) {
        ModelEnviroment modelEnviroment = this.baseLayerEditorPanel.getModelEnviroment();
        boolean execute = true;
        if (modelEnviroment.getUndoManager().canUndo()) {
            int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.mustSave", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
            if (d == 0) {
                this.baseLayerEditorPanel.getSaveAction().actionPerformed(e);
            } else {
                execute = false;
            }
        }
        return execute;
    }

    private class ReportTableModel
    implements TableModel {
        private UploadPmdReportDto uploadPmdReportDto;

        public ReportTableModel(UploadPmdReportDto uploadForPmd) {
            this.uploadPmdReportDto = uploadForPmd;
        }

        @Override
        public int getRowCount() {
            return this.uploadPmdReportDto.getResult().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut.order", new Serializable[0]);
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.status", new Serializable[0]);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Tupel<AreaObjectDto, UploadPmdReportDto.ResultType> tupel = this.uploadPmdReportDto.getResult().get(rowIndex);
            AreaObjectModel areaObjectModel = (AreaObjectModel)UploadPmdAction.this.baseLayerEditorPanel.getModelEnviroment().getModelCache().getModel((Dto)tupel.getElement1(), false);
            switch (columnIndex) {
                case 0: {
                    return areaObjectModel.getShortcut();
                }
                case 1: {
                    switch (tupel.getElement2()) {
                        case OK: {
                            return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0]);
                        }
                        case SAVE_AREA_ALREADY_EXISTS: {
                            return ModelEnviroment.getMessageResolver().resolveMessage("messages.pmd.areaAlreadyExists", new Serializable[0]);
                        }
                        case SAVE_AREA_INVALID_GEOM: {
                            return ModelEnviroment.getMessageResolver().resolveMessage("messages.pmd.invalidGeom", new Serializable[0]);
                        }
                    }
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

