/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.parcel;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.model.parcel.ParcelLocationObject;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.parcel.AbstractParcelMovingAction;
import de.datomino.util.geo.swing.ObjectSelectionChangedEvent;
import de.datomino.util.geo.swing.ObjectSelectionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ktde.util.datatypes.Quad;

public class AddParcelsToAreaAction
extends AbstractParcelMovingAction {
    private static final long serialVersionUID = -3387001525338848984L;

    public AddParcelsToAreaAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(baseLayerEditorPanel, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.addParcelsToArea", new Serializable[0]));
        this.getBaseLayerEditorPanel().addObjectSelectionListener(new AreaSelectionListener());
        this.setEnabled(false);
    }

    @Override
    protected Quad<AreaLayerModel, AreaObjectModel, Set<ParcelModel>, Collection<AreaObjectModel>> moveParcels(Collection<ParcelLocationObject> markedObjects) {
        Set<AreaObjectModel> selectedObjects = this.getBaseLayerEditorPanel().getSelectedObjects();
        AreaObjectModel areaObjectModel = selectedObjects.iterator().next();
        AreaLayerModel areaLayer = areaObjectModel.getAreaLayer();
        HashSet<ParcelModel> parcels = new HashSet<ParcelModel>();
        HashSet<AreaObjectModel> areaObjectModels = new HashSet<AreaObjectModel>();
        for (ParcelLocationObject parcelLocationObject : markedObjects) {
            ParcelModel parcelModel = (ParcelModel)parcelLocationObject.getModel();
            boolean alreadySet = false;
            HashSet<AreaObjectParcelRelModel> toDelete = new HashSet<AreaObjectParcelRelModel>();
            for (AreaObjectParcelRelModel areaObjectParcelRelModel : parcelModel.iterableAreaObjectParcelRel()) {
                AreaObjectModel setAreaObject = areaObjectParcelRelModel.getAreaObject();
                if (setAreaObject == null) {
                    toDelete.add(areaObjectParcelRelModel);
                    continue;
                }
                if (!alreadySet && setAreaObject.equals(areaObjectModel)) {
                    alreadySet = true;
                    continue;
                }
                AreaLayerModel setLayer = setAreaObject.getAreaLayer();
                if (setLayer == null || !setLayer.equals(areaLayer)) continue;
                toDelete.add(areaObjectParcelRelModel);
            }
            if (!alreadySet) {
                AreaObjectParcelRelModelImpl areaObjectParcelRelModel = new AreaObjectParcelRelModelImpl();
                areaObjectParcelRelModel.setParcel(parcelModel);
                areaObjectParcelRelModel.setAreaObject(areaObjectModel);
                areaObjectModels.add(areaObjectModel);
            }
            for (AreaObjectParcelRelModel areaObjectParcelRelModel : toDelete) {
                areaObjectModels.add(areaObjectParcelRelModel.getAreaObject());
                areaObjectParcelRelModel.setAreaObject(null);
                areaObjectParcelRelModel.setParcel(null);
                areaObjectParcelRelModel.delete();
            }
            parcels.add(parcelModel);
        }
        return new Quad<AreaLayerModel, AreaObjectModel, Set<ParcelModel>, Collection<AreaObjectModel>>(areaLayer, areaObjectModel, parcels, areaObjectModels);
    }

    @Override
    protected String getFinishMessageKey() {
        return "messages.area.parcelsToAreaAdded";
    }

    private class AreaSelectionListener
    implements ObjectSelectionListener<AreaObjectModel> {
        private AreaSelectionListener() {
        }

        @Override
        public void selectionChanged(ObjectSelectionChangedEvent<AreaObjectModel> e) {
            Set<AreaObjectModel> newSelection = e.getNewSelection().getElement1();
            AddParcelsToAreaAction.this.setEnabled(newSelection != null && newSelection.size() == 1);
        }
    }
}

