/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.parcel;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class AddGeoParcelToAreaAction
extends AbstractAction {
    private static final long serialVersionUID = -1290989919610081652L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public AddGeoParcelToAreaAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.createParcelAreaRelationsForLayerByGeometryAction", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.createAreaRelByGeometry.keepSetParcelRelations", new Serializable[0]) + "?", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1, 3);
        if (d != 2) {
            boolean addRelOnlyIfNoExists = d == 0;
            ModelEnviroment modelEnviroment = this.baseLayerEditorPanel.getModelEnviroment();
            boolean transactionOpened = false;
            Set<AreaObjectModel> selectedObjects = this.baseLayerEditorPanel.getSelectedObjects();
            if (selectedObjects != null) {
                for (AreaObjectModel areaObjectModel : selectedObjects) {
                    ImmutablePolygonKind geom = areaObjectModel.getGeom();
                    if (geom == null) continue;
                    ImmutableEnvelope envelope = geom.getEnvelope();
                    Collection<ParcelModel> parcels = modelEnviroment.getAllCaller().getStreetNetCaller().fetchParcels(envelope.getTopLeft().getCoordinate(), envelope.getBottomRight().getCoordinate(), true);
                    for (ParcelModel parcel : parcels) {
                        ImmutablePoint pGeom = parcel.getGeom();
                        if (!geom.contains(pGeom) && !geom.crosses(pGeom)) continue;
                        transactionOpened |= this.addParcelToGeom(areaObjectModel, parcel, addRelOnlyIfNoExists, transactionOpened);
                    }
                }
            }
            if (transactionOpened) {
                modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.parcelsToAreaAdded", new Serializable[0]));
            }
        }
    }

    private boolean addParcelToGeom(AreaObjectModel areaObjectModel, ParcelModel parcel, boolean addRelOnlyIfNoExists, boolean transactionOpened) {
        AreaLayerModel layer = areaObjectModel.getAreaLayer();
        AreaObjectParcelRelModel setRel = null;
        for (AreaObjectParcelRelModel rel : parcel.iterableAreaObjectParcelRel()) {
            AreaLayerModel relLayer = rel.getAreaObject().getAreaLayer();
            if (relLayer == null || !relLayer.equals(layer)) continue;
            setRel = rel;
            break;
        }
        if (setRel == null) {
            if (!transactionOpened) {
                this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().startTransaction();
                transactionOpened = true;
            }
            setRel = new AreaObjectParcelRelModelImpl();
            setRel.setAreaObject(areaObjectModel);
            setRel.setParcel(parcel);
        } else if (!addRelOnlyIfNoExists) {
            if (!transactionOpened) {
                this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().startTransaction();
                transactionOpened = true;
            }
            setRel.setAreaObject(areaObjectModel);
            setRel.setParcel(parcel);
        }
        return transactionOpened;
    }
}

