/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.parcel;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.model.parcel.ParcelLocationObject;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.parcel.ConvexHullCalculation;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Quad;

public abstract class AbstractParcelMovingAction
extends AbstractAction {
    private static final long serialVersionUID = 1199787380042540310L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    protected AbstractParcelMovingAction(BaseLayerEditorPanel baseLayerEditorPanel, String actionName) {
        super(actionName);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    protected BaseLayerEditorPanel getBaseLayerEditorPanel() {
        return this.baseLayerEditorPanel;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        Collection<ParcelLocationObject> markedObjects = this.getBaseLayerEditorPanel().getParcelRenderer().getMarkedObjects();
        if (markedObjects != null && !markedObjects.isEmpty()) {
            this.getBaseLayerEditorPanel().getModelEnviroment().getUndoManager().startTransaction();
            Quad<AreaLayerModel, AreaObjectModel, Set<ParcelModel>, Collection<AreaObjectModel>> quad = this.moveParcels(markedObjects);
            boolean commit = this.moveSubscriptions(quad.getElement1(), quad.getElement2(), quad.getElement3());
            if (commit) {
                this.createAreaGeom(quad.getElement4());
                this.getBaseLayerEditorPanel().getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(this.getFinishMessageKey(), new Serializable[0]));
            } else {
                this.getBaseLayerEditorPanel().getModelEnviroment().getUndoManager().rollbackTransaction();
            }
        }
    }

    private void createAreaGeom(Collection<AreaObjectModel> areaObjects) {
        String ask = ModelEnviroment.getProperties().getProperty("area.moveParcel.askForGeom");
        if (StringUtil.isBlank(ask) || StringUtil.isTrue(ask)) {
            ConvexHullCalculation.calculateConvexHull(areaObjects, this.baseLayerEditorPanel);
        }
    }

    protected abstract Quad<AreaLayerModel, AreaObjectModel, Set<ParcelModel>, Collection<AreaObjectModel>> moveParcels(Collection<ParcelLocationObject> var1);

    protected abstract String getFinishMessageKey();

    protected boolean moveSubscriptions(AreaLayerModel areaLayer, AreaObjectModel areaObjectModel, Set<ParcelModel> parcels) {
        ArrayList<SubscriptionModel> subList = new ArrayList<SubscriptionModel>(this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getBaseCaller().fetchSubscriptionsByParcels(parcels, areaLayer));
        boolean commit = true;
        if (!subList.isEmpty()) {
            JPanel panel = new JPanel(new SpringLayout());
            ArrayList<JCheckBox> cbList = new ArrayList<JCheckBox>(subList.size());
            for (SubscriptionModel el : subList) {
                ParcelModel pm = el.getLocation().getParcel();
                StreetModel sm = pm.getStreet();
                PostcodeDistrictRelationModel postcodeDistrictRelation = sm.getPostcodeDistrictRelation();
                PostcodeModel postcode = postcodeDistrictRelation.getPostcode();
                DistrictModel district = postcodeDistrictRelation.getDistrict();
                CityModel city = district.getCity();
                Country country = postcode.getCountry();
                StringBuilder sb = new StringBuilder();
                sb.append(el.getSubscriptionNumber());
                sb.append(", ");
                sb.append(el.getCustomer().getCustomerNumber());
                sb.append(", ");
                sb.append(el.getCustomer().getName());
                sb.append(", ");
                sb.append(country.getVehicleSign());
                sb.append(" ");
                sb.append(postcode.getName());
                sb.append(" ");
                sb.append(city.getName());
                sb.append(" ");
                sb.append(district.getName());
                sb.append(" ");
                sb.append(sm.getName());
                sb.append(" ");
                sb.append(pm.getHouseNumber());
                sb.append(" ");
                sb.append(pm.getHouseNumberExtension());
                JCheckBox cb = new JCheckBox(sb.toString(), true);
                cbList.add(cb);
                panel.add(cb);
            }
            SpringUtilities.makeCompactGrid(panel, subList.size(), 1, 5, 5, 2, 2);
            JScrollPane scroll = new JScrollPane(panel);
            SwingUtils.setPreferredSizeToPercentageOfParent(scroll, SwingUtils.findInternalFrameParent(this.getBaseLayerEditorPanel()), null, 70.0);
            int option = JOptionPane.showConfirmDialog(this.getBaseLayerEditorPanel(), scroll, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.parcelsToArea.moveSubscriptions", new Serializable[0]), 1, 3);
            switch (option) {
                case 0: {
                    int index = 0;
                    for (JCheckBox el : cbList) {
                        if (el.isSelected()) {
                            ((SubscriptionModel)subList.get(index)).setAreaObject(areaObjectModel);
                        }
                        ++index;
                    }
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    commit = false;
                }
            }
        }
        return commit;
    }
}

