/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.mark;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;

public class RemoveHolesAction
extends AbstractAction {
    private static final long serialVersionUID = 2787681816661130806L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public RemoveHolesAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.removeHoles", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set<AreaObjectModel> selectedObjects = this.baseLayerEditorPanel.getSelectedObjects();
        if (selectedObjects != null && this.isAtLeastOneHoleExisting(selectedObjects)) {
            this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().startTransaction();
            for (AreaObjectModel selected : selectedObjects) {
                ImmutablePolygonKind geom = selected.getGeom();
                if (geom instanceof ImmutablePolygon) {
                    ImmutablePolygon p = (ImmutablePolygon)geom;
                    try {
                        ImmutablePolygon createImmutablePolygon = ImmutableGeoObjectFactory.createImmutablePolygon(p.getShell().getCoordinates());
                        selected.setGeom(createImmutablePolygon);
                        continue;
                    }
                    catch (IllegalPointCountException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (!(geom instanceof ImmutableMultiPolygon)) continue;
                ImmutableMultiPolygon pm = (ImmutableMultiPolygon)geom;
                ArrayList<ImmutablePolygon> multiPolygonParts = new ArrayList<ImmutablePolygon>();
                Iterator iterator = pm.getParts().iterator();
                while (iterator.hasNext()) {
                    ImmutablePolygon part;
                    ImmutablePolygon p = part = (ImmutablePolygon)iterator.next();
                    try {
                        ImmutablePolygon createImmutablePolygon = ImmutableGeoObjectFactory.createImmutablePolygon(p.getShell().getCoordinates());
                        multiPolygonParts.add(createImmutablePolygon);
                    }
                    catch (IllegalPointCountException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                ImmutableMultiPolygon createMultiPlygon = ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(pm.getCoordinateFactory(), multiPolygonParts);
                selected.setGeom(createMultiPlygon);
            }
            this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.removeHoles", new Serializable[0]));
        }
    }

    private boolean isAtLeastOneHoleExisting(Set<AreaObjectModel> selectedObjects) {
        for (AreaObjectModel selected : selectedObjects) {
            ImmutablePolygonKind geom = selected.getGeom();
            if (geom instanceof ImmutablePolygon) {
                ImmutablePolygon p = (ImmutablePolygon)geom;
                if (p.getHoles() == null || p.getHoles().isEmpty()) continue;
                return true;
            }
            if (!(geom instanceof ImmutableMultiPolygon)) continue;
            ImmutableMultiPolygon pm = (ImmutableMultiPolygon)geom;
            for (ImmutablePolygon part : pm.getParts()) {
                if (part.getHoles() == null || part.getHoles().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

