/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.mark;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.mark.MarkRadiusActionParameters;
import de.datomino.util.ValueChangeObservable;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.AbstractEnhancedMouseManipulatorAction;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.ToggleAction;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractMarkRadiusAction<T extends MarkRadiusActionParameters, S extends ValueChangeObservable>
extends AbstractEnhancedMouseManipulatorAction {
    private static final long serialVersionUID = -6682478040647819913L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public AbstractMarkRadiusAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(baseLayerEditorPanel.getNavigatorPanel(), null, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.action.createCoverFromRadiusAction", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        NavigatorPanningAction.performWheelZoom(e, this.getNavigatorPanel());
    }

    @Override
    protected void turnedOn() {
    }

    @Override
    protected void turnedOff() {
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseDragged(int x, int y) {
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        Point2D.Double real = this.baseLayerEditorPanel.getNavigatorPanel().getReal(x, y);
        List<? extends ToggleAction> chooseSourceBaseLayerActions = this.baseLayerEditorPanel.getChooseSourceBaseLayerActions();
        for (ToggleAction toggleAction : chooseSourceBaseLayerActions) {
            if (!toggleAction.isSelected() || !(toggleAction instanceof ObjectMarkerNavigatorRenderer)) continue;
            ObjectMarkerNavigatorRenderer objectMarkerNavigatorRenderer = (ObjectMarkerNavigatorRenderer)toggleAction;
            T t = this.getParameters();
            if (t == null) continue;
            GeoObjectBucketsModel bucketsModel = objectMarkerNavigatorRenderer.getBucketsModel();
            Coordinate center = this.baseLayerEditorPanel.getNavigatorPanel().getCoordinateFactory().createCoordinate(real);
            boolean fullCover = t.isFullCover();
            double step = 5000.0;
            Double counter = null;
            Collection satObjects = null;
            double maxRadius = t.getMaxRadius();
            boolean last = false;
            do {
                if ((counter = counter == null ? Double.valueOf(step) : Double.valueOf(counter + step)) >= maxRadius) {
                    counter = maxRadius;
                    last = true;
                }
                Collection objects = bucketsModel.findObjects(center, (double)counter, fullCover);
                Tupel found = this.cutIfStatisfies(objects);
                satObjects = found.getElement1();
                if (!found.getElement2().booleanValue()) continue;
                last = true;
            } while (!last);
            if (satObjects == null) continue;
            objectMarkerNavigatorRenderer.addMarkedObjects(satObjects, true);
        }
    }

    protected abstract Tupel<Collection<S>, Boolean> cutIfStatisfies(Collection<S> var1);

    protected abstract T getParameters();

    @Override
    protected void mouseMoved(int x, int y) {
    }

    protected BaseLayerEditorPanel getBaseLayerEditorPanel() {
        return this.baseLayerEditorPanel;
    }
}

