/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.cover;

import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.LocationObject;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;

public abstract class AbstractMarkCoveredPointAction<T extends LocationObject<?>>
extends AbstractAction {
    private static final long serialVersionUID = -4498254198528681515L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public AbstractMarkCoveredPointAction(BaseLayerEditorPanel baseLayerEditorPanel, String name) {
        super(name);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractFilterableMarkerNavigatorRenderer<?, T, ImmutablePoint, ?, ?, ?, ?> renderer = this.getRenderer();
        HashSet<AreaObjectModel> selectedObjects = new HashSet<AreaObjectModel>(this.baseLayerEditorPanel.getSelectedObjects());
        selectedObjects.addAll(this.baseLayerEditorPanel.getCoverHandler().getCurrentCoverage());
        HashSet markObjects = new HashSet();
        for (AreaObjectModel areaObjectModel : selectedObjects) {
            ImmutablePolygonKind geom = areaObjectModel.getGeom();
            if (geom == null) continue;
            Collection objects = renderer.getBucketsModel().findObjects(geom);
            markObjects.addAll(objects);
        }
        renderer.clearMarked();
        renderer.setMarkedObjects(markObjects);
        renderer.showMarked(markObjects);
    }

    protected BaseLayerEditorPanel getBaseLayerEditorPanel() {
        return this.baseLayerEditorPanel;
    }

    protected abstract AbstractFilterableMarkerNavigatorRenderer<?, T, ImmutablePoint, ?, ?, ?, ?> getRenderer();
}

