/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.clipboard;

import de.datomino.peppergis.client.dataflavor.ImmutableGeoObjectsDataFlavor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.dto.AbstractImmutableGeoObjectDto;
import de.datomino.util.geo.dto.ImmutablePolygonKindDto;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.NavigatorPanel;

public class InsertAreaAction
extends AbstractAction {
    private static final long serialVersionUID = 3616651307358372389L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public InsertAreaAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.paste", new Serializable[0]));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 128));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                Collection dtos = (Collection)clipboard.getData(ImmutableGeoObjectsDataFlavor.INSTANCE);
                ArrayList<ImmutablePolygonKind> polygons = new ArrayList<ImmutablePolygonKind>(dtos.size());
                for (AbstractImmutableGeoObjectDto dto : dtos) {
                    if (!(dto instanceof ImmutablePolygonKindDto)) continue;
                    ImmutablePolygonKindDto polygonDto = (ImmutablePolygonKindDto)dto;
                    polygons.add((ImmutablePolygonKind)polygonDto.getGeoObject());
                }
                this.baseLayerEditorPanel.addFreehandPolygons(polygons);
                Collection<Coordinate> coords = GeoUtils.getCoordinatesFromImmutableGeoObjects(polygons, OpenStreetmapViewFactory.INSTANCE);
                NavigatorPanel navigatorPanel = this.baseLayerEditorPanel.getNavigatorPanel();
                navigatorPanel.center(coords, 5);
                navigatorPanel.repaint(10L);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

