/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.clipboard;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.CreateAreaObjectAction;
import de.datomino.peppergis.simplebasearea.action.clipboard.AbstractAddClipboardSelectionAction;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AddClipboardSelectionFreehandAction
extends AbstractAddClipboardSelectionAction {
    private static final long serialVersionUID = -7563000145062225620L;

    public AddClipboardSelectionFreehandAction(BaseLayerEditorPanel parent) {
        super(parent);
    }

    @Override
    protected boolean paste(Component dialog, AreaLayerModel areaLayer, String text) {
        if (areaLayer != null && text != null) {
            BaseLayerEditorPanel parent = this.getParent();
            HashSet<ImmutablePolygonKind> areaObjects = new HashSet<ImmutablePolygonKind>();
            for (String s : text.split("\n")) {
                if (StringUtil.isBlank(s)) continue;
                AreaObjectModel area = parent.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObject(areaLayer, s);
                if (area == null) {
                    JOptionPane.showMessageDialog(dialog, ModelEnviroment.getMessageResolver().resolveMessage("messages.areas.notFound", new Serializable[0]) + " - " + s, ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 2);
                    return false;
                }
                ImmutablePolygonKind geom = area.getGeom();
                if (geom == null) continue;
                areaObjects.add(geom);
            }
            Tupel<String, String> names = CreateAreaObjectAction.getNames(parent, dialog, parent.getEditBaseLayer());
            if (names != null) {
                this.createAreaObject(names, areaObjects);
            } else {
                return false;
            }
        }
        return true;
    }

    private void createAreaObject(Tupel<String, String> names, Set<ImmutablePolygonKind> areaObjects) {
        BaseLayerEditorPanel baseLayerEditorPanel = this.getParent();
        UndoManager undoManager = baseLayerEditorPanel.getUndoManager();
        undoManager.startTransaction();
        String shortCut = names.getElement1();
        String displayName = names.getElement2();
        AreaObjectModel areaObject = CreateAreaObjectAction.createAreaObjectModel(shortCut, displayName, baseLayerEditorPanel.getCurrentAreaLayer());
        baseLayerEditorPanel.select((Collection<AreaObjectModel>)Collections.singleton(areaObject));
        ModelEnviroment modelEnviroment = baseLayerEditorPanel.getModelEnviroment();
        List<AreaObjectModel> emptyList = Collections.emptyList();
        modelEnviroment.getAllCaller().getAreaCaller().createAreaGeometryReplace(areaObject, emptyList, areaObjects, modelEnviroment);
        ((DefaultGeoObjectBucketsModel)baseLayerEditorPanel.getCurrentAreaRenderer().getBucketsModel()).addGeom(areaObject);
        baseLayerEditorPanel.updateSelectAreaObjectsInfo();
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaCreated", new Serializable[]{shortCut, displayName}));
    }
}

