/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action;

import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.LocationObject;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.KeyStroke;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.navigator.NavigatorPanel;

public class DefaultShowObjectLayerAction<M extends Model, S extends LocationObject<M>, T extends ImmutableGeoObject, U extends RendererProperties, V extends RendererProperties, W extends RendererProperties>
extends AbstractToggleAction {
    private static final long serialVersionUID = -3935100035812533948L;
    private NavigatorPanel navigatorPanel;
    private Collection<AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ?>> renderers;

    public DefaultShowObjectLayerAction(String layerName, NavigatorPanel navigatorPanel, AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ? extends Model> renderer) {
        this(layerName, navigatorPanel, renderer, null);
    }

    public DefaultShowObjectLayerAction(String layerName, NavigatorPanel navigatorPanel, AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ? extends Model> renderer, KeyStroke keyEvent) {
        super(layerName);
        ArrayList<AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, Model>> singleton = new ArrayList<AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, Model>>(1);
        singleton.add(renderer);
        this.init(navigatorPanel, singleton, keyEvent);
    }

    public DefaultShowObjectLayerAction(String layerName, NavigatorPanel navigatorPanel, Collection<AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ? extends Model>> renderers, KeyStroke keyEvent) {
        super(layerName);
        this.init(navigatorPanel, renderers, keyEvent);
    }

    private void init(NavigatorPanel navigatorPanel, Collection<AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ? extends Model>> renderers, KeyStroke keyEvent) {
        this.navigatorPanel = navigatorPanel;
        this.renderers = renderers;
        if (keyEvent != null) {
            this.putValue("AcceleratorKey", keyEvent);
        }
    }

    @Override
    public void turnOn() {
        this.navigatorPanel.removeMouseWheelListener(this.navigatorPanel.getPanningAction());
        for (AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ?> renderer : this.renderers) {
            renderer.setActive(true);
        }
        this.navigatorPanel.repaint(10L);
    }

    @Override
    public void turnOff() {
        for (AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ?> renderer : this.renderers) {
            renderer.setActive(false);
            renderer.turnOff();
        }
        this.navigatorPanel.repaint(10L);
        if (this.navigatorPanel.getMouseWheelListeners().length < 2) {
            this.navigatorPanel.addMouseWheelListener(this.navigatorPanel.getPanningAction());
        }
    }

    public Collection<AbstractFilterableMarkerNavigatorRenderer<M, S, T, U, V, W, ?>> getRenderers() {
        return this.renderers;
    }
}

