/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class CreateAreaObjectAction
extends AbstractAction {
    private static final long serialVersionUID = 3583960656979603477L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public CreateAreaObjectAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage(baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.new.order" : "messages.area.new", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 128));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Tupel<String, String> names = CreateAreaObjectAction.getNames(this.baseLayerEditorPanel, this.baseLayerEditorPanel, this.baseLayerEditorPanel.getEditBaseLayer());
        if (names != null) {
            UndoManager undoManager = this.baseLayerEditorPanel.getUndoManager();
            undoManager.startTransaction();
            String shortCut = names.getElement1();
            String displayName = names.getElement2();
            AreaObjectModel areaObject = CreateAreaObjectAction.createAreaObjectModel(shortCut, displayName, this.baseLayerEditorPanel.getEditBaseLayer());
            this.baseLayerEditorPanel.select((Collection<AreaObjectModel>)Collections.singleton(areaObject));
            this.baseLayerEditorPanel.replaceWithMarkSet(false);
            ((DefaultGeoObjectBucketsModel)this.baseLayerEditorPanel.getCurrentAreaRenderer().getBucketsModel()).addGeom(areaObject);
            String key = areaObject.getAreaLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.areaCreated.order" : "messages.area.areaCreated";
            Map<AreaLayerModel, Set<AreaObjectModel>> objectMarkSetsHash = this.baseLayerEditorPanel.getObjectMarkSetsHash();
            for (AreaLayerModel areaLayer : objectMarkSetsHash.keySet()) {
                AreaObjectGenInfoDiscriminator discriminator = areaLayer.getDiscriminator();
                if (discriminator != AreaObjectGenInfoDiscriminator.AREA_OBJECT_MACRO_CELL && discriminator != AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) continue;
                for (AreaObjectModel object : objectMarkSetsHash.get(areaLayer)) {
                    for (AreaObjectParcelRelModel rel : object.iterableAreaObjectParcelRel()) {
                        AreaObjectParcelRelModelImpl newRel = new AreaObjectParcelRelModelImpl();
                        newRel.setAreaObject(areaObject);
                        newRel.setParcel(rel.getParcel());
                    }
                }
            }
            this.baseLayerEditorPanel.updateSelectAreaObjectsInfo();
            undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[]{shortCut, displayName}));
            GeoObjectBucketsModel bucketsModel = this.baseLayerEditorPanel.getEditBaseLayerRenderer().getBucketsModel();
            bucketsModel.remove(areaObject);
            bucketsModel.addGeom(areaObject);
        }
    }

    public static AreaObjectModel createAreaObjectModel(String shortCut, String displayName, AreaLayerModel areaLayerModel) {
        AreaObjectModelImpl areaObject = new AreaObjectModelImpl();
        areaObject.setAreaLayer(areaLayerModel);
        areaObject.setShortcut(shortCut);
        areaObject.setDisplayname(displayName);
        return areaObject;
    }

    public static Tupel<String, String> getNames(BaseLayerEditorPanel baseLayerEditorPanel, Component parent, AreaLayerModel areaLayer) {
        int d;
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaKey", new Serializable[0])));
        final JTextField shortcutTextField = new JTextField(15);
        panel.add(shortcutTextField);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0])));
        JTextField displayNameTextField = new JTextField(15);
        panel.add(displayNameTextField);
        SpringUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 10, 2);
        do {
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    shortcutTextField.requestFocusInWindow();
                }
            });
            timer.setRepeats(false);
            timer.start();
            d = JOptionPane.showConfirmDialog(parent, panel, ModelEnviroment.getMessageResolver().resolveMessage(baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.new.order" : "messages.area.new", new Serializable[0]), 2, 3);
            if (d != 0) break;
            String areaKey = shortcutTextField.getText();
            if (StringUtil.isBlank(areaKey)) {
                JOptionPane.showMessageDialog(parent, "Schl\u00fcssel darf nicht leer sein");
                continue;
            }
            if ((areaKey = areaKey.trim()).matches(".*\\s.*") || areaKey.matches(".*%.*")) {
                JOptionPane.showMessageDialog(parent, "Schl\u00fcssel " + areaKey + " enth\u00e4lt ung\u00fcltige Zeichen");
                continue;
            }
            AreaObjectModel areaObjectCandidate = null;
            if (baseLayerEditorPanel != null) {
                Collection<AreaObjectModel> changedAreas = baseLayerEditorPanel.getModelEnviroment().getUndoManager().getChangedObjects(AreaObjectModel.class);
                for (AreaObjectModel changed : changedAreas) {
                    String shortcut;
                    if (changed.isDeleted() || !areaKey.equals(shortcut = changed.getShortcut())) continue;
                    areaObjectCandidate = changed;
                    break;
                }
            }
            if (areaObjectCandidate == null) {
                areaObjectCandidate = baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObject(baseLayerEditorPanel.getCurrentAreaLayer(), areaKey);
            }
            if (areaObjectCandidate != null) {
                JOptionPane.showMessageDialog(parent, "Schl\u00fcssel " + areaKey + " existiert bereits");
                continue;
            }
            return new Tupel<String, String>(areaKey, displayNameTextField.getText());
        } while (d == 0);
        return null;
    }
}

