/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea;

import de.datomino.peppergis.client.action.ChooseAreaObjectOnMapAction;
import de.datomino.peppergis.client.action.ChoosePoiOnMapAction;
import de.datomino.peppergis.client.action.SearchAreaAction;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.external.communication.ClientExternalRemoteService;
import de.datomino.peppergis.client.frey.CoordinateAndAreasDto;
import de.datomino.peppergis.client.frey.FreyHandler;
import de.datomino.peppergis.client.gui.AbstractAreaLayerEditorPanel;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.common.ActionComboBox;
import de.datomino.peppergis.client.gui.filter.area.AreaFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractLegendPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.AreaFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.LetterFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.ParcelFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.PoiFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.SubscriptionFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.letter.LetterFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.poi.PoiFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.gui.stop.StopFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.subscription.SubscriptionFilterableMarkerRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModelImpl;
import de.datomino.peppergis.client.model.area.AreaFilterPatternSetupModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.base.LetterFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternSetupModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.model.area.AreaObjectLoctionObject;
import de.datomino.peppergis.client.util.model.letter.LetterLocationObject;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.parcel.ParcelLocationObject;
import de.datomino.peppergis.client.util.model.poi.PoiLocationObject;
import de.datomino.peppergis.client.util.model.stop.StopLocationObject;
import de.datomino.peppergis.client.util.model.subscription.SubscriptionLocationObject;
import de.datomino.peppergis.client.util.wrapper.area.filter.AreaFilterPatternSetupModelWrapper;
import de.datomino.peppergis.client.util.wrapper.letter.filter.LetterFilterPatternSetupModelWrapper;
import de.datomino.peppergis.client.util.wrapper.parcel.filter.ParcelFilterPatternSetupModelWrapper;
import de.datomino.peppergis.client.util.wrapper.poi.filter.PoiFilterPatternSetupModelWrapper;
import de.datomino.peppergis.client.util.wrapper.subscription.filter.SubscriptionFilterPatternSetupModelWrapper;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorActions;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanelExternalMethodDelegate;
import de.datomino.peppergis.simplebasearea.ExternalBaseLayerMethods;
import de.datomino.peppergis.simplebasearea.action.CenterAreaObjectAction;
import de.datomino.peppergis.simplebasearea.action.CircleSearchingAction;
import de.datomino.peppergis.simplebasearea.action.CreateAreaObjectAction;
import de.datomino.peppergis.simplebasearea.action.DefaultShowObjectLayerAction;
import de.datomino.peppergis.simplebasearea.action.DeleteSelectedAreaAction;
import de.datomino.peppergis.simplebasearea.action.ShowAreaLayerAction;
import de.datomino.peppergis.simplebasearea.action.clipboard.AddClipboardSelectionAction;
import de.datomino.peppergis.simplebasearea.action.clipboard.AddClipboardSelectionFreehandAction;
import de.datomino.peppergis.simplebasearea.action.letter.LetterShowObjectLayerAction;
import de.datomino.peppergis.simplebasearea.action.poi.PoiSearchAction;
import de.datomino.peppergis.simplebasearea.action.print.PrintAreaObjectAction;
import de.datomino.peppergis.simplebasearea.action.print.PrintCurrentWindowAction;
import de.datomino.peppergis.simplebasearea.action.sourcearea.SourceAreaMarkerActionNavigatorRenderer;
import de.datomino.peppergis.simplebasearea.action.subscription.SubscriptionSearchAction;
import de.datomino.peppergis.simplebasearea.action.subscription.SubscriptionShowObjectLayerAction;
import de.datomino.peppergis.simplebasearea.cover.CoverHandler;
import de.datomino.peppergis.simplebasearea.cover.CoverHandlerImpl;
import de.datomino.peppergis.simplebasearea.gui.attribute.AreaAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.attribute.LetterAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.attribute.MicrocellAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.attribute.ParcelAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.attribute.SubscriptionAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.legend.BaseAreaAreaFilterPatternLegendDialog;
import de.datomino.peppergis.simplebasearea.gui.menu.BaseLayerEditorPanelMenuBar;
import de.datomino.peppergis.simplebasearea.helper.FreehandSelection;
import de.datomino.peppergis.simplebasearea.makrocell.MakrocellHandler;
import de.datomino.peppergis.simplebasearea.makrocell.MakrocellHandlerImpl;
import de.datomino.peppergis.simplebasearea.messaging.BaseLayerClientMessageHandler;
import de.datomino.peppergis.simplebasearea.microcell.MicrocellHandler;
import de.datomino.peppergis.simplebasearea.microcell.MicrocellHandlerImpl;
import de.datomino.peppergis.simplebasearea.util.LexicalAreaObjectModelComparator;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.model.time.TimeBasedBucketsFetchCallback;
import de.datomino.util.geo.model.time.TimeBasedGeoObjectBucketsModel;
import de.datomino.util.geo.swing.AbstractMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.DropMarkAction;
import de.datomino.util.geo.swing.FreeHandMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.ObjectMarkerSwitchModeAction;
import de.datomino.util.geo.swing.ObjectSelectionChangedEvent;
import de.datomino.util.geo.swing.ObjectSelectionListener;
import de.datomino.util.geo.swing.RulerRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.blocking.AbstractBusyHandlingAction;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.EmptyToggleAction;
import org.ktde.swing.ToggleAction;
import org.ktde.swing.ToggleGroup;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.ArrayHelper;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class BaseLayerEditorPanel
extends AbstractAreaLayerEditorPanel
implements BaseLayerEditorActions,
ExternalBaseLayerMethods,
InternalFrameListener {
    private static final long serialVersionUID = 3511677584453854792L;
    public static final double MAXUPP = 10.0;
    private AreaLayerModel editBaseLayer;
    private AreaLayerRenderer editBaseLayerRenderer;
    private boolean allowsSelection;
    private boolean allowsSegment;
    private boolean allowsFreehand;
    private boolean unmodifyable;
    private AreaLayerModel[] sourceBaseLayer;
    private List<AbstractMarkerNavigatorRenderer> markerActions;
    private List<AbstractMarkerNavigatorRenderer> pointMarkerActions;
    private ToggleAction markRectangleWithin;
    private ToggleAction markRectangleCrosses;
    private ToggleAction markCircleWithin;
    private ToggleAction markCircleCrosses;
    private ToggleAction markFreehandWithin;
    private ToggleAction markFreehandHalf;
    private ToggleAction markPointRectangleWithin;
    private ToggleAction markPointCircleWithin;
    private ToggleAction markPointFreehandWithin;
    private ToggleAction drawFreehand;
    private Action addMarkSetAction;
    private Action removeMarkSetAction;
    private Action replaceWithMarkSetAction;
    private Action dropMarkAction;
    private Action addMarkSetSmoothAction;
    private Action removeSmoothAction;
    private Action smoothAreaAction;
    private Action saveAction;
    private Action revertAction;
    private Action centerAreaObjectsAction;
    private Action printCurrentWindowAction;
    private Action printAreaObjectAction;
    private ToggleAction showParcelAction;
    private SubscriptionShowObjectLayerAction showSubscriptionAllAction;
    private SubscriptionShowObjectLayerAction showSubscriptionActiveAction;
    private SubscriptionShowObjectLayerAction showSubscriptionInactiveAction;
    private LetterShowObjectLayerAction letterShowObjectLayerAction;
    private ToggleAction showEditLayerAction;
    private AreaLayerRenderer currentAreaRenderer;
    private AreaLayerModel currentAreaLayer;
    private ChooseAreaObjectOnMapAction chooseAreaObjectOnMapAction;
    private Action searchAreaAction;
    private Action deleteCurrentAreaAction;
    private Map<AreaLayerModel, Set<AreaObjectModel>> objectMarkSetsHash;
    private Map<AreaLayerModel, SourceAreaMarkerActionNavigatorRenderer> areaObjectMarkers;
    private List<FreehandSelection> freehandSelection;
    private JTabbedPane sumPanel;
    private ExternalBaseLayerMethods externalBaseLayerMethods;
    private SubscriptionFilterableMarkerRenderer subscriptionForAllRenderer;
    private LetterFilterableMarkerRenderer letterFilterableMarkerRenderer;
    private PoiFilterableMarkerRenderer poiRenderer;
    private ChoosePoiOnMapAction showPoiAction;
    private Map<AreaLayerModel, BaseAreaAreaFilterPatternLegendDialog> areaFilterPatternLegendDialogs = new HashMap<AreaLayerModel, BaseAreaAreaFilterPatternLegendDialog>();
    private SubscriptionFilterPatternLegendDialog subscriptionFilterPatternLegendDialog;
    private LetterFilterPatternLegendDialog letterFilterPatternLegendDialog;
    private PoiFilterPatternLegendDialog poiFilterPatternLegendDialog;
    private ParcelFilterPatternLegendDialog parcelFilterPatternLegendDialog;
    private Set<AreaFilterModel> selectedFiltersList;
    private BaseLayerEditorPanelMenuBar baseLayerEditorPanelMenuBar;
    private EmptyToggleAction disableSourceLayers;
    private Map<AreaLayerModel, Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>> showLayerActions;
    private CreateAreaObjectAction createAreaObjectAction;
    private BusyHandler busyHandler;
    private Action circleSearchingAction;
    private Action subscriptionSearchAction;
    private Action poiSearchAction;
    private MicrocellAttributeValueSumPane microcellSumPane;
    private AreaAttributeValueSumPane areaSumPane;
    private ParcelAttributeValueSumPane parcelSumPane;
    private SubscriptionAttributeValueSumPane subscriptionSumPane;
    private LetterAttributeValueSumPane letterSumPane;
    private ParcelFilterableMarkerRenderer parcelObjectMarker;
    private Set<Long> areaObjectIdsNotToShow;
    private RulerRenderer rulerRenderer;
    private CoverHandler coverHandler;
    private ToggleAction showTodayStopAction;
    private ToggleAction showSomeDayStopAction;
    private ToggleAction showAllStopAction;
    private FreyHandler freyHandler;
    private MicrocellHandler microcellHandler;
    private MakrocellHandler makrocellHandler;
    private PausableInternalFrame internalFrame;

    public BaseLayerEditorPanel(Long editBaseLayerId) {
        this(editBaseLayerId, null, false, false, new Long[0]);
    }

    public BaseLayerEditorPanel(ModelEnviroment modelEnviroment, Long editBaseLayerId) {
        this(modelEnviroment, editBaseLayerId, null, new Long[0]);
    }

    public BaseLayerEditorPanel(Long editBaseLayerId, Set<Long> areaObjectIdsNotToShow, boolean centerShowingAreas, boolean markShowingAreas, Long ... sourceBaseLayer) {
        this(editBaseLayerId, null, areaObjectIdsNotToShow, centerShowingAreas, markShowingAreas, sourceBaseLayer);
    }

    public BaseLayerEditorPanel(Long editBaseLayerId, Set<Long> areaObjectIdsNotToShow, boolean centerShowingAreas, boolean markShowingAreas, PausableInternalFrame internalFrame, Long ... sourceBaseLayer) {
        this(editBaseLayerId, null, areaObjectIdsNotToShow, centerShowingAreas, markShowingAreas, sourceBaseLayer);
        this.internalFrame = internalFrame;
    }

    public BaseLayerEditorPanel(ModelEnviroment modelEnviroment, Long editBaseLayerId, String selectedObjectKey, Long ... sourceBaseLayer) {
        super(modelEnviroment);
        this.preInitialize(editBaseLayerId, selectedObjectKey, null, false, false, sourceBaseLayer);
    }

    public BaseLayerEditorPanel(Long editBaseLayerId, String selectedObjectKey, Set<Long> areaObjectIdsNotToShow, boolean centerShowingAreas, boolean markShowingAreas, Long ... sourceBaseLayer) {
        this.preInitialize(editBaseLayerId, selectedObjectKey, areaObjectIdsNotToShow, centerShowingAreas, markShowingAreas, sourceBaseLayer);
    }

    private void preInitialize(Long editBaseLayerId, String selectedObjectKey, Set<Long> areaObjectIdsNotToShow, boolean centerShowingAreas, boolean markShowingAreas, Long ... sourceBaseLayer) {
        this.currentAreaLayer = this.editBaseLayer = this.getModelEnviroment().getAllCaller().getAreaCaller().getAreaLayer(editBaseLayerId);
        AreaObjectGenInfoDiscriminator discriminator = this.editBaseLayer.getDiscriminator();
        this.allowsSegment = false;
        this.allowsFreehand = discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND || discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MACRO_CELL;
        this.allowsSelection = selectedObjectKey == null;
        this.unmodifyable = discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE || discriminator == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL;
        int i = 0;
        if (!ArrayHelper.isEmpty(sourceBaseLayer)) {
            this.sourceBaseLayer = new AreaLayerModel[sourceBaseLayer.length];
            i = 0;
            for (Long id : sourceBaseLayer) {
                this.sourceBaseLayer[i++] = this.getModelEnviroment().getAllCaller().getAreaCaller().getAreaLayer(id);
            }
        }
        this.objectMarkSetsHash = new LinkedHashMap<AreaLayerModel, Set<AreaObjectModel>>();
        this.areaObjectIdsNotToShow = areaObjectIdsNotToShow;
        this.selectedFiltersList = new HashSet<AreaFilterModel>();
        this.initialize(selectedObjectKey, centerShowingAreas, markShowingAreas);
    }

    public static GeomExtractor<AreaObjectModel, ImmutablePolygonKind> createAreaGeomExtractor() {
        return new GeomExtractor<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public ImmutablePolygonKind getGeom(AreaObjectModel object) {
                return object.getGeom();
            }
        };
    }

    public static GeomExtractor<AreaObjectLoctionObject, ImmutablePolygonKind> createAreaLocationGeomExtractor() {
        return new GeomExtractor<AreaObjectLoctionObject, ImmutablePolygonKind>(){

            @Override
            public ImmutablePolygonKind getGeom(AreaObjectLoctionObject object) {
                return ((AreaObjectModel)object.getModel()).getGeom();
            }
        };
    }

    public static GeomExtractor<SubscriptionLocationObject, ImmutablePoint> createSubscriptionGeomExtractor() {
        return new GeomExtractor<SubscriptionLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(SubscriptionLocationObject subscriptionModel) {
                return subscriptionModel.getImmutablePoint();
            }
        };
    }

    public static GeomExtractor<StopLocationObject, ImmutablePoint> createStopGeomExtractor() {
        return new GeomExtractor<StopLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(StopLocationObject stopModel) {
                return stopModel.getImmutablePoint();
            }
        };
    }

    public static GeomExtractor<PoiLocationObject, ImmutablePoint> createPoiGeomExtractor() {
        return new GeomExtractor<PoiLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(PoiLocationObject poiLocationObject) {
                return poiLocationObject.getImmutablePoint();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize(String selectedObjectKey, boolean centerShowingAreas, boolean markShowingAreas) {
        Tupel<ImmutablePoint, ImmutablePoint> tupel;
        ClientExternalRemoteService clientExternalRemoteService;
        super.initialize();
        this.markerActions = new LinkedList<AbstractMarkerNavigatorRenderer>();
        this.pointMarkerActions = new LinkedList<AbstractMarkerNavigatorRenderer>();
        NavigatorPanel navigator = this.getNavigatorPanel();
        LinkedList markSets = new LinkedList();
        this.initializeShowLayerActions(navigator);
        this.initializeCurrentAreaLayer(navigator);
        this.initializeSourceLayerActions(navigator, markSets);
        this.coverHandler = new CoverHandlerImpl(this, 2000);
        if (this.areaObjectMarkers != null) {
            for (ObjectMarkerNavigatorRenderer objectMarkerNavigatorRenderer : this.areaObjectMarkers.values()) {
                navigator.addRenderer(objectMarkerNavigatorRenderer);
            }
        }
        if (this.allowsFreehand) {
            this.initializeFreehandSelection(navigator, markSets);
        }
        this.initializeParcelLayer(navigator);
        this.initializeSubscriptionLayers(navigator);
        this.initializeLetterLayers(navigator);
        this.initializePoiLayer(navigator);
        this.initializeStopLayer(navigator);
        this.initializeToolActions(navigator);
        if (!this.unmodifyable) {
            this.dropMarkAction = new DropMarkAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.dropMark", new Serializable[0]), navigator, markSets){
                private static final long serialVersionUID = -4998359387591667436L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection<Collection<GeomAccess<?>>> markSets = this.getMarkSets();
                    HashSet flat = new HashSet();
                    for (Collection<? extends GeomAccess<?>> collection : markSets) {
                        flat.addAll(collection);
                    }
                    BaseLayerEditorPanel.this.getSelectedObjects().removeAll(flat);
                    super.actionPerformed(e);
                    BaseLayerEditorPanel.this.updateMarkSets();
                }
            };
        }
        this.initializeMarkActions();
        this.initializePointMarkActions();
        if (!this.unmodifyable) {
            this.addMarkSetAction = new AbstractBusyHandlingAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.addMarkSet", new Serializable[0]), this.busyHandler){
                private static final long serialVersionUID = -1262397541057151830L;

                @Override
                public void actionPerformedInternal(ActionEvent e) {
                    BaseLayerEditorPanel.this.addMarkSet();
                }
            };
            this.addMarkSetAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 128));
            this.replaceWithMarkSetAction = new AbstractBusyHandlingAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.replaceMarkSet", new Serializable[0]), this.busyHandler){
                private static final long serialVersionUID = 7447188509196977271L;

                @Override
                public void actionPerformedInternal(ActionEvent event) {
                    UndoManager undoManager = BaseLayerEditorPanel.this.getModelEnviroment().getUndoManager();
                    undoManager.startTransaction();
                    BaseLayerEditorPanel.this.replaceWithMarkSet(false);
                    String key = BaseLayerEditorPanel.this.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.areaChanged.order" : "messages.area.areaChanged";
                    undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
                }
            };
            this.replaceWithMarkSetAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 128));
            this.removeMarkSetAction = new AbstractBusyHandlingAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.removeMarkSet", new Serializable[0]), this.busyHandler){
                private static final long serialVersionUID = -3527211832331263246L;

                @Override
                public void actionPerformedInternal(ActionEvent e) {
                    BaseLayerEditorPanel.this.removeMarkSet();
                }
            };
            this.removeMarkSetAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 128));
        }
        this.searchAreaAction = new SearchAreaAction(this){
            private static final long serialVersionUID = -698058557798091581L;

            @Override
            protected void doSpecialActionsIfSearchSuccessFul(boolean polygonSelected, boolean parcelsSelected) {
                super.doSpecialActionsIfSearchSuccessFul(polygonSelected, parcelsSelected);
                if (parcelsSelected) {
                    BaseLayerEditorPanel.this.getParcelRenderer().setActive(true);
                }
            }
        };
        this.circleSearchingAction = new CircleSearchingAction(this, this.getParentWindow(), this.getModelEnviroment(), this.markerActions);
        this.subscriptionSearchAction = new SubscriptionSearchAction(this, this.getModelEnviroment());
        this.poiSearchAction = new PoiSearchAction(this, this.getModelEnviroment());
        if (!this.unmodifyable) {
            this.deleteCurrentAreaAction = new DeleteSelectedAreaAction(this);
        }
        this.saveAction = this.createSaveAction();
        this.saveAction.putValue("MnemonicKey", 83);
        this.saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        this.connectEnabledState(this.saveAction, this.getModelEnviroment().getUndoManager().getSaveAction());
        this.revertAction = this.getModelEnviroment().getUndoManager().getRevertAction();
        this.centerAreaObjectsAction = new CenterAreaObjectAction(this);
        this.printCurrentWindowAction = new PrintCurrentWindowAction(this);
        this.printAreaObjectAction = new PrintAreaObjectAction(this);
        if (!this.unmodifyable) {
            this.createAreaObjectAction = new CreateAreaObjectAction(this);
        }
        if ((clientExternalRemoteService = ClientExternalRemoteService.getInstance()) != null) {
            clientExternalRemoteService.addClientMessageHandler(new BaseLayerClientMessageHandler(this.getModelEnviroment().getAllCaller(), this));
        }
        this.addObjectSelectionListener(new AreaObjectSelectionListenerForEnabling());
        this.setEnablings(false);
        this.initializeSumPanel();
        this.externalBaseLayerMethods = new BaseLayerEditorPanelExternalMethodDelegate(this);
        this.showEditLayerAction.actionPerformed(null);
        if (!this.allowsSelection && selectedObjectKey != null) {
            void var7_10;
            this.getSelectedObjects().clear();
            AreaObjectModel areaObjectModel = this.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObject(this.editBaseLayer, selectedObjectKey);
            if (areaObjectModel == null) {
                AreaObjectModel areaObjectModel2 = this.createAreaObject(selectedObjectKey, selectedObjectKey);
            }
            if (var7_10 != null) {
                this.select((Collection<AreaObjectModel>)Collections.singleton(var7_10));
            }
        }
        this.getPanningAction().turnOn();
        if (centerShowingAreas && (tupel = this.getModelEnviroment().getAllCaller().getAreaCaller().getTopLeftAndBottomRightForLayer(this.editBaseLayer, this.areaObjectIdsNotToShow)) != null) {
            final ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(2);
            coordinates.add(tupel.getElement1().getCoordinate());
            coordinates.add(tupel.getElement2().getCoordinate());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseLayerEditorPanel.this.getNavigatorPanel().center(coordinates, 10);
                }
            });
        }
        if (markShowingAreas) {
            Collection<AreaObjectModel> collection = this.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjectsWithoutIds(this.editBaseLayer, null, null, this.areaObjectIdsNotToShow);
            this.select(collection);
        }
    }

    protected AbstractAction createSaveAction() {
        String freySpecialProposalTransmitProperty = ModelEnviroment.getProperties().getProperty("frey.proposallayer.id");
        Long freyProposalId = null;
        try {
            freyProposalId = Long.valueOf(freySpecialProposalTransmitProperty);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (freyProposalId != null && this.editBaseLayer.getId().equals(freyProposalId)) {
            return new AbstractAction("Speichern"){
                private static final long serialVersionUID = -118788712818452114L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection<String> areaKeys = BaseLayerEditorPanel.this.getAreaKeys();
                    String[] areaKeyArray = new String[areaKeys.size()];
                    areaKeyArray = areaKeys.toArray(areaKeyArray);
                    if (BaseLayerEditorPanel.this.freyHandler != null) {
                        Coordinate coordinate = BaseLayerEditorPanel.this.getSearchActionMenu().getCoordinate();
                        Double x = 0.0;
                        Double y = 0.0;
                        if (coordinate != null) {
                            coordinate = Wgs84Factory.INSTANCE.createCoordinate(coordinate);
                            x = coordinate.getX();
                            y = coordinate.getY();
                        }
                        CoordinateAndAreasDto coordinateAndAreasDto = new CoordinateAndAreasDto(x, y, areaKeyArray);
                        BaseLayerEditorPanel.this.freyHandler.sendProposalKeys(coordinateAndAreasDto);
                    }
                }
            };
        }
        return new AbstractBusyHandlingAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]), this.busyHandler){
            private static final long serialVersionUID = 1L;

            @Override
            protected void actionPerformedInternal(ActionEvent e) {
                BaseLayerEditorPanel.this.getModelEnviroment().getUndoManager().getSaveAction().actionPerformed(e);
            }
        };
    }

    private void initializeToolActions(NavigatorPanel navigator) {
        String rulerName = ModelEnviroment.getMessageResolver().resolveMessage("messages.area.ruler", new Serializable[0]);
        this.rulerRenderer = new RulerRenderer(navigator, rulerName, rulerName);
        this.rulerRenderer.turnOff();
        this.rulerRenderer.setSortOrder(10000);
        navigator.addRenderer(this.rulerRenderer);
        navigator.getToggleActions().addAction(this.rulerRenderer);
    }

    private void initializeStopLayer(NavigatorPanel navigator) {
        DefaultGeoObjectBucketsModel<StopLocationObject, ImmutablePoint> stopBucketsModel = new DefaultGeoObjectBucketsModel<StopLocationObject, ImmutablePoint>(navigator.getCoordinateFactory().getRefScale() * 5000.0, navigator.getCoordinateFactory(), BaseLayerEditorPanel.createStopGeomExtractor());
        stopBucketsModel.setFetchCallback(new BucketsFetchCallback<StopLocationObject, ImmutablePoint>(){

            @Override
            public Collection<StopLocationObject> fetch(Coordinate topLeft, Coordinate bottomRight) {
                ImmutablePoint topLeftPoint = ImmutableGeoObjectFactory.createImmutablePoint(topLeft);
                ImmutablePoint bottomRightPoint = ImmutableGeoObjectFactory.createImmutablePoint(bottomRight);
                List<StopModel> stops = BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getTourCaller().fetchStops(topLeftPoint, bottomRightPoint, true);
                ArrayList<StopLocationObject> objects = new ArrayList<StopLocationObject>(stops.size());
                for (StopModel stop : stops) {
                    LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation());
                    objects.add(new StopLocationObject(stop, locationWrapper.getGeoLocation()));
                }
                return objects;
            }
        });
        final Calendar startTime = Calendar.getInstance();
        startTime.set(11, 0);
        startTime.set(12, 0);
        startTime.set(13, 0);
        final Calendar endTime = Calendar.getInstance();
        endTime.set(11, 23);
        endTime.set(12, 59);
        endTime.set(13, 59);
        Double maxuppStop = null;
        try {
            maxuppStop = Double.valueOf(ModelEnviroment.getProperties().getProperty("maxupp.stop"));
        }
        catch (Exception e) {
            maxuppStop = 10.0;
        }
        StopFilterableMarkerRenderer allStopRenderer = new StopFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.STOPRENDERER.name() + "0", "", this, maxuppStop, stopBucketsModel);
        navigator.getToggleActions().addAction(allStopRenderer);
        allStopRenderer.setSortOrder(6010);
        navigator.addRenderer(allStopRenderer);
        this.showAllStopAction = new DefaultShowObjectLayerAction<StopModel, StopLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties>("Alle", this.navigator, allStopRenderer, KeyStroke.getKeyStroke(116, 0));
        StopFilterableMarkerRenderer todayStopRenderer = new StopFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.STOPRENDERER.name() + "1", "", this, maxuppStop, stopBucketsModel);
        todayStopRenderer.setStartTime(startTime.getTime());
        todayStopRenderer.setEndTime(endTime.getTime());
        navigator.getToggleActions().addAction(todayStopRenderer);
        todayStopRenderer.setSortOrder(6020);
        navigator.addRenderer(todayStopRenderer);
        this.showTodayStopAction = new DefaultShowObjectLayerAction<StopModel, StopLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties>("Heute", this.navigator, todayStopRenderer, KeyStroke.getKeyStroke(115, 0));
        final StopFilterableMarkerRenderer someDayStopRenderer = new StopFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.STOPRENDERER.name() + "2", "", this, maxuppStop, stopBucketsModel);
        navigator.getToggleActions().addAction(someDayStopRenderer);
        someDayStopRenderer.setSortOrder(6030);
        navigator.addRenderer(someDayStopRenderer);
        this.showSomeDayStopAction = new DefaultShowObjectLayerAction<StopModel, StopLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties>("Bestimmtes Zeitfenster", this.navigator, (AbstractFilterableMarkerNavigatorRenderer)someDayStopRenderer){
            private static final long serialVersionUID = 3770497302656799790L;

            @Override
            public void turnOn() {
                JSpinner startTimeSpinner = new JSpinner(new SpinnerDateModel(startTime.getTime(), null, null, 5));
                JSpinner.DateEditor startTimeEditor = new JSpinner.DateEditor(startTimeSpinner, FormUtil.TIMEFORMAT);
                startTimeSpinner.setEditor(startTimeEditor);
                JSpinner endTimeSpinner = new JSpinner(new SpinnerDateModel(endTime.getTime(), null, null, 5));
                JSpinner.DateEditor endTimeEditor = new JSpinner.DateEditor(endTimeSpinner, FormUtil.TIMEFORMAT);
                endTimeSpinner.setEditor(endTimeEditor);
                JPanel timeSettingPanel = new JPanel(new FlowLayout());
                timeSettingPanel.add(startTimeSpinner);
                timeSettingPanel.add(new JLabel(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " "));
                timeSettingPanel.add(endTimeSpinner);
                int d = JOptionPane.showConfirmDialog(BaseLayerEditorPanel.this, timeSettingPanel, "Eingabe des Zeitfensters", 0);
                switch (d) {
                    case 0: {
                        someDayStopRenderer.setStartTime((Date)startTimeSpinner.getValue());
                        someDayStopRenderer.setEndTime((Date)endTimeSpinner.getValue());
                    }
                }
                super.turnOn();
            }
        };
    }

    private void initializeCurrentAreaLayer(NavigatorPanel navigator) {
        DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(AreaLayerRenderer.getAreaLayerBucketSize(), navigator.getCoordinateFactory(), BaseLayerEditorPanel.createAreaGeomExtractor());
        bucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                AreaCaller areaCaller = BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getAreaCaller();
                Collection<AreaObjectModel> areaObjects = areaCaller.fetchAreaObjects(BaseLayerEditorPanel.this.editBaseLayer, topLeft, bottomRight);
                if (BaseLayerEditorPanel.this.areaObjectIdsNotToShow != null) {
                    LinkedList<AreaObjectModel> filteredAreaObjectModels = new LinkedList<AreaObjectModel>();
                    for (AreaObjectModel areaObject : areaObjects) {
                        if (BaseLayerEditorPanel.this.areaObjectIdsNotToShow.contains(areaObject.getId())) continue;
                        filteredAreaObjectModels.add(areaObject);
                    }
                    areaObjects = filteredAreaObjectModels;
                }
                return areaObjects;
            }
        });
        bucketsModel.setBusyHandler(this.busyHandler);
        String editRendererName = ModelEnviroment.getMessageResolver().resolveMessage("messages.renderer.editAreaLayer", new Serializable[]{this.editBaseLayer.getDisplayname()});
        final AreaLayerRenderer areaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer(editRendererName, bucketsModel, BaseLayerEditorPanel.createAreaGeomExtractor(), Long.toString(this.editBaseLayer.getId()), this.getModelEnviroment(), true, this.getNavigatorPanel());
        areaLayerRenderer.setBusyHandler(this.busyHandler);
        areaLayerRenderer.setSortOrder(1000);
        navigator.addRenderer(areaLayerRenderer);
        navigator.addMouseMotionListener(areaLayerRenderer);
        this.showEditLayerAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.editBaseLayer", new Serializable[]{this.editBaseLayer.getDisplayname()})){
            private static final long serialVersionUID = -3900857661261027324L;

            @Override
            public void turnOff() {
                BaseLayerEditorPanel.this.editBaseLayerRenderer.setActive(false);
                BaseLayerEditorPanel.this.editBaseLayerRenderer.removeAllowedAreaLayer(BaseLayerEditorPanel.this.currentAreaLayer);
                BaseLayerEditorPanel.this.select((Collection<AreaObjectModel>)null);
            }

            @Override
            public void turnOn() {
                BaseLayerEditorPanel.this.setCurrentAreaRenderer(areaLayerRenderer);
                BaseLayerEditorPanel.this.setCurrentAreaLayer(BaseLayerEditorPanel.this.editBaseLayer);
                BaseLayerEditorPanel.this.chooseAreaObjectOnMapAction.setAreaLayerRenderer(areaLayerRenderer);
                BaseLayerEditorPanel.this.editBaseLayerRenderer.addAllowedAreaLayer(BaseLayerEditorPanel.this.currentAreaLayer);
                BaseLayerEditorPanel.this.editBaseLayerRenderer.setActive(true);
            }
        };
        this.showEditLayerAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 128));
        this.editBaseLayerRenderer = areaLayerRenderer;
        this.chooseAreaObjectOnMapAction = new ChooseAreaObjectOnMapAction(this, navigator, this.editBaseLayerRenderer, this, this.getModelEnviroment(), this.editBaseLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.chooseArea.order" : "messages.area.chooseArea");
        navigator.getToggleActions().addAction(this.chooseAreaObjectOnMapAction);
    }

    protected Double getAreaLayerBucketSize(AreaLayerModel areaLayer, boolean currentLayer) {
        return AreaLayerRenderer.getAreaLayerBucketSize();
    }

    private void initializeSumPanel() {
        Component sumComponent = this.createSumPanel();
        this.setLeftComponent(sumComponent);
        this.setDividerSize(10);
        this.setOneTouchExpandable(true);
    }

    protected Component createSumPanel() {
        this.sumPanel = new JTabbedPane(1, 1);
        if (this.currentAreaLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) {
            this.microcellSumPane = new MicrocellAttributeValueSumPane(this);
            this.microcellSumPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.sumPanel.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.microcell", new Serializable[0]), this.microcellSumPane);
        } else {
            this.areaSumPane = new AreaAttributeValueSumPane(this);
            this.areaSumPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.sumPanel.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0]), this.areaSumPane);
        }
        this.parcelSumPane = new ParcelAttributeValueSumPane(this);
        this.parcelSumPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.sumPanel.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]), this.parcelSumPane);
        this.subscriptionSumPane = new SubscriptionAttributeValueSumPane(this);
        this.subscriptionSumPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.sumPanel.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]), this.subscriptionSumPane);
        this.letterSumPane = new LetterAttributeValueSumPane(this);
        this.letterSumPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.sumPanel.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]), this.letterSumPane);
        this.sumPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.overview", new Serializable[0])));
        return this.sumPanel;
    }

    private AreaObjectGenInfoDiscriminator[] filterDiscriminators() {
        boolean micro = this.getModelEnviroment().getAllCaller().getAreaCaller().isMicroCellAllowed();
        boolean macro = this.getModelEnviroment().getAllCaller().getAreaCaller().isMacroCellAllowed();
        AreaObjectGenInfoDiscriminator[] discriminator = AreaObjectGenInfoDiscriminator.values();
        AreaObjectGenInfoDiscriminator[] mDiscriminator = new AreaObjectGenInfoDiscriminator[discriminator.length - (micro ? 0 : 1) - (macro ? 0 : 1)];
        int i = 0;
        block4: for (AreaObjectGenInfoDiscriminator disc : discriminator) {
            switch (disc) {
                case AREA_OBJECT_MICRO_CELL: {
                    if (!micro) continue block4;
                    mDiscriminator[i++] = disc;
                    continue block4;
                }
                case AREA_OBJECT_MACRO_CELL: {
                    if (!macro) continue block4;
                    mDiscriminator[i++] = disc;
                    continue block4;
                }
                default: {
                    mDiscriminator[i++] = disc;
                }
            }
        }
        discriminator = mDiscriminator;
        return discriminator;
    }

    private void initializeShowLayerActions(NavigatorPanel navigator) {
        AreaObjectGenInfoDiscriminator[] discriminator = this.filterDiscriminators();
        Collection<AreaLayerModel> areaLayers = this.getModelEnviroment().getAllCaller().getAreaCaller().getAreaLayersForType(discriminator);
        this.showLayerActions = new LinkedHashMap<AreaLayerModel, Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>>();
        for (final AreaLayerModel areaLayerModel : areaLayers) {
            if (areaLayerModel.getId().equals(this.editBaseLayer.getId())) continue;
            DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> areaObjectBucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(AreaLayerRenderer.getAreaLayerBucketSize(), navigator.getCoordinateFactory(), BaseLayerEditorPanel.createAreaGeomExtractor());
            areaObjectBucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

                @Override
                public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                    return BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjects(areaLayerModel, topLeft, bottomRight);
                }
            });
            AreaLayerRenderer localAreaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("Showing area layer renderer for " + areaLayerModel.getDisplayname() + " (" + areaLayerModel.getId() + ")", areaObjectBucketsModel, BaseLayerEditorPanel.createAreaGeomExtractor(), areaLayerModel.getId().toString(), this.getModelEnviroment(), true, this.getNavigatorPanel());
            localAreaLayerRenderer.setBusyHandler(this.busyHandler);
            localAreaLayerRenderer.setActive(false);
            localAreaLayerRenderer.setSortOrder(2000);
            navigator.addRenderer(localAreaLayerRenderer);
            ShowAreaLayerAction showLayerAction = new ShowAreaLayerAction(areaLayerModel, localAreaLayerRenderer, this);
            this.showLayerActions.put(areaLayerModel, new Tripel<ShowAreaLayerAction, AreaLayerRenderer, DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>(showLayerAction, localAreaLayerRenderer, areaObjectBucketsModel));
        }
    }

    private void initializeSourceLayerActions(NavigatorPanel navigator, List<Collection<? extends GeomAccess<?>>> markSets) {
        this.areaObjectMarkers = new HashMap<AreaLayerModel, SourceAreaMarkerActionNavigatorRenderer>();
        if (this.sourceBaseLayer != null && this.sourceBaseLayer.length > 0) {
            for (final AreaLayerModel areaLayerModel : this.sourceBaseLayer) {
                AreaLayerRenderer areaLayerRenderer;
                GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> areaObjectBucketsModel;
                LinkedHashSet<AreaObjectModel> markSet;
                LinkedHashSet<AreaObjectModel> cMarkedSet = markSet = new LinkedHashSet<AreaObjectModel>();
                markSets.add(cMarkedSet);
                this.objectMarkSetsHash.put(areaLayerModel, markSet);
                Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>> tripel = this.showLayerActions.get(areaLayerModel);
                if (tripel == null) {
                    DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> defaultAreaObjectBucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(this.getAreaLayerBucketSize(areaLayerModel, false), navigator.getCoordinateFactory(), BaseLayerEditorPanel.createAreaGeomExtractor());
                    defaultAreaObjectBucketsModel.setBusyHandler(this.busyHandler);
                    defaultAreaObjectBucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

                        @Override
                        public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                            return BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjects(areaLayerModel, topLeft, bottomRight);
                        }
                    });
                    areaObjectBucketsModel = defaultAreaObjectBucketsModel;
                    areaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("Source layer renderer " + areaLayerModel.getDisplayname() + " (" + areaLayerModel.getId() + ")", areaObjectBucketsModel, BaseLayerEditorPanel.createAreaGeomExtractor(), Long.toString(areaLayerModel.getId()), this.getModelEnviroment(), true, this.getNavigatorPanel());
                    areaLayerRenderer.setBusyHandler(this.busyHandler);
                    areaLayerRenderer.setSortOrder(2000);
                    navigator.addRenderer(areaLayerRenderer);
                } else {
                    areaObjectBucketsModel = tripel.getElement3();
                    areaLayerRenderer = tripel.getElement2();
                }
                double upp = 257.0;
                try {
                    upp = Double.parseDouble(ModelEnviroment.getProperties().getProperty("area.marker.area.maxUpp"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SourceAreaMarkerActionNavigatorRenderer areaObjectMarker = new SourceAreaMarkerActionNavigatorRenderer("SourceLayerMarkerNavigatorRenderer", navigator, areaLayerRenderer, upp, areaLayerModel.getDisplayname() + " markieren", areaObjectBucketsModel, markSet, this, areaLayerModel);
                navigator.getToggleActions().addAction(areaObjectMarker);
                this.markerActions.add(areaObjectMarker);
                this.areaObjectMarkers.put(areaLayerModel, areaObjectMarker);
                if (tripel == null) continue;
                tripel.getElement1().addToggleAction(areaObjectMarker);
            }
            this.disableSourceLayers = new EmptyToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.disableSourceLayers", new Serializable[0]));
            navigator.getToggleActions().addAction(this.disableSourceLayers);
        }
    }

    private void initializeMarkActions() {
        if (!this.unmodifyable && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.DISPONENT_SUPER)) {
            if (this.allowsFreehand) {
                this.markFreehandWithin = new ObjectMarkerSwitchModeAction("Freihand", this.markerActions, MarkerMode.FREEHAND_WITHIN);
                this.markFreehandWithin.setEnabled(true);
                this.markFreehandHalf = new ObjectMarkerSwitchModeAction("Freihand mit Punkten", this.markerActions, MarkerMode.FREEHAND_HALF);
                this.markFreehandHalf.setEnabled(false);
                new ToggleGroup(this.markFreehandWithin, this.markFreehandHalf);
            } else {
                this.markRectangleWithin = new ObjectMarkerSwitchModeAction("Rechteck vollst\u00e4ndig", this.markerActions, MarkerMode.RECTANGLE_WITHIN);
                this.markRectangleWithin.setEnabled(false);
                this.markRectangleCrosses = new ObjectMarkerSwitchModeAction("Rechteck", this.markerActions, MarkerMode.RECTANGLE_CROSSES);
                this.markRectangleCrosses.setEnabled(false);
                this.markCircleWithin = new ObjectMarkerSwitchModeAction("Kreis vollst\u00e4ndig", this.markerActions, MarkerMode.CIRCLE_WITHIN);
                this.markCircleWithin.setEnabled(false);
                this.markCircleCrosses = new ObjectMarkerSwitchModeAction("Kreis", this.markerActions, MarkerMode.CIRCLE_CROSSES);
                this.markCircleCrosses.setEnabled(false);
                this.markFreehandWithin = new ObjectMarkerSwitchModeAction("Freihand vollst\u00e4ndig", this.markerActions, MarkerMode.FREEHAND_WITHIN);
                this.markFreehandWithin.setEnabled(false);
                this.markFreehandHalf = new ObjectMarkerSwitchModeAction("Freihand > 50%", this.markerActions, MarkerMode.FREEHAND_HALF);
                this.markFreehandHalf.setEnabled(false);
                new ToggleGroup(this.markRectangleWithin, this.markRectangleCrosses, this.markCircleWithin, this.markCircleCrosses, this.markFreehandWithin, this.markFreehandHalf);
                this.markRectangleWithin.setSelected(true);
            }
        }
    }

    private void initializePointMarkActions() {
        this.markPointRectangleWithin = new ObjectMarkerSwitchModeAction("Rechteck vollst\u00e4ndig", this.pointMarkerActions, MarkerMode.RECTANGLE_WITHIN);
        this.markPointCircleWithin = new ObjectMarkerSwitchModeAction("Kreis vollst\u00e4ndig", this.pointMarkerActions, MarkerMode.CIRCLE_WITHIN);
        this.markPointFreehandWithin = new ObjectMarkerSwitchModeAction("Freihand vollst\u00e4ndig", this.pointMarkerActions, MarkerMode.FREEHAND_WITHIN);
        new ToggleGroup(this.markPointRectangleWithin, this.markPointCircleWithin, this.markPointFreehandWithin);
        this.markPointRectangleWithin.setSelected(true);
    }

    private void initializeParcelLayer(NavigatorPanel navigator) {
        String bucketSizeString = ModelEnviroment.getProperties().getProperty("area.parcel.bucketsize");
        double bucketSize = 10000.0;
        try {
            bucketSize = Double.parseDouble(bucketSizeString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultGeoObjectBucketsModel<ParcelLocationObject, ImmutablePoint> parcelBucketsModel = new DefaultGeoObjectBucketsModel<ParcelLocationObject, ImmutablePoint>(navigator.getCoordinateFactory().getRefScale() * bucketSize, navigator.getCoordinateFactory(), new GeomExtractor<ParcelLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(ParcelLocationObject object) {
                return object.getImmutablePoint();
            }
        });
        parcelBucketsModel.setBusyHandler(this.busyHandler);
        parcelBucketsModel.setFetchCallback(new BucketsFetchCallback<ParcelLocationObject, ImmutablePoint>(){

            @Override
            public Collection<ParcelLocationObject> fetch(Coordinate topLeft, Coordinate bottomRight) {
                Collection<ParcelModel> parcels = BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getStreetNetCaller().fetchParcels(topLeft, bottomRight, true);
                HashSet<ParcelLocationObject> objects = new HashSet<ParcelLocationObject>(parcels.size());
                CollectionUtil.transform(parcels, objects, new Transformer<ParcelModel, ParcelLocationObject>(){

                    @Override
                    public ParcelLocationObject transform(ParcelModel t) {
                        ParcelLocationObject object = new ParcelLocationObject(t, t.getGeom());
                        return object;
                    }
                });
                return objects;
            }
        });
        Double maxuppParcel = null;
        try {
            maxuppParcel = Double.valueOf(ModelEnviroment.getProperties().getProperty("maxupp.parcel"));
        }
        catch (Exception e) {
            maxuppParcel = 10.0;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(123, 192);
        final ParcelFilterableMarkerRenderer parcelFromArea = new ParcelFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.PARCELAREARENDERER.name(), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.makrParcelsBySelectedArea", new Serializable[0]), this.navigator, maxuppParcel, parcelBucketsModel, this.editBaseLayer, false, keyStroke, this.getModelEnviroment()){
            private static final long serialVersionUID = 9219108129290167469L;

            @Override
            protected void turnedOn() {
                super.turnedOn();
                super.setActive(true);
                BaseLayerEditorPanel.this.parcelObjectMarker.turnOff();
                BaseLayerEditorPanel.this.parcelObjectMarker.setActive(false);
                BaseLayerEditorPanel.this.parcelObjectMarker.clearMarked();
                this.updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.PARCELRENDERER, Collections.EMPTY_SET);
            }

            @Override
            protected void markedObjectsChanged() {
                Collection found = BaseLayerEditorPanel.this.findParcelsFromAreaInActiveLayers(this.getMarkedObjects());
                super.setMarkedObjects(found);
                BaseLayerEditorPanel.this.parcelObjectMarker.setMarkedObjects(found);
            }

            @Override
            protected void updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType renderObjectType, Collection<ParcelModel> parcels) {
                BaseLayerEditorPanel.this.updatePanelAfterMark(renderObjectType, parcels);
            }

            @Override
            protected PausableInternalFrame getInternalFrame() {
                return BaseLayerEditorPanel.this.internalFrame;
            }
        };
        this.parcelObjectMarker = new ParcelFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.PARCELRENDERER.name(), this.getNavigatorPanel(), maxuppParcel, parcelBucketsModel, this.editBaseLayer, false, this.getModelEnviroment()){
            private static final long serialVersionUID = -2005622629860657261L;
            private boolean directTurnOn;
            private boolean directActive;
            {
                super(x0, x1, x2, x3, x4, x5, x6);
                this.directTurnOn = false;
                this.directActive = false;
            }

            @Override
            protected void turnedOn() {
                if (!this.directActive) {
                    this.directTurnOn = true;
                }
                super.turnedOn();
                if (this.directTurnOn) {
                    super.setActive(true);
                    super.clearMarked();
                    Set<ParcelModel> emptySet = Collections.emptySet();
                    this.updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.PARCELRENDERER, emptySet);
                }
                parcelFromArea.turnOff();
                parcelFromArea.setActive(false);
                parcelFromArea.clearMarked();
                this.directTurnOn = false;
            }

            @Override
            public void setActive(boolean active) {
                super.setActive(active);
                if (active && this.isSelected()) {
                    if (!this.directTurnOn) {
                        this.directActive = true;
                    }
                    if (this.directActive) {
                        this.turnOn();
                    }
                    this.directActive = false;
                }
            }

            @Override
            protected void updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType renderObjectType, Collection<ParcelModel> parcels) {
                BaseLayerEditorPanel.this.updatePanelAfterMark(renderObjectType, parcels);
            }

            @Override
            protected PausableInternalFrame getInternalFrame() {
                return BaseLayerEditorPanel.this.internalFrame;
            }
        };
        this.parcelObjectMarker.setBusyHandler(this.busyHandler);
        navigator.getToggleActions().addAction(this.parcelObjectMarker);
        this.pointMarkerActions.add(this.parcelObjectMarker);
        this.parcelObjectMarker.setSortOrder(3000);
        navigator.addRenderer(this.parcelObjectMarker);
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER, UserRole.AREA_ADMIN)) {
            parcelFromArea.setBusyHandler(this.busyHandler);
            navigator.getToggleActions().addAction(parcelFromArea);
            this.pointMarkerActions.add(parcelFromArea);
            parcelFromArea.setSortOrder(3010);
            navigator.addRenderer(parcelFromArea);
        }
        this.showParcelAction = new DefaultShowObjectLayerAction<ParcelModel, ParcelLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties>(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]), this.navigator, this.parcelObjectMarker, KeyStroke.getKeyStroke(122, 0));
    }

    private Collection<ParcelLocationObject> findParcelsFromAreaInActiveLayers(Collection<ParcelLocationObject> markedObjects) {
        if (markedObjects == null || markedObjects.isEmpty()) {
            return markedObjects;
        }
        Set<AreaLayerModel> activeLayers = CollectionUtil.buildHashSet(this.editBaseLayer);
        for (AreaLayerModel areaLayer : this.showLayerActions.keySet()) {
            ShowAreaLayerAction action = this.showLayerActions.get(areaLayer).getElement1();
            if (!action.isSelected()) continue;
            activeLayers.add(areaLayer);
        }
        HashSet<ParcelLocationObject> found = new HashSet<ParcelLocationObject>();
        HashSet<AreaObjectModel> areaObjects = new HashSet<AreaObjectModel>();
        for (ParcelLocationObject o : markedObjects) {
            ParcelModel parcel = (ParcelModel)o.getModel();
            for (AreaObjectParcelRelModel rel : parcel.iterableAreaObjectParcelRel()) {
                AreaObjectModel areaObject = rel.getAreaObject();
                if (areaObject == null || !activeLayers.contains(areaObject.getAreaLayer())) continue;
                areaObjects.add(areaObject);
            }
        }
        for (AreaObjectModel areaObject : areaObjects) {
            for (AreaObjectParcelRelModel rel : areaObject.iterableAreaObjectParcelRel()) {
                ParcelModel parcelInArea = rel.getParcel();
                found.add(new ParcelLocationObject(parcelInArea, parcelInArea.getGeom()));
            }
        }
        return found;
    }

    private void initializeSubscriptionLayers(NavigatorPanel navigator) {
        DefaultGeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint> subscriptionBucketsModel = new DefaultGeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint>(navigator.getCoordinateFactory().getRefScale() * 2000.0, navigator.getCoordinateFactory(), BaseLayerEditorPanel.createSubscriptionGeomExtractor()){

            @Override
            protected void handleUndelete(Object source) {
                if (source instanceof SubscriptionModel) {
                    SubscriptionModel subscription = (SubscriptionModel)source;
                    super.handleUndelete(new SubscriptionLocationObject(subscription, LocationWrapperFactory.INSTANCE.createLocationWrapper(subscription.getLocation()).getGeoLocation()));
                } else {
                    super.handleUndelete(source);
                }
            }
        };
        subscriptionBucketsModel.setBusyHandler(this.busyHandler);
        subscriptionBucketsModel.setFetchCallback(new BucketsFetchCallback<SubscriptionLocationObject, ImmutablePoint>(){

            @Override
            public Collection<SubscriptionLocationObject> fetch(Coordinate topLeft, Coordinate bottomRight) {
                return BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getSubscriptionCaller().fetchSubscriptionsInRectangleForLayer(topLeft, bottomRight, BaseLayerEditorPanel.this.editBaseLayer);
            }
        });
        this.initializeAllSubscriptionLayer(navigator, (GeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint>)subscriptionBucketsModel);
    }

    private void initializeLetterLayers(NavigatorPanel navigator) {
        TimeBasedGeoObjectBucketsModel<LetterLocationObject, ImmutablePoint> letterBucketsModel = new TimeBasedGeoObjectBucketsModel<LetterLocationObject, ImmutablePoint>(navigator.getCoordinateFactory().getRefScale() * 10000.0, navigator.getCoordinateFactory(), BaseLayerEditorPanel.createLetterGeomExtractor());
        letterBucketsModel.setFetchCallback(new TimeBasedBucketsFetchCallback<LetterLocationObject, ImmutablePoint>(){

            @Override
            public Collection<LetterLocationObject> fetch(Coordinate topLeft, Coordinate bottomRight, Date start, Date end) {
                return BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getLetterCaller().fetchLetterInRectangelForLayerAndDate(topLeft, bottomRight, start, end, BaseLayerEditorPanel.this.editBaseLayer);
            }
        });
        Double maxuppLetter = null;
        try {
            maxuppLetter = Double.valueOf(ModelEnviroment.getProperties().getProperty("maxupp.letter"));
        }
        catch (Exception e) {
            maxuppLetter = 10.0;
        }
        this.letterFilterableMarkerRenderer = new LetterFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.LETTERRENDERER.name(), "Briefe markieren", this, maxuppLetter, letterBucketsModel, this.editBaseLayer){
            private static final long serialVersionUID = -1736158446976963502L;

            @Override
            protected PausableInternalFrame getInternalFrame() {
                return BaseLayerEditorPanel.this.internalFrame;
            }
        };
        this.letterFilterableMarkerRenderer.setBusyHandler(this.busyHandler);
        this.letterFilterableMarkerRenderer.setActive(false);
        navigator.getToggleActions().addAction(this.letterFilterableMarkerRenderer);
        this.pointMarkerActions.add(this.letterFilterableMarkerRenderer);
        this.letterFilterableMarkerRenderer.setSortOrder(4000);
        navigator.addRenderer(this.letterFilterableMarkerRenderer);
        this.letterShowObjectLayerAction = new LetterShowObjectLayerAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.letters", new Serializable[0]), this.navigator, this.letterFilterableMarkerRenderer, KeyStroke.getKeyStroke(66, 128));
    }

    private static GeomExtractor<LetterLocationObject, ImmutablePoint> createLetterGeomExtractor() {
        return new GeomExtractor<LetterLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(LetterLocationObject object) {
                return object.getImmutablePoint();
            }
        };
    }

    private void initializeAllSubscriptionLayer(NavigatorPanel navigator, GeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint> subscriptionBucketsModel) {
        Double maxuppSubscription = null;
        try {
            maxuppSubscription = Double.valueOf(ModelEnviroment.getProperties().getProperty("maxupp.subscription"));
        }
        catch (Exception e) {
            maxuppSubscription = 10.0;
        }
        this.subscriptionForAllRenderer = new SubscriptionFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.SUBSCRIPTIONRENDERER.name(), "Abonnenten markieren", this, maxuppSubscription, subscriptionBucketsModel, this.editBaseLayer){
            private static final long serialVersionUID = 740307629168061670L;

            @Override
            protected PausableInternalFrame getInternalFrame() {
                return BaseLayerEditorPanel.this.internalFrame;
            }
        };
        this.subscriptionForAllRenderer.setBusyHandler(this.busyHandler);
        this.subscriptionForAllRenderer.setActive(false);
        AreaObjectGenInfoDiscriminator discriminator = this.getEditBaseLayer().getDiscriminator();
        switch (discriminator) {
            case AREA_OBJECT_GEN_AREA_OBJECT: {
                break;
            }
            case AREA_OBJECT_MICRO_CELL: 
            case AREA_OBJECT_MACRO_CELL: 
            case AREA_OBJECT_GEN_FREEHAND: 
            case AREA_OBJECT_GEN_UNMODIFYABLE: {
                navigator.getToggleActions().addAction(this.subscriptionForAllRenderer);
                this.pointMarkerActions.add(this.subscriptionForAllRenderer);
                this.subscriptionForAllRenderer.setSortOrder(5000);
                navigator.addRenderer(this.subscriptionForAllRenderer);
            }
        }
        this.showSubscriptionAllAction = new SubscriptionShowObjectLayerAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]), this.navigator, this.subscriptionForAllRenderer, KeyStroke.getKeyStroke(123, 0), SubscriptionFilterableMarkerRenderer.Mode.ALL);
        this.showSubscriptionInactiveAction = new SubscriptionShowObjectLayerAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions.inactive", new Serializable[0]), this.navigator, this.subscriptionForAllRenderer, KeyStroke.getKeyStroke(123, 128), SubscriptionFilterableMarkerRenderer.Mode.INACTIVE);
        this.showSubscriptionActiveAction = new SubscriptionShowObjectLayerAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions.active", new Serializable[0]), this.navigator, this.subscriptionForAllRenderer, KeyStroke.getKeyStroke(123, 512), SubscriptionFilterableMarkerRenderer.Mode.ACTIVE);
        this.showSubscriptionAllAction.setActions(Arrays.asList(this.showSubscriptionInactiveAction, this.showSubscriptionActiveAction));
        this.showSubscriptionInactiveAction.setActions(Arrays.asList(this.showSubscriptionAllAction, this.showSubscriptionActiveAction));
        this.showSubscriptionActiveAction.setActions(Arrays.asList(this.showSubscriptionAllAction, this.showSubscriptionInactiveAction));
    }

    private void initializePoiLayer(NavigatorPanel navigator) {
        String poibucketSize = ModelEnviroment.getProperties().getProperty("area.poi.bucketsize");
        double poibucketSizeValue = 100000.0;
        try {
            poibucketSizeValue = Double.parseDouble(poibucketSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultGeoObjectBucketsModel<PoiLocationObject, ImmutablePoint> poiBucketsModel = new DefaultGeoObjectBucketsModel<PoiLocationObject, ImmutablePoint>(navigator.getCoordinateFactory().getRefScale() * poibucketSizeValue, navigator.getCoordinateFactory(), BaseLayerEditorPanel.createPoiGeomExtractor());
        poiBucketsModel.setFetchCallback(new BucketsFetchCallback<PoiLocationObject, ImmutablePoint>(){

            @Override
            public Collection<PoiLocationObject> fetch(Coordinate topLeft, Coordinate bottomRight) {
                Collection<PoiModel> models = BaseLayerEditorPanel.this.getModelEnviroment().getAllCaller().getBaseCaller().fetchPoisInRectangle(topLeft, bottomRight);
                ArrayList<PoiLocationObject> pois = new ArrayList<PoiLocationObject>(models.size());
                for (PoiModel poiModel : models) {
                    pois.add(new PoiLocationObject(poiModel));
                }
                return pois;
            }
        });
        poiBucketsModel.setBusyHandler(this.busyHandler);
        this.poiRenderer = new PoiFilterableMarkerRenderer(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.POIRENDERER.name(), "", this, (Double)2048.0, poiBucketsModel, this.getModelEnviroment(), this.getEditBaseLayer());
        this.poiRenderer.setBusyHandler(this.busyHandler);
        navigator.getToggleActions().addAction(this.poiRenderer);
        this.poiRenderer.setSortOrder(6000);
        navigator.addRenderer(this.poiRenderer);
        this.showPoiAction = new ChoosePoiOnMapAction(this.navigator, poiBucketsModel, this.getModelEnviroment(), StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("poi.movable")) && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.DISPONENT_SUPER), this.poiRenderer){
            private static final long serialVersionUID = -6149715200897274495L;

            @Override
            protected void renderHover(Collection<PoiLocationObject> s) {
            }

            @Override
            protected Window getParent() {
                return BaseLayerEditorPanel.this.getParentWindow();
            }
        };
        navigator.addMouseListener(this.showPoiAction);
    }

    private void initializeFreehandSelection(NavigatorPanel navigator, List<Collection<? extends GeomAccess<?>>> markSets) {
        this.freehandSelection = new LinkedList<FreehandSelection>();
        markSets.add(this.freehandSelection);
        double maxUpp = 33.0;
        String maxUppString = ModelEnviroment.getProperties().getProperty("area.freehandmarker.maxUpp");
        try {
            maxUpp = Double.parseDouble(maxUppString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Float clickedWidthFactor = null;
        try {
            clickedWidthFactor = Float.valueOf(ModelEnviroment.getProperties().getProperty("area.freehand.marker.clicked.width"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Float draggedWidthFactor = null;
        try {
            draggedWidthFactor = Float.valueOf(ModelEnviroment.getProperties().getProperty("area.freehand.marker.dragged.width"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FreeHandMarkerNavigatorRenderer<FreehandSelection> polygonMarkerNavigatorRenderer = new FreeHandMarkerNavigatorRenderer<FreehandSelection>(ModelEnviroment.getMessageResolver().resolveMessage("messages.renderers.freehandmarker.name", new Serializable[0]), navigator, Double.valueOf(maxUpp), "Polygone zeichnen", this.freehandSelection, draggedWidthFactor, clickedWidthFactor){
            private static final long serialVersionUID = 71396080800724877L;

            @Override
            protected FreehandSelection createT(ImmutablePolygonKind polygon) {
                return new FreehandSelection(polygon);
            }

            @Override
            public String getName() {
                return "FreeHandMarkerNavigatorRenderer";
            }
        };
        polygonMarkerNavigatorRenderer.putValue("AcceleratorKey", KeyStroke.getKeyStroke(117, 0));
        navigator.getToggleActions().addAction(polygonMarkerNavigatorRenderer);
        this.markerActions.add(polygonMarkerNavigatorRenderer);
        polygonMarkerNavigatorRenderer.setSortOrder(1010);
        this.getNavigatorPanel().addRenderer(polygonMarkerNavigatorRenderer);
    }

    public void replaceWithMarkSet(boolean startTransaction) {
        for (AreaObjectModel singleSelectedObject : this.currentAreaRenderer.getCurrentAreaObjects()) {
            if (startTransaction) {
                this.getModelEnviroment().getUndoManager().startTransaction();
            }
            try {
                List<ImmutablePolygonKind> freeHands = this.getFreehandPolygons();
                this.getModelEnviroment().getAllCaller().getAreaCaller().createAreaGeometryReplace(singleSelectedObject, CollectionUtil.flatCollection(this.objectMarkSetsHash.values(), true), freeHands, this.getModelEnviroment());
                DefaultGeoObjectBucketsModel bucketsModel = (DefaultGeoObjectBucketsModel)this.getCurrentAreaRenderer().getBucketsModel();
                bucketsModel.addGeom(singleSelectedObject);
                this.updateSelectAreaObjectsInfo();
            }
            catch (RuntimeException e) {
                this.showException(e);
                if (!startTransaction) continue;
                this.getModelEnviroment().getUndoManager().rollbackTransaction();
            }
        }
    }

    protected void removeMarkSet() {
        for (AreaObjectModel singleSelectedObject : this.currentAreaRenderer.getCurrentAreaObjects()) {
            this.getModelEnviroment().getUndoManager().startTransaction();
            try {
                List<ImmutablePolygonKind> freeHands = this.getFreehandPolygons();
                this.getModelEnviroment().getAllCaller().getAreaCaller().createAreaGeometryRemove(singleSelectedObject, CollectionUtil.flatCollection(this.objectMarkSetsHash.values(), true), freeHands, this.getModelEnviroment());
                DefaultGeoObjectBucketsModel bucketsModel = (DefaultGeoObjectBucketsModel)this.getCurrentAreaRenderer().getBucketsModel();
                bucketsModel.addGeom(singleSelectedObject);
                String key = this.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.areaChanged.order" : "messages.area.areaChanged";
                this.getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
                this.updateSelectAreaObjectsInfo();
            }
            catch (RuntimeException e) {
                this.showException(e);
                this.getModelEnviroment().getUndoManager().rollbackTransaction();
            }
        }
    }

    private List<ImmutablePolygonKind> getFreehandPolygons() {
        ArrayList<ImmutablePolygonKind> freeHands = null;
        if (this.freehandSelection != null) {
            freeHands = new ArrayList<ImmutablePolygonKind>(this.freehandSelection.size());
            for (FreehandSelection freehandSelection : this.freehandSelection) {
                freeHands.add(freehandSelection.getGeom());
            }
        }
        return freeHands;
    }

    public void addFreehandPolygons(Collection<ImmutablePolygonKind> polygons) {
        if (polygons != null && this.freehandSelection != null) {
            for (ImmutablePolygonKind polygon : polygons) {
                this.freehandSelection.add(new FreehandSelection(polygon));
            }
        }
        this.repaint(10L);
    }

    public void addMarkSet() {
        for (AreaObjectModel singleSelectedObject : this.currentAreaRenderer.getCurrentAreaObjects()) {
            this.getModelEnviroment().getUndoManager().startTransaction();
            try {
                List<ImmutablePolygonKind> freeHands = this.getFreehandPolygons();
                this.getModelEnviroment().getAllCaller().getAreaCaller().createAreaGeometryAdd(singleSelectedObject, CollectionUtil.flatCollection(this.objectMarkSetsHash.values(), true), freeHands, this.getModelEnviroment());
                DefaultGeoObjectBucketsModel bucketsModel = (DefaultGeoObjectBucketsModel)this.getCurrentAreaRenderer().getBucketsModel();
                bucketsModel.addGeom(singleSelectedObject);
                String key = this.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.areaChanged.order" : "messages.area.areaChanged";
                this.getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
                this.updateSelectAreaObjectsInfo();
            }
            catch (RuntimeException e) {
                this.showException(e);
                this.getModelEnviroment().getUndoManager().rollbackTransaction();
            }
        }
    }

    private void connectEnabledState(final Action action, final Action wrappedAction) {
        wrappedAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                action.setEnabled(wrappedAction.isEnabled());
            }
        });
        action.setEnabled(wrappedAction.isEnabled());
    }

    protected AreaObjectModel createAreaObject(String displayname, String key) {
        this.getModelEnviroment().getUndoManager().startTransaction();
        AreaObjectModelImpl model = new AreaObjectModelImpl();
        model.setAreaLayer(this.getCurrentAreaLayer());
        model.setShortcut(key);
        model.setDisplayname(displayname);
        this.getModelEnviroment().getUndoManager().finishTransaction("created object " + displayname);
        ((DefaultGeoObjectBucketsModel)this.getCurrentAreaRenderer().getBucketsModel()).addGeom(model);
        return model;
    }

    @Override
    public Action getSaveAction() {
        return this.saveAction;
    }

    @Override
    public Action getRevertAction() {
        return this.revertAction;
    }

    @Override
    public Action getAddMarkSetAction() {
        return this.addMarkSetAction;
    }

    @Override
    public Action getRemoveMarkSetAction() {
        return this.removeMarkSetAction;
    }

    @Override
    public Action getReplaceWithMarkSetAction() {
        return this.replaceWithMarkSetAction;
    }

    @Override
    public ToggleAction getSetMarkModeCircleCrossesAction() {
        return this.markCircleCrosses;
    }

    @Override
    public ToggleAction getSetMarkModeCircleWithinAction() {
        return this.markCircleWithin;
    }

    @Override
    public ToggleAction getSetMarkModeRectangleCrossesAction() {
        return this.markRectangleCrosses;
    }

    @Override
    public ToggleAction getSetMarkModeRectangleWithinAction() {
        return this.markRectangleWithin;
    }

    @Override
    public ToggleAction getSetMarkModeFreehandWithinAction() {
        return this.markFreehandWithin;
    }

    @Override
    public ToggleAction getSetMarkModeFreehandHalfAction() {
        return this.markFreehandHalf;
    }

    public ToggleAction getSetPointMarkModeCircleWithinAction() {
        return this.markPointCircleWithin;
    }

    public ToggleAction getSetPointMarkModeRectangleWithinAction() {
        return this.markPointRectangleWithin;
    }

    public ToggleAction getSetPointMarkModeFreehandWithinAction() {
        return this.markPointFreehandWithin;
    }

    @Override
    public Action getDropMarkAction() {
        return this.dropMarkAction;
    }

    public ChooseAreaObjectOnMapAction getChooseAreaOnMapAction() {
        return this.chooseAreaObjectOnMapAction;
    }

    @Override
    public List<? extends ToggleAction> getChooseSourceBaseLayerActions() {
        return this.markerActions;
    }

    public List<? extends ToggleAction> getPointMarkerActions() {
        return this.pointMarkerActions;
    }

    public Action getCreateNewAreaAction() {
        return this.createAreaObjectAction;
    }

    public Action getDeleteCurrentAreaAction() {
        return this.deleteCurrentAreaAction;
    }

    public void setMarkedObjects(Collection<AreaObjectModel> objects) {
        for (Map.Entry<AreaLayerModel, Set<AreaObjectModel>> entry : this.objectMarkSetsHash.entrySet()) {
            Set<AreaObjectModel> objectMarkSet = entry.getValue();
            objectMarkSet.clear();
        }
        if (objects != null) {
            for (AreaObjectModel areaObjectModel : objects) {
                AreaLayerModel layer = areaObjectModel.getAreaLayer();
                Set<AreaObjectModel> objectMarkSet = this.objectMarkSetsHash.get(layer);
                if (objectMarkSet == null) continue;
                objectMarkSet.add(areaObjectModel);
            }
        }
        this.navigator.repaint(10L);
    }

    public void updateMarkSets() {
        HashSet<AreaObjectModel> set = new HashSet<AreaObjectModel>();
        for (Map.Entry<AreaLayerModel, Set<AreaObjectModel>> entry : this.objectMarkSetsHash.entrySet()) {
            Set<AreaObjectModel> value = entry.getValue();
            set.addAll(value);
        }
        this.updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.AREAOBJECTRENDERER, set);
    }

    @Override
    public void updatePanelAfterMark(AbstractFilterableMarkerNavigatorRenderer.RenderObjectType name, Collection<? extends Model> marked) {
        super.updatePanelAfterMark(name, marked);
        switch (name) {
            case AREAOBJECTRENDERER: {
                if (this.currentAreaRenderer.isActive()) {
                    if (this.currentAreaLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) {
                        this.sumPanel.setSelectedComponent(this.microcellSumPane);
                        this.microcellSumPane.loadSpecialValues(marked);
                    } else {
                        this.sumPanel.setSelectedComponent(this.areaSumPane);
                        this.areaSumPane.loadSpecialValues(marked);
                        this.updateSelectAreaObjectsInfo();
                    }
                } else {
                    if (this.currentAreaLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) {
                        this.microcellSumPane.loadSpecialValues(null);
                    }
                    this.areaSumPane.loadSpecialValues(null);
                }
                Tupel areaObjectsForLegend = this.getAreaObjectsForLegend();
                super.fireObjectSelectionChanged(new ObjectSelectionChangedEvent<AreaObjectModel>(this, null, areaObjectsForLegend));
                break;
            }
            case PARCELRENDERER: {
                this.sumPanel.setSelectedComponent(this.parcelSumPane);
                this.parcelSumPane.loadValues((Collection<ParcelModel>)marked);
                break;
            }
            case SUBSCRIPTIONRENDERER: {
                this.sumPanel.setSelectedComponent(this.subscriptionSumPane);
                this.subscriptionSumPane.loadValues((Collection<SubscriptionModel>)marked);
                break;
            }
            case LETTERRENDERER: {
                this.sumPanel.setSelectedComponent(this.letterSumPane);
                this.letterSumPane.loadValues((Collection<LetterModel>)marked);
                break;
            }
        }
    }

    @Override
    public ToggleAction getFreehandDrawMode() {
        return this.drawFreehand;
    }

    public void setCurrentAreaLayer(AreaLayerModel currentAreaLayer) {
        this.currentAreaLayer = currentAreaLayer;
    }

    @Override
    public AreaLayerModel getCurrentAreaLayer() {
        return this.currentAreaLayer;
    }

    public void setCurrentAreaRenderer(AreaLayerRenderer currentAreaRenderer) {
        this.currentAreaRenderer = currentAreaRenderer;
    }

    public AreaLayerRenderer getCurrentAreaRenderer() {
        return this.currentAreaRenderer;
    }

    @Override
    public Action getSearchAreaAction() {
        return this.searchAreaAction;
    }

    @Override
    public Action getCenterSelectedAreaObjectsAction() {
        return this.centerAreaObjectsAction;
    }

    @Override
    public Action getPrintCurrentWindowAction() {
        return this.printCurrentWindowAction;
    }

    @Override
    public Action getPrintAreaObjectsAction() {
        return this.printAreaObjectAction;
    }

    private void setEnablings(boolean areaEdit) {
        if (this.addMarkSetAction != null) {
            this.addMarkSetAction.setEnabled(areaEdit);
        }
        if (this.removeMarkSetAction != null) {
            this.removeMarkSetAction.setEnabled(areaEdit);
        }
        if (this.replaceWithMarkSetAction != null) {
            this.replaceWithMarkSetAction.setEnabled(areaEdit);
        }
        if (this.markCircleCrosses != null) {
            this.markCircleCrosses.setEnabled(areaEdit);
        }
        if (this.markCircleWithin != null) {
            this.markCircleWithin.setEnabled(areaEdit);
        }
        if (this.markFreehandHalf != null) {
            this.markFreehandHalf.setEnabled(areaEdit);
        }
        if (this.markFreehandWithin != null) {
            this.markFreehandWithin.setEnabled(areaEdit);
        }
        if (this.markRectangleCrosses != null) {
            this.markRectangleCrosses.setEnabled(areaEdit);
        }
        if (this.markRectangleWithin != null) {
            this.markRectangleWithin.setEnabled(areaEdit);
        }
        if (this.addMarkSetSmoothAction != null) {
            this.addMarkSetSmoothAction.setEnabled(areaEdit);
        }
        if (this.removeSmoothAction != null) {
            this.removeSmoothAction.setEnabled(areaEdit);
        }
        if (this.smoothAreaAction != null) {
            this.smoothAreaAction.setEnabled(areaEdit);
        }
        if (this.deleteCurrentAreaAction != null) {
            this.deleteCurrentAreaAction.setEnabled(areaEdit);
        }
    }

    public JToolBar createJToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.extendToolBar(jToolBar);
        return jToolBar;
    }

    public void extendToolBar(JToolBar toolBar) {
        boolean editable;
        boolean bl = editable = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER) || ModelEnviroment.getUserInformation().getAttachedIdsForUserRole(UserRole.AREA_EDITOR).contains(this.getEditBaseLayer().getId());
        if (editable) {
            toolBar.add(new JButton(this.getSaveAction()));
            toolBar.add(new JButton(this.getRevertAction()));
            toolBar.add(new JButton(this.getUndoAction()));
            toolBar.add(new JButton(this.getRedoAction()));
            toolBar.add(new JToggleButton(this.getPanningAction()));
            toolBar.add(new JButton(this.getSearchActionButton()));
            toolBar.add(new JButton(this.getCreateNewAreaAction()));
            toolBar.add(new JButton(this.getDeleteCurrentAreaAction()));
            ToggleAction markAction = this.getSetMarkModeRectangleCrossesAction();
            if (markAction != null) {
                toolBar.add(new JToggleButton(markAction));
            }
            if ((markAction = this.getSetMarkModeRectangleWithinAction()) != null) {
                toolBar.add(new JToggleButton(markAction));
            }
            if ((markAction = this.getSetMarkModeCircleCrossesAction()) != null) {
                toolBar.add(new JToggleButton(markAction));
            }
            if ((markAction = this.getSetMarkModeCircleWithinAction()) != null) {
                toolBar.add(new JToggleButton(markAction));
            }
            if ((markAction = this.getSetMarkModeFreehandWithinAction()) != null) {
                toolBar.add(new JToggleButton(markAction));
            }
            if ((markAction = this.getSetMarkModeFreehandHalfAction()) != null) {
                toolBar.add(new JToggleButton(markAction));
            }
            toolBar.add(new JButton(this.getAddMarkSetAction()));
            toolBar.add(new JButton(this.getRemoveMarkSetAction()));
            toolBar.add(new JButton(this.getReplaceWithMarkSetAction()));
            toolBar.add(new JButton(this.getDropMarkAction()));
        }
        toolBar.add(new JToggleButton(this.getChooseEditLayerAction()));
        if (editable) {
            if (this.sourceBaseLayer != null && this.sourceBaseLayer.length > 0) {
                LinkedList<? extends ToggleAction> sourceActions = new LinkedList<ToggleAction>();
                EmptyToggleAction emptyToggleAction = this.getDisableSourceLayers();
                sourceActions.add(emptyToggleAction);
                sourceActions.addAll(this.getChooseSourceBaseLayerActions());
                ActionComboBox sourceActionComboBox = new ActionComboBox(sourceActions, false);
                sourceActionComboBox.setSpecialRenderName(emptyToggleAction, " ");
                toolBar.add(sourceActionComboBox);
            } else {
                for (ToggleAction toggleAction : this.getChooseSourceBaseLayerActions()) {
                    toolBar.add(new JToggleButton(toggleAction));
                }
            }
        }
        toolBar.add(new JButton(this.getSearchAreaAction()));
        toolBar.add(new JButton(this.getCenterSelectedAreaObjectsAction()));
        toolBar.add(new JButton(this.getPrintCurrentWindowAction()));
        toolBar.add(new JButton(this.getPrintAreaObjectsAction()));
        toolBar.add(new JToggleButton(this.getShowParcelAction()));
        toolBar.add(new JToggleButton(this.getShowSubscriptionAction()));
        toolBar.add(new JToggleButton(this.getShowActiveSubscriptionAction()));
        toolBar.add(new JToggleButton(this.getShowInactiveSubscriptionAction()));
        toolBar.add(new JToggleButton(this.getShowAllStopAction()));
        toolBar.add(new JToggleButton(this.getShowPoiAction()));
    }

    @Override
    public void selectAreas(Collection<String> areaKeys) {
        this.externalBaseLayerMethods.selectAreas(areaKeys);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.externalBaseLayerMethods.mouseWheelMoved(e);
    }

    @Override
    public void mouseWheelMoved(int x, int y, int count) {
        this.externalBaseLayerMethods.mouseWheelMoved(x, y, count);
    }

    @Override
    public Collection<String> getAreaKeys() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (AreaObjectModel areaObjectModel : this.getSelectedObjects()) {
            AreaObjectGenAreaObjectModel areaObjectGenAreaObject;
            AreaObjectGenInfoModel genInfo = areaObjectModel.getGenInfo();
            if (genInfo == null || (areaObjectGenAreaObject = genInfo.getAreaObjectGenAreaObject()) == null) continue;
            for (AreaObjectGenAreaObjectRelModel subobject : areaObjectGenAreaObject.iterableAreaObjects()) {
                result.add(subobject.getAreaObject().getShortcut());
            }
        }
        return result;
    }

    @Override
    public ToggleAction getShowParcelAction() {
        return this.showParcelAction;
    }

    public LetterShowObjectLayerAction getShowLetterAction() {
        return this.letterShowObjectLayerAction;
    }

    @Override
    public ToggleAction getShowSubscriptionAction() {
        return this.showSubscriptionAllAction;
    }

    public ToggleAction getShowActiveSubscriptionAction() {
        return this.showSubscriptionActiveAction;
    }

    public ToggleAction getShowInactiveSubscriptionAction() {
        return this.showSubscriptionInactiveAction;
    }

    @Override
    public ChoosePoiOnMapAction getShowPoiAction() {
        return this.showPoiAction;
    }

    @Override
    public ToggleAction getShowAllStopAction() {
        return this.showAllStopAction;
    }

    public ToggleAction getShowTodayStopAction() {
        return this.showTodayStopAction;
    }

    public void setAreaFilterPatternRendererSetup(AreaFilterPatternSetupModel areaFilterPatternSetupModel, AreaLayerModel areaLayerModel) {
        if (this.editBaseLayer.getId().equals(areaLayerModel.getId())) {
            AreaFilterPatternSetupRendererSelektor areaFilterPatternSetupRendererSelektor = this.editBaseLayerRenderer.setAreaFilterPatternSetupModel(areaFilterPatternSetupModel, this.getModelEnviroment());
            this.chooseAreaObjectOnMapAction.setRendererChecker(areaFilterPatternSetupRendererSelektor);
        } else {
            Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>> tripel = this.showLayerActions.get(areaLayerModel);
            if (tripel != null) {
                ObjectMarkerNavigatorRenderer objectMarkerNavigatorRenderer;
                AreaFilterPatternSetupRendererSelektor areaFilterPatternSetupRendererSelektor = tripel.getElement2().setAreaFilterPatternSetupModel(areaFilterPatternSetupModel, this.getModelEnviroment());
                if (this.areaObjectMarkers != null && (objectMarkerNavigatorRenderer = (ObjectMarkerNavigatorRenderer)this.areaObjectMarkers.get(areaLayerModel)) != null) {
                    objectMarkerNavigatorRenderer.setRendererChecker(areaFilterPatternSetupRendererSelektor);
                }
            }
        }
        AreaFilterPatternLegendDialog areaFilterPatternLegendDialog = this.createIfNullAreaFilterPatternLegendDialog(areaLayerModel);
        areaFilterPatternLegendDialog.setFilterPatternSetup(areaFilterPatternSetupModel == null ? null : new AreaFilterPatternSetupModelWrapper(areaFilterPatternSetupModel), AbstractLegendPane.SymbolType.AREA, this.getModelEnviroment());
        areaFilterPatternLegendDialog.setVisible(true);
    }

    public BaseLayerEditorPanelMenuBar getMenuBar() {
        if (this.baseLayerEditorPanelMenuBar == null) {
            this.baseLayerEditorPanelMenuBar = new BaseLayerEditorPanelMenuBar(this);
        }
        return this.baseLayerEditorPanelMenuBar;
    }

    public PausableInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    public AreaLayerModel getEditBaseLayer() {
        return this.editBaseLayer;
    }

    public void setSubscriptionFilterPatternRendererSetup(SubscriptionFilterPatternSetupModel subscriptionFilterPatternSetupModel) {
        this.subscriptionForAllRenderer.setSubscriptionFilterPatternSetupModel(subscriptionFilterPatternSetupModel, this.getModelEnviroment());
        if (subscriptionFilterPatternSetupModel != null) {
            SubscriptionFilterPatternLegendDialog subscriptionFilterPatternLegendDialog = this.createIfNullSubscriptionFilterPatternLegendDialog();
            subscriptionFilterPatternLegendDialog.setFilterPatternSetup(new SubscriptionFilterPatternSetupModelWrapper(subscriptionFilterPatternSetupModel), AbstractLegendPane.SymbolType.POINT, this.getModelEnviroment());
            subscriptionFilterPatternLegendDialog.setVisible(true);
        }
    }

    public void setLetterFilterPatternRendererSetup(LetterFilterPatternSetupModel letterFilterPatternSetupModel) {
        this.letterFilterableMarkerRenderer.setLetterFilterPatternSetupModel(letterFilterPatternSetupModel, this.getModelEnviroment());
        if (letterFilterPatternSetupModel != null) {
            LetterFilterPatternLegendDialog letterFilterPatternLegendDialog = this.createIfNullLetterFilterPatternLegendDialog();
            letterFilterPatternLegendDialog.setFilterPatternSetup(new LetterFilterPatternSetupModelWrapper(letterFilterPatternSetupModel), AbstractLegendPane.SymbolType.POINT, this.getModelEnviroment());
            letterFilterPatternLegendDialog.setVisible(true);
        }
    }

    public void setPoiFilterPatternRendererSetup(PoiFilterPatternSetupModel poiFilterPatternSetupModel) {
        this.poiRenderer.setPoiFilterPatternSetup(poiFilterPatternSetupModel, this.getModelEnviroment());
        if (poiFilterPatternSetupModel != null) {
            PoiFilterPatternLegendDialog poiFilterPatternLegendDialog = this.createIfNullPoiFilterPatternLegendDialog();
            poiFilterPatternLegendDialog.setFilterPatternSetup(poiFilterPatternSetupModel == null ? null : new PoiFilterPatternSetupModelWrapper(poiFilterPatternSetupModel), AbstractLegendPane.SymbolType.POINT, this.getModelEnviroment());
            poiFilterPatternLegendDialog.setVisible(true);
        }
    }

    public void setParcelFilterPatternRendererSetup(ParcelFilterPatternSetupModel parcelFilterPatternSetupModel) {
        this.parcelObjectMarker.setParcelFilterPatternSetup(parcelFilterPatternSetupModel, this.getModelEnviroment());
        if (parcelFilterPatternSetupModel != null) {
            ParcelFilterPatternLegendDialog parcelFilterPatternLegendDialog = this.createIfNullParcelFilterPatternLegendDialog();
            parcelFilterPatternLegendDialog.setFilterPatternSetup(parcelFilterPatternSetupModel == null ? null : new ParcelFilterPatternSetupModelWrapper(parcelFilterPatternSetupModel), AbstractLegendPane.SymbolType.POINT, this.getModelEnviroment());
            parcelFilterPatternLegendDialog.setVisible(true);
        }
    }

    public AreaFilterPatternLegendDialog getAreaFilterPatternLegendDialog(AreaLayerModel areaLayerModel) {
        return this.areaFilterPatternLegendDialogs.get(areaLayerModel);
    }

    public AreaFilterPatternLegendDialog createIfNullAreaFilterPatternLegendDialog(AreaLayerModel areaLayerModel) {
        BaseAreaAreaFilterPatternLegendDialog areaFilterPatternLegendDialog = this.areaFilterPatternLegendDialogs.get(areaLayerModel);
        if (areaFilterPatternLegendDialog == null) {
            areaFilterPatternLegendDialog = new BaseAreaAreaFilterPatternLegendDialog(this, areaLayerModel);
            this.areaFilterPatternLegendDialogs.put(areaLayerModel, areaFilterPatternLegendDialog);
        }
        return this.getAreaFilterPatternLegendDialog(areaLayerModel);
    }

    public SubscriptionFilterPatternLegendDialog getSubscriptionFilterPatternLegendDialog() {
        return this.subscriptionFilterPatternLegendDialog;
    }

    public SubscriptionFilterPatternLegendDialog createIfNullSubscriptionFilterPatternLegendDialog() {
        if (this.subscriptionFilterPatternLegendDialog == null) {
            this.subscriptionFilterPatternLegendDialog = new SubscriptionFilterPatternLegendDialog(this.getParentWindow(), this.getEditBaseLayer().getDisplayname(), SwingUtils.findInternalFrameParent(this));
            this.subscriptionFilterPatternLegendDialog.addPatternLegendSelectionListener(this.subscriptionForAllRenderer);
            this.subscriptionFilterPatternLegendDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    BaseLayerEditorPanel.this.getMenuBar().subscriptionFilterLegendDialogClosing();
                    BaseLayerEditorPanel.this.subscriptionFilterPatternLegendDialog = null;
                }
            });
        }
        return this.getSubscriptionFilterPatternLegendDialog();
    }

    public LetterFilterPatternLegendDialog getLetterFilterPatternLegendDialog() {
        return this.letterFilterPatternLegendDialog;
    }

    public LetterFilterPatternLegendDialog createIfNullLetterFilterPatternLegendDialog() {
        if (this.letterFilterPatternLegendDialog == null) {
            this.letterFilterPatternLegendDialog = new LetterFilterPatternLegendDialog(this.getParentWindow(), this.getEditBaseLayer().getDisplayname(), SwingUtils.findInternalFrameParent(this));
            this.letterFilterPatternLegendDialog.addPatternLegendSelectionListener(this.letterFilterableMarkerRenderer);
            this.letterFilterPatternLegendDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    BaseLayerEditorPanel.this.getMenuBar().subscriptionFilterLegendDialogClosing();
                    BaseLayerEditorPanel.this.letterFilterPatternLegendDialog = null;
                }
            });
        }
        return this.getLetterFilterPatternLegendDialog();
    }

    public PoiFilterPatternLegendDialog getPoiFilterPatternLegendDialog() {
        return this.poiFilterPatternLegendDialog;
    }

    public PoiFilterPatternLegendDialog createIfNullPoiFilterPatternLegendDialog() {
        if (this.poiFilterPatternLegendDialog == null) {
            this.poiFilterPatternLegendDialog = new PoiFilterPatternLegendDialog(this.getParentWindow(), this.getEditBaseLayer().getDisplayname(), SwingUtils.findInternalFrameParent(this));
            this.poiFilterPatternLegendDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    BaseLayerEditorPanel.this.getMenuBar().poiFilterLegendDialogClosing();
                    BaseLayerEditorPanel.this.poiFilterPatternLegendDialog = null;
                }
            });
        }
        return this.getPoiFilterPatternLegendDialog();
    }

    public ParcelFilterPatternLegendDialog createIfNullParcelFilterPatternLegendDialog() {
        if (this.parcelFilterPatternLegendDialog == null) {
            this.parcelFilterPatternLegendDialog = new ParcelFilterPatternLegendDialog(this.getParentWindow(), this.getEditBaseLayer().getDisplayname(), SwingUtils.findInternalFrameParent(this));
            this.parcelFilterPatternLegendDialog.addPatternLegendSelectionListener(this.parcelObjectMarker);
            this.parcelFilterPatternLegendDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    BaseLayerEditorPanel.this.getMenuBar().parcelFilterLegendDialogClosing();
                    BaseLayerEditorPanel.this.parcelFilterPatternLegendDialog = null;
                }
            });
        }
        return this.getParcelFilterPatternLegendDialog();
    }

    public ParcelFilterPatternLegendDialog getParcelFilterPatternLegendDialog() {
        return this.parcelFilterPatternLegendDialog;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        PoiFilterPatternLegendDialog poiFilterPatternLegendDialog;
        Collection<BaseAreaAreaFilterPatternLegendDialog> areaFilterPatternLegendDialogs = this.getAreaFilterPatternLegendDialogs();
        for (AreaFilterPatternLegendDialog areaFilterPatternLegendDialog : areaFilterPatternLegendDialogs) {
            if (areaFilterPatternLegendDialog == null) continue;
            areaFilterPatternLegendDialog.dispose();
        }
        SubscriptionFilterPatternLegendDialog subscriptionFilterPatternLegendDialog = this.getSubscriptionFilterPatternLegendDialog();
        if (subscriptionFilterPatternLegendDialog != null) {
            subscriptionFilterPatternLegendDialog.dispose();
        }
        if ((poiFilterPatternLegendDialog = this.getPoiFilterPatternLegendDialog()) != null) {
            poiFilterPatternLegendDialog.dispose();
        }
    }

    private Collection<BaseAreaAreaFilterPatternLegendDialog> getAreaFilterPatternLegendDialogs() {
        return this.areaFilterPatternLegendDialogs.values();
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void consumeApplicationMessage(ApplicationMessage<?> message) {
        switch (message.getMessage()) {
            case REFRESH_AREA_PATTERNS: {
                this.getMenuBar().refreshAreaFilterPatternMenu();
                this.repaint(1L);
                break;
            }
            case REFRESH_SUBSCRIPTION_PATTERNS: {
                this.getMenuBar().refreshSubscriptionFilterPatternMenu();
                this.repaint(1L);
                break;
            }
            case REFRESH_POI_PATTERNS: {
                this.getMenuBar().refreshPoiFilterPatternMenu();
                this.repaint(1L);
                break;
            }
            case REFRESH_PARCEL_PATTERNS: {
                this.getMenuBar().refreshParcelFilterPatternMenu();
                this.repaint(1L);
                break;
            }
            case REFRESH_MODELS: {
                Map idMap = (Map)message.getPayload();
                for (Class key : idMap.keySet()) {
                    Collection ids = (Collection)idMap.get(key);
                    if (ids == null) continue;
                    for (Long id : ids) {
                        this.getModelEnviroment().getModelCache().refreshRek(key, id, true);
                    }
                }
                this.repaint(1L);
            }
        }
    }

    public ToggleAction getChooseEditLayerAction() {
        return this.showEditLayerAction;
    }

    public EmptyToggleAction getDisableSourceLayers() {
        return this.disableSourceLayers;
    }

    public Map<AreaLayerModel, Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>>> getShowLayerActions() {
        return this.showLayerActions;
    }

    public boolean isAllowsSegment() {
        return this.allowsSegment;
    }

    public boolean isAllowsFreehand() {
        return this.allowsFreehand;
    }

    public boolean isUnmodifyable() {
        return this.unmodifyable;
    }

    public AreaLayerRenderer getEditBaseLayerRenderer() {
        return this.editBaseLayerRenderer;
    }

    @Override
    protected void setCurrentAreaObjects(Collection<AreaObjectModel> areaObjects) {
        this.getSelectedObjects().clear();
        this.getSelectedObjects().addAll(areaObjects);
        this.getCurrentAreaRenderer().setCurrentAreaObject(areaObjects);
    }

    public Action getCircleSearchingAction() {
        return this.circleSearchingAction;
    }

    public Action getSubscriptionSearchAction() {
        return this.subscriptionSearchAction;
    }

    public Action getPoiSearchAction() {
        return this.poiSearchAction;
    }

    @Override
    public void updateSelectAreaObjectsInfo() {
        Tupel ts = this.getAreaObjectsForLegend();
        HashSet<AreaObjectModel> whole = new HashSet<AreaObjectModel>((Collection)ts.getElement1());
        whole.addAll((Collection)ts.getElement2());
        if (this.editBaseLayerRenderer.isActive()) {
            if (this.currentAreaLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) {
                this.sumPanel.setSelectedComponent(this.microcellSumPane);
                this.microcellSumPane.loadValues(whole);
                this.microcellSumPane.loadAggregateValues(whole);
            } else {
                this.sumPanel.setSelectedComponent(this.areaSumPane);
                this.areaSumPane.loadValues(whole);
                this.areaSumPane.loadAggregateValues(whole);
            }
        } else if (this.currentAreaLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) {
            this.microcellSumPane.loadValues(null);
            this.microcellSumPane.loadAggregateValues(null);
        } else {
            this.areaSumPane.loadValues(null);
            this.areaSumPane.loadAggregateValues(null);
        }
        super.fireObjectSelectionChanged(new ObjectSelectionChangedEvent<AreaObjectModel>(this, null, ts));
        this.repaint(10L);
    }

    public Tupel<Set<AreaObjectModel>, Set<AreaObjectModel>> getAreaObjectsForLegend() {
        TreeSet<AreaObjectModel> areaObjectForSum = new TreeSet<AreaObjectModel>(LexicalAreaObjectModelComparator.INSTANCE);
        areaObjectForSum.addAll(this.getAllObjectsFromHash());
        TreeSet<AreaObjectModel> selected = new TreeSet<AreaObjectModel>(LexicalAreaObjectModelComparator.INSTANCE);
        selected.addAll(this.getSelectedObjects());
        return new Tupel<Set<AreaObjectModel>, Set<AreaObjectModel>>(selected, areaObjectForSum);
    }

    private Set<AreaObjectModel> getAllObjectsFromHash() {
        HashSet<AreaObjectModel> flatHash = new HashSet<AreaObjectModel>();
        for (AreaLayerModel areaLayer : this.objectMarkSetsHash.keySet()) {
            for (AreaObjectModel areaObject : this.objectMarkSetsHash.get(areaLayer)) {
                flatHash.add(areaObject);
            }
        }
        return flatHash;
    }

    public Map<AreaLayerModel, Set<AreaObjectModel>> getObjectMarkSetsHash() {
        return this.objectMarkSetsHash;
    }

    public SubscriptionFilterableMarkerRenderer getSubscriptionAllRenderer() {
        return this.subscriptionForAllRenderer;
    }

    public ParcelFilterableMarkerRenderer getParcelRenderer() {
        return this.parcelObjectMarker;
    }

    public RulerRenderer getRulerRenderer() {
        return this.rulerRenderer;
    }

    public CoverHandler getCoverHandler() {
        return this.coverHandler;
    }

    public ToggleAction getShowSomeDayStopAction() {
        return this.showSomeDayStopAction;
    }

    public List<AreaAttributeValueDescriptorModel> getAreaDescriptorForLegend(boolean onlyNumber) {
        String aggregate = ModelEnviroment.getProperties().getProperty("area.attributes.aggregate.sum");
        HashSet atrributesForSum = aggregate == null ? new HashSet() : CollectionUtil.buildHashSet(aggregate.replaceAll(" ", "").split(","));
        Collection<AreaAttributeValueDescriptorModel> areaAttributeValueDescriptors = this.getModelEnviroment().getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        ArrayList<AreaAttributeValueDescriptorModel> descriptors = new ArrayList<AreaAttributeValueDescriptorModel>(areaAttributeValueDescriptors.size());
        for (AreaAttributeValueDescriptorModel descriptor : areaAttributeValueDescriptors) {
            AttributeValueType attributeValueType = descriptor.getAttributeValueType();
            if ((attributeValueType == AttributeValueType.INTEGER || attributeValueType == AttributeValueType.FLOAT) && atrributesForSum.contains(descriptor.getKey().replaceAll(" ", ""))) {
                descriptors.add(descriptor);
                continue;
            }
            if (attributeValueType == AttributeValueType.INTEGER || attributeValueType == AttributeValueType.FLOAT || onlyNumber) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<AreaAttributeValueDescriptorModel> getMicrocellDescriptorForLegend(boolean onlyNumber) {
        Collection<AreaAttributeValueDescriptorModel> areaAttributeValueDescriptors = this.getModelEnviroment().getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        ArrayList<AreaAttributeValueDescriptorModel> descriptors = new ArrayList<AreaAttributeValueDescriptorModel>();
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        descriptors.add(this.getMicrocellDescriptor("microcell.attribute.descriptor.distance", areaAttributeValueDescriptors));
        descriptors.add(this.getMicrocellDescriptor("microcell.attribute.descriptor.duration", areaAttributeValueDescriptors));
        descriptors.add(this.getMicrocellDescriptor("microcell.attribute.descriptor.parcels", areaAttributeValueDescriptors));
        descriptors.add(this.getMicrocellDescriptor("microcell.attribute.descriptor.weight", areaAttributeValueDescriptors));
        undoManager.finishTransaction("");
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException e) {
            undoManager.rollbackTransaction();
        }
        return descriptors;
    }

    private AreaAttributeValueDescriptorModel getMicrocellDescriptor(String property, Collection<AreaAttributeValueDescriptorModel> areaDescriptors) {
        String key = ModelEnviroment.getProperties().getProperty(property);
        AreaAttributeValueDescriptorModel descriptor = null;
        for (AreaAttributeValueDescriptorModel d : areaDescriptors) {
            if (!d.getKey().equals(key)) continue;
            descriptor = d;
            break;
        }
        if (descriptor == null) {
            descriptor = new AreaAttributeValueDescriptorModelImpl();
            descriptor.setKey(key);
            descriptor.setName(ModelEnviroment.getMessageResolver().resolveMessage(property, new Serializable[0]));
            descriptor.setEditable(true);
            descriptor.setModifiable(true);
            descriptor.setAttributeValueType(AttributeValueType.INTEGER);
        }
        return descriptor;
    }

    public PoiFilterableMarkerRenderer getPoiRenderer() {
        return this.poiRenderer;
    }

    public void setFreyHandler(FreyHandler freyHandler) {
        this.freyHandler = freyHandler;
    }

    public FreyHandler getFreyHandler() {
        return this.freyHandler;
    }

    public Action getAddClipboardSelectionAction() {
        return new AddClipboardSelectionAction(this);
    }

    public Action getAddClipboardSelectionFreehandAction() {
        return new AddClipboardSelectionFreehandAction(this);
    }

    @Override
    protected void firePlainObjectSelectionChanged(Set<AreaObjectModel> oldSelection, Set<AreaObjectModel> newSelection) {
        Set<AreaObjectModel> allObjectsFromHash = this.getAllObjectsFromHash();
        ObjectSelectionChangedEvent<AreaObjectModel> event = new ObjectSelectionChangedEvent<AreaObjectModel>(this, new Tupel(oldSelection, allObjectsFromHash), new Tupel(newSelection, allObjectsFromHash));
        super.fireObjectSelectionChanged(event);
    }

    public BusyHandler getBusyHandler() {
        return this.busyHandler;
    }

    public MicrocellHandler getMicrocellHandler() {
        if (this.microcellHandler == null) {
            this.microcellHandler = new MicrocellHandlerImpl(this);
        }
        return this.microcellHandler;
    }

    public MakrocellHandler getMakrocellHandler() {
        if (this.makrocellHandler == null) {
            this.makrocellHandler = new MakrocellHandlerImpl(this);
        }
        return this.makrocellHandler;
    }

    public void removeAreaFilterPatternLegendDialog(AreaLayerModel areaLayerModel) {
        this.areaFilterPatternLegendDialogs.remove(areaLayerModel);
    }

    public Set<Long> getAreaObjectIdsNotToShow() {
        return this.areaObjectIdsNotToShow;
    }

    public void emptySelectedFiltersList() {
        this.selectedFiltersList.clear();
    }

    public void setSelectedFiltersList(Set<AreaFilterModel> selectedFiltersList) {
        this.selectedFiltersList = selectedFiltersList;
    }

    public Set<AreaFilterModel> getSelectedFiltersList() {
        return this.selectedFiltersList;
    }

    public Map<AreaLayerModel, SourceAreaMarkerActionNavigatorRenderer> getAreaObjectMarkers() {
        return this.areaObjectMarkers;
    }

    @Override
    protected boolean isSearchOnlyForParcel() {
        return false;
    }

    public LetterFilterableMarkerRenderer getLetterFilterableMarkerRenderer() {
        return this.letterFilterableMarkerRenderer;
    }

    private class AreaObjectSelectionListenerForEnabling
    implements ObjectSelectionListener<AreaObjectModel> {
        private AreaObjectSelectionListenerForEnabling() {
        }

        @Override
        public void selectionChanged(ObjectSelectionChangedEvent<AreaObjectModel> objectSelectionChangedEvent) {
            Tupel<Set<AreaObjectModel>, Set<AreaObjectModel>> newSelection = objectSelectionChangedEvent.getNewSelection();
            int selectedObjectSize = newSelection.getElement1().size();
            boolean areaEdit = selectedObjectSize >= 1;
            BaseLayerEditorPanel.this.setEnablings(areaEdit);
        }
    }
}

