/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.properties.single;

import de.datomino.peppergis.properties.single.AbstractPropertyEditorPanel;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class SelectableChainPropertyEditorPanel
extends AbstractPropertyEditorPanel {
    private static final long serialVersionUID = -2450511549914075366L;
    private JList<String> choices;
    private JList<String> selections;
    private Character separator;
    private JTextField value;

    @Override
    protected JComponent getEditorComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel subPanel = new JPanel(new SpringLayout());
        this.choices = new JList(new DefaultListModel());
        this.selections = new JList(new DefaultListModel());
        subPanel.add(new JScrollPane(this.choices));
        subPanel.add(new JScrollPane(this.selections));
        subPanel.add(new JButton(new AbstractAction("+"){
            private static final long serialVersionUID = 429692036619727899L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValuesList = SelectableChainPropertyEditorPanel.this.choices.getSelectedValuesList();
                DefaultListModel dlm = (DefaultListModel)SelectableChainPropertyEditorPanel.this.selections.getModel();
                for (String s : selectedValuesList) {
                    dlm.addElement(s);
                }
                SelectableChainPropertyEditorPanel.this.recalculateValue();
            }
        }));
        subPanel.add(new JButton(new AbstractAction("-"){
            private static final long serialVersionUID = 429692036619727899L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = SelectableChainPropertyEditorPanel.this.selections.getSelectedIndices();
                DefaultListModel dlm = (DefaultListModel)SelectableChainPropertyEditorPanel.this.selections.getModel();
                for (int i = indices.length - 1; i >= 0; --i) {
                    dlm.removeElementAt(indices[i]);
                }
                SelectableChainPropertyEditorPanel.this.recalculateValue();
            }
        }));
        SpringUtilities.makeCompactGrid(subPanel, 2, 2, 5, 5, 5, 5);
        panel.add((Component)subPanel, "North");
        this.value = new JTextField();
        panel.add((Component)this.value, "South");
        return panel;
    }

    private void recalculateValue() {
        ListModel<String> listModel = this.selections.getModel();
        int size = listModel.getSize();
        ArrayList<String> selectedValuesList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            selectedValuesList.add(listModel.getElementAt(i));
        }
        this.value.setText(StringUtil.implode(selectedValuesList, this.separator.toString()));
    }

    @Override
    public void setValue(String value) {
        if (StringUtil.isEmpty(value)) {
            this.value.setText("");
        } else {
            String[] values = value.split(this.separator.toString());
            DefaultListModel dlm = (DefaultListModel)this.selections.getModel();
            dlm.clear();
            for (String sValue : values) {
                dlm.addElement(sValue);
            }
            this.value.setText(value);
        }
    }

    @Override
    public String getValue() {
        return this.value.getText();
    }

    @Override
    public void setElements(List<String> elements) {
        super.setElements(elements);
        Iterator<String> iter = elements.iterator();
        this.separator = Character.valueOf(iter.next().charAt(0));
        DefaultListModel dlm = (DefaultListModel)this.choices.getModel();
        dlm.clear();
        while (iter.hasNext()) {
            dlm.addElement(iter.next());
        }
    }
}

