/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.properties.server;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.properties.PropertyOverviewPane;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tupel;

public class ServerPropertyEditorPanel
extends PropertyOverviewPane {
    private static final long serialVersionUID = -3860563665088988065L;
    private ModelEnviroment modelEnviroment;

    public ServerPropertyEditorPanel(ModelEnviroment modelEnviroment) {
        super(ServerPropertyEditorPanel.createInput());
        this.modelEnviroment = modelEnviroment;
    }

    private static Collection<Tupel<String, InputStream>> createInput() {
        return Arrays.asList(new Tupel<String, InputStream>("Applikation", ServerPropertyEditorPanel.class.getResourceAsStream("/de/datomino/peppergis/properties/application.properties.csv")), new Tupel<String, InputStream>("Job", ServerPropertyEditorPanel.class.getResourceAsStream("/de/datomino/peppergis/properties/job.properties.csv")));
    }

    @Override
    protected Action[] getAdditionalActions() {
        return new Action[]{new LoadFromServerAction(), new SaveToServerAction()};
    }

    private class SaveToServerAction
    extends AbstractAction {
        private static final long serialVersionUID = 2686754933009728352L;

        public SaveToServerAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.properties.saveToServer", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Properties currentProperties = ServerPropertyEditorPanel.this.getCurrentProperties();
            boolean b = ServerPropertyEditorPanel.this.modelEnviroment.getAllCaller().getBaseCaller().savePropertiesToServer(currentProperties);
            JOptionPane.showMessageDialog(ServerPropertyEditorPanel.this, ModelEnviroment.getMessageResolver().resolveMessage(b ? "messages.properties.propertiesSavedToServer" : "messages.properties.propertiesSaveToServerDenied", new Serializable[0]));
        }
    }

    private class LoadFromServerAction
    extends AbstractAction {
        private static final long serialVersionUID = -1939330227804090196L;

        public LoadFromServerAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.properties.loadFromServer", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Properties properties = ServerPropertyEditorPanel.this.modelEnviroment.getAllCaller().getBaseCaller().getAllServerProperties();
            if (properties == null) {
                JOptionPane.showMessageDialog(ServerPropertyEditorPanel.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.properties.notAllowed", new Serializable[0]));
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter out = new OutputStreamWriter(baos);
                try {
                    properties.store(out, "");
                    out.flush();
                    out.close();
                    ServerPropertyEditorPanel.this.loadProperties(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(ServerPropertyEditorPanel.this, e1.getMessage());
                }
            }
        }
    }
}

