/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.properties;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.properties.PropertiesEditor;
import de.datomino.peppergis.properties.PropertyDescriptor;
import de.datomino.peppergis.properties.PropertyGroupDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.datatypes.Tupel;

public abstract class PropertyOverviewPane
extends JPanel {
    private static final long serialVersionUID = -3509884332104218782L;
    private PropertyGroupDescriptor propertyGroupDescriptor;
    private Properties properties;
    private List<PropertiesEditor> propertyEditors;

    public PropertyOverviewPane(Collection<Tupel<String, InputStream>> in) {
        super(new BorderLayout());
        this.propertyGroupDescriptor = new PropertyGroupDescriptor(in);
        this.properties = new Properties();
        this.buildLayout();
    }

    private void buildLayout() {
        Action[] actions2;
        TabChangeListener tabChangeListener = new TabChangeListener();
        Map<String, Map<String, List<PropertyDescriptor>>> groupMap = this.propertyGroupDescriptor.getGroupMap();
        JTabbedPane outerTabbedPane = new JTabbedPane();
        for (Map.Entry<String, Map<String, List<PropertyDescriptor>>> entry : groupMap.entrySet()) {
            JTabbedPane tabbedPane = new JTabbedPane();
            Map<String, List<PropertyDescriptor>> map = entry.getValue();
            TreeSet<String> keys = new TreeSet<String>(map.keySet());
            this.propertyEditors = new ArrayList<PropertiesEditor>(map.size());
            for (String key : keys) {
                List<PropertyDescriptor> value = map.get(key);
                PropertiesEditor propertyEditor = new PropertiesEditor(value, this.properties);
                tabbedPane.addTab(key, propertyEditor);
                this.propertyEditors.add(propertyEditor);
                tabbedPane.addChangeListener(tabChangeListener);
            }
            outerTabbedPane.addTab(entry.getKey(), tabbedPane);
        }
        outerTabbedPane.addChangeListener(tabChangeListener);
        this.add((Component)outerTabbedPane, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel2 = new JPanel(new FlowLayout());
        JButton loadLocalButton = new JButton(new LoadLocalAction());
        JButton saveLocalButton = new JButton(new SaveLocalAction());
        buttonPanel2.add(loadLocalButton);
        buttonPanel2.add(saveLocalButton);
        for (Action action : actions2 = this.getAdditionalActions()) {
            buttonPanel2.add(new JButton(action));
        }
        buttonPanel.add((Component)buttonPanel2, "East");
        this.add((Component)buttonPanel, "South");
        int maxWidth = 0;
        for (PropertiesEditor propertiesEditor : this.propertyEditors) {
            int width = propertiesEditor.getPreferredListWidth();
            maxWidth = Math.max(maxWidth, width);
        }
        for (PropertiesEditor propertiesEditor : this.propertyEditors) {
            propertiesEditor.setPreferredListWidth(maxWidth);
        }
    }

    protected abstract Action[] getAdditionalActions();

    protected void loadProperties(Reader reader) throws IOException {
        this.properties.clear();
        this.properties.load(reader);
        for (PropertiesEditor propertiesEditor : this.propertyEditors) {
            propertiesEditor.refresh();
        }
    }

    protected Properties getCurrentProperties() {
        Map<String, String> defaultValueMap = this.propertyGroupDescriptor.getDefaultValueMap();
        for (PropertiesEditor propertiesEditor : this.propertyEditors) {
            propertiesEditor.save();
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        HashSet<String> toRemove = new HashSet<String>();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String currentValue;
            String nextElement = keys.nextElement().toString();
            String defaultValue = defaultValueMap.get(nextElement);
            if (!new EqualsBuilder().append(defaultValue, currentValue = props.getProperty(nextElement.toString())).isEquals()) continue;
            toRemove.add(nextElement);
        }
        for (String key : toRemove) {
            props.remove(key);
        }
        return props;
    }

    public void updateProperties() {
        for (PropertiesEditor propertiesEditor : this.propertyEditors) {
            propertiesEditor.updatePropertyValue();
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PropertyOverviewPane.this.updateProperties();
        }
    }

    private class SaveLocalAction
    extends AbstractAction {
        private static final long serialVersionUID = -4051042261309335791L;

        public SaveLocalAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.properties.saveLocal", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser jf = new JFileChooser();
            jf.setAcceptAllFileFilterUsed(false);
            jf.setFileSelectionMode(0);
            jf.addChoosableFileFilter(new FileNameExtensionFilter("Properties", "properties"));
            int d = jf.showSaveDialog(PropertyOverviewPane.this);
            if (d == 0) {
                File file = jf.getSelectedFile();
                Properties props = PropertyOverviewPane.this.getCurrentProperties();
                try {
                    props.store(new FileWriter(file), "");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(PropertyOverviewPane.this, e1.getMessage());
                }
            }
        }
    }

    private class LoadLocalAction
    extends AbstractAction {
        private static final long serialVersionUID = 7768358012920167275L;

        public LoadLocalAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.properties.loadLocal", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser jf = new JFileChooser();
            jf.setAcceptAllFileFilterUsed(false);
            jf.setFileSelectionMode(0);
            jf.addChoosableFileFilter(new FileNameExtensionFilter("Properties", "properties"));
            int d = jf.showOpenDialog(PropertyOverviewPane.this);
            if (d == 0) {
                File file = jf.getSelectedFile();
                try {
                    FileReader reader = new FileReader(file);
                    PropertyOverviewPane.this.loadProperties(reader);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(PropertyOverviewPane.this, e1.getMessage());
                }
            }
        }
    }
}

