/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.properties;

import de.datomino.peppergis.properties.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.io.CsvReader;

public class PropertyGroupDescriptor {
    private Map<String, Map<String, List<PropertyDescriptor>>> groupMap = new LinkedHashMap<String, Map<String, List<PropertyDescriptor>>>();

    public PropertyGroupDescriptor(Collection<Tupel<String, InputStream>> ins) {
        for (Tupel<String, InputStream> in : ins) {
            try {
                HashMap<String, LinkedList<PropertyDescriptor>> subMap = new HashMap<String, LinkedList<PropertyDescriptor>>();
                this.groupMap.put(in.getElement1(), subMap);
                CsvReader csvReader = new CsvReader(in.getElement2());
                csvReader.readLine();
                List<String> line = csvReader.readLine();
                while (line != null) {
                    String name = line.get(0);
                    if ("job.parcelImporter.marshallers".equals(name)) {
                        System.out.println();
                    }
                    PropertyDescriptor.PropertyType type = PropertyDescriptor.PropertyType.valueOf(line.get(1));
                    String description = line.get(2);
                    String group = line.get(3);
                    String defaultValue = line.get(4);
                    List<String> subList = line.subList(5, line.size());
                    List<String> elements = this.removeEmptyEntries(subList);
                    LinkedList<PropertyDescriptor> list = (LinkedList<PropertyDescriptor>)subMap.get(group);
                    if (list == null) {
                        list = new LinkedList<PropertyDescriptor>();
                        subMap.put(group, list);
                    }
                    list.add(new PropertyDescriptor(name, description, type, defaultValue, elements));
                    line = csvReader.readLine();
                }
                csvReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<String> removeEmptyEntries(List<String> subList) {
        int i = 0;
        for (String s : subList) {
            if (StringUtil.isBlank(s)) break;
            ++i;
        }
        if (i == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(subList.subList(0, i));
    }

    public Map<String, Map<String, List<PropertyDescriptor>>> getGroupMap() {
        return this.groupMap;
    }

    public Map<String, String> getDefaultValueMap() {
        HashMap<String, String> defaultValueMap = new HashMap<String, String>();
        for (Map<String, List<PropertyDescriptor>> map : this.groupMap.values()) {
            for (List<PropertyDescriptor> list : map.values()) {
                for (PropertyDescriptor propertyDescriptor : list) {
                    defaultValueMap.put(propertyDescriptor.getName(), propertyDescriptor.getDefaultValue());
                }
            }
        }
        return defaultValueMap;
    }
}

