/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.properties;

import de.datomino.peppergis.properties.PropertyDescriptor;
import de.datomino.peppergis.properties.SinglePropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertiesEditor
extends JPanel {
    private static final long serialVersionUID = -835744802376554203L;
    private JList<PropertyDescriptor> propertyDescriptorList;
    private SinglePropertyEditor singlePropertyEditor;
    private Properties properties;

    private PropertiesEditor() {
        super(new BorderLayout());
    }

    public PropertiesEditor(List<PropertyDescriptor> value, Properties properties) {
        this();
        this.properties = properties;
        this.buildLayout();
        this.fillValues(value);
    }

    private void fillValues(List<PropertyDescriptor> propertyDescriptors) {
        DefaultListModel dlm = (DefaultListModel)this.propertyDescriptorList.getModel();
        for (PropertyDescriptor desc : propertyDescriptors) {
            dlm.addElement(desc);
        }
    }

    private void buildLayout() {
        JSplitPane split = new JSplitPane(1);
        this.propertyDescriptorList = new JList(new DefaultListModel());
        this.propertyDescriptorList.setSelectionMode(0);
        this.propertyDescriptorList.addListSelectionListener(new PropertyListSelectionListener());
        final ListCellRenderer<PropertyDescriptor> cellRenderer = this.propertyDescriptorList.getCellRenderer();
        this.propertyDescriptorList.setCellRenderer(new ListCellRenderer<PropertyDescriptor>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends PropertyDescriptor> list, PropertyDescriptor value, int index, boolean isSelected, boolean cellHasFocus) {
                return cellRenderer.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
            }
        });
        split.setLeftComponent(new JScrollPane(this.propertyDescriptorList));
        this.singlePropertyEditor = new SinglePropertyEditor(this.properties);
        split.setRightComponent(this.singlePropertyEditor);
        this.add((Component)split, "Center");
    }

    public void refresh() {
        this.singlePropertyEditor.refresh();
    }

    public void save() {
        this.singlePropertyEditor.saveValue();
    }

    public int getPreferredListWidth() {
        return this.propertyDescriptorList.getPreferredSize().width;
    }

    public void setPreferredListWidth(int maxWidth) {
        Dimension dim = this.propertyDescriptorList.getPreferredSize();
        dim = new Dimension(maxWidth, dim.height);
        this.propertyDescriptorList.setPreferredSize(dim);
    }

    public void updatePropertyValue() {
        PropertyDescriptor selectedValue = this.propertyDescriptorList.getSelectedValue();
        this.singlePropertyEditor.setPropertyGroupDescriptor(selectedValue);
    }

    private class PropertyListSelectionListener
    implements ListSelectionListener {
        private PropertyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PropertiesEditor.this.updatePropertyValue();
        }
    }
}

