/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.print;

import de.datomino.peppergis.client.model.offer.OfferDeliveryInformationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryRelationModel;
import de.datomino.peppergis.client.model.offer.OfferExtension1Model;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferWeightExtension1Model;
import de.datomino.peppergis.type.OfferType;
import de.datomino.util.common.PrimitiveUtil;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.ktde.util.StringUtil;

public class OfferPrinterHelper {
    public String getOfferTypeName(OfferExtension1Model extension) {
        String subject = extension.getTextBrick2();
        if (!StringUtil.isBlank(subject)) {
            return subject;
        }
        OfferType offerType = extension.getOfferType();
        if (offerType == null) {
            return "";
        }
        switch (offerType) {
            case OFFER: {
                return "Angebot";
            }
            case CONFIRMATION: {
                return "Auftragsbest\u00e4tigung";
            }
        }
        return "";
    }

    public String getDeliveryInformationCommaSeparated(OfferModel offer) {
        ArrayList<String> deliveries = new ArrayList<String>(offer.countOfferDeliveryRelations());
        for (OfferDeliveryRelationModel offerDeliveryRelationModel : offer.iterableOfferDeliveryRelations()) {
            OfferDeliveryInformationModel offerDeliveryInformation = offerDeliveryRelationModel.getOfferDeliveryInformation();
            deliveries.add(offerDeliveryInformation.getName());
        }
        if (!deliveries.isEmpty()) {
            return "Belegung " + StringUtil.implode(deliveries, ", ");
        }
        return "";
    }

    public String getOpeningText(OfferType offerType) {
        switch (offerType) {
            case OFFER: {
                return "vielen Dank f\u00fcr Ihr Interesse an einer Prospektwerbung mit dem Pforzheimer Medienhaus.";
            }
            case CONFIRMATION: {
                return "vielen Dank f\u00fcr den Auftrag, den ich Ihnen gerne wie folgt best\u00e4tige:";
            }
        }
        return "";
    }

    public String getEndText(OfferExtension1Model extension) {
        String subject = extension.getTextBrick1();
        if (!StringUtil.isBlank(subject)) {
            return subject;
        }
        OfferType offerType = extension.getOfferType();
        switch (offerType) {
            case OFFER: {
                return "Ich freue mich auf eine positive R\u00fcckmeldung und bin bei R\u00fcckfragen gerne f\u00fcr Sie da.";
            }
            case CONFIRMATION: {
                return "Ich freue mich auf den n\u00e4chsten Kontakt mit Ihnen.";
            }
        }
        return "";
    }

    public boolean shouldPrintAreaImage(OfferModel offerModel, OfferExtension1Model offerExtension1Model) {
        return offerExtension1Model.getRetailCity() == null && offerExtension1Model.getRetailCountry() == null && offerExtension1Model.getStationBookStore() == null && !offerModel.isOfferAreaRelationsEmpty();
    }

    public String getPrice(OfferExtension1Model offerExtension1Model) {
        boolean found;
        OfferWeightExtension1Model offerWeight = offerExtension1Model.getOfferWeight();
        Double weight = offerExtension1Model.getWeight();
        boolean weightSet = weight != null && weight > 0.0;
        Integer fixedPrice = offerExtension1Model.getFixedPrice();
        boolean discountAe = PrimitiveUtil.nullToFalse(offerExtension1Model.getDiscountAE());
        int discount1 = PrimitiveUtil.nullToZero(offerExtension1Model.getDiscount1());
        StringBuilder sb = new StringBuilder();
        if (!weightSet) {
            if (fixedPrice == null) {
                sb.append("\n");
                found = false;
            } else {
                String priceString = StringUtils.leftPad(fixedPrice.toString(), 3, '0');
                sb.append("Festpreis ").append(priceString.substring(0, priceString.length() - 2)).append(",").append(priceString.substring(priceString.length() - 2)).append(" Euro");
                found = true;
            }
        } else {
            Integer price = fixedPrice == null ? Integer.valueOf(offerWeight == null ? 0 : offerWeight.getPrice()) : fixedPrice;
            if (price == null) {
                sb.append("\n");
                found = false;
            } else {
                String priceString = StringUtils.leftPad(price.toString(), 3, '0');
                sb.append(priceString.substring(0, priceString.length() - 2)).append(",").append(priceString.substring(priceString.length() - 2));
                sb.append(" Euro/1.000 Expl.");
                if (offerWeight != null) {
                    sb.append(" bis ").append(offerWeight.getMinWeight()).append(" g");
                }
                found = true;
            }
        }
        if (found) {
            if (discount1 > 0 || discountAe) {
                sb.append("\n");
                if (discount1 > 0) {
                    sb.append("./. ").append(discount1).append(" % Rabatt");
                }
                if (discountAe) {
                    if (discount1 > 0) {
                        sb.append(" ");
                    }
                    sb.append("./. 15 % AE");
                }
            }
            sb.append("\nzzgl. Mwst.");
        }
        return sb.toString();
    }
}

