/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.gui.extension.esslinger;

import de.datomino.peppergis.client.gui.area.MultiAreaObjectSelectionPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.client.model.offer.OfferExtension1Model;
import de.datomino.peppergis.client.model.offer.OfferExtension1ModelImpl;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.offer.gui.AbstractOfferPane;
import de.datomino.peppergis.offer.gui.OfferSettingsPane;
import de.datomino.peppergis.offer.gui.extension.ExtensionPane;
import de.datomino.peppergis.offer.gui.extension.esslinger.EsslingerExtensionPane1;
import de.datomino.peppergis.offer.gui.extension.esslinger.EsslingerMultiAreaObjectSelectionPane;
import de.datomino.peppergis.offer.gui.extension.esslinger.EsslingerOfferSettingsPane;
import de.datomino.peppergis.type.OfferExtension;
import de.datomino.peppergis.type.OfferType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.datatypes.Tupel;

public class EsslingerOfferPane
extends AbstractOfferPane<OfferExtension1Model> {
    private static final long serialVersionUID = 1722551257354533431L;
    private EsslingerExtensionPane1 esslingerExtensionPane1;

    public EsslingerOfferPane(ModelEnviroment modelEnviroment) {
        super(modelEnviroment);
        this.getCustomerSearchPane().getCustomerSearchParameterPane().getAgencyComboBox().addActionListener(new AgencyChangeListener());
        this.getCustomerSearchPane().getCustomerSearchParameterPane().setOfferNumber(modelEnviroment.getAllCaller().getOfferCaller().getNextOfferNumber());
        this.getCustomerSearchPane().addListSelectionListener(new OfferListSelectionListener());
    }

    @Override
    protected void buildLayout() {
        super.buildLayout();
        EsslingerMultiAreaObjectSelectionPane esslingerMultiAreaObjectSelectionPane = (EsslingerMultiAreaObjectSelectionPane)this.getMultiAreaObjectSelectionPane();
        SpecialPrintCountActionListener actionListener = new SpecialPrintCountActionListener();
        esslingerMultiAreaObjectSelectionPane.getRetailCityActive().addActionListener(actionListener);
        esslingerMultiAreaObjectSelectionPane.getRetailCountryActive().addActionListener(actionListener);
        esslingerMultiAreaObjectSelectionPane.getStationBookStoreActive().addActionListener(actionListener);
    }

    @Override
    protected List<ExtensionPane> getExtensionComponents() {
        this.esslingerExtensionPane1 = new EsslingerExtensionPane1(this.getModelEnviroment());
        List<ExtensionPane> list = Collections.singletonList(this.esslingerExtensionPane1);
        return list;
    }

    @Override
    protected MultiAreaObjectSelectionPane createAreaObjectSelectionPane() {
        return new EsslingerMultiAreaObjectSelectionPane(this.getModelEnviroment()){
            private static final long serialVersionUID = -61268096673288343L;

            @Override
            protected void recalcSums() {
                super.recalcSums();
                EsslingerOfferPane.this.calcPrintCount();
            }
        };
    }

    @Override
    protected void adaptAreaValuesToModel(OfferModel offerModel, OfferExtension1Model esslingerOfferExtensionModel) {
        EsslingerMultiAreaObjectSelectionPane esslingerMultiAreaObjectSelectionPane = (EsslingerMultiAreaObjectSelectionPane)this.getMultiAreaObjectSelectionPane();
        boolean b = esslingerMultiAreaObjectSelectionPane.adaptSpecialValuesToOffer(offerModel, esslingerOfferExtensionModel);
        if (!b) {
            super.adaptAreaValuesToModel(offerModel, esslingerOfferExtensionModel);
        }
    }

    @Override
    protected OfferExtension1Model createOrGetExtensionModel(OfferModel offer) {
        OfferExtension1Model esslingerOfferExtensionModel = this.getModelEnviroment().getAllCaller().getOfferCaller().getEsslingerExtensionForOffer(offer);
        if (esslingerOfferExtensionModel == null) {
            esslingerOfferExtensionModel = new OfferExtension1ModelImpl();
            esslingerOfferExtensionModel.setOffer(offer);
        }
        return esslingerOfferExtensionModel;
    }

    @Override
    public Tupel<OfferModel, OfferExtension1Model> getOfferModel() {
        Tupel<OfferModel, OfferExtension1Model> tupel = super.getOfferModel();
        OfferModel offerModel = tupel.getElement1();
        offerModel.setType(OfferExtension.ESSLINGER);
        OfferExtension1Model extension = (OfferExtension1Model)tupel.getElement2();
        this.esslingerExtensionPane1.adaptOfferModel(offerModel, extension);
        return tupel;
    }

    @Override
    protected String createOfferNumber() {
        String offerNumber = super.createOfferNumber();
        if (this.esslingerExtensionPane1.getOfferType() == OfferType.CONFIRMATION && offerNumber.length() == 5) {
            offerNumber = "1" + offerNumber;
        }
        return offerNumber;
    }

    private void calcPrintCount() {
        int[] sums;
        Integer count = 0;
        boolean oneActive = false;
        EsslingerMultiAreaObjectSelectionPane esslingerMultiAreaObjectSelectionPane = (EsslingerMultiAreaObjectSelectionPane)this.getMultiAreaObjectSelectionPane();
        if (esslingerMultiAreaObjectSelectionPane.getRetailCityActive().isSelected()) {
            count = count + esslingerMultiAreaObjectSelectionPane.getRetailCity();
            oneActive = true;
        }
        if (esslingerMultiAreaObjectSelectionPane.getRetailCountryActive().isSelected()) {
            count = count + esslingerMultiAreaObjectSelectionPane.getRetailCountry();
            oneActive = true;
        }
        if (esslingerMultiAreaObjectSelectionPane.getStationBookStoreActive().isSelected()) {
            count = count + esslingerMultiAreaObjectSelectionPane.getStationBookStore();
            oneActive = true;
        }
        if (!oneActive && (sums = esslingerMultiAreaObjectSelectionPane.getSums()) != null) {
            for (int sum : sums) {
                count = count + sum;
            }
        }
        this.esslingerExtensionPane1.getPrintRunCount().setValue(count);
        this.getOfferSettingsPane().setPrintRunCount(count);
    }

    @Override
    protected void fillWithValuesFromOffer(OfferModel offer) {
        super.fillWithValuesFromOffer(offer);
        OfferExtension1Model offerExtension1Model = this.getModelEnviroment().getAllCaller().getOfferCaller().getEsslingerExtensionForOffer(offer);
        EsslingerMultiAreaObjectSelectionPane esslingerMultiAreaObjectSelectionPane = (EsslingerMultiAreaObjectSelectionPane)this.getMultiAreaObjectSelectionPane();
        esslingerMultiAreaObjectSelectionPane.setOfferValues(offerExtension1Model);
        this.esslingerExtensionPane1.setOfferValues(offerExtension1Model);
    }

    @Override
    public boolean checkForPrint() {
        return super.checkForPrint() && this.esslingerExtensionPane1.checkForPrint();
    }

    @Override
    public boolean checkForSave() {
        return super.checkForSave() && this.esslingerExtensionPane1.checkForSave();
    }

    @Override
    protected OfferSettingsPane createOfferSettingsPane(ModelEnviroment modelEnviroment) {
        return new EsslingerOfferSettingsPane(modelEnviroment);
    }

    private class OfferListSelectionListener
    implements ListSelectionListener {
        private OfferListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            OfferModel offerModel = EsslingerOfferPane.this.getCustomerSearchPane().getSelectedOffer();
            if (offerModel != null) {
                EsslingerOfferPane.this.fillWithValuesFromOffer(offerModel);
            }
        }
    }

    private class SpecialPrintCountActionListener
    implements ActionListener {
        private SpecialPrintCountActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EsslingerOfferPane.this.calcPrintCount();
        }
    }

    private class AgencyChangeListener
    implements ActionListener {
        private AgencyChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AgencyModel selectedItem = (AgencyModel)EsslingerOfferPane.this.getCustomerSearchPane().getCustomerSearchParameterPane().getAgencyComboBox().getSelectedItem();
            if (selectedItem != null) {
                EsslingerOfferPane.this.esslingerExtensionPane1.getDiscountAE().setSelected(true);
                EsslingerOfferPane.this.esslingerExtensionPane1.getPriceType().setSelectedByName("GP");
            }
        }
    }
}

