/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.gui.extension.esslinger;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.customer.MediaComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.offer.DeliveryType1Model;
import de.datomino.peppergis.client.model.offer.MediaModel;
import de.datomino.peppergis.client.model.offer.OfferExtension1Model;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferWeightExtension1Model;
import de.datomino.peppergis.client.model.offer.PriceType1Model;
import de.datomino.peppergis.offer.gui.PriceTypeComboBox;
import de.datomino.peppergis.offer.gui.extension.ExtensionPane;
import de.datomino.peppergis.offer.gui.extension.esslinger.EsslingerDeliveryType1ComboBox;
import de.datomino.peppergis.type.OfferType;
import de.datomino.util.format.SpecialNumberFormat;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class EsslingerExtensionPane1
implements ExtensionPane {
    private static final String DEFAULT_TECHNICAL_INFORMATION = "H\u00f6chstma\u00df 320 x 250 mm\nMindestma\u00df 148 x 105 mm\nEinzelbl\u00e4tter 100-g-Papier oder gefalzt\n\nBei evtl. auftretenden Verarbeitungsschwierigkeiten hat die Fertigstellung Vorrang gegen\u00fcber den Sonderwerbeformen.\nDer Verlag verteilt die Prospekte mit gesch\u00e4fts\u00fcblicher Sorgfalt, wobei bis zu 3 % Fehlzustellung oder Verlust als verkehrs\u00fcblich gelten.";
    private JFormattedTextField weight;
    private JSpinner discount1;
    private JCheckBox discountAE;
    private JSpinner printRunCount;
    private JFormattedTextField distributionTime;
    private JFormattedTextField fixedPrice;
    private PriceTypeComboBox priceType;
    private MediaComboBox media;
    private EsslingerDeliveryType1ComboBox deliveryType;
    private JTextField textBrick1;
    private JTextField textBrick2;
    private EnumComboBox<OfferType> offerType;
    private JTextArea salutationText;
    private JTextArea technicalInformation;
    private JTextArea postScriptum;
    private ModelEnviroment modelEnviroment;

    public EsslingerExtensionPane1(ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    public Component getComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel subPanel = new JPanel(new SpringLayout());
        WidthUnifier widthUnifier1 = new WidthUnifier();
        WidthUnifier widthUnifier2 = new WidthUnifier();
        JLabel l = new JLabel("Gewicht*");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.weight = new JFormattedTextField(new SpecialNumberFormat(true, null));
        subPanel.add(this.weight);
        widthUnifier2.add(this.weight);
        l = new JLabel("Verteilart");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.deliveryType = new EsslingerDeliveryType1ComboBox(this.modelEnviroment.getAllCaller().getOfferCaller().getAllEsslingerDeliveryTypes(), false);
        subPanel.add(this.deliveryType);
        widthUnifier2.add(this.deliveryType);
        l = new JLabel("Rabatt1");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.discount1 = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        subPanel.add(this.discount1);
        widthUnifier2.add(this.discount1);
        l = new JLabel("RabattAE 15%");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.discountAE = new JCheckBox();
        subPanel.add(this.discountAE);
        widthUnifier2.add(this.discountAE);
        l = new JLabel("Summierte Auflage");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.printRunCount = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        subPanel.add(this.printRunCount);
        widthUnifier2.add(this.printRunCount);
        l = new JLabel("Verteiltermin*");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.distributionTime = new JFormattedTextField(new SimpleDateFormat("dd.MM.yyyy"));
        subPanel.add(this.distributionTime);
        widthUnifier2.add(this.distributionTime);
        l = new JLabel("Medium*");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.media = new MediaComboBox(this.modelEnviroment, true);
        subPanel.add(this.media);
        widthUnifier2.add(this.media);
        l = new JLabel("Betreff");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.textBrick2 = new JTextField(30);
        subPanel.add(this.textBrick2);
        widthUnifier2.add(this.textBrick2);
        l = new JLabel("Typ");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.offerType = new EnumComboBox<OfferType>(OfferType.class, false);
        subPanel.add(this.offerType);
        widthUnifier2.add(this.offerType);
        l = new JLabel("Abschlusstext");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.textBrick1 = new JTextField(30);
        subPanel.add(this.textBrick1);
        widthUnifier2.add(this.textBrick1);
        l = new JLabel("Preis-Typ*");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.priceType = new PriceTypeComboBox(this.modelEnviroment.getAllCaller().getOfferCaller().getAllPriceTypes(), true);
        subPanel.add(this.priceType);
        widthUnifier2.add(this.priceType);
        l = new JLabel("Preis");
        subPanel.add(l);
        widthUnifier1.add(l);
        this.fixedPrice = new JFormattedTextField(new SpecialNumberFormat(true, 2));
        subPanel.add(this.fixedPrice);
        widthUnifier2.add(this.fixedPrice);
        widthUnifier1.unifyWidth();
        widthUnifier2.unifyWidth();
        SpringUtilities.makeCompactGrid(subPanel, 6, 4, 5, 5, 10, 5);
        panel.add((Component)subPanel, "North");
        subPanel = new JPanel(new SpringLayout());
        JLabel label = new JLabel("Gru\u00dfbaustein");
        label.setVerticalAlignment(1);
        subPanel.add(label);
        this.salutationText = new JTextArea(10, 30);
        this.salutationText.setText("Mit freundlichen Gr\u00fc\u00dfen");
        subPanel.add(new JScrollPane(this.salutationText));
        label = new JLabel("Technische Angaben");
        label.setVerticalAlignment(1);
        subPanel.add(label);
        this.technicalInformation = new JTextArea(10, 30);
        this.technicalInformation.setText(DEFAULT_TECHNICAL_INFORMATION);
        subPanel.add(new JScrollPane(this.technicalInformation));
        label = new JLabel("Post scriptum");
        label.setVerticalAlignment(1);
        subPanel.add(label);
        this.postScriptum = new JTextArea(10, 30);
        this.postScriptum.setText("Ohne Unterschrift");
        subPanel.add(new JScrollPane(this.postScriptum));
        SpringUtilities.makeCompactGrid(subPanel, 3, 2, 5, 5, 2, 2);
        panel.add((Component)subPanel, "Center");
        return panel;
    }

    @Override
    public String getTabName() {
        return "Spezial 1";
    }

    public void adaptOfferModel(OfferModel offerModel, OfferExtension1Model extension) {
        Number number = (Number)this.discount1.getValue();
        extension.setDiscount1(number == null ? 0 : number.intValue());
        extension.setDiscountAE(this.discountAE.isSelected());
        extension.setDistributorsTime((Date)this.distributionTime.getValue());
        extension.setMedia(this.media.getSelectedMediaModel());
        extension.setOfferType(this.offerType.getSelectedValue());
        extension.setPostScriptum(this.postScriptum.getText());
        number = (Number)this.printRunCount.getValue();
        extension.setPrintRunCount(number == null ? 0 : number.intValue());
        extension.setTechnicalInformation(this.technicalInformation.getText());
        extension.setTextBrick1(this.textBrick1.getText());
        extension.setTextBrick2(this.textBrick2.getText());
        extension.setFinalSalutation(this.salutationText.getText());
        Number fixed = (Number)this.fixedPrice.getValue();
        Integer iFixed = null;
        if (fixed != null) {
            iFixed = Math.round(fixed.floatValue() * 100.0f);
        }
        extension.setFixedPrice(iFixed);
        Double dWeight = this.getWeight();
        extension.setWeight(dWeight);
        extension.setOfferWeight(this.determineOfferWeightClass());
    }

    private Double getWeight() {
        Number weightValue = (Number)this.weight.getValue();
        Double dWeight = null;
        if (weightValue != null) {
            dWeight = weightValue.doubleValue();
        }
        return dWeight;
    }

    private OfferWeightExtension1Model determineOfferWeightClass() {
        return this.modelEnviroment.getAllCaller().getOfferCaller().determineEsslingerWeight((DeliveryType1Model)this.deliveryType.getSelectedItem(), (PriceType1Model)this.priceType.getSelectedItem(), this.getWeight());
    }

    JCheckBox getDiscountAE() {
        return this.discountAE;
    }

    PriceTypeComboBox getPriceType() {
        return this.priceType;
    }

    JSpinner getPrintRunCount() {
        return this.printRunCount;
    }

    void setOfferValues(OfferExtension1Model offerExtension1Model) {
        this.weight.setValue(offerExtension1Model.getWeight());
        this.discount1.setValue(offerExtension1Model.getDiscount1());
        this.discountAE.setSelected(offerExtension1Model.getDiscountAE());
        this.printRunCount.setValue(offerExtension1Model.getPrintRunCount());
        this.distributionTime.setValue(offerExtension1Model.getDistributorsTime());
        Integer fixedPrice = offerExtension1Model.getFixedPrice();
        this.fixedPrice.setValue(fixedPrice == null ? null : Float.valueOf(fixedPrice.floatValue() / 100.0f));
        OfferWeightExtension1Model offerWeight = offerExtension1Model.getOfferWeight();
        PriceType1Model priceType = null;
        DeliveryType1Model deliveryType = null;
        if (offerWeight != null) {
            priceType = offerWeight.getPriceType();
            deliveryType = offerWeight.getDeliveryType();
        }
        if (priceType == null) {
            this.priceType.setSelectedIndex(0);
        } else {
            this.priceType.setSelectedItem(priceType);
        }
        MediaModel media = offerExtension1Model.getMedia();
        if (media == null) {
            this.media.setSelectedIndex(0);
        } else {
            this.media.setSelectedItem(media);
        }
        if (deliveryType == null) {
            this.deliveryType.setSelectedIndex(0);
        } else {
            this.deliveryType.setSelectedItem(deliveryType);
        }
        this.textBrick1.setText(StringUtil.nullToEmpty(offerExtension1Model.getTextBrick1()));
        this.textBrick2.setText(StringUtil.nullToEmpty(offerExtension1Model.getTextBrick2()));
        this.offerType.setSelectedItem((Object)offerExtension1Model.getOfferType());
        this.salutationText.setText(StringUtil.nullToEmpty(offerExtension1Model.getFinalSalutation()));
        this.technicalInformation.setText(StringUtil.nullToEmpty(offerExtension1Model.getTechnicalInformation()));
        this.postScriptum.setText(StringUtil.nullToEmpty(offerExtension1Model.getPostScriptum()));
    }

    OfferType getOfferType() {
        return this.offerType.getSelectedValue();
    }

    boolean checkForPrint() {
        return this.weight.getValue() != null && this.distributionTime.getValue() != null && this.priceType.getSelectedItem() != null && this.media.getSelectedMediaModel() != null;
    }

    boolean checkForSave() {
        return this.weight.getValue() != null && this.distributionTime.getValue() != null && this.priceType.getSelectedItem() != null && this.media.getSelectedMediaModel() != null;
    }
}

