/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.gui;

import de.datomino.peppergis.client.gui.customer.AgentComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.offer.AgentModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryInformationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryRelationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryRelationModelImpl;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.util.format.SpecialNumberFormat;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class OfferSettingsPane
extends JPanel {
    private static final long serialVersionUID = -3229926447983403659L;
    private AgentComboBox agentComboBox;
    private JCheckBox[] deliveryAddressActive;
    private OfferDeliveryInformationModel[] offerDeliveryInformationModels;
    private JFormattedTextField[] deliveryCounts;
    private JTextField deliveryTime;
    private ModelEnviroment modelEnviroment;

    public OfferSettingsPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel tPanel = new JPanel(new SpringLayout());
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.offer.agent", new Serializable[0])));
        this.agentComboBox = new AgentComboBox(this.modelEnviroment, true);
        panel.add(this.agentComboBox);
        panel.add(new JLabel("Anlieferhinweis"));
        this.deliveryTime = new JTextField(30);
        this.deliveryTime.setText("Sp\u00e4testens 3 Tage vor Verteilung, fr\u00fchestens 10 Werktage vor Verteilung");
        panel.add(this.deliveryTime);
        SpringUtilities.makeCompactGrid(panel, 2, 2, 2, 2, 2, 2);
        tPanel.add(panel);
        tPanel.add(this.createDeliveryJPanel());
        SpringUtilities.makeCompactGrid(tPanel, 2, 1, 5, 5, 2, 2);
        this.add((Component)tPanel, "North");
    }

    private JPanel createDeliveryJPanel() {
        Collection<OfferDeliveryInformationModel> offerDeliveryInformationModels = this.modelEnviroment.getAllCaller().getOfferCaller().getAllDeliveryInformations();
        int size = offerDeliveryInformationModels.size();
        JPanel panel = new JPanel(new SpringLayout());
        this.deliveryAddressActive = new JCheckBox[size];
        this.deliveryCounts = new JFormattedTextField[size];
        this.offerDeliveryInformationModels = new OfferDeliveryInformationModel[size];
        Iterator<OfferDeliveryInformationModel> iter = offerDeliveryInformationModels.iterator();
        for (int i = 0; i < size; ++i) {
            OfferDeliveryInformationModel offerDeliveryInformationModel = iter.next();
            this.deliveryAddressActive[i] = new JCheckBox(this.createDeliveryLabel(offerDeliveryInformationModel));
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.deliveryAddressActive[i], "North");
            panel.add(p);
            this.offerDeliveryInformationModels[i] = offerDeliveryInformationModel;
            this.deliveryCounts[i] = new JFormattedTextField(new SpecialNumberFormat(true, null));
            p = new JPanel(new BorderLayout());
            p.add((Component)this.deliveryCounts[i], "Center");
            p.add((Component)new JLabel("Menge"), "West");
            panel.add(p);
        }
        SpringUtilities.makeCompactGrid(panel, size, 2, 2, 2, 2, 2);
        return panel;
    }

    protected String createDeliveryLabel(OfferDeliveryInformationModel offerDeliveryInformationModel) {
        String text = offerDeliveryInformationModel.getName() + ", " + offerDeliveryInformationModel.getDeliveryStreet() + " " + offerDeliveryInformationModel.getDeliveryHousenumber() + offerDeliveryInformationModel.getDeliveryHousenumberExtension() + " " + offerDeliveryInformationModel.getDeliveryPostcode() + " " + offerDeliveryInformationModel.getDeliveryCity();
        return text;
    }

    public void setAllDeliveryCount(Integer value) {
        for (JFormattedTextField d : this.deliveryCounts) {
            d.setValue(value);
        }
    }

    public void adaptOfferToModel(OfferModel offerModel) {
        offerModel.setAgent(this.agentComboBox.getSelectedItem());
        offerModel.setCreationTime(new Date());
        offerModel.setDeliveryInformation(this.deliveryTime.getText());
        for (OfferDeliveryRelationModel offerDeliveryRelationModel : offerModel.iterableOfferDeliveryRelations()) {
            offerDeliveryRelationModel.delete();
        }
        offerModel.clearOfferDeliveryRelations();
        for (int i = 0; i < this.offerDeliveryInformationModels.length; ++i) {
            OfferDeliveryRelationModel offerDeliveryRelationModel;
            if (!this.deliveryAddressActive[i].isSelected()) continue;
            offerDeliveryRelationModel = new OfferDeliveryRelationModelImpl();
            offerDeliveryRelationModel.setOffer(offerModel);
            offerDeliveryRelationModel.setOfferDeliveryInformation(this.offerDeliveryInformationModels[i]);
            Number number = (Number)this.deliveryCounts[i].getValue();
            int value = 0;
            if (number != null) {
                value = number.intValue();
            }
            offerDeliveryRelationModel.setQuantity(value);
            offerModel.addOfferDeliveryRelation(offerDeliveryRelationModel);
        }
    }

    public void fillWithValuesFromOffer(OfferModel offer) {
        AgentModel agent = offer.getAgent();
        if (agent == null) {
            this.agentComboBox.setSelectedIndex(0);
        } else {
            this.agentComboBox.setSelectedItem(agent);
        }
        this.deliveryTime.setText(StringUtil.nullToEmpty(offer.getDeliveryInformation()));
        for (JCheckBox jCheckBox : this.deliveryAddressActive) {
            jCheckBox.setSelected(false);
        }
        for (JComponent jComponent : this.deliveryCounts) {
            ((JFormattedTextField)jComponent).setValue(null);
        }
        block2: for (OfferDeliveryRelationModel offerDeliveryRelationModel : offer.iterableOfferDeliveryRelations()) {
            for (int i = 0; i < this.offerDeliveryInformationModels.length; ++i) {
                if (!this.offerDeliveryInformationModels[i].equals(offerDeliveryRelationModel.getOfferDeliveryInformation())) continue;
                this.deliveryAddressActive[i].setSelected(true);
                this.deliveryCounts[i].setValue(offerDeliveryRelationModel.getQuantity());
                continue block2;
            }
        }
    }

    public void setPrintRunCount(Integer value) {
    }

    protected JFormattedTextField[] getDeliveryCounts() {
        return this.deliveryCounts;
    }
}

